/****************************************************************************
 ****************************************************************************
Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/1000 Family of Adapters (e1000) (the "Software") being provided 
by Intel Corporation. 

"Licensed Patents" means patent claims licensable by Intel Corporation which are
 necessarily infringed by the use or sale of the Software alone or when combined
 with the operating system referred to below.
"Recipient" means the party to whom Intel delivers this Software.
"Licensee" means Recipient and those third parties that receive a license to any
 operating system available under the GNU Public License version 2.0 or later.

Copyright (c) 1996-2001 Intel Corporation 
All rights reserved. 

The license is provided to Recipient and Recipient's Licensees under the 
following terms.  

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions are
met: 

Redistributions of source code of the Software may retain the above copyright
notice, this list of conditions and the following disclaimer. 
Redistributions in binary form of the Software may reproduce the above
copyright notice, this list of conditions and the following disclaimer in the 
documentation and/or other materials provided with the distribution. 
Neither the name of Intel Corporation nor the names of its contributors shall be
used to endorse or promote products derived from this Software without specific 
prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, royalty-
free patent license under Licensed Patents to make, use, sell, offer to sell, 
import and otherwise transfer the Software, if any, in source code and object 
code form. This license shall include changes to the Software that are error 
corrections or other minor changes to the Software that do not add functionality
or features when the Software is incorporated in any version of a operating 
system that has been distributed under the GNU General Public License 2.0 or 
later.  This patent license shall apply to the combination of the Software and 
any operating system licensed under the GNU Public License version 2.0 or later 
if, at the time Intel provides the Software to Recipient, such addition of the 
Software to the then publicly available versions of such operating system 
available under the GNU Public License version 2.0 or later (whether in gold,
beta or alpha form) causes such combination to be covered by the Licensed 
Patents. The patent license shall not apply to any other combinations which 
include the Software. No hardware per se is licensed hereunder. 
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED.IN NO EVENT SHALL INTEL OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************
 ***************************************************************************/

/**********************************************************************
 *                                                                     *
 * INTEL CORPORATION                                                   *
 *                                                                     *
 * This software is supplied under the terms of the license included   *
 * above.  All use of this software must be in accordance with the     *
 * terms of that license.                                              *
 *                                                                     *
 * Module Name:  e1000_idiag.h                                         *
 *                                                                     *
 * Abstract:     Header file for data structure definition for common  *
 *               diagnostics support                                   *
 *                                                                     *
 **********************************************************************/

#ifndef _E1000_IDIAG_H
#define _E1000_IDIAG_H

#include "idiag_pro.h"
#include "idiag_e1000.h"

extern idiag_pro_stat_t e1000_DiagRegTest
(struct adapter *Adapter, idiag_e1000_diag_reg_test_param_t *Param);

extern idiag_pro_stat_t e1000_DiagFifoTest
(struct adapter *Adapter, idiag_e1000_diag_fifo_test_param_t *Param);

extern idiag_pro_stat_t e1000_DiagEepromTest
(struct adapter *Adapter, idiag_e1000_diag_eeprom_test_param_t *Param);

extern idiag_pro_stat_t e1000_DiagIntrTest
(struct adapter *Adapter, idiag_e1000_diag_intr_test_param_t *Param);

extern idiag_pro_stat_t e1000_DiagLoopbackTest
(struct adapter *Adapter, idiag_e1000_diag_loopback_test_param_t *Param);

extern idiag_pro_stat_t e1000_DiagLinkTest
(struct adapter *Adapter, idiag_e1000_diag_link_test_param_t *Param);

struct device_diagnostics {
  uint16_t line_speed;
  uint8_t media_type;
  uint8_t cable_length;
  uint8_t extended_10b_t_distance;
  uint8_t cable_polarity;
  uint8_t polarity_reversal;
  uint32_t idle_errors;
  uint8_t link_reset;
  uint32_t receive_errors;
  uint8_t mdi_x_mode;
  uint8_t local_rx;
  uint8_t remote_rx;
  uint8_t pci_mode;
  uint8_t bus_speed;
  uint8_t slot_size;
};

extern idiag_pro_stat_t e1000_GetPhyInformation
(struct adapter *Adapter, struct device_diagnostics *Param);

#endif /* _E1000_IDIAG_H */
