/****************************************************************************
 ****************************************************************************
Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/1000 Family of Adapters (e1000) (the "Software") being provided 
by Intel Corporation. 

"Licensed Patents" means patent claims licensable by Intel Corporation which are
 necessarily infringed by the use or sale of the Software alone or when combined
 with the operating system referred to below.
"Recipient" means the party to whom Intel delivers this Software.
"Licensee" means Recipient and those third parties that receive a license to any
 operating system available under the GNU Public License version 2.0 or later.

Copyright (c) 1996-2001 Intel Corporation 
All rights reserved. 

The license is provided to Recipient and Recipient's Licensees under the 
following terms.  

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions are
met: 

Redistributions of source code of the Software may retain the above copyright
notice, this list of conditions and the following disclaimer. 
Redistributions in binary form of the Software may reproduce the above
copyright notice, this list of conditions and the following disclaimer in the 
documentation and/or other materials provided with the distribution. 
Neither the name of Intel Corporation nor the names of its contributors shall be
used to endorse or promote products derived from this Software without specific 
prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, royalty-
free patent license under Licensed Patents to make, use, sell, offer to sell, 
import and otherwise transfer the Software, if any, in source code and object 
code form. This license shall include changes to the Software that are error 
corrections or other minor changes to the Software that do not add functionality
or features when the Software is incorporated in any version of a operating 
system that has been distributed under the GNU General Public License 2.0 or 
later.  This patent license shall apply to the combination of the Software and 
any operating system licensed under the GNU Public License version 2.0 or later 
if, at the time Intel provides the Software to Recipient, such addition of the 
Software to the then publicly available versions of such operating system 
available under the GNU Public License version 2.0 or later (whether in gold,
beta or alpha form) causes such combination to be covered by the Licensed 
Patents. The patent license shall not apply to any other combinations which 
include the Software. No hardware per se is licensed hereunder. 
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED.IN NO EVENT SHALL INTEL OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************
 ***************************************************************************/

/*************************************************************************/
/*! \file   e1000.h
 *  \author Intel Corporation
 *  \date   1999-2001
 *  \brief  Linux PRO/1000 Ethernet Driver main header file
 *************************************************************************/

#ifndef _E1000_H_
#define _E1000_H_

struct adapter;

#include <linux/config.h>
#include "e1000_kcompat.h"
#include <linux/module.h>
#include <linux/types.h>
#include <asm/byteorder.h>

/* Prevent name space polution */
#define BD_ANS_BCMP e1000_BD_ANS_BCMP
#define BD_ANS_BCOPY e1000_BD_ANS_BCOPY
#define BD_ANS_BZERO e1000_BD_ANS_BZERO
#define DiagEepromTest e1000_DiagEepromTest
#define DiagFifoTest e1000_DiagFifoTest
#define DiagIntrRoutine e1000_DiagIntrRoutine
#define DiagIntrTest e1000_DiagIntrTest
#define DiagLinkTest e1000_DiagLinkTest
#define DiagLoopbackTest e1000_DiagLoopbackTest
#define DiagRegTest e1000_DiagRegTest
#define IntelCopyrightString e1000_IntelCopyrightString
#define Osdep_LoopBackTest e1000_Osdep_LoopBackTest
#define SetLoopBackMode e1000_SetLoopBackMode
#define ans_notify e1000_ans_notify
#define bd_ans_ActivateFastPolling e1000_ans_ActivateFastPolling
#define bd_ans_AttributeFill e1000_ans_AttributeFill
#define bd_ans_DeActivateFastPolling e1000_ans_DeActivateFastPolling
#define bd_ans_Disconnect e1000_ans_Disconnect
#define bd_ans_ExtendedGetCapability e1000_ans_ExtendedGetCapability
#define bd_ans_ExtendedGetStatus e1000_ans_ExtendedGetStatus
#define bd_ans_ExtendedSetMode e1000_ans_ExtendedSetMode
#define bd_ans_ExtendedStopPromiscuousMode e1000_ans_ExtendedStopPromiscuousMode
#define bd_ans_ExtractValue e1000_ans_ExtractValue
#define bd_ans_FillStatus e1000_ans_FillStatus
#define bd_ans_GetAllCapabilities e1000_ans_GetAllCapabilities
#define bd_ans_GetVlanId e1000_ans_GetVlanId
#define bd_ans_Identify e1000_ans_Identify
#define bd_ans_Init e1000_ans_Init
#define bd_ans_IsQtagPacket e1000_ans_IsQtagPacket
#define bd_ans_ProcessRequest e1000_ans_ProcessRequest
#define bd_ans_Receive e1000_ans_Receive
#define bd_ans_ResetAllModes e1000_ans_ResetAllModes
#define bd_ans_SetReportingMode e1000_ans_SetReportingMode
#define bd_ans_TagGetCapability e1000_ans_TagGetCapability
#define bd_ans_TagSetMode e1000_ans_TagSetMode
#define bd_ans_Transmit e1000_ans_Transmit
#define bd_ans_VlanGetCapability e1000_ans_VlanGetCapability
#define bd_ans_VlanSetMode e1000_ans_VlanSetMode
#define bd_ans_VlanSetTable e1000_ans_VlanSetTable
#define bd_ans_drv_ConfigureTagging e1000_ans_drv_ConfigureTagging
#define bd_ans_drv_ConfigureVlan e1000_ans_drv_ConfigureVlan
#define bd_ans_drv_ConfigureVlanTable e1000_ans_drv_ConfigureVlanTable
#define bd_ans_drv_InitANS e1000_ans_drv_InitANS
#define bd_ans_drv_StartWatchdog e1000_ans_drv_StartWatchdog
#define bd_ans_drv_StopPromiscuousMode e1000_ans_drv_StopPromiscuousMode
#define bd_ans_drv_StopWatchdog e1000_ans_drv_StopWatchdog
#define bd_ans_drv_UpdateStatus e1000_ans_drv_UpdateStatus
#define bd_ans_hw_DisableTagging e1000_ans_hw_DisableTagging
#define bd_ans_hw_EnablePriorityRx e1000_ans_hw_EnablePriorityRx
#define bd_ans_hw_EnableVLAN e1000_ans_hw_EnableVLAN
#define bd_ans_hw_GetVlanId e1000_ans_hw_GetVlanId
#define bd_ans_hw_InsertQtagHW e1000_ans_hw_InsertQtagHW
#define bd_ans_hw_IsQtagPacket e1000_ans_hw_IsQtagPacket
#define bd_ans_hw_available_speeds e1000_ans_hw_available_speeds
#define bd_ans_os_AllocateTLV e1000_ans_os_AllocateTLV
#define bd_ans_os_AttributeFill e1000_ans_os_AttributeFill
#define bd_ans_os_InsertQtagSW e1000_ans_os_InsertQtagSW
#define bd_ans_os_Ioctl e1000_ans_os_Ioctl
#define bd_ans_os_Receive e1000_ans_os_Receive
#define bd_ans_os_ReserveSpaceForANS e1000_ans_os_ReserveSpaceForANS
#define bd_ans_os_SetCallback e1000_ans_os_SetCallback
#define bd_ans_os_StripQtagSW e1000_ans_os_StripQtagSW
#define bd_ans_os_Transmit e1000_ans_os_Transmit
#define bd_ans_os_Watchdog e1000_ans_os_Watchdog

#define static static

#include "e1000_fxhw.h"
#include "e1000_phy.h"

#ifdef IANS
#include "base_comm.h"
#include "ans_driver.h"
#include "ans.h"
#endif

#ifdef IDIAG
#include "idiag_pro.h"
#include "idiag_e1000.h"
#endif

#define PCI_DEVICE_ID_82542        0x1000
#define PCI_DEVICE_ID_82543GC_FIBER  0x1001
#define PCI_DEVICE_ID_82543GC_COPPER 0x1004
#define PCI_DEVICE_ID_82544EI_COPPER 0x1008
#define PCI_DEVICE_ID_82544EI_FIBER  0x1009
#define PCI_DEVICE_ID_82544GC_DT_COPPER   0x100C
#define PCI_DEVICE_ID_82544GC_CREB   0x100D
#define BAR_0 0

/* 8254x can use Dual Address Cycles for 64-bit addressing */
/* Advertise that we can DMA from any address location */
#define E1000_DMA_MASK (~0x0UL)
#define E1000_DBG(args...)
// #define E1000_DBG(args...) printk("e1000: " args)
#define E1000_ERR(args...) printk(KERN_ERR "e1000: " args)
#ifdef CONFIG_PPC
#define E1000_MAX_INTR 1
#else
#define E1000_MAX_INTR 10
#endif
#define MAX_NUM_MULTICAST_ADDRESSES 128

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/string.h>
#include <linux/pagemap.h>
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <linux/capability.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <net/pkt_sched.h>

/* ethtool support */
#ifdef SIOCETHTOOL
#include <linux/ethtool.h>
#include <asm/uaccess.h>
#define E1000_ETHTOOL
#define  E1000_ETHTOOL_COPPER_INTERFACE_SUPPORTS (SUPPORTED_10baseT_Half | \
					SUPPORTED_10baseT_Full | SUPPORTED_100baseT_Half | \
					SUPPORTED_100baseT_Full | SUPPORTED_1000baseT_Full | \
					SUPPORTED_Autoneg | SUPPORTED_MII)
#define  E1000_ETHTOOL_COPPER_INTERFACE_ADVERTISE (ADVERTISED_10baseT_Half | \
					ADVERTISED_10baseT_Full | ADVERTISED_100baseT_Half | \
					ADVERTISED_100baseT_Full | ADVERTISED_1000baseT_Full | \
					ADVERTISED_Autoneg | ADVERTISED_MII)
#define E1000_ETHTOOL_FIBER_INTERFACE_SUPPORTS (SUPPORTED_Autoneg | \
					SUPPORTED_FIBRE)
#define E1000_ETHTOOL_FIBER_INTERFACE_ADVERTISE (ADVERTISED_Autoneg | \
					ADVERTISED_FIBRE)
#endif /* SIOCETHTOOL */

#define B_TRUE  1
#define B_FALSE 0
#define TRUE    1
#define FALSE   0

/* command line options defaults */
#define DEFAULT_TXD                  256
#define MAX_TXD                      256
#define MIN_TXD                       80
#define MAX_82544_TXD               4096    
#define DEFAULT_RXD                  256
#define MAX_RXD                      256
#define MIN_RXD                       80
#define MAX_82544_RXD               4096
#define DEFAULT_TIDV                  64
#define MAX_TIDV                  0xFFFF
#define MIN_TIDV                       0
#define DEFAULT_RIDV                  64
#define MAX_RIDV                  0xFFFF
#define MIN_RIDV                       0
#define DEFAULT_MDIX                   0
#define MAX_MDIX                       3
#define MIN_MDIX                       0

#define OPTION_UNSET    -1
#define OPTION_DISABLED 0
#define OPTION_ENABLED  1
#define XSUMRX_DEFAULT       OPTION_ENABLED
#define WAITFORLINK_DEFAULT  OPTION_ENABLED
#define AUTONEG_ADV_DEFAULT  0x2F
#define AUTONEG_ADV_MASK     0x2F
#define FLOW_CONTROL_DEFAULT FLOW_CONTROL_FULL

#define E1000_REPORT_TX_EARLY  2
#define E1000_PCI_MWI_ENABLE   1
#define E1000_PCI_MLT_OVERRIDE 0

#define E1000_BUS_TYPE_PCI               1
#define E1000_BUS_TYPE_PCIX              2

#define E1000_BUS_SPEED_PCI_33MHZ        1
#define E1000_BUS_SPEED_PCI_66MHZ        2
#define E1000_BUS_SPEED_PCIX_50_66MHZ    3
#define E1000_BUS_SPEED_PCIX_66_100MHZ   4
#define E1000_BUS_SPEED_PCIX_100_133MHZ  5
#define E1000_BUS_SPEED_PCIX_RESERVED    6

#define E1000_BUS_WIDTH_32_BIT           1
#define E1000_BUS_WIDTH_64_BIT           2

/* Supported RX Buffer Sizes */
#define E1000_RXBUFFER_2048        2048
#define E1000_RXBUFFER_4096        4096
#define E1000_RXBUFFER_8192        8192
#define E1000_RXBUFFER_16384      16384

#define E1000_JUMBO_PBA		0x00000028
#define E1000_DEFAULT_PBA	0x00000030

#define ETH_LENGTH_OF_ADDRESS 6

#define RET_STATUS_SUCCESS 0
#define RET_STATUS_FAILURE 1

/* The size in bytes of a standard ethernet header */
#define ENET_HEADER_SIZE    14
#define MAX_INTS            256
#define CRC_LENGTH 4

#define MAXIMUM_ETHERNET_PACKET_SIZE    1514
#define RCV_PKT_MUL              5

/* Round size up to the next multiple of unit */
#define E1000_ROUNDUP(size, unit) ((((size) + (unit) - 1) / (unit)) * (unit))
/* This is better, but only works for unit sizes that are powers of 2 */
#define E1000_ROUNDUP2(size, unit) (((size) + (unit) - 1) & ~((unit) - 1))

/* wrapper around a pointer to a socket buffer,
 * so a DMA handle can be stored along with the buffer */
struct e1000_buffer {
    struct sk_buff *skb;
    uint64_t       dma;
    unsigned long  length;
};

/* Adapter->flags definitions */
#define E1000_BOARD_OPEN 0
#define E1000_RX_REFILL 1
#define E1000_DIAG_OPEN 2

typedef enum _XSUM_CONTEXT_T {
    OFFLOAD_NONE,
    OFFLOAD_TCP_IP,
    OFFLOAD_UDP_IP
} XSUM_CONTEXT_T;

/* board specific private data structure */

struct adapter {
    struct adapter *next;
    struct adapter *prev;

#ifdef IANS
    void *iANSReserved;
    piANSsupport_t iANSdata;
    u32 ans_link;
    u32 ans_speed;
    u32 ans_duplex;
    u32 ans_suspend;
    IANS_BD_TAGGING_MODE tag_mode;
#endif

    /* MMIO PCI Registers */
    volatile struct E1000_REGISTERS *HardwareVirtualAddress;

    spinlock_t stats_lock;
    spinlock_t rx_fill_lock;

    unsigned long flags;
    uint32_t bd_number;
    struct timer_list timer_id;

    /* Ethernet Node Address */
    uint8_t CurrentNetAddress[ETH_LENGTH_OF_ADDRESS];
    uint8_t PermNetAddress[ETH_LENGTH_OF_ADDRESS];

    /* Mac and Phy Settings */
    MAC_TYPE MacType;
    GIGABIT_MEDIA_TYPE MediaType;
    uint32_t PhyId;
    uint32_t PhyAddress;

    /* MAC Configuration */
    uint8_t AutoNeg;
    uint8_t ForcedSpeedDuplex;
    uint16_t AutoNegAdvertised;
    uint8_t WaitAutoNegComplete;

    /* Status Flags */
    u8 LinkIsActive;
    uint16_t LineSpeed;
    uint16_t FullDuplex;
    u8 GetLinkStatus;
    u8 LinkStatusChanged;
    u8 LongPacket;
    uint32_t RxBufferLen;
    u8 TbiCompatibilityEnable;
    u8 TbiCompatibilityOn;

    /* PCI Device Info */
    uint16_t VendorId;
    uint16_t DeviceId;
    uint8_t RevId;
    uint16_t SubVendorId;
    uint16_t SubSystemId;

    /* PCI Bus Info */
    E1000_BUS_TYPE_ENUM BusType;
    E1000_BUS_SPEED_ENUM BusSpeed;
    E1000_BUS_WIDTH_ENUM BusWidth;

    u32 PartNumber;

    u8 NosEnabledMulticastPromiscuous;

    u8 AdapterStopped;
    uint32_t IntMask;
    uint16_t PciCommandWord;
    uint8_t DmaFairness;
    uint32_t OriginalFlowControl;
    uint8_t FlowControl;
    uint16_t FlowControlHighWatermark;
    uint16_t FlowControlLowWatermark;
    uint16_t FlowControlPauseTime;
    u8 FlowControlSendXon;
    u8 ReportTxEarly;
    uint32_t TxcwRegValue;
    uint32_t AutoNegFailed;

    u32 MaxFrameSize;
#if 0
    /* e1000_adaptive */
    u8 AdaptiveTxThreshold;
    u32 CurrentTxThreshold;
    u8 TxThresholdTimer;
    u8 AdaptiveIFS;
    u8 InIFSMode;
    u8 IFSParamsForced;
    u16 CurrentIFSValue;
    u16 IFSMaxValue;
    u16 IFSMinValue;
    u16 IFSStepSize;
    u16 IFSRatio;
#endif

    /* driver specific */
    struct tasklet_struct rx_fill_tasklet;

    int NumTxDescriptors;
    uint32_t TxIntDelay;
    int NextAvailTxDescriptor;
    int OldestUsedTxDescriptor;
    struct _E1000_TRANSMIT_DESCRIPTOR *TxDescriptors;
    dma_addr_t TxDescDMA;
    struct e1000_buffer *tx_skb;
    atomic_t NumTxDescriptorsAvail;
    uint32_t TxdCmd;

    int NumRxDescriptors;
    uint32_t RxIntDelay;
    int NextRxDescriptorToCheck;
    struct _E1000_RECEIVE_DESCRIPTOR *RxDescriptors;
    dma_addr_t RxDescDMA;
    struct e1000_buffer *rx_skb;
    atomic_t NumRxDescriptorsEmpty;
    int NextRxDescriptorToFill;
    atomic_t tx_timeout;

    uint64_t XsumRXGood;
    uint64_t XsumRXError;
    
    /* Linux driver specific */
    struct net_device *netdev;
    struct pci_dev *pdev;
    struct net_device_stats net_stats;
    char *id_string;
    uint8_t RxChecksum;
    XSUM_CONTEXT_T ActiveChecksumContext;

    phy_status_info_struct phy_info;
    uint8_t MdiX;
    uint8_t DisablePolarityCorrection;

    /* Multicast Stuff */
    u32 MulticastFilterType;
    u32 NumberOfMcAddresses;
    u8 MulticastAddressList[MAX_NUM_MULTICAST_ADDRESSES][ETH_LENGTH_OF_ADDRESS];
    /* calling these out as unsigned longs helps match up with the OS
     * stats, which as unsigned longs change from 32 to 64 bits when moving
     * to a 64-bit CPU, that change should not effect us */

    /* statistic registers present in the 82542 */
    unsigned long Crcerrs;
    unsigned long Symerrs;
    unsigned long Mpc;
    unsigned long Scc;
    unsigned long Ecol;
    unsigned long Mcc;
    unsigned long Latecol;
    unsigned long Colc;
    unsigned long Dc;
    unsigned long Sec;
    unsigned long Rlec;
    unsigned long Xonrxc;
    unsigned long Xontxc;
    unsigned long Xoffrxc;
    unsigned long Xofftxc;
    unsigned long Fcruc;
    unsigned long Prc64;
    unsigned long Prc127;
    unsigned long Prc255;
    unsigned long Prc511;
    unsigned long Prc1023;
    unsigned long Prc1522;
    unsigned long Gprc;
    unsigned long Bprc;
    unsigned long Mprc;
    unsigned long Gptc;
    unsigned long Gorcl;
    unsigned long Gorch;
    unsigned long Gotcl;
    unsigned long Gotch;
    unsigned long Rnbc;
    unsigned long Ruc;
    unsigned long Rfc;
    unsigned long Roc;
    unsigned long Rjc;
    unsigned long Torcl;
    unsigned long Torch;
    unsigned long Totcl;
    unsigned long Totch;
    unsigned long Tpr;
    unsigned long Tpt;
    unsigned long Ptc64;
    unsigned long Ptc127;
    unsigned long Ptc255;
    unsigned long Ptc511;
    unsigned long Ptc1023;
    unsigned long Ptc1522;
    unsigned long Mptc;
    unsigned long Bptc;
    /* statistic registers added in the 82543 */
    unsigned long Algnerrc;
    unsigned long Rxerrc;
    unsigned long Tuc;
    unsigned long Tncrs;
    unsigned long Cexterr;
    unsigned long Rutec;
    unsigned long Tsctc;
    unsigned long Tsctfc;

    /* PHY Statistics */
    uint32_t receive_errors;
    uint32_t idle_errors;
};

/* PCI defines needed by e1000_fxhw.c */
/* define these using the Linux names for the same thing (pci.h) */
#define CMD_MEM_WRT_INVALIDATE PCI_COMMAND_INVALIDATE
#define PCI_COMMAND_REGISTER PCI_COMMAND

/* Prototypes */
/* e1000_main.c */
extern int e1000_init_module(void);
extern int e1000_probe_all(void);
extern void e1000_exit_module(void);
extern int e1000_probe(struct pci_dev *pdev,
                                 const struct pci_device_id *ent);
extern void e1000_remove(struct pci_dev *pdev);
extern void e1000_delete(struct adapter * Adapter);
extern int e1000_open(struct net_device *netdev);
extern int e1000_close(struct net_device *netdev);
extern void e1000_set_multi(struct net_device *netdev);
extern int e1000_xmit_frame(struct sk_buff *skb, struct net_device *netdev);
extern struct net_device_stats *e1000_get_stats(struct net_device *netdev);
extern int e1000_change_mtu(struct net_device *netdev, int new_mtu);
extern int e1000_set_mac(struct net_device *netdev, void *p);
extern void e1000_intr(int irq, void *data, struct pt_regs *regs);
extern int e1000_ioctl(struct net_device *netdev,
                          struct ifreq *ifr, int cmd);
extern void e1000_watchdog(unsigned long data);
extern void e1000_diag_ioctl(struct net_device *netdev, struct ifreq *ifr);

/*  #include "e1000_adaptive.h" */
#include "e1000_proc.h"
#ifdef IDIAG
#include "e1000_idiag.h"
#endif
#endif /* _E1000_H_ */
