Name        	: ucd-snmp
Version     	: 4.2.1
Release     	: 17
Group       	: Administration/Network

Summary     	: Simple Network Management Protocol (SNMP) tools.

Copyright   	: distributable
Packager    	: Olaf Kirch <okir@caldera.de>
URL         	: http://net-snmp.sourceforge.net/


BuildRoot   	: /tmp/%{Name}-%{Version}

%define		ShlibVer	0.%{Version}

Source0: ftp://ucd-snmp.ucdavis.edu/ucd-snmp-%{Version}.tar.gz
Source1: ucd-snmp-%{Version}-COL.init
Source2: ucd-snmp-%{Version}-COL.conf
Source3: ftp://ucd-snmp.ucdavis.edu/contrib/ucd-ipchains.tar.gz
Patch0:  ucd-snmp-%{Version}-glibc.patch
Patch1:  ucd-snmp-%{Version}-security.patch
Patch2:  ucd-snmp-%{Version}-man.patch
# This patch fixes buffer overflows in various locations
# (including but not limited to snmptrapd).
Patch3:  ucd-snmp-%{Version}-security2.patch
# This patch fixes a signedness issue with ASN.1 length values
Patch4:  ucd-snmp-%{Version}-security3.patch
# This one adds a weird compaq extension
Patch5:  ucd-snmp-%{Version}-compaq.patch
# This one tries to avoid client timeouts during snmpbulkwalk
Patch6:  ucd-snmp-%{Version}-hostmib.patch
# This one makes sure that libsnmp always pulls in libcrypto
Patch7:  ucd-snmp-%{Version}-ssl.patch
# Patches galore: fix a segfault in snmpdf
Patch8:  ucd-snmp-%{Version}-df.patch
# Remotely exploitable buffer overflow
Patch9:  ucd-snmp-%{Version}-security4.patch
# Misc fixes backported from release 4.2.2
Patch10: ucd-snmp-%{Version}-422.patch
# Fix a buffer overflow in snmpnetstat
Patch11: ucd-snmp-%{Version}-security5.patch
# General security cleanup courtesy of Thomas Biege at SuSE
Patch12: ucd-snmp-%{Version}-suse.patch

%Package devel
Group       	: Administration/Network
Requires    	: ucd-snmp

Summary     	: The development environment for the UCD-SNMP project.


%Package utils
Group       	: Administration/Network
Requires    	: ucd-snmp

Summary     	: SNMP network management utilities, from the UCD-SNMP project.

%Package tkmib
Group       	: Administration/Network
Requires    	: ucd-snmp, perl-tk

Summary     	: A browser for SNMP MIB files.


%Description
This package contains an implementation of an SNMP agent originally
developed at UC Davis. SNMP client utilities can be found in the
ucd-snmp-utils package.

%Description devel
The ucd-snmp-devel package contains the development libraries and header files
for use with the UCD-SNMP project's network management tools. Install the 
ucd-snmp-devel package if you would like to develop applications for use with 
the UCD-SNMP project's network management tools. You will also need to have 
the ucd-snmp and ucd-snmp-utils packages installed.

%Description utils
The ucd-snmp package contains various utilities for use with the UCD-SNMP 
network management project. Install this package if you need utilities for 
managing your network using the SNMP protocol.  You will also need to install 
the ucd-snmp package.

%Description tkmib
This package contains tkmib, a utility for browsing SNMP MIBs.

%Prep
%setup -q -a3
%patch0 -p1 -b .glibc
%patch1 -p1 -b .security
%patch2 -p1 -b .man
%patch3 -p1 -b .security2
%patch4 -p1 -b .security3
%patch5 -p1 -b .compaq
%patch6 -p1 -b .hostmib
%patch7 -p1 -b .ssl
%patch8 -p1 -b .df
%patch9 -p1 -b .security4
%patch10 -p1 -b .422
%patch11 -p1 -b .security5
%patch12 -p1 -b .suse
ln -s ../agent/mibgroup/ipfwchains/IPFWCHAINS-MIB.txt mibs


%Build
autoconf

# mibII/vacm_vars.c crashes the egcs compiler with -O2
case `gcc --version` in
egcs*)	RPM_OPT_FLAGS=`echo $RPM_OPT_FLAGS | sed 's:-O2:-O:'`;;
esac

# This will now build both shared and static libs
./configure --prefix=/usr				\
	--exec-prefix=/usr				\
	--with-cflags="$RPM_OPT_FLAGS"			\
	--with-ldflags="-s"				\
	--with-sys-location="Unknown"			\
	--with-persistent-directory="/var/lib/snmp"	\
	--with-mib-modules="host ipfwchains/ipfwchains cmaX" \
	--without-libwrap				\
	--with-logfile=none				\
	--sysconfdir=/etc				\
	--disable-debugging				\
	--with-sys-contact="root@localhost"		\
	--enable-ipv6					\
	--without-root-access
# Disabled - we now log through syslog
#	--with-libwrap=/usr/lib
#	--with-logfile=/var/log/snmpd.log

make -C snmplib

# lastly ...
make all


%Install
%{mkDESTDIR}

make	prefix=$DESTDIR/usr				\
	exec_prefix=$DESTDIR/usr 			\
	persistentdir=$DESTDIR/var/ucd-snmp 		\
	PERSISTENT_DIRECTORY=$DESTDIR/var/ucd-snmp 	\
	install

# add header link ...
ln -s ucd-snmp $DESTDIR/usr/include/snmp

# install init script ...
install -d $DESTDIR%{SVIdir}
install -m 755 %SOURCE1 $DESTDIR%{SVIdir}/snmpd
%{fixUP} -vT $DESTDIR%{SVIdir}/snmpd -e 's|\@SVIdir\@|%{SVIdir}|o'

# The -u/-g options to snmpd tell it to run as user nobody.
# We should probably create a separate user named snmp to avoid
# weakiening the nobody account.
mkdir -p $DESTDIR%{SVIcdir}
cat <<-EOD  > $DESTDIR%{SVIcdir}/snmpd
	IDENT=snmpd
	DESCRIPTIVE="Simple Network Management Protocol (SNMP) Agent"
	ONBOOT=no
	OPTIONS="-u 65534 -g 65534"
EOD

# install config files ...
install -d $DESTDIR/etc/snmp
install -m 644 %SOURCE2 $DESTDIR/etc/snmp/snmpd.conf
install -m 644 /dev/null $DESTDIR/etc/snmp/snmpd.local.conf

# install perl module
mkdir -p $DESTDIR/usr/lib/perl5/site-perl
install -m 444 perl/SNMP/SNMP.pm $DESTDIR/usr/lib/perl5/site-perl

%{fixUP} -vT $DESTDIR \
 	-e 's:/usr/local/bin/perl5:/usr/bin/perl:' \
 	-e 's:/usr/local/bin/perl:/usr/bin/perl:' \
	-e 's:/usr/bin/perl55:/usr/bin/perl:'

# Create the presistent data directory
mkdir -p $DESTDIR/var/lib/snmp
touch $DESTDIR/var/lib/snmp/.snmp-exec-cache

%{fixManPages}


%Clean
%{rmDESTDIR}


%Post
/sbin/ldconfig

/usr/lib/LSB/init-install snmpd
if [ -s /etc/snmpd/snmpd.conf.rpmsave ]; then
	cp /etc/snmpd/snmpd.conf.rpmsave /etc/snmpd/snmpd.conf
fi
# ! %{SVIdir}/snmpd status || %{SVIdir}/snmpd restart

%PreUn
rm -f /usr/share/snmp/mibs/.index
rm -f /var/lib/snmp/*

%PostUn
/sbin/ldconfig

/usr/lib/LSB/init-remove snmpd || true


%Files
%defattr(-,root,root,-)
%doc	ChangeLog EXAMPLE.conf FAQ NEWS PORTING README* TODO

# the config files contain passwords ... 
%attr(700,root,root) %dir	/etc/snmp
%attr(600,root,root) %config(noreplace) /etc/snmp/snmpd.conf
%attr(600,root,root) %config(noreplace,missingok) /etc/snmp/snmpd.local.conf

%attr(555,root,root) %config	%{SVIdir}/snmpd
%attr(644,root,root) %config	%{SVIcdir}/snmpd

%attr(555,root,root) %dir	/usr/share/snmp
%attr(444,root,root)		/usr/share/snmp/mib2c.*
%attr(555,root,root) %dir	/usr/share/snmp/mibs
%attr(444,root,root)		/usr/share/snmp/mibs/*
%attr(555,root,root) %dir	/usr/share/snmp/snmpconf
%attr(444,root,root)		/usr/share/snmp/snmpconf/*
%attr(755,root,root) %dir	/var/lib/snmp
%attr(600,nobody,root)		/var/lib/snmp/.snmp-exec-cache

%attr(555,root,root) /usr/lib/lib*[0-9].so
%attr(555,root,root) /usr/sbin/snmpd
%attr(555,root,root) /usr/sbin/snmptrapd
%attr(444,root,root) %{_mandir}%{manEN}/man1/snmpd.1*
%attr(444,root,root) %{_mandir}%{manEN}/man5/*.5*
%attr(444,root,root) %{_mandir}%{manEN}/man8/snmptrapd.8*


%Files devel
%defattr(0644,root,root,0555)
%attr(555,root,root) /usr/lib/lib*[a-z].so
%attr(444,root,root) /usr/lib/lib*.a
%attr(555,root,root) %dir /usr/include/ucd-snmp
%attr(444,root,root) /usr/include/ucd-snmp/*.h
%attr(555,root,root) /usr/include/snmp
%attr(444,root,root) %{_mandir}%{manEN}/man3/*.3*


%Files utils
%defattr(-,root,root,-)
%attr(555,root,root) /usr/bin/[a-s]*

%attr(444,root,root)	%{_mandir}%{manEN}/man1/snmp??*.1*

%Files tkmib
%attr(555,root,root) /usr/bin/tkmib
%attr(444,root,root) /usr/lib/perl5/site-perl/SNMP.pm


%ChangeLog
* Mon Jan 01 1998 ...
Template Version: 1.31

$Id: ucd-snmp.spec,v 1.24 2001/12/11 10:53:52 okir Exp $
