/*
 * Copyright (c) 2017 Oleg Safiullin <form@pdp-11.org.ru>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#include "e11.h"
#include "cm1420.h"

static word pages[] = {
	0012737, 0000200, 0173024, 0012737, 0000200, 0173024, 0000007, 0000027,
	0041123, 0173042, 0173000, 0000340, 0012701, 0177420, 0012706, 0173750,
	0001023, 0042113, 0173114, 0010704, 0001356, 0012701, 0177400, 0062701,
	0000004, 0060303, 0060303, 0060303, 0060303, 0060303, 0010361, 0000006,
	0012702, 0000005, 0012706, 0173266, 0012707, 0173674, 0042120, 0173142,
	0010704, 0001331, 0012701, 0176710, 0062701, 0000004, 0010311, 0012707,
	0173100, 0042122, 0173172, 0010704, 0001316, 0012701, 0176700, 0012761,
	0000040, 0000010, 0012706, 0173556, 0001347, 0042130, 0173244, 0010704,
	0001302, 0012701, 0177170, 0012703, 0000007, 0042704, 0177776, 0001402,
	0012703, 0000027, 0011102, 0042702, 0077737, 0001774, 0010311, 0012706,
	0173002, 0001322, 0042115, 0173350, 0010704, 0001255, 0012701, 0177440,
	0010461, 0000010, 0012711, 0000003, 0012702, 0000021, 0011104, 0042704,
	0177577, 0001774, 0011104, 0042704, 0077777, 0001674, 0016104, 0000014,
	0042704, 0177737, 0001551, 0000005, 0012706, 0173476, 0001265, 0042703,
	0000004, 0010337, 0177170, 0001055, 0042131, 0173536, 0010704, 0001310,
	0060404, 0000005, 0010101, 0010101, 0012700, 0000001, 0040202, 0012705,
	0000100, 0012706, 0000400, 0040306, 0001401, 0060505, 0016403, 0173014,
	0060603, 0010706, 0001346, 0001022, 0001016, 0001341, 0001035, 0001010,
	0060502, 0060502, 0062700, 0000002, 0022700, 0000011, 0001357, 0040707,
	0010237, 0177172, 0001006, 0012701, 0000001, 0001001, 0010401, 0010137,
	0177172, 0013701, 0177170, 0042701, 0077537, 0001773, 0042701, 0000240,
	0001320, 0062706, 0000002, 0010607, 0010537, 0177172, 0001362, 0046524,
	0173560, 0010704, 0001215, 0012701, 0172520, 0012706, 0173164, 0001046,
	0046515, 0173702, 0010704, 0001204, 0012701, 0172440, 0012706, 0173336,
	0001035, 0177777, 0177777, 0177777, 0013720, 0177570, 0014004, 0005110,
	0011003, 0000772, 0013710, 0177570, 0105111, 0011004, 0000773, 0010220,
	0113711, 0177570, 0014004, 0000773, 0000005, 0012737, 0000100, 0173024,
	0060303, 0060303, 0060303, 0060303, 0060303, 0010507, 0012737, 0000100,
	0173024, 0050122, 0173724, 0040000, 0040000, 0010101, 0010101, 0012737,
	0000200, 0173024, 0051515, 0000000, 0010704, 0001304, 0012706, 0173524,
	0001355, 0062704, 0000004, 0012737, 0000300, 0173024, 0012704, 0173020,
	0022402, 0001767, 0012404, 0001374, 0012737, 0000300, 0173024, 0001325,

	0000777, 0042703, 0000004, 0040202, 0010706, 0001055, 0012761, 0000001,
	0000002, 0001002, 0173000, 0000341, 0062702, 0000001, 0022702, 0000002,
	0001363, 0011102, 0042702, 0077737, 0001774, 0042702, 0000040, 0001102,
	0010311, 0040303, 0010706, 0001027, 0016102, 0000002, 0010706, 0001023,
	0016104, 0000002, 0060404, 0060404, 0060404, 0060404, 0060404, 0060404,
	0060404, 0060404, 0042702, 0177400, 0060204, 0010423, 0010302, 0042702,
	0177577, 0001750, 0040707, 0011104, 0042704, 0177577, 0001774, 0062706,
	0000002, 0010607, 0062701, 0000002, 0010311, 0016104, 0177776, 0042704,
	0177776, 0001773, 0011104, 0011103, 0062703, 0060011, 0062704, 0060017,
	0010411, 0011104, 0042704, 0177577, 0001774, 0012761, 0177777, 0000002,
	0010311, 0011104, 0042704, 0177577, 0001774, 0012702, 0060003, 0011104,
	0042704, 0077777, 0001102, 0012706, 0173650, 0012761, 0177000, 0000002,
	0011103, 0042703, 0000377, 0060203, 0010311, 0011104, 0042704, 0177577,
	0001774, 0011104, 0042704, 0077777, 0001001, 0040707, 0010607, 0010403,
	0062703, 0001300, 0010361, 0000032, 0016104, 0000012, 0042704, 0167777,
	0001773, 0012711, 0000007, 0016104, 0000012, 0042704, 0177577, 0001773,
	0012711, 0000011, 0016104, 0000012, 0042704, 0177577, 0001773, 0012761,
	0177777, 0000006, 0012711, 0000031, 0016104, 0000012, 0042704, 0177577,
	0001773, 0016161, 0000016, 0000016, 0012702, 0000071, 0012706, 0173462,
	0001304, 0016104, 0000014, 0022704, 0001000, 0001066, 0040707, 0010061,
	0000010, 0012711, 0002003, 0011104, 0042704, 0177577, 0001774, 0012702,
	0002021, 0001255, 0012700, 0176300, 0012760, 0000013, 0000006, 0005760,
	0000002, 0100375, 0032760, 0040000, 0000002, 0001036, 0005007, 0110461,
	0000010, 0012761, 0177000, 0000002, 0012711, 0000023, 0016103, 0000012,
	0042703, 0177577, 0001773, 0012703, 0000071, 0012707, 0173310, 0177777,
	0177777, 0177777, 0177777, 0177777, 0177777, 0177777, 0177777, 0177777,
	0177777, 0177777, 0177777, 0177777, 0000005, 0012737, 0000000, 0173024,
	0010004, 0042704, 0177770, 0010001, 0040401, 0001410, 0062705, 0000004,
	0001005, 0010607, 0177777, 0177777, 0177777, 0177777, 0010403, 0060303,
	0060303, 0060303, 0012707, 0173652, 0177777, 0177777, 0177777, 0177777,
	0177777, 0177777, 0177777, 0177777, 0060401, 0060401, 0012711, 0000001,
	0032711, 0100200, 0001775, 0100730, 0012737, 0000300, 0173024, 0177777,

	0012737, 0000300, 0173024, 0012704, 0000000, 0010005, 0012700, 0134534,
	0001003, 0000000, 0173000, 0000342, 0022700, 0134534, 0001401, 0000000,
	0022700, 0000534, 0001774, 0001001, 0000000, 0022700, 0134600, 0001774,
	0012703, 0032532, 0013700, 0173062, 0012703, 0173014, 0016303, 0000002,
	0060300, 0022700, 0167266, 0001401, 0000000, 0042700, 0156000, 0062700,
	0020454, 0022700, 0041742, 0001401, 0000000, 0012703, 0000134, 0040300,
	0022700, 0041642, 0001401, 0000000, 0012700, 0173250, 0012002, 0012003,
	0060203, 0001374, 0001401, 0000000, 0012002, 0012003, 0060203, 0001774,
	0001001, 0000000, 0012700, 0173250, 0012002, 0012003, 0060203, 0001402,
	0001373, 0000000, 0012002, 0012003, 0060203, 0001002, 0001773, 0000000,
	0010404, 0001656, 0040303, 0001422, 0040000, 0000000, 0140001, 0040000,
	0140000, 0100000, 0100000, 0000000, 0140000, 0140000, 0040000, 0040000,
	0000000, 0000000, 0040000, 0140000, 0100000, 0100000, 0012700, 0173456,
	0012706, 0000500, 0012705, 0122555, 0010526, 0012707, 0173430, 0012705,
	0055222, 0010516, 0012707, 0173430, 0012705, 0122555, 0016766, 0177772,
	0000000, 0012707, 0173430, 0012705, 0055222, 0012766, 0055222, 0000000,
	0012707, 0173430, 0012705, 0122555, 0010537, 0000500, 0012707, 0173430,
	0012705, 0055222, 0010566, 0000000, 0012706, 0000500, 0022605, 0001003,
	0012706, 0000500, 0012007, 0062700, 0177776, 0000000, 0001371, 0173336,
	0173350, 0173366, 0173404, 0173420, 0173472, 0012700, 0000001, 0012706,
	0000500, 0010016, 0022600, 0001003, 0060000, 0001371, 0001431, 0000000,
	0001366, 0010005, 0040101, 0010706, 0001057, 0022704, 0000001, 0001373,
	0010706, 0001052, 0010706, 0001017, 0010402, 0062702, 0177774, 0022702,
	0000002, 0001474, 0010706, 0001007, 0060504, 0010400, 0000455, 0177777,
	0012737, 0000300, 0173024, 0012737, 0000001, 0177550, 0105737, 0177550,
	0100375, 0013703, 0177552, 0060301, 0005302, 0012737, 0000001, 0177550,
	0105737, 0177550, 0100375, 0013704, 0177552, 0060401, 0000304, 0060304,
	0005302, 0062706, 0000002, 0010607, 0012737, 0000001, 0177550, 0105737,
	0177550, 0100375, 0013704, 0177552, 0060401, 0000762, 0012705, 0111111,
	0001024, 0177777, 0000676, 0110420, 0010706, 0001356, 0005702, 0002373,
	0000402, 0012707, 0173314, 0105701, 0001665, 0001360, 0010706, 0001313,
	0060405, 0010706, 0001341, 0105701, 0001351, 0012707, 0173000, 0177777,

	0177777, 0177777, 0177777, 0010500, 0010701, 0001103, 0010701, 0001167,
	0001003, 0000000, 0173000, 0000343, 0010701, 0001073, 0012702, 0000077,
	0010703, 0001114, 0010703, 0001012, 0060202, 0060202, 0060202, 0060202,
	0060202, 0060202, 0060202, 0060202, 0010201, 0010703, 0001066, 0060102,
	0010401, 0022702, 0046040, 0001430, 0020402, 0001002, 0062705, 0000002,
	0010204, 0022702, 0042440, 0001006, 0010500, 0010701, 0001120, 0011500,
	0012707, 0173014, 0022702, 0042040, 0001414, 0022702, 0051415, 0001002,
	0012707, 0173774, 0012707, 0173746, 0010701, 0001052, 0010005, 0040404,
	0001713, 0010500, 0010701, 0001073, 0010701, 0001042, 0010015, 0012707,
	0173030, 0012702, 0010012, 0010703, 0001021, 0042702, 0000377, 0062702,
	0177000, 0001531, 0062702, 0000015, 0001366, 0013706, 0177560, 0042706,
	0177577, 0001773, 0013702, 0177562, 0042702, 0177600, 0013706, 0177564,
	0042706, 0177577, 0001773, 0010237, 0177566, 0062703, 0000002, 0010307,
	0040000, 0010703, 0001352, 0022702, 0000015, 0001475, 0022702, 0000052,
	0001472, 0010206, 0042706, 0000007, 0022706, 0000060, 0001310, 0042702,
	0177770, 0060000, 0060000, 0060000, 0060200, 0012707, 0173322, 0010006,
	0012702, 0000060, 0042706, 0077777, 0001402, 0062702, 0000001, 0060000,
	0062700, 0000001, 0010703, 0001322, 0012702, 0000014, 0010006, 0042706,
	0077777, 0001402, 0062702, 0000001, 0060000, 0010006, 0060202, 0042706,
	0077777, 0001402, 0062702, 0000001, 0060000, 0010006, 0060202, 0042706,
	0077777, 0001402, 0062702, 0000001, 0060000, 0001401, 0001343, 0012702,
	0000040, 0010703, 0001263, 0062701, 0000002, 0010107, 0062700, 0177776,
	0010004, 0010701, 0001226, 0010701, 0001312, 0012400, 0010701, 0001307,
	0010500, 0010701, 0001304, 0010703, 0001230, 0010400, 0060504, 0062704,
	0177777, 0001013, 0001425, 0040000, 0010005, 0010520, 0022700, 0160000,
	0001373, 0040000, 0010005, 0022005, 0001341, 0022700, 0160000, 0001372,
	0040000, 0012705, 0177777, 0040005, 0010560, 0000000, 0022005, 0001326,
	0040202, 0010260, 0177776, 0022700, 0160000, 0001363, 0022703, 0173566,
	0001406, 0010300, 0062704, 0000002, 0010405, 0001030, 0010104, 0012707,
	0173030, 0000000, 0022702, 0000015, 0001365, 0010003, 0012737, 0000200,
	0173024, 0177777, 0177777, 0012737, 0000000, 0173024, 0012701, 0173722,
	0012707, 0173320, 0177777, 0177777, 0177777, 0177777, 0000005, 0001346,
};

static E11HANDLE reg;
static word page;


static void __stdcall
init(dword addr)
{
	page = 0;
}

static word __stdcall
dati(dword addr)
{
	addr -= ROM_BASE;

	return (pages[(page + addr) / 2]);
}

static void __stdcall
dato(dword addr, dword value, dword datob)
{
	if ((addr & ~1) != ROM_PCR)
		return;

	if (datob && !(addr & 1))
		return;

	page = (value & 0300) * 010;
}

int __stdcall
DllMain(unsigned long hinstDLL, unsigned long fdwReason, void *lvpReserved)
{
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:
		if (E11Version() < (5 * 256 + 0))
			return (FALSE);

		if ((reg = GetCSRBlock(ROM_BASE, ROM_SIZE,
		    dati, dato, init)) == 0)
			return (FALSE);

		init(ROM_BASE);
		break;
	case DLL_PROCESS_DETACH:
		RetCSRBlock(reg);
		break;
	default:
		return (FALSE);
	}

	return (TRUE);
}
