C	PROGRAM TO PLOT CONTENTS OF A DISPLAY FILE
C	  WRITTEN BY MICHAEL LAMPI    23-FEB-79
C	  UPDATED 5-10-79
C
C	  SUPPORTS TEKT 4662 FLATBED PLOTTER & VT-11 INSTRUCTION SET
C
	COMMON/DFILE/ IBUF(10000)
	COMMON/PLOTTR/LASTX,LASTY
	IMPLICIT INTEGER (A-Z)
C
	DIMENSION INSTR(13)
	LOGICAL*1 ILINE(40),ICHR(2),FNAME(16),ANSWER
	DIMENSION TSCAL(9)
	DIMENSION PLTON(3),PLTOFF(3),PLTRST(3),PLTPON(3),PLTPOF(3)
	DIMENSION PLTGIN(3)
	EQUIVALENCE (ICHAR,ICHR)
C
	DATA INSTR/"173400,"162000,"160000,"164000,"170000,
     C		   "174000,"120000,"124000,"110000,"104000,
     C		   "100000,"114000,"130000/
C
C	PLOTTER CONTROL CHARACTERS
	DATA PLTON/"33,'A','E'/, PLTOFF/"33,'A','F'/
	DATA PLTRST/"33,'A','N'/, PLTPON/"33,'A','K'/
	DATA PLTPOF/"33,'A','L'/, PLTGIN/"33,'A','M'/
	DATA US/'_'/,GS/"35/,BELL/"7/
	DATA TSCAL/"33,'A','I','5','6',' ','7','8',"177/
	DATA TWIDTH/14/,OINTNS/0/,LINTYP/1/,JFLAG/0/
C
	WRITE(5,4)
 11	WRITE(5,1)
 4	FORMAT(' DPLOT - Plotting Utility')
 1	FORMAT($,' Enter display file name:')
	READ(5,3) LEN,FNAME
 3	FORMAT(Q,16A1)
 2	FORMAT(16A1)
	IF(LEN.EQ.0) GOTO 11
C
C	CHECK FOR AN EXTENSION - IF THERE IS A PERIOD, ASSUME HE KNOWS
C	WHAT HE IS DOING; ELSE ADD DEFAULT EXTENSION OF ".DSP"
	DO 12 I=1,LEN
	IF(FNAME(I).EQ.'.') GOTO 13
12	CONTINUE
	FNAME(LEN+1)='.'
	FNAME(LEN+2)='D'
	FNAME(LEN+3)='S'
	FNAME(LEN+4)='P'
13	CONTINUE
C
C	  SEE IF THE FILE IS THERE
	OPEN(UNIT=7,NAME=FNAME,TYPE='OLD',READONLY,ERR=222)
C	  IF WE GET HERE, FILE MUST EXIST, SO CLOSE IT
	CLOSE(UNIT=7)
	GOTO 223
C	  ERROR--FILE NOT THERE
 222	WRITE(5,224)
 224	FORMAT(' ***ERROR: File not found***')
	GOTO 11
C
C	GET THE FILE
 223	CALL RSTR(FNAME)
	IMODE = 1
C
C	SEE HOW MUCH OF DISPLAY FILE REALLY USED
	DO 5 IEND=1,9999
	IF(IBUF(IEND).EQ.-1) GOTO 6
5	CONTINUE
6	IEND=IEND-1
C	  SEE WHAT CREATED THE DISPLAY FILE
 45	WRITE(5,50)
 50	FORMAT($,' (D)RAW, (T)est DRAW, or (B)ASIC format: ')
	READ(5,2) ANSWER
	IF(ANSWER.EQ.'D'.OR.ANSWER.EQ.'B'.OR.ANSWER.EQ.'T') GOTO 55
	WRITE(5,51)
 51	FORMAT($,' Enter starting address of display (O6 format): ')
	READ(5,52) ISTART
 52	FORMAT(O6)
	ISTART=ISTART+1
	GOTO 110
C
C	  DETERMINE PROPER DISPLAY FILE STARTING POINT
C	   FIRST, PRESENT STARTING ADDRESS OF THE TEST VERSION OF DRAW:
 55	IF(ANSWER.EQ.'T') ISTART="1711
C	  STARTING ADDRESS OF NON-TEST VERSION OF DRAW:
	IF(ANSWER.EQ.'D') ISTART="1271
C	  STARTING ADDRESS FOR BASIC:
	IF(ANSWER.EQ.'B') ISTART=2
C
C	COMES HERE IF HE WISHES TO PLOT THE DISPLAY FILE
C
110	CONTINUE
C	  INITIALIZE INPTT1 SUBROUTINE
	J=INPTT1(IDUMMY)
C	  INITIALIZE PLOTTER - TURN ON
	DO 112 I=1,3
	CALL OUTT(PLTON(I))
 112	CONTINUE
C
C	RESET PLOTTER
	DO 114 I=1,3
	CALL OUTT(PLTRST(I))
114	CONTINUE
C	  GET BUFFER SIZE OF PLOTTER
	CALL BUFCHK(10)
C	  INITIALIZE FLAGS
	IFLAG=0
	MODE=0
	DINSTR=0
	OINSTR=0
	INTENS=0
	I=ISTART
	INCR=0
	NEW=1
C	  START PLOTTING WITH DEFAULT PLOTTER LOCATION OF 0,0
	CALL APLOT(0,0,0)
120	CONTINUE
	IF(IBUF(I).LT.0) GOTO 900
125	IF(DINSTR.NE.0) GOTO 129
	WRITE(5,126) IBUF(I),I-1
126	FORMAT(' ERROR in decoding display file:',O6,' ADDR=',O6)
	STOP
C	FIGURE WHICH INSTRUCTION IT IS
129	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),DINSTR
C	DHALT - IGNORE THIS DATA WORD
130	IF(IBUF(I).EQ.0) IFLAG=IFLAG+1
	IF(IBUF(I).NE.0) IFLAG=0
	IF(IFLAG.GE.2) STOP'End DPLOT'
	NEW=0
	I=I+1
	GOTO 1000
C
C	DJSR - WE DON'T HAVE THIS INSTRUCTION
C
150	STOP'Missing DJSR support'
C
C	DJMPA - NOT YET SUPPORTED
C
200	IF(JFLAG.EQ.0) CALL PRINT('DJMPA not supported')
	JFLAG=1
	NEW=0
	OINSTR=0
C
C	DNOP WAS PREVIOUS INSTRUCTION; INTERPRET UNDER OLD INSTRUCTION
C
250	NEW=0
	IF(OINSTR.EQ.0) GOTO 260
	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),OINSTR
260	I=I+1
	GOTO 1000
C
C	LOAD STATUS REG A - SAME ACTION AS PREVIOUS INSTRUCTION=DNOP
300	GOTO 250
C
C	LOAD STATUS REGISTER B--LOAD XGRA/YGRA INCREMENT IF BIT 6 SET
350	IF((IBUF(I).AND."100).NE.0) INCR=IBUF(I).AND."77
	I=I+1
	GOTO 1000
C
C	XGRA - EVERY WORD IS A DATA POINT
400	NEW=0
	IY=IBUF(I).AND."1777
	CALL APLOT((LASTX+2)/4+INCR,IY,1)
	I=I+1
	GOTO 1000
C
C	YGRA - SAME AS XGRA EXCEPT ROTATED 90 DEGREES
450	NEW=0
	IX=IBUF(I).AND."1777
	CALL APLOT(IX,(LASTY+2)/4+INCR,1)
	I=I+1
	GOTO 1000
C
C	NOW FOR THE IMPORTANT STUFF - LVECT
C
500	NEW=0
	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
C	  CHECK IF SECOND WORD IS AN INSTRUCTION (BUG IN DECGRAPHIC)
	IF(IY.LT.0) GOTO 900
	I=I+1
C	NOW PLOT THIS VECTOR
C	SEE IF WE SHOULD HAVE PEN DOWN OR NOT
	IDRAW=1
	IF((IX.AND."040000).EQ.0) IDRAW=0
520	CONTINUE
C	COMPUTE COORDINATES
	ITX=IX.AND."001777
	ITY=IY.AND."001777
	IF((IX.AND."020000).NE.0) ITX=0-ITX
	IF((IY.AND."020000).NE.0) ITY=0-ITY
	CALL LPLOT(ITX,ITY,LINTYP,IDRAW)
	GOTO 1000
C
C	SVECT
C
550	NEW=0
C	SEE IF THE PEN SHOULD BE DOWN
	IDRAW=0
	IF((IBUF(I).AND."040000).NE.0) IDRAW=1
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	CALL LPLOT(IX,IY,LINTYP,IDRAW)
	I=I+1
	GOTO 1000
C
C	  TEXT
C
C	  FIRST RESET THE PLOTTER
 600	IF(NEW.EQ.0.OR.NEW.EQ.-1) GOTO 630
	NEW=-1
	CALL BUFCHK(30)
C	  FIRST RE-POSITION PEN ABOVE STARTING POINT
	CALL OUTT(GS)
	CALL PLOT(0,2*4)
C	  NOW RESET THE PLOTTER
	DO 610 J=1,3
 610	CALL OUTT(PLTRST(J))
C	  NOW SET UP THE PROPER SCALING
	DO 620 J=1,9
 620	CALL OUTT(TSCAL(J))
C
C	  NOW SEND THE CHARACTERS
 630	K=IBUF(I).AND."177
	K1=IBUF(I)/256
	CALL BUFCHK(5)
	CALL OUTT(K)
	CALL OUTT(K1)
	J=0
	IF(K.NE.0) J=1
	IF(K1.NE.0) J=J+1
	I=I+1
	IWORD=0
C	  INCREASE X-POSITION SO IF WE DRAW ANY VECTORS WE WILL THINK
C	  THAT WE ARE IN CORRECT LOCATION
	LASTX=LASTX+TWIDTH*J*4
	GOTO 1000
C
C	  APNT
C
 650	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
C	  CHECK IF SECOND WORD IS AN INSTRUCTION OR NOT
	IF(IY.LT.0) GOTO 900
	I=I+1
	ITX=(IX.AND."1777)
	ITY=(IY.AND."1777)
	MODE=0
	IF((IX.AND."040000).NE.0) MODE=1
	CALL APLOT(ITX,ITY,MODE)
	GOTO 1000
C
C	  RPNT
C
 700	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	CALL OUTT(GS)
	CALL PLOT(IX*4,IY*4)
C	  SEE IF WE SHOULD MAKE A DOT HERE
	IF((IBUF(I).AND."040000).NE.0) GOTO 720
C	  YES - PLOT THIS POINT 2 TIMES INSTEAD OF SENDING A BELL
	CALL PLOT(0,0)
	CALL PLOT(0,0)
 720	I=I+1
	GOTO 1000
C
C	  COMES HERE IF WE GOT AN INSTRUCTION
 900	CONTINUE
C	  SEE IF PREVIOUS INSTRUCTION WAS 'TEXT'
C	IF SO, THEN REPOSITION PEN DOWN A LINE
	IF(NEW.NE.-1) GOTO 905
	CALL OUTT(GS)
	CALL PLOT(0,-2*4)
 905	CONTINUE
C	  RESET DHALT FLAG TO INDICATE END OF DISPLAY FILE
	IF((IBUF(I).AND."177400).NE."173400) IFLAG=0
	DO 910 J=1,13
	IVAL=IBUF(I)
	IF(J.GE.5) IVAL=IVAL.AND."174000
	IF(IVAL.EQ.INSTR(J)) GOTO 920
 910	CONTINUE
 915	FORMAT(' Erroneous instruction found:',O6)
	WRITE(5,915) IBUF(I)
	STOP
 920	OINSTR=DINSTR
	DINSTR=J
	OINTNS=INTENS
	JFLAG=0
C	  PICK UP INTENSITY FROM SET GRAPHIC MODE INSTRUCTION
	IF((IBUF(I).AND."002000).NE.0.AND.J.GE.5)
     C		INTENS=(IBUF(I).AND."001600)/"200+1
	IF(OINTNS.EQ.INTENS) GOTO 930
C	  ASK FOR A CHANGE OF PEN FOR THIS INTENSITY
	WRITE(5,925) I-1,INTENS
 925	FORMAT($,1X,O6,' Intensity change to ',I1,
     C		'; change pen and hit <CR>')
	READ(5,2) FNAME
C
C	  NOW CHECK FOR A CHANGE IN LINE TYPE
 930	IF(J.GE.5.AND.(IBUF(I).AND."4).NE.0) LINTYP=(IBUF(I).AND."3)+1
	I=I+1
	MODE=0
	NEW=1
C
1000	CONTINUE
	IF(I.LE.IEND) GOTO 120
	STOP'End DPLOT'
	END



	SUBROUTINE RSTR(FNAME)
C	  THIS SUBROUTINE READS THE DISPLAY FILE FROM DISK TO MEMORY
	LOGICAL*1 FNAME(30)
	COMMON/DFILE/IBUF(32)
C
	DO 50 I=10000,1,-1
	IBUF(I)=-1
50	CONTINUE
C
	CALL ASSIGN(1,FNAME)
	DEFINE FILE 1(64,256,U,IBLK)
	IBLK=1
	READ(1'IBLK,END=110)J,(IBUF(K),K=1,255)
	IPTR=J
	DO 100 J=1,IPTR,256
100	READ(1'IBLK,END=110)(IBUF(K),K=J+255,J+510)
	CALL CLOSE(1)
	RETURN
C	  COMES HERE IF WE READ PAST END OF FILE
 110	WRITE(5,120)
 120	FORMAT(' *** Premature End of File encountered ***')
	RETURN
	END

 