C	PROGRAM TO CONVERT DISPLAY FILES TO .ARK FORMAT
C	  BASED ON PROGRAM TO PLOT CONTENTS OF A DISPLAY FILE
C	  WRITTEN BY MICHAEL LAMPI    23-MAY-79
C
C	  SUPPORTS VT-11 INSTRUCTION SET
C
	IMPLICIT INTEGER(A-Z)
	COMMON/DFILE/ IBUF(10000)
	COMMON/ARK/LASTX,LASTY,LASTIN,LINTYP
C
	DIMENSION INSTR(13)
	LOGICAL*1 ILINE(40),ICHR(2),FNAME(22),ANSWER
	EQUIVALENCE (ICHAR,ICHR)
C
	DATA INSTR/"173400,"162000,"160000,"164000,"170000,
     C		   "174000,"120000,"124000,"110000,"104000,
     C		   "100000,"114000,"130000/
C
	DATA LASTIN/1/,LINTYP/0/,JFLAG/0/
C
	WRITE(5,4)
 11	WRITE(5,1)
 4	FORMAT(' CONVRT - Display File Conversion Utility')
 1	FORMAT($,' Enter display file name: ')
	READ(5,3) LEN,FNAME
 3	FORMAT(Q,22A1)
 2	FORMAT(16A1)
	IF(LEN.EQ.0) GOTO 11
C
C	CHECK FOR AN EXTENSION - IF THERE IS A PERIOD, ASSUME HE KNOWS
C	WHAT HE IS DOING; ELSE ADD DEFAULT EXTENSION OF ".DSP"
C	ALSO CHECK IF FILE IS THERE
	CALL NAMDSP(FNAME,IERR,LEN,'DSP')
	IF(IERR.NE.0) GOTO 11
C
C	GET THE FILE
 223	CALL RSTR(FNAME)
	IMODE = 1
C
C	SEE HOW MUCH OF DISPLAY FILE REALLY USED
	DO 5 IEND=1,9999
	IF(IBUF(IEND).EQ.-1) GOTO 6
5	CONTINUE
6	IEND=IEND-1
	ISTART="1312
C
C	  NOW ASK WHAT NAME IS WANTED FOR OUTPUT FILE
 30	WRITE(5,32)
 32	FORMAT($,' Enter name of output file: ')
	READ(5,3) LEN,FNAME
	IF(LEN.EQ.0) GOTO 30
	CALL NAMDSP(FNAME,IERR,LEN,'ARK')
	IF(IERR.NE.0) GOTO 40
C	  FILE ALREADY EXISTS--ASK IF HE WANTS TO REPLACE IT
	WRITE(5,35)
 35	FORMAT($,' File already exists. Delete it (Y or N)? ')
	READ(5,3) LEN,ANSWER
	IF(ANSWER.NE.'Y') GOTO 30
C	  HE WANTS IT DELETED
	OPEN(UNIT=8,NAME=FNAME,DISP='DELETE',TYPE='OLD')
	CLOSE(UNIT=8)
C	  OPEN THE OUTPUT FILE
 40	OPEN(UNIT=8,NAME=FNAME,TYPE='NEW')
C	  SEE WHAT CREATED THE DISPLAY FILE
 45	WRITE(5,50)
 50	FORMAT($,' (D)RAW, (G)ETGIN, or (B)ASIC format: ')
	READ(5,2) ANSWER
	IF(ANSWER.EQ.'D'.OR.ANSWER.EQ.'B'.OR.ANSWER.EQ.'G') GOTO 55
	WRITE(5,51)
 51	FORMAT($,' Enter starting address of display (O6 format): ')
	READ(5,52) ISTART
 52	FORMAT(O6)
	ISTART=ISTART+1
	GOTO 110
C
C	  DETERMINE PROPER DISPLAY FILE STARTING POINT
C	   FIRST, PRESENT STARTING ADDRESS OF THE TEST VERSION OF DRAW:
 55	IF(ANSWER.EQ.'G') ISTART=5
C	  STARTING ADDRESS OF NON-TEST VERSION OF DRAW:
	IF(ANSWER.EQ.'D') ISTART="1270
C	  STARTING ADDRESS FOR BASIC:
	IF(ANSWER.EQ.'B') ISTART=1
C
C	COMES HERE IF HE WISHES TO CONVERT THE DISPLAY FILE
C
C	  INITIALIZE FLAGS
 110	MODE=0
	DINSTR=0
	OINSTR=0
	I=ISTART
	INCR=0
	NEW=1
 120	CONTINUE
	IF(IBUF(I).LT.0) GOTO 900
 125	IF(DINSTR.NE.0) GOTO 129
	WRITE(5,126) IBUF(I),I-1
 126	FORMAT(' ERROR in decoding display file:',O6,' ADDR=',O6)
	STOP
C	FIGURE WHICH INSTRUCTION IT IS
 129	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),DINSTR
C	DHALT - IGNORE THIS DATA WORD
 130	CONTINUE
C
 135	NEW=0
	I=I+1
	GOTO 1000
C
C	DJSR - WE DON'T HAVE THIS INSTRUCTION
C
 150	STOP'Missing DJSR support'
C
C	DJMPA - NOT YET SUPPORTED
C
 200	IF(JFLAG.EQ.0) CALL PRINT('DJMPA not supported')
	JFLAG=1
	NEW=0
	OINSTR=0
C
C	DNOP WAS PREVIOUS INSTRUCTION; INTERPRET UNDER OLD INSTRUCTION
C
 250	NEW=0
	IF(OINSTR.EQ.0) GOTO 260
	GOTO(130,150,200,250,300,350,400,450,500,550,600,650,700),OINSTR
 260	I=I+1
	GOTO 1000
C
C	LOAD STATUS REG A - SAME ACTION AS PREVIOUS INSTRUCTION=DNOP
 300	GOTO 250
C
C	LOAD STATUS REGISTER B--LOAD XGRA/YGRA INCREMENT IF BIT 6 SET
 350	IF((IBUF(I).AND."100).NE.0) INCR=IBUF(I).AND."77
	I=I+1
	GOTO 1000
C
C	XGRA - EVERY WORD IS A DATA POINT
 400	NEW=0
	IY=IBUF(I).AND."1777
	CALL ADUMP(LASTX+INCR,IY,1)
	I=I+1
	GOTO 1000
C
C	YGRA - SAME AS XGRA EXCEPT ROTATED 90 DEGREES
 450	NEW=0
	IX=IBUF(I).AND."1777
	CALL ADUMP(IX,LASTY+INCR,1)
	I=I+1
	GOTO 1000
C
C	NOW FOR THE IMPORTANT STUFF - LVECT
C
 500	NEW=0
	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
C	  CHECK IF SECOND WORD IS AN INSTRUCTION (BUG IN DECGRAPHIC)
	IF(IY.LT.0) GOTO 900
	I=I+1
C	NOW PLOT THIS VECTOR
C	SEE IF WE SHOULD HAVE PEN DOWN OR NOT
	IDRAW=1
	IF((IX.AND."040000).EQ.0) IDRAW=0
 520	CONTINUE
C	COMPUTE COORDINATES
	ITX=IX.AND."001777
	ITY=IY.AND."001777
	IF((IX.AND."020000).NE.0) ITX=0-ITX
	IF((IY.AND."020000).NE.0) ITY=0-ITY
	CALL LDUMP(ITX,ITY,IDRAW)
	GOTO 1000
C
C	SVECT
C
550	NEW=0
C	SEE IF THE PEN SHOULD BE DOWN
	IDRAW=0
	IF((IBUF(I).AND."040000).NE.0) IDRAW=1
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	CALL LDUMP(IX,IY,IDRAW)
	I=I+1
	GOTO 1000
C
C	  TEXT
C
C	  FIRST RESET THE PLOTTER
 600	IF(NEW.EQ.0.OR.NEW.EQ.-1) GOTO 630
	NEW=-1
C	  FIRST RE-POSITION PEN ABOVE STARTING POINT
	LASTI=LASTIN
	LASTIN=0
	CALL DUMP(0,2)
	LASTIN=LASTI
C
C	  NOW SEND THE CHARACTERS
 630	K=IBUF(I).AND."177
	K1=IBUF(I)/256
	CALL CHRDMP(K)
	CALL CHRDMP(K1)
	J=0
	IF(K.NE.0) J=1
	IF(K1.NE.0) J=J+1
	I=I+1
	IWORD=0
C	  INCREASE X-POSITION SO IF WE DRAW ANY VECTORS WE WILL THINK
C	  THAT WE ARE IN CORRECT LOCATION
	LASTX=LASTX+TWIDTH*J
	GOTO 1000
C
C	  APNT
C
 650	IX=IBUF(I)
	I=I+1
	IY=IBUF(I)
C	  CHECK IF SECOND WORD IS AN INSTRUCTION OR NOT
	IF(IY.LT.0) GOTO 900
	I=I+1
	ITX=(IX.AND."1777)
	ITY=(IY.AND."1777)
	MODE=0
	IF((IX.AND."040000).NE.0) MODE=1
	CALL ADUMP(ITX,ITY,MODE)
	GOTO 1000
C
C	  RPNT
C
 700	IY=IBUF(I).AND."177
	IF((IY.AND."100).NE.0) IY=0-(IY.AND."77)
	IX=(IBUF(I)/128).AND."177
	IF((IX.AND."100).NE.0) IX=0-(IX.AND."77)
	LASTI=LASTIN
	LASTIN=0
	CALL DUMP(IX,IY)
	LASTIN=LASTI
C	  SEE IF WE SHOULD MAKE A DOT HERE
	IF((IBUF(I).AND."040000).NE.0) GOTO 720
C	  YES - PLOT THIS POINT 2 TIMES INSTEAD OF SENDING A BELL
	CALL DUMP(0,0)
 720	I=I+1
	GOTO 1000
C
C	  COMES HERE IF WE GOT AN INSTRUCTION
 900	CONTINUE
C	  SEE IF PREVIOUS INSTRUCTION WAS 'TEXT'
C	IF SO, THEN REPOSITION PEN DOWN A LINE
	IF(NEW.NE.-1) GOTO 905
	LASTI=LASTIN
	LASTIN=0
	CALL DUMP(0,-2)
	LASTIN=LASTI
 905	CONTINUE
C	  FIGURE WHICH INSTRUCTION THIS IS
	DO 910 J=1,13
	IVAL=IBUF(I)
	IF(J.GE.5) IVAL=IVAL.AND."174000
	IF(IVAL.EQ.INSTR(J)) GOTO 920
 910	CONTINUE
 915	FORMAT(' Erroneous instruction found:',O6)
	WRITE(5,915) IBUF(I)
	CALL CLSDMP
	STOP
C
 920	OINSTR=DINSTR
	DINSTR=J
	JFLAG=0
C	  PICK UP INTENSITY FROM SET GRAPHIC MODE INSTRUCTION
	IF((IBUF(I).AND."002000).NE.0.AND.J.GE.5)
     C		LASTIN=(IBUF(I).AND."001600)/"200+1
C
C	  NOW CHECK FOR A CHANGE IN LINE TYPE
 930	IF(J.GE.5.AND.(IBUF(I).AND."4).NE.0) LINTYP=(IBUF(I).AND."3)
	I=I+1
	MODE=0
	NEW=1
C
1000	CONTINUE
	IF(I.LE.IEND) GOTO 120
C	  CLOSE THE OUTPUT FILE
	CALL CLSDMP
	STOP'End CONVRT'
	END



	SUBROUTINE RSTR(FNAME)
C	  THIS SUBROUTINE READS THE DISPLAY FILE FROM DISK TO MEMORY
	LOGICAL*1 FNAME(30)
	COMMON/DFILE/IBUF(32)
C
	DO 50 I=10000,1,-1
	IBUF(I)=-1
50	CONTINUE
C
	CALL ASSIGN(1,FNAME)
	DEFINE FILE 1(64,256,U,IBLK)
	IBLK=1
	READ(1'IBLK,END=110)J,III,(IBUF(K),K=1,254)
	IPTR=J
	DO 100 J=1,IPTR,256
100	READ(1'IBLK,END=110)(IBUF(K),K=J+254,J+509)
	CALL CLOSE(1)
	RETURN
C	  COMES HERE IF WE READ PAST END OF FILE
 110	WRITE(5,120)
 120	FORMAT(' *** Premature End of File encountered ***')
	RETURN
	END



	SUBROUTINE NAMDSP(NAME,IERR,LEN,EXT)
C	  THIS SUBROUTINE CHECKS EACH NAME FOR AN EXTENSION
C	  IF NONE FOUND (PRESENCE IS INDICATED BY A PERIOD),
C	  THEN AN EXTENSION OF .DSP IS ADDED
C	  WE THEN CHECK TO SEE IF FILE EXISTS
C
	LOGICAL*1 NAME(22),EXT(4)
C
	IERR=0
	IF(LEN.EQ.1) GOTO 50
	IF(LEN.GT.14) GOTO 70
	DO 40 I=2,LEN
	IF(NAME(I).EQ.'.') GOTO 60
 40	CONTINUE
C	  IF IT GETS HERE, NO EXTENSION ON FILENAME--PLACE DEFAULT .DSP
 50	NAME(LEN+1)='.'
	NAME(LEN+2)=EXT(1)
	NAME(LEN+3)=EXT(2)
	NAME(LEN+4)=EXT(3)
	NAME(LEN+5)=0
	NAME(LEN+6)=0
	NAME(LEN+7)=0
	GOTO 65
 60	NAME(LEN+1)=0
	NAME(LEN+2)=0
C	  NOW TRY TO OPEN THE FILE
 65	OPEN(UNIT=7,NAME=NAME,READONLY,TYPE='OLD',ERR=70)
C	  IF IT STAYS HERE THE FILE EXISTS
	CLOSE(UNIT=7)
	RETURN
C	  *** FILE NOT THERE ***!!
 70	WRITE(5,80) (NAME(I),I=1,LEN+4)
 80	FORMAT(' *** File not found: ',20A1)
	IERR=1
	RETURN
	END

	SUBROUTINE DUMP(IX,IY)
	IMPLICIT INTEGER (A-Z)
C
	COMMON/ARK/LASTX,LASTY,LASTIN,LINTYP
	DIMENSION INTNS(8)
	DATA INTNS/1,1,1,2,2,3,3,3/
C
	LASTX=LASTX+IX
	LASTY=LASTY+IY
	IF(LASTIN.LE.0) GOTO 5
	INTOUT=INTNS(LASTIN)
	GOTO 8
 5	INTOUT=0
C	  NOW WRITE THIS STUFF OUT IN .ARK FORMAT (+LINE TYPE)
 8	WRITE(8,10) INTOUT,LASTX,LASTY,LINTYP
 10	FORMAT(I2,I4,I4,I1)
	RETURN
	END


	SUBROUTINE ADUMP(IX,IY,IMODE)
	IMPLICIT INTEGER(A-Z)
	COMMON/ARK/LASTX,LASTY,LASTIN,LINTYP
C
	LASTX=IX
	LASTY=IY
	LASTL=LINTYP
C	  SET LINETYPE TO 0 TO ALLOW FOR FASTER MOVE
	LINTYP=0
C	  SAVE INTENSITY
	LASTI=LASTIN
	IF(IMODE.EQ.0) LASTIN=0
C	  LET DUMP DO ALL THE WORK
	CALL DUMP(0,0)
C	  SEE IF WE SHOULD MAKE A DOT HERE
	LASTIN=LASTI
	IF(IMODE.EQ.1) CALL DUMP(0,0)
C	  RESET LINETYPE
	LINTYP=LASTL
	RETURN
	END

	SUBROUTINE LDUMP(IX,IY,IMODE)
	IMPLICIT INTEGER(A-Z)
	COMMON/ARK/LASTX,LASTY,LASTIN,LINTYP
C
	IF(IMODE.NE.0) GOTO 10
C	  OUTPUT AN UNDRAWN LINE
	IDUM1=LINTYP
	LINTYP=0
	IDUM2=LASTIN
	LASTIN=0
	CALL DUMP(IX,IY)
C	  NOW RESTORE VALUES OF LINTYP & LASTIN
	LASTIN=IDUM2
	LINTYP=IDUM1
	RETURN
C
 10	CALL DUMP(IX,IY)
	RETURN
	END


	SUBROUTINE CHRDMP(ICHAR)
	IMPLICIT INTEGER(A-Z)
	COMMON/ARK/LASTX,LASTY,LASTIN,LINTYP
C
C	  FOR NOW JUST IGNORE CHARACTERS
	RETURN
	END


	SUBROUTINE CLSDMP
C	  CLOSE THE OUTPUT FILE
	WRITE(8,10)
 10	FORMAT('9900000000')
	CLOSE(UNIT=8)
	RETURN
	END
