/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	table.h,v $
 * Revision 4.2.2.2  92/05/07  09:56:27  Jeff_Anuszczyk
 * 	Update/add comments.
 * 	[92/04/30  10:14:52  Jeff_Anuszczyk]
 * 
 * 	Change interrupt statistics counters to be unsigned long.  Convert it to
 * 	long when exiting handler_stats() routines.
 * 	[92/04/29  17:28:49  Jeff_Anuszczyk]
 * 
 * 	Added system interrupt counters structures.  Used to provide counts
 * 	of number of interrupts that occur.  Add macros to allow easy access
 * 	to interrupt couter tables.
 * 	[92/04/29  15:02:28  Jeff_Anuszczyk]
 * 
 * Revision 4.2  91/09/19  23:00:52  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: table.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/05/07 09:56:27 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * Copyright (c) 1986 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_SYS_TABLE_H_
#define _SYS_TABLE_H_

#define TBL_TTYLOC		0	/* index by device number */
#define TBL_U_TTYD		1	/* index by process ID */
#define TBL_UAREA		2	/* index by process ID */
#define TBL_LOADAVG		3	/* (no index) */
#define TBL_INCLUDE_VERSION	4	/* (no index) */
#define TBL_FSPARAM		5	/* index by device number */
#define TBL_ARGUMENTS		6	/* index by process ID */
#define TBL_MAXUPRC		7	/* index by process ID */
#define TBL_AID			8	/* index by process ID */
#define TBL_MODES		9	/* index by process ID */
#define TBL_PROCINFO		10	/* index by proc table slot */
#define TBL_ENVIRONMENT		11	/* index by process ID */
#define TBL_SYSINFO		12	/* (no index) */
#define TBL_DKINFO		13	/* index by disk */
#define TBL_TTYINFO		14	/* (no index) */
#define TBL_MSGDS		15	/* index by array index */
#define TBL_SEMDS		16	/* index by array index */
#define TBL_SHMDS		17	/* index by array index */
#define TBL_MSGINFO		18	/* index by structure element */
#define TBL_SEMINFO		19	/* index by structure element */
#define TBL_SHMINFO		20	/* index by structure element */
#define TBL_INTR		21	/* (no index) */

#define MSGINFO_MAX		0	/* max message size */
#define MSGINFO_MNB		1	/* max # bytes on queue */
#define MSGINFO_MNI		2	/* # of message queue identifiers */
#define MSGINFO_TQL		3	/* # of system message headers */

#define	SEMINFO_MNI		0	/* # of semaphore identifiers */
#define	SEMINFO_MSL		1	/* max # of semaphores per id */
#define	SEMINFO_OPM		2	/* max # of operations per semop call */
#define	SEMINFO_UME		3	/* max # of undo entries per process */
#define	SEMINFO_VMX		4	/* semaphore maximum value */
#define	SEMINFO_AEM		5	/* adjust on exit max value */

#define SHMINFO_MAX		0	/* max shared memory segment size */
#define SHMINFO_MIN		1	/* min shared memory segment size */
#define SHMINFO_MNI		2	/* num shared memory identifiers */
#define SHMINFO_SEG		3	/* max attached shared memory segments per process */

/* The new method for recording interrupt statistics is via three tables
 * which should be defined as follows:
 *
 *		extern volatile unsigned long  system_intr_cnts_level[INTR_MAX_LEVEL];
 *		extern volatile unsigned long  system_intr_cnts_type[INTR_TYPE_SIZE];
 *      or if NCPUS > 1
 *		extern volatile unsigned long  system_intr_cnts_level[NCPUS][INTR_MAX_LEVEL];
 *		extern volatile unsigned long  system_intr_cnts_type[NCPUS][INTR_TYPE_SIZE];
 *
 *		extern volatile int  *system_intr_cnts_type_transl;
 *
 * When an interrupt occurs, the interrupt dispatcher in /arch/mips/hal/intr.c
 * will increment system_intr_cnts_level[cpu#][level].  This is a count of the 
 * number of interrupts serviced at each interrupt level.  If any other type of
 * interrupt is detected (stray, other, etc), it will increment the
 * system_intr_cntr_type[type] table.
 *
 * If a cpu does not user intr.c as its primary interrupt dispatcher, it will
 * need to do those functions itself.  This can be done either by interrupt
 * level (using the system_intr_cnts_level table) or explicitly by type
 * (using the system_intr_cnts_type table).
 *
 * The pointer *system_intr_cnts_type_transl, points to a table that converts
 * an interrupt level into its associated interrupt type (device, softclock,
 * hardclock, etc).  It is primarily used to allow easy summarization of
 * these counts into the types defined above (INTR_xxx) as done by the
 * routine handler_stats() in /io/common/handler.c.  Each CPU specific 
 * module  (e.g. - kn01.c) must provide this table even if the level table
 * is not used.
 *
 * NOTE:  This whole mechanism has been designed with one design goal:
 *
 *		KEEP THE OVERHEAD IN THE INTERRUPT CODE
 *		       PATH AS LOW AS POSSIBLE.
 *
 *	  As such, this mechanism is more complicated to report the 
 *	  counts, however, it is very easy to record the interrupts.
 */

/*
 * Values for ihs_type  -  interrupt types
 */
#define INTR_MAX_LEVEL 8	/* Maximum num. of interrupt level */
#define INTR_NOSPEC   0x0000
#define INTR_HARDCLK  0x0001
#define INTR_SOFTCLK  0x0002
#define INTR_DEVICE   0x0004
#define INTR_OTHER    0x0008
#define INTR_STRAY    0x8000
#define INTR_DISABLED 0x4000

#define INTR_CLOCK    (INTR_HARDCLK|INTR_SOFTCLK)
#define INTR_NOTCLOCK (~INTR_CLOCK)

/*
 * Values for system_intr_cnts_type and system_intr_cnts_type_tranls tables.
 */

#define INTR_TYPE_NOSPEC   0
#define INTR_TYPE_HARDCLK  1
#define INTR_TYPE_SOFTCLK  2
#define INTR_TYPE_DEVICE   3
#define INTR_TYPE_OTHER    4
#define INTR_TYPE_STRAY    5
#define INTR_TYPE_DISABLED 6
#define INTR_TYPE_NOTUSED  7	/* Filler */

#define INTR_TYPE_SIZE	   8	/* Make it a power of 2 to allow compiler to shift on multiply */

/*
 * Macros for incrementing, looking at the interrupt counter table.
 */

#if NCPUS > 1
#define incr_interrupt_counter_level(level) \
	system_intr_cnts_level[cpu_number()][level]++
#else	/* NCPUS */
#define incr_interrupt_counter_level(level) \
	system_intr_cnts_level[level]++
#endif	/* NCPUS */

#if NCPUS > 1
#define incr_interrupt_counter_type(type) \
	system_intr_cnts_type[cpu_number()][type]++
#else	/* NCPUS */
#define incr_interrupt_counter_type(type) \
	system_intr_cnts_type[type]++
#endif	/* NCPUS */

#if NCPUS > 1
#define examine_interrupt_cnts_level(level) \
	{ \
	   int cpu; \
	   unsigned long count = 0; \
	   for (cpu = 0; cpu < NCPUS; cpu++) { \
	      count += system_intr_cnts_level[cpu][level]; \
           } \
           count \
        }
#else	/* NCPUS */
#define examine_interrupt_cnts_level(level) \
	system_intr_cnts_level[level]
#endif	/* NCPUS */

#if NCPUS > 1
#define examine_interrupt_cnts_type(type) \
	{ \
	   int cpu; \
	   unsigned long count = 0; \
	   for (cpu = 0; cpu < NCPUS; cpu++) { \
	      count += system_intr_cnts_type[cpu][type]; \
           } \
           count \
        }
#else	/* NCPUS */
#define examine_interrupt_cnts_type(type) \
	system_intr_cnts_type[type]
#endif	/* NCPUS */

/*
 *  TBL_FSPARAM data layout
 */

struct tbl_fsparam
{
    long tf_used;		/* free fragments */
    long tf_iused;		/* free inodes */
    long tf_size;		/* total fragments */
    long tf_isize;		/* total inodes */
};


/*
 *  TBL_LOADAVG data layout
 */

struct tbl_loadavg
{
    union {
	    long   l[3];
	    double d[3];
    } tl_avenrun;
    int    tl_lscale;		/* 0 scale when floating point */
    long   tl_mach_factor[3];
};


/*
 *  TBL_INTR data layout
 */

struct tbl_intr
{
	long   	in_devintr;	/* Device interrupts (non-clock) */
	long   	in_context;	/* Context switches */
	long   	in_syscalls;	/* Syscalls */
	long   	in_forks;	/* Forks */
	long   	in_vforks;	/* Vforks */
};


/*
 *  TBL_MODES bit definitions
 */

#define UMODE_P_GID	01	/* - 4.2 parent GID on inode create */
#define UMODE_NOFOLLOW	02	/* - don't follow symbolic links */
#define UMODE_NONICE	04	/* - don't auto-nice long job */



/*
 *	TBL_PROCINFO data layout
 */
#define PI_COMLEN	19	/* length of command string */
struct tbl_procinfo
{
    int		pi_uid;		/* (effective) user ID */
    int		pi_pid;		/* proc ID */
    int		pi_ppid;	/* parent proc ID */
    int		pi_pgrp;	/* proc group ID */
    int		pi_ttyd;	/* controlling terminal number */
    int		pi_status;	/* process status: */
#define PI_EMPTY	0	    /* no process */
#define PI_ACTIVE	1	    /* active process */
#define PI_EXITING	2	    /* exiting */
#define PI_ZOMBIE	3	    /* zombie */
    int		pi_flag;	/* other random flags */
    char	pi_comm[PI_COMLEN+1];
				/* short command name */
    int		pi_ruid;        /* (real) user ID */
    int		pi_svuid;       /* saved (effective) user ID */
    int         pi_rgid;        /* (real) group ID */
    int         pi_svgid;       /* saved (effective) group ID */
    int		pi_session;	/* session ID */
    int         pi_tpgrp;       /* tty pgrp */
    int         pi_tsession;    /* tty session id */
    int         pi_jobc;        /* # procs qualifying pgrp for job control */
    int         pi_cursig;
    int         pi_sig;         /* signals pending */
    int         pi_sigmask;     /* current signal mask */
    int         pi_sigignore;   /* signals being ignored */
    int         pi_sigcatch;    /* signals being caught by user */
};

/*
 *	TBL_SYSINFO data layout
 */
struct tbl_sysinfo {
        long	si_user;		/* User time */
        long	si_nice;		/* Nice time */
        long	si_sys;			/* System time */
        long	si_idle;		/* Idle time */
        long    si_hz;
        long    si_phz;
	long 	si_boottime;		/* Boot time in seconds */
};

/*
 *	TBL_DKINFO data layout
 */
#define DI_NAMESZ	8
struct tbl_dkinfo {
        int	di_ndrive;
        int	di_busy;
        long	di_time;
        long	di_seek;
        long	di_xfer;
        long	di_wds;
        long	di_wpms;
        int	di_unit;
        char    di_name[DI_NAMESZ+1];
};
        
/*
 *	TBL_TTYINFO data layout
 */
struct tbl_ttyinfo {
        long	ti_nin;
        long	ti_nout;
        long	ti_cancc;
        long	ti_rawcc;
};

#endif	/* _SYS_TABLE_H_ */
