/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	limits.h,v $
 * Revision 4.3.7.5  92/06/04  14:10:55  Anthony_Decarlo
 * 	bmerge done
 * 	[92/06/04  13:57:48  Anthony_Decarlo]
 * 
 * 	Added USI_MAX macro for OSF1.1 compatibility
 * 	[92/06/04  08:21:38  Anthony_Decarlo]
 * 
 * Revision 4.3.7.4  92/04/24  16:45:11  William_Burns
 * 	Back out preious mod. TZNAME_MAX is in syslimits.h.
 * 	[92/04/24  16:43:54  William_Burns]
 * 
 * Revision 4.3.7.3  92/04/23  14:51:07  Raymond_Glaser
 * 	   Define TZNAME_MAX for POSIX
 * 
 * Revision 4.3.7.2  92/04/08  12:09:52  David_Metsky
 * 	Define _POSIX_TZNAME_MAX _POSIX_STREAM_MAX _POSIX_SSIZE_MAX
 * 	[92/03/31  18:16:39  David_Metsky]
 * 
 * Revision 4.3  91/11/26  11:13:05  devbld_zk3
 * 	Baselevel AG_BL0
 * 
 * Revision 4.2.2.2  91/10/25  14:49:42  William_Burns
 * 	Merge from ODE/TIN: revision 3.4.9.2
 * 	date: 91/10/22 20:06:29;  author: devrcs;  state: Exp;  lines added/del: 10/12
 * 	sccs rev: 3.6;  orig date: 91/10/08 14:56:00;  orig author: plong
 * 	  Realtime extension
 * 	[91/10/25  12:49:14  William_Burns]
 * 
 * Revision 4.2  91/09/19  22:58:25  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: limits.h,v $ $Revision: 4.3.7.5 $ (DEC) $Date: 92/06/04 14:10:55 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * limits.h
 *
 * Modification History:
 *
 * 27-Mar-91	 David Metsky
 *	Define _POSIX_TZNAME_MAX _POSIX_STREAM_MAX _POSIX_SSIZE_MAX
 *
 * 27-Sep-91     Paula Long
 *      Moved P1003.4 defines to rt_limits.h.  rt_limits.h will be 
 *      included in limits.h if _KERNEL || _POSIX_4SOURCE is defined.
 *
 * 3-jun-91	Rob Haydt
 *	add more aio limits
 *
 * 4-Apr-91     Paula Long
 *      Add P1003.4 required extensions.  
 *
 */

/*
 * COMPONENT_NAME: limits.h
 *                                                                    
 * ORIGIN: IBM
 *
 * Copyright International Business Machines Corp. 1985, 1988
 * All Rights Reserved
 * Licensed Material - Property of IBM
 *
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the Rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 * 
 * limits.h 1.42  com/inc/sys,3.1,9021 5/18/90 14:35:04
 */                                                                   

#ifndef _SYS_LIMITS_H_
#define _SYS_LIMITS_H_ 
#include <standards.h>

/*
 *
 *      The ANSI and POSIX standards require that certain values be in limits.h.
 *      They also require that if _ANSI_C_SOURCE or _POSIX_SOURCE is 
 *      defined then ONLY those standard specific values are present.
 *      This header includes all the ANSI and POSIX required entries.
 *      In addition other entries for the XIX system are included.
 *
 */
#ifdef _ANSI_C_SOURCE

#include <machine/machlimits.h>


#endif /* _ANSI_C_SOURCE */

/*
 *   The following are values that have historically been in limits.h.
 *
 *   They are a part of the POSIX defined limits.h and therefore are
 *   included when _POSIX_SOURCE is defined.
 *
 */

#ifdef _POSIX_SOURCE


/* limits on a system conforming to the POSIX standard */

#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_MAX_INPUT	255
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512
#define _POSIX_TZNAME_MAX       3
#define _POSIX_STREAM_MAX       8
#define _POSIX_SSIZE_MAX        32767


/* RUN-TIME INVARIANT VALUES
   The system supports the following fixed magnitude limitations.
*/

#include <sys/syslimits.h>

#endif /* _POSIX_SOURCE */

#ifdef _XOPEN_SOURCE

/* Some of the values in <float.h> are required in limits.h by XPG3, but
 * are not allowed by Posix.1.  The include must remain in _XOPEN_SOURCE.
 * The kernel can't include things not in sys, hence the ifdef.
 */

#ifndef _KERNEL
#include <float.h>      /* DBL_DIG, DBL_MAX, DBL_MIN, */
			/* FLT_DIG, FLT_MAX, FLT_MIN  */
#endif


/* ANSI C requires TMP_MAX to be in stdio.h, however, XOPEN requires it to be
 * in limits.h.  
 */

#ifndef TMP_MAX
#define TMP_MAX		16384		/* The number of unique names 
					   generated by the tmpnam() function */
#endif
					/* max decimal value of a double */
/* defines for message catalog usage */

#define NL_ARGMAX       9               /* max number of printf args */

#define NL_MSGMAX       65535           /* max number of messages per set */

#define NL_SETMAX       65535           /* max number of set per catalog */

#define NL_TEXTMAX      4096            /* max message length in bytes */

#define PASS_MAX	16		/* max number of bytes in a password
					   (not a string length; doesn't include
					   terminating null), >= 8 */
#define NL_LANGMAX	14	/* max number of of bytes in a LANG name */

#define NL_NMAX 	10		/* max number of bytes in N-to-1 mapping
					   characters */
#ifdef _BSD
#define NZERO		0		/* default proc priority (BSD) */
#else
#define NZERO		20		/* default proc priority (SYSV/XOPEN) */
#endif

#define LONG_BIT	32		/* number of bits in a long     */

#define WORD_BIT	32		/* number of bits in a "word" or int */


#endif /* _XOPEN_SOURCE */

#ifdef _AES_SOURCE

#define	ATEXIT_MAX	32

#endif /* _AES_SOURCE */

#ifdef _OSF_SOURCE

#include <machine/machtime.h>		/* to get CLOCKS_PER_SEC */

#define PID_MAX		SHRT_MAX	/* max value for a process ID,
					   >=30000	*/ 
#define UID_MAX		USHRT_MAX	/* max value for a user or group ID */
#define USI_MAX		UINT_MAX	/* max unsigned int - for OSF1.1 comp.*/


#endif /*_OSF_SOURCE */   
                       
/* 
 * P1003.4 Required Constants
 */

#if defined(_KERNEL) || defined(_POSIX_4SOURCE) 
#include <sys/rt_limits.h>
#endif /* _KERNEL || _POSIX_4SOURCE */

#endif /* _SYS_LIMITS_H_ */
