/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	audit_module.h,v $
 * Revision 1.1.4.3  92/03/27  13:18:43  Sec_Proj_Michael_Fairbrother
 * 
 * 		Fixed where audit_table gets built, thus I fixed
 * 	this header file to reflect that change
 * 	[92/03/27  09:49:13  Sec_Proj_Michael_Fairbrother]
 * 
 * Revision 1.1.4.2  92/02/28  21:29:53  Sec_Proj_Michael_Fairbrother
 * 	Changed to use a constant for nsysent, so that reduce and the kernel will
 * 	both build.
 * 	[92/02/11  14:35:22  Michael_Fairbrother]
 * 
 * 	fixed nsysent lines.
 * 	[92/02/11  12:30:55  Michael_Fairbrother]
 * 
 * 	Added entry into aud_mod for max number of system calls.
 * 	[92/02/10  15:50:15  Michael_Fairbrother]
 * 
 * 	Fixed so that reduce.c can also include this file.
 * 	[92/02/10  14:58:46  Michael_Fairbrother]
 * 
 * 	A bit hasty on check in of changes.  Bogus constants.
 * 	[92/02/07  19:57:52  Michael_Fairbrother]
 * 
 * 	This file is used by audit.c and reduce.c ( user security command ).
 * 	[92/02/07  11:36:27  Michael_Fairbrother]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: audit_module.h,v $ $Revision: 1.1.4.3 $ (DEC) $Date: 92/03/27 13:18:43 $
 */

#include <sys/systm.h>
#include <sys/habitat.h>
#include <sys/audit_table>

extern char *syscallnames[];

#if ULTV42V11
extern char *ult_syscallnames[];
#endif
#if SYSVV11
extern char *sysv_syscallnames[];
#endif

struct aud_mod {
	char *name;			/* name of the module/habitat */
	char *version;			/* version of the module/habitat */
	struct  syscall_audit *tbl;	/* pointer to the audit_table */
	char **syscall;			/* list of system calls */
	int  nsysent;			/* Max number of system calls */
};

struct aud_mod aud_mod[] = {
	"OSF/1 Base System", "1.0", syscall_audit, syscallnames, AUD_MAX_SYSCALLS,

#if ULTV42V11
	ULT_BIN, ULT42V11A, ult_syscall_audit, ult_syscallnames, AUD_ULT_MAX_SYSCALLS,
#endif

#if SYSVV11
	SYSV_HAB, SYSVV11A, sysv_syscall_audit, sysv_syscallnames, AUD_SYSV_MAX_SYSCALLS,
#endif

};

#define AUD_MAX_MODULES sizeof(struct aud_mod) / sizeof(aud_mod[0])
