/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	msg_queue.h,v $
 * Revision 4.2  91/09/19  22:26:23  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: msg_queue.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:26:23 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *	kern/msg_queue.h
 *
 *	Revision History:
 *
 * 8-Apr-91	Ron Widyono
 *	Delay inclusion of sys/preempt.h (for RT_PREEMPT) to avoid circular
 *	include file problem.
 *
 */

#ifndef	_KERN_MSG_QUEUE_H_
#define _KERN_MSG_QUEUE_H_

#include <rt_preempt.h>

#if	RT_PREEMPT
#ifndef	_SKIP_PREEMPT_H_
#define _SKIP_PREEMPT_H_
#define	_KERN_MSG_QUEUE_H_PREEMPT_
#endif
#endif

#include <kern/queue.h>
#include <kern/lock.h>
#include <kern/macro_help.h>

typedef struct {
	queue_head_t messages;
	decl_simple_lock_data(,lock)
	queue_head_t blocked_threads;
} msg_queue_t;

#define msg_queue_lock(mq)	simple_lock(&(mq)->lock)
#define msg_queue_unlock(mq)	simple_unlock(&(mq)->lock)

#define msg_queue_init(mq)			\
MACRO_BEGIN					\
	simple_lock_init(&(mq)->lock);		\
	queue_init(&(mq)->messages);		\
	queue_init(&(mq)->blocked_threads);	\
MACRO_END

#if	RT_PREEMPT
#ifdef	_KERN_MSG_QUEUE_H_PREEMPT_
#include <sys/preempt.h>
#endif
#endif

#endif	/* _KERN_MSG_QUEUE_H_ */
