/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	tty_pty_data.c,v $
 * Revision 1.1.3.6  92/06/30  12:22:18  Ronald_Menner
 * 	extended pty space to 3162
 * 	[92/06/18  15:04:50  Ronald_Menner]
 * 
 * Revision 1.1.3.5  92/05/07  13:22:47  Thomas_Tierney
 * 	Merge with AG.
 * 	[92/05/07  12:42:40  Thomas_Tierney]
 * 
 * 	Check in for next ag.latest merge.
 * 	[92/04/30  10:11:51  Thomas_Tierney]
 * 
 * 	Check-in for remerge
 * 	[92/04/30  09:36:11  Thomas_Tierney]
 * 
 * 	Merge
 * 	[92/04/23  10:34:59  Thomas_Tierney]
 * 
 * 	Merged Ron Menner's work to expand pty space to 816.
 * 	[92/04/21  16:16:56  Thomas_Tierney]
 * 
 * Revision 1.1.3.4  92/03/23  07:05:23  Ronald_Menner
 * 	Bmerge'd to ag.latest
 * 	[92/03/23  06:49:36  Ronald_Menner]
 * 
 * 	Added pt_mask array and nMASK
 * 	[92/03/03  18:08:26  Ronald_Menner]
 * 
 * Revision 1.1.3.3  92/02/24  15:10:52  Ronald_Menner
 * 	added pt_data structure so tty and ptioctl could be allocated
 * 	and deallocated in one chunk - ron menner
 * 	[92/02/24  14:58:01  Ronald_Menner]
 * 
 * Revision 1.1.3.2  91/11/20  13:54:11  Hal_Project
 * 	Moved from dec/data; pool reorg
 * 	[91/11/18  00:45:50  Donald_Dutile]
 * 
 * Revision 4.1.2.2  91/10/23  15:02:31  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 91/10/17 21:14:05;  author: devrcs;  state: Exp;  lines added/del: 116/0
 * 	sccs rev: 3.1;  orig date: 91/10/02 14:17:22;  orig author: fred
 * 	Fred Canter - config NPTY.
 * 	[91/10/23  10:43:16  William_Burns]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: tty_pty_data.c,v $ $Revision: 1.1.3.6 $ (DEC) $Date: 92/06/30 12:22:18 $";
#endif
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 *
 * tty_pty_data.c
 *
 * Modification History:
 *
 * 31-Aug-91	Fred Canter
 *	Created file to make NPTY configurable.
 */

#include "pty.h"
#include <rt_preempt.h>

#include <sys/secdefines.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/limits.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/user.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/uio.h>
#include <sys/kernel.h>
#include <sys/vnode.h>
#include <sys/poll.h>
#include <sys/select.h>
#include <sys/lock_types.h>
#include <kern/assert.h>
#include <kern/parallel.h>
#if	SEC_BASE
#include <sys/security.h>
#endif
#if	SEC_ARCH
#include <sys/secpolicy.h>
#endif
#include <kji.h>

#ifdef BINARY

/*
 * pts == /dev/tty[pqrs]?
 * ptc == /dev/pty[pqrs]?
 */
struct	pt_ioctl {
	int	pt_flags;
	queue_head_t	pt_selq;
	u_char	pt_send;
	u_char	pt_ucntl;
};
struct pt_data {
		struct tty pt_tty;
		struct pt_ioctl pt_ioctl;
	};
extern struct	pt_data *pt_datap[];
extern u_int 	pt_mask[];
extern int	npty;		/* for pstat -t */
extern int	nNPTY;
extern int 	nMASK;

#if	SEC_ARCH
/*
 * Allocate space for pty tag pools.  On systems that allocate the pty
 * structures dynamically, the tag pools should also be dynamically
 * allocated at the same time as the ptys.
 */
extern tag_t	ptctag[];
extern tag_t	ptstag[];
#endif

#else	/* BINARY */

#if	NPTY == 1
#undef	NPTY
#define NPTY	(64+16)		/* crude XXX */
#endif

#if	NPTY > 3162
#undef	NPTY
#define	NPTY 3162
#endif

/*
 * pts == /dev/tty[pqrs]?
 * ptc == /dev/pty[pqrs]?
 */
struct	pt_ioctl {
	int	pt_flags;
	queue_head_t	pt_selq;
	u_char	pt_send;
	u_char	pt_ucntl;
};
struct pt_data {
		struct tty pt_tty;
		struct pt_ioctl pt_ioctl;
	};
struct	pt_data *pt_datap[NPTY];
u_int	pt_mask[(NPTY/WORD_BIT)+1];
int	npty = NPTY;		/* for pstat -t */
int	nNPTY = NPTY;
int	nMASK = (NPTY/WORD_BIT)+1;

#if	SEC_ARCH
/*
 * Allocate space for pty tag pools.  On systems that allocate the pty
 * structures dynamically, the tag pools should also be dynamically
 * allocated at the same time as the ptys.
 */
tag_t	ptctag[NPTY * SEC_TAG_COUNT];
tag_t	ptstag[NPTY * SEC_TAG_COUNT];
#endif

#endif	/* BINARY */
