#
# @DEC_COPYRIGHT@
#
#
# HISTORY
# $Log:	template.std.mk,v $
# Revision 4.5.2.9  92/04/21  12:40:07  Robin_Lewis
# 	Alpha/Mips merged template file
# 	[92/04/21  12:17:41  Robin_Lewis]
# 
# 	Made changes to set some variables based on MACHINE value.
# 	[92/04/20  14:26:21  Robin_Lewis]
# 
# Revision 4.5.2.8  92/03/24  17:53:37  halproject_Donald_Dutile
# 	Merged changes from HALPROJECT to AG
# 	[92/03/24  16:57:46  halproject_Donald_Dutile]
# 
# 	Added additional tool macros to allow for synchronization of toolsets
# 	with that used by kernel libraries.
# 	[92/03/23  19:35:14  Dave_Gerson]
# 
# Revision 4.5.2.7  92/03/13  13:28:13  Debra_Haeck
# 	hand merge with AG version
# 	[92/03/13  13:25:31  Debra_Haeck]
# 
# Revision 4.5.2.6  92/03/12  14:47:21  Brian_Stevens
# 	Fixed make depend.  Changed the default load address of kernels
# 	to not allow space for kdebug.
# 	[92/03/12  14:44:21  Brian_Stevens]
# 
# Revision 4.5.2.5  92/02/28  21:24:17  Sec_Proj_Michael_Fairbrother
# 	keep security pool upto date.
# 	[92/02/17  11:02:22  Michael_Fairbrother]
# 
# 	Merge Phil Cameron's work with Security changes
# 	[92/02/05  09:03:14  Michael_Fairbrother]
# 
# Revision 4.5.2.4  92/02/28  14:46:28  Dave_Gerson
# 	Added KERNEL_LIBS macro to support optional kernel libraries. Added
# 	make(1) variable 'LIB_SEARCH' to link line of targets '.swap.sys'
# 	and 'vmunix.relink' to provide kernel library search path.
# 	[92/02/25  15:17:53  Dave_Gerson]
# 
# Revision 4.5.2.3  92/02/12  08:33:13  Brian_Stevens
# 	Changed the kernel TEXTBASE to be set from the config file rather
# 	than by the config program.  The default is 0x80050000, but can be
# 	overridden using the config file LOADADDR makeoptions flag.
# 	[92/02/05  14:16:33  Brian_Stevens]
# 
# Revision 4.5.2.2  91/12/20  14:29:03  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.3
# 	date: 91/12/20 11:59:07;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.7;  orig date: 91/11/10 14:23:51;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:25:47  William_Burns]
# 
# Revision 4.5.2.3  92/02/12  08:33:13  Brian_Stevens
# 	Changed the kernel TEXTBASE to be set from the config file rather
# 	than by the config program.  The default is 0x80050000, but can be
# 	overridden using the config file LOADADDR makeoptions flag.
# 	[92/02/05  14:16:33  Brian_Stevens]
# 
# Revision 4.5.2.2  91/12/20  14:29:03  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.3
# 	date: 91/12/20 11:59:07;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.7;  orig date: 91/11/10 14:23:51;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:25:47  William_Burns]
# 
# Revision 4.5.2.6  92/03/12  14:47:21  Brian_Stevens
# 	Fixed make depend.  Changed the default load address of kernels
# 	to not allow space for kdebug.
# 	[92/03/12  14:44:21  Brian_Stevens]
# 
# Revision 4.5.2.5  92/02/28  21:24:17  Sec_Proj_Michael_Fairbrother
# 	keep security pool upto date.
# 	[92/02/17  11:02:22  Michael_Fairbrother]
# 
# 	Merge Phil Cameron's work with Security changes
# 	[92/02/05  09:03:14  Michael_Fairbrother]
# 
# Revision 4.5.2.4  92/02/28  14:46:28  Dave_Gerson
# 	Added KERNEL_LIBS macro to support optional kernel libraries. Added
# 	make(1) variable 'LIB_SEARCH' to link line of targets '.swap.sys'
# 	and 'vmunix.relink' to provide kernel library search path.
# 	[92/02/25  15:17:53  Dave_Gerson]
# 
# Revision 4.5.2.3  92/02/12  08:33:13  Brian_Stevens
# 	Changed the kernel TEXTBASE to be set from the config file rather
# 	than by the config program.  The default is 0x80050000, but can be
# 	overridden using the config file LOADADDR makeoptions flag.
# 	[92/02/05  14:16:33  Brian_Stevens]
# 
# Revision 4.5.2.2  91/12/20  14:29:03  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.3
# 	date: 91/12/20 11:59:07;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.7;  orig date: 91/11/10 14:23:51;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:25:47  William_Burns]
# 
# Revision 4.5.2.3  92/02/12  08:33:13  Brian_Stevens
# 	Changed the kernel TEXTBASE to be set from the config file rather
# 	than by the config program.  The default is 0x80050000, but can be
# 	overridden using the config file LOADADDR makeoptions flag.
# 	[92/02/05  14:16:33  Brian_Stevens]
# 
# Revision 4.5.2.2  91/12/20  14:29:03  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.3
# 	date: 91/12/20 11:59:07;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.7;  orig date: 91/11/10 14:23:51;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:25:47  William_Burns]
# 
# Revision 4.5  91/11/27  15:50:16  devbld_zk3
# 	Incbaselevel update
# 
# Revision 4.2.2.3  91/11/20  13:51:20  Hal_Project
# 	Modified cpu var from dec/machine/mips to arch/MIPS due to pool reorg.
# 	[91/11/17  13:14:17  Donald_Dutile]
# 
# Revision 4.2.2.2  91/10/23  15:02:02  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.2
# 	date: 91/10/17 21:12:42;  author: devrcs;  state: Exp;  lines added/del: 6/5
# 	sccs rev: 3.6;  orig date: 91/10/02 08:32:08;  orig author: fred
# 	Fred Canter - headers and kernel warnings.
# 	[91/10/23  09:54:12  William_Burns]
# 
# Revision 4.2  91/09/19  22:07:23  devbld
# 	Adding ODE Headers
# 
# $EndLog$
#
#	@(#)$RCSfile: template.std.mk,v $ $Revision: 4.5.2.9 $ (DEC) $Date: 92/04/21 12:40:07 $
#
# Copyright (c) 1980, 1986 Regents of the University of California.
# All rights reserved.  The Berkeley software License Agreement
# specifies the terms and conditions for redistribution.
#

#
#  This must be here before any rules are possibly defined by the
#  machine dependent makefile fragment so that a plain "make" command
#  always works.  The config program will emit an appropriate rule to
#  cause "all" to depend on every kernel configuration it generates.
#

VPATH=..

build_all: all

_build_prefix_%: %

cpu=arch/${MACHINE}

#
#  In order to move the link commands out of config and back into the
#  template makefile, config has been changed to emit a dendency rule
#  of the form *vmunix.sys: *vmunix.swap for each configuration so that
#  the common commands for building each configuration can be placed
#  directly in the template in the default rule for the .sys.swap
#  dependency.
#
.SUFFIXES: .swap .sys

#
#  Make sure we don't remove this by accident if interrupted at the wrong
#  time.
#
.PRECIOUS: Makefile

#  Lots of tools and files needed by config and the Makefile (that builds
#  a system are located in the directory where config lives.  That directory
#  is:
CONFIG_DIR=	conf

#  tools needed.
SED=	sed
AWK=	awk
ECHO=	echo
EX=	ex
ED=	ed


KSH=	ksh
EGREP=	egrep
GREP=	grep
LINT=	lint
SHELL=	sh
MAKE=	make
#
#  Compilation components
#
_alpha_CC=	${COFF_GCC_EXEC_PREFIX}cc
_mips_CC=	${KERNEL_SH?${COFF_GCC_EXEC_PREFIX}cc:cc}
CC=${_${MACHINE}_CC}

CPP=	${CC} -ES
#C2=	/lib/c2

_alpha_LD=	${COFF_GCC_EXEC_PREFIX}ld
_mips_LD=	${KERNEL_SH?${COFF_GCC_EXEC_PREFIX}ld:ld}
LD=${_${MACHINE}_LD}

LN=	/bin/ln
# Note not used.
MD=	${CONFIG_DIR}/md
ENCODE=	uuencode
DECODE=	uudecode

VOLATILE=${NO_GCC?"-Dvolatile=":}
FORCE_VOLATILE=


KCC=	gcc
KCPP=	${KCC} -E

#   Dynamic linking components for creating surrogate ROSE kernel package and
#   for linking dynamic kernel modules
#
#DCC=		${MACHO_GCC_EXEC_PREFIX}gcc
#DAS=		${MACHO_GCC_EXEC_PREFIX}as
#DLD=		${MACHO_GCC_EXEC_PREFIX}ld
DLD=		${LD}
#DLD_FLAGS=	-R
DLD_FLAGS=	-r -d -G 0
#VMUNIX_LIB=	libvmunix.so
VMUNIX_LIB=
#VMUNIX_PICNAMES= vmunix.picnames

NM=		${KERNEL_SH?${COFF_GCC_EXEC_PREFIX}nm:nm}

#
#  This changed in the 4.3 CPP from .n to .d
#
MD_SUFFIX=d

#
#  Pre-processor environment
#
DEPENDS=
INCLUDES= -I -I. -I.. -I../include
#INCLUDES= ${KERNEL_SH? -I -I. -I../include -I../../../../src/kernel : -I -I. -I../include}
ALLDEFINES= -DKERNEL -D_KERNEL -D_BSD
ALLOPTS= ${INCLUDES} ${IDENT} ${ALLDEFINES}
LINTOPTS=${ALLOPTS} ${VOLATILE}

#
#  Common C-compilation flags
#
#  To build a DEBUGable kernel define CDEBUGOPTS=-g in config file
# 
COPTS_P=${CDEBUGOPTS} ${DEPENDS} ${ALLOPTS} ${GCC_OPTS}

_alpha_COPTS=  ${COPTS_P} ${${@}_MIG?-Imach:} -Wb,-static -Wc,-nofloat
_mips_COPTS=  ${COPTS_P} ${${@}_MIG?-Imach:}
COPTS=${_${MACHINE}_COPTS}

CFLAGS= ${COPTS} 

#
#  Common assembly flags
#
SFLAGS=	${DEPENDS} ${ALLOPTS} ${GCC_OPTS} -DASSEMBLER


#
#  Path name of the version identification file.
#
FEATURES=FEATURES.h
VERSION_FILES= \
	${CONFIG_DIR}/version.major \
	${CONFIG_DIR}/version.minor \
	${CONFIG_DIR}/version.variant \
	${CONFIG_DIR}/version.build \
	${CONFIG_DIR}/version.patch

#  LOBJS is a list of files that are unique to builds from BINARY systems.
#  That is, systems which do not have access to source code.  These files
#  are the files which will be compiled on each system because they tend
#  to be "tuned" to the specific system.

_alpha_LOBJS=	param.o ioconf.o
_mips_LOBJS= ioconf.o scb_vec.o param.o conf.o
LOBJS=${_${MACHINE}_LOBJS}

#
#  LDOBJS is the set of object files which comprise the kernel.
#  It is used both in the dependency list for each *vmunix.swap
#  rule emitted by config and also in the .sys.swap rule
#  below which links the kernel from these objects.
#  
#  LDOBJS_PREFIX and LDOBJS_SUFFIX are defined in the machine
#  dependent Makefile (if necessary).
#
LDOBJS=${LDOBJS_PREFIX} ${OBJS} ${LOBJS} ${LDOBJS_SUFFIX}

#
#  LDDEPS is the set of extra dependencies associated with each
#  *vmunix.swap rule (in addition to $LDOBJS and the swap*.o file).
#
#  LDDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
LDDEPS=${LDDEPS_PREFIX} ${VERSION_FILES} \
	${CONFIG_DIR}/version.banner ${CONFIG_DIR}/newvers.sh ${CONFIG_DIR}/copyright

#
#  PRELDDEPS is another set of extra dependencies associated with each
#  *vmunix.swap rule (in addition to $LDOBJS and the swap*.o file).
#  It is defined in the machine dependent Makefile (if necessary).
#
#  The generated rule looks like
#	vmunix.sys : ${PRELDDEPS} ${LDOBJS} ${LDDEPS}
#

#
#  SWAPDEPS is the set of extra dependencies associated with each
#  swap*.o rule emitted by config (in addition to the
#  ../swap*.c file).
#
#  SWAPDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
SWAPDEPS=${SWAPDEPS_PREFIX} 

#
#  SYSDEPS is the set of extra dependencies associated with each
#  *vmunix rule (in addition to *vmunix.sys).
#
#  SYSDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
SYSDEPS=${SYSDEPS_PREFIX}



#
#  Compilation rules to generate *vmunix from *vmunix.sys
#
SYS_RULE_1=@eval `${AWK} 'NR==1{S=$$1;next;};\
END {\
  print "rm -f $@";\
  C = "ln $@.sys $@";\
  if (S != "") {\
    C = C "; ln $@ $@" S; \
    printf "rm -f $@%s; ", S; \
  }\
  printf "echo \"%s\"; %s\n", C, C; \
}' vers.suffix`
SYS_RULE_2=
SYS_RULE_3=
SYS_RULE_4=

#
# Compilation rules to generate .o from .b
#
B_RULE_1A=rm -f $*.o; ${DECODE} 
B_RULE_1B=$*.b

#
# Compilation rules to generate .o from .o
#
O_RULE_1A=rm -f $*.o; cp 
O_RULE_1B=$*.o .

#
# Compilation rules to generate .o from .s
#
S_RULE_1A=${KCPP} ${SFLAGS} 
S_RULE_1B=$*.s >$*.i 
S_RULE_2=${AS} -o $*.o $*.i
S_RULE_3=rm -f $*.i

#
# Compilation rules to generate .o from .c for normal files
#
C_RULE_1A=${KCC} -c ${CFLAGS} 
C_RULE_1B=$*.c
C_RULE_2=
C_RULE_3=
C_RULE_4=

#
# Compilation rules to generate .o from .c for driver files
#
C_RULE_1A_D=${C_RULE_1A}
C_RULE_1B_D=${C_RULE_1B}
C_RULE_2_D=${C_RULE_2}
C_RULE_3_D=${C_RULE_3}
C_RULE_4_D=${C_RULE_4}

#
# Compilation rules to generate .o from .c for profiling routine files
#
C_RULE_1A_P=${KCC} -c -S ${COPTS_P} 
C_RULE_1B_P=${C_RULE_1B}
C_RULE_2_P=ex - $*.s < ${GPROF.EX}
C_RULE_3_P=${AS} -o $*.o $*.s
C_RULE_4_P=rm -f $*.s


gprof: kgmon_on all kgmon_off

kgmon_on:
	kgmon -r -b

kgmon_off:
	kgmon -h -p
	gprof /mach >GPROF

_mips_TEXTBASE=${LOADADDR?${LOADADDR}:80030000}
_alpha_TEXTBASE=${LOADADDR?${LOADADDR}:ffffffff00000000}
TEXTBASE=${_${MACHINE}_TEXTBASE}

#
#  Theses macros are filled in by the config program depending on the
#  current configuration.  The MACHDEP macro is replaced by the
#  contents of the machine dependent makefile template and the others
#  are replaced by the corresponding symbol definitions for the
#  configuration.
#

%KERNEL_LIBS

%OBJS

%CFILES

%SFILES

%BFILES

%ORDERED

%MACHDEP

CFILES=${CFILES1} ${CFILES2} ${CFILES3} ${CFILES4}

##
# echo the list of CFILES used to build the system
##
cfiles:
	@${ECHO} ${CFILES}
objfiles:
	@${ECHO} ${OBJS}

#
#  Default rule used to build a *vmunix.sys configuration from the
#  object list and a particular *vmunix.swap module.  The *vmunix.swap
#  module is a normal object file compiled from the appropriate swap*.c
#  file and then copied to the *vmunix.swap name to trigger the full
#  kernel link using this default rule.
#

.swap.sys: 
	${SHELL} ${CONFIG_DIR}/newvers.sh \
			 ${CONFIG_DIR}/copyright \
			`cat ${VERSION_FILES}` \
			"`cat ${CONFIG_DIR}/version.banner`"
	${KCC} ${ALLOPTS} -c vers.c
	rm -f $* $*.sys
	@echo loading $*.sys
	@if [ "${MACHINE}" = "alpha" ]; then \
		${LD} ${LDFLAGS} ${LDOBJS} vers.o $*.swap; \
	else \
		${LD} ${LDFLAGS} ${LDOBJS} vers.o $*.swap ${LIB_SEARCH} ${LIBS}; \
	fi
	chmod 755 a.out
	-${SWAPSYS}
	-mv a.out $*.sys
	@if [ "${CONFIG}" = "SAS" -o "${CONFIG}" = "ADU.SAS" -a "${MACHINE}" = "alpha" ]; then \
		echo "${SOURCEDIR}/../tools/alpha/hostbin/fsmrg ${SOURCEDIR}/../tools/alpha/hostbin/MINIROOT.${CONFIG} $*.sys"; \
		${SOURCEDIR}/../tools/alpha/hostbin/fsmrg \
		${SOURCEDIR}/../tools/alpha/hostbin/MINIROOT.${CONFIG} $*.sys; \
	else true; fi
	@if [ "${MACHINE}" = "alpha" ]; then \
		${SOURCEDIR}/../tools/alpha/hostbin/pmerge \
		${SOURCEDIR}/../tools/alpha/hostbin/sboot $*.sys simvmunix; \
	else true; fi

relink: vmunix.relink 

vmunix.relink: ${LDDEPS}
	${SHELL} ${CONFIG_DIR}/newvers.sh \
			 ${CONFIG_DIR}/copyright \
			`cat ${VERSION_FILES}` \
			"`cat ${CONFIG_DIR}/version.banner`"
	${KCC} ${ALLOPTS} -c vers.c
	rm -f vmunix vmunix.sys
	@echo loading vmunix.sys
	@if [ "${MACHINE}" = "alpha" ]; then \
		${LD} ${LDFLAGS} ${LDOBJS} vers.o vmunix.swap; \
	else \
		${LD} ${LDFLAGS} ${LDOBJS} vers.o vmunix.swap ${LIB_SEARCH} ${LIBS}; \
	fi
	chmod 755 a.out
	-${SWAPSYS}
	-mv a.out vmunix.sys
	@if [ "${CONFIG}" = "SAS" -o "${CONFIG}" = "ADU.SAS" -a "${MACHINE}" = "alpha" ]; then \
		echo "${SOURCEDIR}/../tools/alpha/hostbin/fsmrg ${SOURCEDIR}/../tools/alpha/hostbin/MINIROOT.${CONFIG} vmunix.sys"; \
		${SOURCEDIR}/../tools/alpha/hostbin/fsmrg \
		${SOURCEDIR}/../tools/alpha/hostbin/MINIROOT.${CONFIG} \
		vmunix.sys; \
	else true; fi
	@if [ "${MACHINE}" = "alpha" ]; then \
		${SOURCEDIR}/../tools/alpha/hostbin/pmerge \
		${SOURCEDIR}/../tools/alpha/hostbin/sboot vmunix.sys simvmunix; \
	else true; fi
	@eval `awk 'NR==1{S=$$1;next;};\
	 END {\
	   C = "ln vmunix.sys vmunix";\
	   if (S != "") {\
	     C = C "; ln vmunix vmunix" S; \
	     printf "rm -f vmunix%s; ", S; \
	   }\
	   printf "echo \"%s\"; %s\n", C, C; \
	 }' vers.suffix`

#
#  OBJSDEPS is the set of files (defined in the machine dependent
#  template if necessary) which all objects depend on (such as an
#  in-line assembler expansion filter
#

${OBJS}: ${OBJSDEPS}



#
#  This macro is replaced by three rules per configuration, plus a
#  final definition for the LOAD symbol consisting of all configuration
#  names and a dependency of "all" on this symbol (so that the
#  "default" rule above will build everything).  The three rules in
#  each configuration are:
#
#  - a *vmunix from *vmunix.sys dependency using the SYS_RULE_* rules,
#  - a *vmunix.swap from LDDEPS, swap*.o, and LDDEPS dependency that
#    simply copies the swap file to the target name, and
#  - a swap*.o from swap*.c and SWAPDEPS dependency using the C_RULE_* rules.
#

%LOAD

#
#  Rules for components which are not part of the kernel proper or that
#  need to be built in a special manner.
#

ioconf.o: ioconf.c
	-${RM} ioconf.o
	${KCC} ${CCNFLAGS} ioconf.c

param.c: ${CONFIG_DIR}/param.c
	-${RM} param.c
	${CP} ${CONFIG_DIR}/param.c .

param.o: param.c 
	-${RM} param.o
	${KCC} ${CCNFLAGS} ${PARAM} param.c

conf.o: conf.c 
	-${RM} conf.o
	${KCC} ${CCNFLAGS} conf.c

scb_vec.o: scb_vec.c
	-${RM} scb_vec.o
	${KCC} ${CCNFLAGS} scb_vec.c

scalls:  ${SEC_LEVEL?audit_table:}

audit_table:	${CONFIG_DIR}/maketable.ksh ${CONFIG_DIR}/audit.master \
		${AUDIT} ${CONFIG_DIR}/auderrmsg
	rm -f auderrmsg 
	cp  ${CONFIG_DIR}/auderrmsg .
	ksh ${CONFIG_DIR}/maketable.ksh -hk \
		${CONFIG_DIR}/audit.master ${AUDIT}
	rm -f ../include/sys/auditsysc.h
	mv ./auditsysc.h ../include/sys/auditsysc.h
	mv ./audit_table ../include/sys/audit_table
	rm -f auderrmsg reduce_mdep.h

genassym.o: ${cpu}/genassym.c
	@if [ ${MACHINE} = alpha ]; then \
		${CC} -EL ${ALLOPTS} ${VOLATILE} -c ${cpu}/genassym.c; \
	else \
		${CC} -std0 -EL ${ALLOPTS} ${VOLATILE} -c ${cpu}/genassym.c; \
	fi

PMAX_CC_PREFIX=
MMAX_CC_PREFIX=LPATH=/usr/lib:/lib; export LPATH; 
I386_CC_PREFIX=LPATH=/usr/lib:/lib; export LPATH; 
CC_PREFIX=${${TARGET_MACHINE}_CC_PREFIX}

# Note: works on customer's system because LIBDIRS not in environment.
assym.s: genassym.o
	@if [ ${MACHINE} = alpha ]; then \
		${LD} -o genassym -L -L${COMP_HOST_ROOT}/usr/lib/cmplrs/acc \
	    	${COMP_HOST_ROOT}/usr/lib/cmplrs/acc/crt0_sa.o genassym.o \
	    	${COMP_HOST_ROOT}/usr/lib/cmplrs/acc/libc_sa.a -N -T ${TEXTBASE}; \
		/bin/sh ${SOURCEDIR}/../tools/alpha/hostbin/run-genassym; \
	else \
		${CC} -std0 -EL -non_shared -o genassym genassym.o; \
		./genassym  > assym.s; rm -f genassym; \
	fi

locore.o: assym.s ${LOCORE_HEADS}

#
#  Mach IPC-based interfaces
#

MACH_DEFSFILES=\
	mach/std_types.defs \
	mach/mach_types.defs \
	mach/mach.defs \
	mach/mach_host.defs \
	mach/exc.defs \
	mach/memory_object.defs \
	mach/memory_object_default.defs \
	mach/device_types.defs \
	mach/device.defs \
	mach/monitor.defs

MACH_GENFILES=\
	./mach/mach_server.o \
	./mach/mach_user_internal.h \
	./mach/mach_interface.h \
	./mach/mach_host_server.o \
	./mach/mach_host.h \
	./mach/memory_object_server.o \
	./mach/memory_object_user.o \
	./mach/memory_object_user.h \
	./mach/memory_object_default_server.o \
	./mach/memory_object_default_user.o \
	./mach/memory_object_default.h \
	./mach/device_server.o \
	./mach/exc_server.o \
	./mach/exc_user.o \
	./mach/exc.h \
	./mach/monitor_server.o \
	./mach/monitor.h

MACH_MKFILE=	mach/Makefile

$(MACH_GENFILES) : migfiles

migfiles :
	@if test ! -d mach; \
	then \
		mkdir mach; \
		for allfiles in $(MACH_DEFSFILES) ; \
		do \
		rm -f $$allfiles; \
		${LN} -s ../BINARY/$$allfiles $$allfiles ;\
		done; \
	else \
		true; \
	fi


MACH_DEBUG_DEFSFILES=\
	mach_debug/mach_debug_types.defs \
	mach_debug/mach_debug.defs

MACH_DEBUG_GENFILES=\
	mach_debug/mach_debug_server.o

MACH_DEBUG_MKFILE=	mach_debug/Makefile

$(MACH_DEBUG_GENFILES) : migdebugfiles

migdebugfiles :
	@if [ ! -d mach_debug ];\
	then \
		mkdir mach_debug; \
		for allfiles in $(MACH_DEBUG_DEFSFILES) ${MACH_DEBUG_DEFSFILES} ${MACH_DEBUG_GENFILES} ; \
		do \
		rm -f $$allfiles; \
		${LN} -s ../BINARY/$$allfiles $$allfiles ;\
		done; \
	else \
		true; \
	fi

MIG_ALL_FILES =	migfiles \
		migmachinefiles \
		migdebugfiles \
		migdebugmachinefiles

#
#  Update the Makefile when any dependency files exist rather than only
#  when they are newer than the makefile (since it often gets touched
#  during reconfigurations when dependency files have yet to be
#  integrated).  The makefile is copied before doing any potential
#  integration so that the new and old versions can be compared when
#  done (by the SYS_RULE_* rules) to prevent re-building things when no
#  dependencies change.
#
#  N.B.  There is always an empty artificial dependency file M.d
#  (created by config) which will never be integrated and simply
#  prevents the wild-card expansion below from failing.
#
#  The default exit rule now brings the Makefile up to date, so it
#  shouldn't be necessary to execute this rule manually.
#

.EXIT:

# depend on local 'c' and 's' files along with anything else we build
# to make a kernel that is not found in this directory, like data.c files.

depend: param.c assym.s ${CFILES} ${SFILES}
	-if [ ! -f assym.h ]; then ${ECHO} >assym.h; else exit 0; fi
	-${RM} makedep eddep
	for file_list in $? ioconf.c scb_vec.c; \
	do \
		${CC} -M -DOSF ${ALLOPTS} $${file_list} | \
		${AWK} ' { if ($$1 != prev) { \
 				print rec; rec = $$0; prev = $$1; \
 			} else { \
 				if (length(rec $$2) > 78) { \
 					print rec; rec = $$0; \
 			} else \
 					rec = rec " " $$2 \
 			} } \
	     	 END { print rec } ' >> makedep ; \
	done
	${ECHO} '/^# DO NOT DELETE THIS LINE/+1,$$d' >eddep
	${ECHO} '$$r makedep' >>eddep
	${ECHO} 'w Makefile' >>eddep
	${RM} makefile.bak
	${CP} Makefile makefile.bak
	${RM} Makefile
	${ED} - makefile.bak < eddep


#
#  Permit manually forced checkout of modules when the dependency
#  information is not current.
#

checkout:	${USE}



#
#  Clean up the current build directory.
#

clean:
	@for f in ${LOAD}; do ${ECHO} rm -f $$f $$f.* && rm -f $$f $$f.*; done
	rm -f eddep tags *.o locore.i \
		$(MIG_ALL_FILES) \
		errs linterrs makelinks *.log *LOG* ${CLEAN_EXTRA}


#
#  Run "lint" on the current build directory.  This will often be done
#  with a special configuration that defines the union of all options
#  used in all configurations so that all combinations are checked.
#  The LINTFILES variable allows lint to be easily run on an optional
#  sub-set of files specified on the make command line when this is
#  desired.
#

LINTFILES=Locore.c ${CFILES} swapgeneric.c

lint .ORDER:	$(EXTERNAL_FILES) \
		$(MIG_ALL_FILES) \
		assym.s \
		ALWAYS
	@${LINT} -n -hbxn -DGENERIC ${LINTOPTS} ${LINTFILES} | \
	    ${EGREP} -v 'struct/union .* never defined' | \
	    ${EGREP} -v 'possible pointer alignment problem'

ALWAYS:

MACHINEDIR=.

symbols.sort: ${MACHINEDIR}/symbols.raw
	-${GREP} -v '^#' ${MACHINEDIR}/symbols.raw \
	    | ${SED} 's/^	//' | sort -u > symbols.tmp
	mv -f symbols.tmp symbols.sort

#
#  This macro is replaced by the set of rules which build everything in
#  OBJS.
#

%DYNAMIC

%RULES

