/* Module mach_debug */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msg_request_port	msg_local_port
#define msg_reply_port		msg_remote_port
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <mach_debug/mach_debug_types.h>

/* Routine host_ipc_statistics */
mig_internal novalue _Xhost_ipc_statistics
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t statisticsType;
		ipc_statistics_t statistics;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t host_ipc_statistics
#if	(defined(__STDC__) || defined(c_plusplus))
		(task_t task, ipc_statistics_t *statistics);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t statisticsType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		15,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_ipc_statistics(In0P->Head.msg_request_port, &OutP->statistics);
#ifdef	label_punt0
#undef	label_punt0
punt0:
#endif	label_punt0
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 96;

#if	UseStaticMsgType
	OutP->statisticsType = statisticsType;
#else	UseStaticMsgType
	OutP->statisticsType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->statisticsType.msg_type_size = 32;
	OutP->statisticsType.msg_type_number = 15;
	OutP->statisticsType.msg_type_inline = TRUE;
	OutP->statisticsType.msg_type_longform = FALSE;
	OutP->statisticsType.msg_type_deallocate = FALSE;
	OutP->statisticsType.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Routine host_ipc_statistics_reset */
mig_internal novalue _Xhost_ipc_statistics_reset
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t host_ipc_statistics_reset
#if	(defined(__STDC__) || defined(c_plusplus))
		(task_t task);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_ipc_statistics_reset(In0P->Head.msg_request_port);
#ifdef	label_punt0
#undef	label_punt0
punt0:
#endif	label_punt0
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 32;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Routine host_callout_info */
mig_internal novalue _Xhost_callout_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t infoType;
		callout_info_array_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t host_callout_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(task_t task, callout_info_array_t *info, unsigned int *infoCnt);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_long_t infoType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0
	};
#endif	UseStaticMsgType

	unsigned int infoCnt;

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_callout_info(In0P->Head.msg_request_port, &OutP->info, &infoCnt);
#ifdef	label_punt0
#undef	label_punt0
punt0:
#endif	label_punt0
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 48;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->infoType.msg_type_long_size = 32;
	OutP->infoType.msg_type_header.msg_type_inline = FALSE;
	OutP->infoType.msg_type_header.msg_type_longform = TRUE;
	OutP->infoType.msg_type_header.msg_type_deallocate = FALSE;
	OutP->infoType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->infoType.msg_type_long_number /* 3 infoCnt */ = /* infoType.msg_type_long_number */ 3 * infoCnt;

	OutP->Head.msg_simple = FALSE;
	OutP->Head.msg_size = msg_size;
}

/* Routine host_zone_info */
mig_internal novalue _Xhost_zone_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t namesType;
		zone_name_array_t names;
		msg_type_long_t infoType;
		zone_info_array_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t host_zone_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(task_t task, zone_name_array_t *names, unsigned int *namesCnt, zone_info_array_t *info, unsigned int *infoCnt);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_long_t namesType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	},
		/* msg_type_long_name = */	MSG_TYPE_CHAR,
		/* msg_type_long_size = */	8,
		/* msg_type_long_number = */	0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_long_t infoType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0
	};
#endif	UseStaticMsgType

	unsigned int namesCnt;
	unsigned int infoCnt;

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_zone_info(In0P->Head.msg_request_port, &OutP->names, &namesCnt, &OutP->info, &infoCnt);
#ifdef	label_punt0
#undef	label_punt0
punt0:
#endif	label_punt0
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 64;

#if	UseStaticMsgType
	OutP->namesType = namesType;
#else	UseStaticMsgType
	OutP->namesType.msg_type_long_name = MSG_TYPE_CHAR;
	OutP->namesType.msg_type_long_size = 8;
	OutP->namesType.msg_type_header.msg_type_inline = FALSE;
	OutP->namesType.msg_type_header.msg_type_longform = TRUE;
	OutP->namesType.msg_type_header.msg_type_deallocate = FALSE;
	OutP->namesType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->namesType.msg_type_long_number /* 80 namesCnt */ = /* namesType.msg_type_long_number */ 80 * namesCnt;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->infoType.msg_type_long_size = 32;
	OutP->infoType.msg_type_header.msg_type_inline = FALSE;
	OutP->infoType.msg_type_header.msg_type_longform = TRUE;
	OutP->infoType.msg_type_header.msg_type_deallocate = FALSE;
	OutP->infoType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->infoType.msg_type_long_number /* 8 infoCnt */ = /* infoType.msg_type_long_number */ 8 * infoCnt;

	OutP->Head.msg_simple = FALSE;
	OutP->Head.msg_size = msg_size;
}

/* Routine host_ipc_bucket_info */
mig_internal novalue _Xhost_ipc_bucket_info
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t TLinfoType;
		ipc_bucket_info_array_t TLinfo;
		msg_type_long_t TPinfoType;
		ipc_bucket_info_array_t TPinfo;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t host_ipc_bucket_info
#if	(defined(__STDC__) || defined(c_plusplus))
		(task_t task, ipc_bucket_info_array_t *TLinfo, unsigned int *TLinfoCnt, ipc_bucket_info_array_t *TPinfo, unsigned int *TPinfoCnt);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_long_t TLinfoType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_long_t TPinfoType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0
	};
#endif	UseStaticMsgType

	unsigned int TLinfoCnt;
	unsigned int TPinfoCnt;

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = host_ipc_bucket_info(In0P->Head.msg_request_port, &OutP->TLinfo, &TLinfoCnt, &OutP->TPinfo, &TPinfoCnt);
#ifdef	label_punt0
#undef	label_punt0
punt0:
#endif	label_punt0
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 64;

#if	UseStaticMsgType
	OutP->TLinfoType = TLinfoType;
#else	UseStaticMsgType
	OutP->TLinfoType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->TLinfoType.msg_type_long_size = 32;
	OutP->TLinfoType.msg_type_header.msg_type_inline = FALSE;
	OutP->TLinfoType.msg_type_header.msg_type_longform = TRUE;
	OutP->TLinfoType.msg_type_header.msg_type_deallocate = FALSE;
	OutP->TLinfoType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->TLinfoType.msg_type_long_number /* TLinfoCnt */ = /* TLinfoType.msg_type_long_number */ TLinfoCnt;

#if	UseStaticMsgType
	OutP->TPinfoType = TPinfoType;
#else	UseStaticMsgType
	OutP->TPinfoType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->TPinfoType.msg_type_long_size = 32;
	OutP->TPinfoType.msg_type_header.msg_type_inline = FALSE;
	OutP->TPinfoType.msg_type_header.msg_type_longform = TRUE;
	OutP->TPinfoType.msg_type_header.msg_type_deallocate = FALSE;
	OutP->TPinfoType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->TPinfoType.msg_type_long_number /* TPinfoCnt */ = /* TPinfoType.msg_type_long_number */ TPinfoCnt;

	OutP->Head.msg_simple = FALSE;
	OutP->Head.msg_size = msg_size;
}

boolean_t mach_debug_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register msg_header_t *InP =  InHeadP;
	register death_pill_t *OutP = (death_pill_t *) OutHeadP;

#if	UseStaticMsgType
	static msg_type_t RetCodeType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0
	};
#endif	UseStaticMsgType

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof *OutP;
	OutP->Head.msg_type = InP->msg_type;
	OutP->Head.msg_local_port = PORT_NULL;
	OutP->Head.msg_remote_port = InP->msg_reply_port;
	OutP->Head.msg_id = InP->msg_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msg_type_size = 32;
	OutP->RetCodeType.msg_type_number = 1;
	OutP->RetCodeType.msg_type_inline = TRUE;
	OutP->RetCodeType.msg_type_longform = FALSE;
	OutP->RetCodeType.msg_type_deallocate = FALSE;
	OutP->RetCodeType.msg_type_unused = 0;
#endif	UseStaticMsgType
	OutP->RetCode = MIG_BAD_ID;

	if ((InP->msg_id > 3006) || (InP->msg_id < 3000))
		return FALSE;
	else {
		typedef novalue (*SERVER_STUB_PROC)
#if	(defined(__STDC__) || defined(c_plusplus))
			(msg_header_t *, msg_header_t *);
#else
			();
#endif
		static SERVER_STUB_PROC routines[] = {
			_Xhost_ipc_statistics,
			_Xhost_ipc_statistics_reset,
			_Xhost_callout_info,
			0,
			0,
			_Xhost_zone_info,
			_Xhost_ipc_bucket_info,
		};

		if (routines[InP->msg_id - 3000])
			(routines[InP->msg_id - 3000]) (InP, &OutP->Head);
		 else
			return FALSE;
	}
	return TRUE;
}
