/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	times.h,v $
 * Revision 4.2.2.2  92/03/27  15:16:09  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:43:55  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:35:31  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:57:26  Craig_Horman]
 * 
 * Revision 4.2  91/09/19  23:01:40  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: times.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:16:09 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */


/*
 * COMPONENT_NAME: times.h
 *                                                                    
 * ORIGIN: IBM
 *
 * Copyright International Business Machines Corp. 1985, 1988
 * All Rights Reserved
 * Licensed Material - Property of IBM
 *
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the Rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */                                                                   
/*
 * OSF/1 Release 1.0
 */

#ifndef _SYS_TIMES_H_
#define _SYS_TIMES_H_

#include <standards.h>
#include <sys/types.h>			/* for clock_t */


#ifdef _POSIX_SOURCE

/*
 * POSIX requires that certain values be included in times.h.  It also
 * requires that when _POSIX_SOURCE is defined only those standard
 * specific values are present.  This header includes all the POSIX
 * required entries.
 */

/*
 * Structure returned by times()
 */
struct tms {
	clock_t	tms_utime;		/* user time */
	clock_t	tms_stime;		/* system time */
	clock_t	tms_cutime;		/* user time, children */
	clock_t	tms_cstime;		/* system time, children */
};

#ifdef _NO_PROTO
extern clock_t times();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern clock_t times(struct tms *);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */

#endif /* _POSIX_SOURCE */
#endif	/* _SYS_TIMES_H_ */
