
/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mach_param.h,v $
 * Revision 4.2.2.3  92/06/18  13:17:05  Robert_McGuirk
 * 	Increase TASK_MAX and THREAD_MAX to 8192.
 * 	[92/06/18  13:15:34  Robert_McGuirk]
 * 
 * Revision 4.2.2.2  92/03/26  11:44:28  Robert_Picco
 * 	increased task and thread maximums
 * 	[92/03/24  10:00:52  Robert_Picco]
 * 
 * Revision 4.2  91/09/19  22:25:51  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mach_param.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/06/18 13:17:05 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *	File:	kern/mach_param.h
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *	Copyright (C) 1986, Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Mach system sizing parameters
 *
 */

#ifndef	_KERN_MACH_PARAM_H_
#define _KERN_MACH_PARAM_H_

#include <mach/mach_param.h>		/* for backwards compatibility */

#define THREAD_MAX	8192		/* Max number of threads */
#define THREAD_CHUNK	64		/* Allocation chunk */

#define TASK_MAX	8192		/* Max number of tasks */
#define TASK_CHUNK	64		/* Allocation chunk */

#define PORT_MAX	((TASK_MAX * 3 + THREAD_MAX)	/* kernel */ \
				+ (THREAD_MAX * 2)	/* user */ \
				+ 20000)		/* slop for objects */
					/* Number of ports, system-wide */

#define SET_MAX		(TASK_MAX + THREAD_MAX + 200)
					/* Max number of port sets */

#define KERN_MSG_SMALL_SIZE	128	/* Size of small kernel message */

#endif	/* _KERN_MACH_PARAM_H_ */
