/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	event.h,v $
 * Revision 4.2  91/09/19  22:23:19  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: event.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:23:19 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (C) 1988,1989 Encore Computer Corporation.  All Rights Reserved
 *
 * Property of Encore Computer Corporation.
 * This software is made available solely pursuant to the terms of
 * a software license agreement which governs its use. Unauthorized
 * duplication, distribution or sale are strictly prohibited.
 *
 */
/*
 *	File:	sys/event.h
 *
 *	Event structure and definitions.
 *
 *	Events with "memory".
 *
 *	Revision History:
 *
 * 8-Apr-91	Ron Widyono
 *	Delay inclusion of sys/preempt.h (for RT_PREEMPT) to avoid circular
 *	include file problem.
 *
 */

#ifndef	_KERN_EVENT_H_
#define	_KERN_EVENT_H_

#include <rt_preempt.h>

#if	RT_PREEMPT
#ifndef	_SKIP_PREEMPT_H_
#define _SKIP_PREEMPT_H_
#define	_KERN_EVENT_H_PREEMPT_
#endif
#endif

#include <mach/boolean.h>
#include <kern/lock.h>

struct event {
	boolean_t		ev_event;
#if	defined(_KERNEL) && defined(MACH_LDEBUG)
	char		*ev_thread;	/* thread posted/cleared event */
	int		ev_paddr;	/* pc of last event_post */
	int		ev_caddr;	/* pc of last event_clear */
#endif
	decl_simple_lock_data(,ev_slock)
};

typedef struct event		event_t;

void	event_clear();			/* event hasn't happened yet */
void	event_init();			/* init lock and event */
void	event_post();			/* tell world event happened */
int	event_posted();			/* has event happened yet? */
int	event_wait();			/* wait for momentous event */

#if	RT_PREEMPT
#ifdef	_KERN_EVENT_H_PREEMPT_
#include <sys/preempt.h>
#endif
#endif

#endif	/* _KERN_EVENT_H_ */
