/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	gen_bus_adapt.h,v $
 * Revision 1.1.2.3  92/05/20  15:39:33  Stuart_Hollander
 * 	get_bus_addr returns unsigned long
 * 	[92/05/15  13:56:05  Stuart_Hollander]
 * 
 * Revision 1.1.2.2  92/02/14  13:31:06  Stuart_Hollander
 * 	Original Version
 * 	[92/02/10  22:38:18  Stuart_Hollander]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: gen_bus_adapt.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/20 15:39:33 $
 */

/*
 * Generic bus_adapter structure.
 * 
 */

struct	gen_bus_adapt {
	struct	gen_bus_adapt *next;	/* pointer to next in list */
	int	xbanum;		/* ba number passed in to adapter code */
	int	adptnum;	/* internal number of adapter per bus type */
	caddr_t virt_addr;		/* virt addr of bus adapter */
	caddr_t phys_addr;		/* phys addr of bus adapter */
	int	(*display_addr_type)(); /* displays atype during config */
	int	(*is_ivec_valid)();	/* is interrupt vector valid? */
	caddr_t	(*map_csr)();		/* map csr (for pio) */
	int	(*unmap_csr)();		/* unmap csr (for pio) */
	unsigned int	(*setup)();	/* set up dma mapping */
	int	(*release)();		/* release dma mapping */
	int	(*log_ctlr_err)();	/* log controller error */
	int	(*log_dev_err)();	/* log device error */
	int	(*rmw)();		/* do read/modify/write */
	unsigned long	(*get_bus_addr)();/* get address on target bus */
	int	(*errors)();		/* Error routine for adapter */

	int	(**intr_vec)();		/* interrupt vectors */
	caddr_t	adapt_regs;		/* ptr to adapter registers	*/
	caddr_t	adapt_vars;		/* ptr to adapter specific variables */
	caddr_t	bus_vars;		/* ptr to bus specific variables    */
	short	bus_want;		/* someone is waiting for bus space */
	caddr_t reserved[5];
};

extern u_long gen_ba_vatophys();
#define xbahd private[4]
