/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sim_config.h,v $
 * Revision 1.1.3.2  92/02/27  16:04:55  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.4  92/01/31  11:19:47  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  09:55:45  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:28:17  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:08:36  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:22:57  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:18:35  Janet_Schank]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: sim_config.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/02/27 16:04:55 $
 */
#ifndef	SIM_CONFIG_INCLUDE
#define	SIM_CONFIG_INCLUDE	1

/************************************************************************
 *
 * File:	sim_config.h
 * Date:	June 17, 1991
 * Author:	Robert P. Scott
 *
 * Description:
 *	CAM SIM subsystem configuration definitions.
 *
 * Modification History:
 *
 *      08/17/91    rps    Added chip reset pointer to hba struct.
 */

#define	INIT_CAM_HBA_LIMIT	16		/* # of sim drv. tbl. ent. */
#define	INIT_CAM_DME_LIMIT	16		/* # of sim drv. tbl. ent. */

typedef struct cam_hba_list_entry 
    {
    char        *cs_name;
    int         (*cs_probe)();
    int         (*cs_attach)();
    int         (*cs_reset_attach)();
    int         (*cs_unload)();
    U32	        (*hba_init)();	/* initialize the HBA			*/
    U32         (*hba_go)();	/* function to start a command off	*
    U32         (*hba_sm)();	/* HBA specific state machine		*/
    U32         (*hba_bus_reset)();
    U32         (*hba_send_msg)();
    U32         (*hba_xfer_info)();
    U32         (*hba_sel_msgout)();
    U32         (*hba_msgout_pend)();
    U32         (*hba_msgout_clear)();
    U32         (*hba_msg_accept)();
    U32         (*hba_setup_sync)();
    U32         (*hba_discard_data)();
    } CAM_HBA_LIST_ENTRY;

typedef struct cam_dme_list_entry 
    {
    char        *dme_name;
    int         (*dme_init)();
    int         (*dme_unload)();
    void 	*base_address;
    } CAM_DME_LIST_ENTRY;

#endif /* SIM_CONFIG_INCLUDE */












