
/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	errlog.h,v $
 * Revision 1.1.2.9  92/06/16  09:58:53  cam_proj_Janet_Schank
 * 	Added defines for RZ24l. RZ26, and TKZ09.
 * 	[92/06/09  16:57:40  Maria_Vella]
 * 
 * Revision 1.1.2.8  92/06/02  10:51:41  cam_proj_Janet_Schank
 * 	Merged with AG
 * 	[92/06/02  07:53:34  cam_proj_Janet_Schank]
 * 
 * 	Moved devio.h from sys to io/common
 * 	[92/05/26  10:20:26  Janet_Schank]
 * 
 * Revision 1.1.2.7  92/06/01  10:40:44  Scott_Cranston
 * 	Correct Warning msg problem - Missing ';' on esr_ipcr in struct el_esr5500
 * 	[92/05/21  14:29:13  Scott_Cranston]
 * 
 * 	Changed #include path for binlog.h
 * 	[92/05/19  10:43:30  Scott_Cranston]
 * 
 * Revision 1.1.2.6  92/04/10  12:53:40  Scott_Cranston
 * 
 * 	 - changed long data types to int.
 * 	 - added 'L' to some #define's.
 * 	[92/04/09  09:43:35  Scott_Cranston]
 * 
 * Revision 1.1.2.5  92/03/24  14:57:29  Scott_Cranston
 * 	Added CITCA support.
 * 	Changed DEFTA data structure.
 * 	[92/03/24  14:37:12  Scott_Cranston]
 * 
 * Revision 1.1.2.4  92/02/29  09:23:18  cam_proj_Janet_Schank
 * 	Removed old SCSI driver includes and structures.
 * 	[92/02/29  09:19:05  cam_proj_Janet_Schank]
 * 
 * Revision 1.1.2.3  92/02/28  14:10:00  Scott_Cranston
 * 	merge with DSA stuff.
 * 	[92/02/27  19:45:42  Scott_Cranston]
 * 
 * 	   -  add CAM
 * 	   -  add NPORT
 * 	   -  add TC VME
 * 	[92/02/23  08:10:38  Scott_Cranston]
 * 
 * 	  - Replace sub file with the real stuff.
 * 	  - Add DEFTA support.
 * 	[92/02/19  13:46:33  Scott_Cranston]
 * 
 * 	Stub file to aid in migration from sys/errlog./h to dec/binlog.h
 * 	[92/02/12  08:42:31  Scott_Cranston]
 * 
 * Revision 1.1.2.2  92/02/13  15:14:21  Scott_Cranston
 * 	Stub file to aid in migration from sys/errlog./h to dec/binlog.h
 * 	[92/02/12  08:42:31  Scott_Cranston]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: errlog.h,v $ $Revision: 1.1.2.9 $ (DEC) $Date: 92/06/16 09:58:53 $
 */


/*
 * Old logs before move from sys/errlog.h to dec/binlog/errlog.h
 *
 * Revision 4.5.1.2  91/12/16  09:25:59  Gary_Dupuis
 * 	Merge with 4.5
 * 	[91/12/12  11:05:30  Gary_Dupuis]
 * 
 * 	91/12/06	Gary Dupuis
 * 	Added support for Maxine (PERSONAL_DECstation)
 * 	1) Add define for error and status type for MAXine and 3MAX+.
 * 	   ELESR_KN03 and ELESR_KN02CA.
 * 	2) Add defines formemory control types for the 3MAX+ and
 * 	   MAXine. ELMCNTR_KN03 and ELMCNTR_KN02CA.
 * 	3) Define error log structures for the MAXine and 3MAX+.
 * 	   el_esrkn02ba and el_esrkn02ca.
 * 	4) Add entries to the el_esr structure for the MAXine and the
 * 	   3MAX+.
 * 	[91/12/12  11:03:05  Gary_Dupuis]
 * 
 * Revision 4.5.5.2  92/01/19  12:25:20  Scott_Cranston
 * 	- Cleaned up, removed unsupported devices (VAX stuff).
 * 
 * 	- Split ino two files vendor dependent (errlog.h) and vendor
 * 	  independent (binlog.h).
 * 
 * Revision 4.5  91/11/27  15:50:41  devbld_zk3
 * 	Incbaselevel update
 * 
 * Revision 4.2  91/09/19  23:04:08  devbld
 * 	Adding ODE Headers
 * 
 * Revision 4.2.2.3  91/11/20  14:10:30  Hal_Project
 * 	Changed dec/machine/mips include to machinine/
 * 	[91/11/18  00:37:18  Donald_Dutile]
 * 
 * Revision 4.2.2.2  91/10/23  15:09:05  William_Burns
 * 	Merge from ODE/TIN: revision 3.5.9.2
 * 	date: 91/10/17 21:12:28;  author: devrcs;  state: Exp;  lines added/del: 4/2
 * 	sccs rev: 3.7;  orig date: 91/10/02 08:20:10;  orig author: fred
 * 	Fred Canter - fix keywords.
 * 	[91/10/23  09:13:47  William_Burns]
 * 
 */

#ifndef __ERRLOG__
#define __ERRLOG__ 

#include <dec/binlog/binlog.h>
#include <io/common/devio.h>
#include <io/dec/bi/bireg.h>
#include <io/dec/sysap/mscp_msg.h>



/* Digital Equiptment Corp specific binary event log record definitions */


/* for backward compatibility with TIN and ULTRIX */
#define ealloc (struct el_rec *)binlog_alloc
#define EL_FULL (struct el_rec *)0
#define EVALID(erp) binlog_valid((char *)erp);
#define EL_MAXRECSIZE  6144L       /*  6Kb, used by uerf */
#define EL_MAXAPPSIZE   (EL_MAXRECSIZE - EL_MISCSIZE)






/* machinecheck and exception frame types (el_sub_id.subid_type)*/
#define	ELESR_5400	1			/* DS5400 ESR	*/
#define ELESR_kn01      2                       /* DS2100/3100 ESR */
#define	ELESR_kn02	3			/* DS5000 ESR   */
#define	ELESR_5500	4			/* DS5500 ESR	*/
#define ELESR_5100      5                       /* DS5100 ESR   */
#define ELESR_KN02BA	6			/* DS5000_100 ESR */
#define ELESR_KN03      7                       /* DS5000_300 ESR */
#define ELESR_KN02CA    8                       /* DSMAXINE ESR   */


/* stray intr types (el_sub_id.subid_type) */
   /*  this was VAX specific stuff */


/* console timeout entry types (el_sub_id.subid_type) */
   /*  this was VAX specific stuff */


/* device error types (el_sub_id.subid_type) */
#define ELDEV_MSCP	1
#define ELDEV_REGDUMP	2
#define	ELDEV_SCSI	3

/* device controller error/event types (el_sub_id.subid_type) */
#define ELCI_ATTN	1
#define ELCI_LPKT	2
#define	ELUQ_ATTN	3
#define ELMSCP_CNTRL	6
#define ELTMSCP_CNTRL	7
#define ELMSI_ATTN	8
#define ELMSI_LPKT	9
#define	ELSCSI_CNTRL	10
#define ELXMI_XNA       12
#define ELVME_DEV_CNTL  13          /* general purpose VME dev/ctrl packet */
#define ELFZA		14
#define ELFTA           15

/* adapter error types (el_sub_id.subid_type) */
#define ELADP_VBA       6                       /* VMEbus adapters */

/* bus error types (el_sub_id.subid_type) */

/* stack dump error types (el_sub_id.subid_type) */
#define ELSTK_KER	1
#define ELSTK_INT	2
#define ELSTK_USR	3

/* Soft & Hard error types (el_sub_id.subid_type) */

/* Vector error types (el_sub_id.subid_type) */

/* vector processor types (el_sub_id.subid_ctldevtyp) */

/* MIPS mem cntl types (el_sub_id.subid_ctldevtyp) */
#define ELMCNTR_PMAX    13                      /* PMAX mem. cntl. */
#define	ELMCNTR_5400	16			/* DS5400 mem cntl. */
#define	ELMCNTR_kn02	18			/* DS5000 (3max) mem cntl. */
#define	ELMCNTR_5500	19			/* DS5500 mem cntl. */
#define ELMCNTR_5100    25                      /* DS5100 mem cntl. */
#define ELMCNTR_KN02BA	28			/* DS5000_100 mem. cntl. */
#define ELMCNTR_KN03    29                      /* DS5000_300 mem. cntl. */
#define ELMCNTR_KN02CA  30                      /* DSMAXINE mem. cntl. */

/* ci hardware port types (el_sub_id.subid_ctldevtyp) */
#define ELCIHPT_CI780   2
#define ELCIHPT_CI750   3
#define ELCIHPT_CIBCI   5
#define ELCIHPT_CIBCABA 10
#define ELCIHPT_CIBCAAA 11
#define ELCIHPT_CIXCD   14
#define ELCIHPT_CIMNA   16
#define ELCIHPT_CITCA   17


/* msi hardware port type (el_sub_id.subid_ctldevtyp) */
#define ELMSIHPT_SII	32

/* bvp hardware port types (el_sub_id.subid_ctldevtyp) */

/* uq hardware port types (el_sub_id.subid_ctldevtyp) */
#define ELUQHPT_UDA50   0
#define ELUQHPT_RC25    1
#define	ELUQHPT_RUX50	2		
#define	ELUQHPT_TK50	3		
#define	ELUQHPT_TU81	5
#define ELUQHPT_UDA50A  6
#define	ELUQHPT_RQDX	7
#define ELUQHPT_KDA50   13
#define	ELUQHPT_TK70	14
#define	ELUQHPT_RV20	15
#define	ELUQHPT_RRD50	16
#define ELUQHPT_KDB50   18
#define	ELUQHPT_RQDX3	19
#define ELUQHPT_KDM70   27

/* controller types mscp (el_sub_id.subid_ctldevtyp) */
#define	ELMPCT_HSC50	1		
#define ELMPCT_UDA50    2
#define ELMPCT_RC25     3
#define ELMPCT_VMS      4
#define	ELMPCT_TU81	5
#define	ELMPCT_RQDX	7
#define ELMPCT_TOPS     8
#define	ELMPCT_TK50	9		
#define	ELMPCT_RUX50	10		
#define	ELMPCT_KFBTA	12
#define	ELMPCT_TK70	14
#define	ELMPCT_RV20	15
#define	ELMPCT_RRD50	16
#define	ELMPCT_KDB50	18
#define	ELMPCT_RQDX3	19
#define	ELMPCT_RQDX4	20
#define	ELMPCT_SII_DISK	21
#define	ELMPCT_SII_TAPE	22
#define	ELMPCT_SII_DISK_TAPE	23
#define	ELMPCT_SII_OTHER	24
#define ELMPCT_KDM70    27
#define	ELMPCT_HSC70	32
#define	ELMPCT_HSB50	64
#define	ELMPCT_RF30	96
#define	ELMPCT_RF71	97
#define ELMPCT_ULTRIX   248


/* controller types SCSI (el_sub_id.subid_ctldevtyp) */
#define	ELSCCT_5380	1
#define	ELSCCT_SII	2
#define ELSCCT_ASC	3
#define ELSCCT_KZQ      4

/* disks types mscp (el_sub_id.subid_ctldevtyp) */
#define ELDT_RA80	1
#define ELDT_RC25	2
#define ELDT_RCF25	3
#define ELDT_RA60	4
#define ELDT_RA81	5
#define ELDT_RD51	6
#define ELDT_RX50	7
#define ELDT_RD52	8
#define ELDT_RD53	9
#define ELDT_RX33	10
#define ELDT_RA82	11
#define ELDT_RD31	12
#define ELDT_RD54	13
#define ELDT_RRD50	14
#define ELDT_RV20	15
#define ELDT_RD32	15
/* unused	 	16 */
#define ELDT_RX18	17
#define ELDT_RA70	18
#define ELDT_RA90	19
#define ELDT_RX35	20
#define ELDT_RF30	21
#define ELDT_RF71	22
#define ELDT_SVS00	23
#define ELDT_RD33	24
#define ELDT_ESE20	25
#define ELDT_RRD40	26
#define ELDT_RF31	27
#define ELDT_RF72	28
#define ELDT_RA92	29
#define ELDT_RA72	37
#define ELDT_RA71	40

/* tapes types tmscp (el_sub_id.subid_ctldevtyp) */
#define ELTT_TA78	1
#define ELTT_TU81	2
#define ELTT_TK50	3
#define ELTT_TA81	4
#define ELTT_TA79	5
#define ELTT_TA90	7
#define ELTT_RV60	8
#define ELTT_SVS00	9
#define ELTT_TA91	12
#define ELTT_TK70	14
#define ELTT_TRV20	15

/* disks types SCSI (el_sub_id.subid_ctldevtyp) */
#define	ELSDT_RX23	1
#define ELSDT_RX33	2
#define	ELSDT_RZ22	3
#define	ELSDT_RZ23	4
#define	ELSDT_RZ55	5
#define	ELSDT_RZ56	6
#define	ELSDT_RRD40	7
#define	ELSDT_RZxx	8
#define ELSDT_RZ24      9
#define ELSDT_RZ57      10
#define ELSDT_RZ23L     11
#define ELSDT_RRD42	12
#define ELSDT_RX26	13
#define ELSDT_RZ25	14
#define ELSDT_RZ58	15
#define ELSDT_RZ24L     16
#define ELSDT_RZ26	17

/* tapes types SCSI (el_sub_id.subid_ctldevtyp) */
#define	ELSTT_TZ30	1
#define	ELSTT_TZK50	2
#define	ELSTT_TZxx	3
#define ELSTT_TLZ04     4
#define ELSTT_TZ05      5
#define ELSTT_TZ07	6
#define ELSTT_TZK08	7
#define	ELSTT_TZK10	8
#define ELSTT_TKZ09	9

/* VMEbus adapter types (el_sub_id.subid_ctldevtype) */
#define ELDT_3VIA       1                      /* 3max VME adapter */
#define ELDT_MVIA       2                      /* Mipsfair-2 VME adapter */
#define ELDT_XBIA       3                      /* Cmax VME adapter (XMI) */
#define ELDT_TC300      4                      /* DAA TC300/VME (TC-VME) */

/* panic exception/fault errcodes (el_sub_id.subid_type) */

/* elmemerr.type */
#define ELMETYP_CRD	1
#define ELMETYP_RDS	2
#define ELMETYP_CNTL	3
#define ELMETYP_WMASK	4
#define ELMETYP_PAR	5
#define ELMETYP_NXM	6

/* el_sub_id.subid_num  for machine check is cpu number */


/* sca( scs, bvp, uq, ci ppd, ci, msi ) event codes definition
 * ( el_sub_id.subid_errcode )
 *
 *  3 3 2 2 2 2 2 2 2 2 2 2 1 2 1 1 1 1 1 1 1 1 
 *  1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
 * +-+-+-+---+-----+-----------------------------------------------+
 * |E|E| |   |  E  |                                               |
 * |C|S|E| E |  S  |                                               |
 * |L|U|C| S |  E  |                                               |
 * |A|B|L| E |  V  |                                               |
 * |L|C|A| V |  E  |                    ECODE                      |
 * |W|L|S| M |  R  |                                               |
 * |A|A|S| O |  I  |                                               |
 * |Y|S| | D |  T  |                                               |
 * |A|S| |   |  Y  |                                               |
 * +-+-+-+---+-----+-----------------------------------------------+
 *		
 *  Bits		     		Function
 * -----		-----------------------------------------
 *  0-23		ECODE     - Event Code Number
 * 24-26		ESEVERITY - Event Severity Codes
 *		            Informational	0x00
 *			    Warning		0x01
 *			    Remote Error	0x02
 *			    Error		0x03
 * 		            Severe Error	0x04
 * 		            Fatal Error		0x05
 *			    RSVD( Future Use )	0x06
 *			    RSVD( Future Use )	0x07
 * 27-28		ESEVMOD	  - Event Severity Modifier Codes
 *			    None		0x00
 *			    Path Crash		0x01
 *			    Local Port Crash	0x02
 *			    RSVD( Future Use )	0x03
 *    29		ECLASS	  - Event Class Code
 *			    SCS			0x00
 *			    PD			0x01
 *    30		ESUBCLASS - Event Subclass Code( PD dependent )
 *			    PD			0x00( NP/MSI/CI/BVP/UQ )
 *			    PPD			0x01( MSI/CI )
 *    31		ECLALWAYS - Event Console Loggging Filter Override
 *		
 * Event codes ( ECODE ) are densely assigned for each possible combination
 * of ESEVERITY, ECLASS, and ESUBCLASS.
 *
 *			Definition of Severity Conditions
 *			---------------------------------
 *
 * Informational:		Notifies of a fully successful event.
 *				Notifies of a purely informative event.
 *				Does NOT increment any error counters.
 *
 * Warning:			Warns of possible problems associated with an
 *				 otherwise successful event.
 *				Does NOT increment any error counters.
 *
 * Remote Error:		Notifies of the occurrence of a remote error.
 *				Does NOT increment any error counters.
 *
 * Error:			Notifies of the occurrence of a local
 *				 recoverable error associated with a specific
 *				 path or local port.
 *				May have the path crash modifier applied.
 *				Increments the number of errors associated with
 *				 the appropriate local port.
 *
 * Severe Error:		Notifies of the occurrence of a severe( but
 *				 still recoverable ) local error associated
 *				 with a specific path or local port.
 *				May have the path or local port crash severity
 *				 modifier applied.
 *				Increments the number of errors associated with
 *				 the appropriate local port.
 *
 * Fatal Error:			Notifies of the occurrence of a fatal
 *				 non-recoverable error associated with a
 *				 specific local port.
 *				Increments the number of errors associated with
 *				 the local port.
 *				Always logged to the console.
 */

/*  elbd_flags (el_bdhdr) */
/* 0x00 = write */
/* 0x01 = read */
/* 0x02 = done */
/* 0x04 = error */

/* uq error codes definition (el_sub_id.subid_errcode)
 */
#define ELUQ_SA_FATAL           1       /* Fatal error in SA register   */
#define ELUQ_RESET_FAIL         2       /* Initialization failed        */


/* XNA error codes (el_sub_id.subid_errcode) */
#define XNA_FATAL       0
#define XNA_NONFATAL    1

/* VMEbus device/controller errcode (el_sub_id.subid_errcode) */
#define VME_DEVICE      1
#define VME_CONTROLLER  2


/* VMEbus adapter error codes (el_sub_id.subid_errcode) */
#define VBA_VME_ERROR         0                /* general VME error */
#define VBA_VME_PARITY        1                /* general parity errors */
#define VBA_VME_TIMEOUT       2                /* vme timeout errors */
#define VBA_IBUS_CABLE_FLT    3                /* ibus cable fault */
#define VBA_IBUS_PARITY       4                /* ibus parity errors */
#define VBA_RMW_INTERLOCK     5                /* Read Mod Write/Interlock */
#define VBA_VME_BERR          6                /* VMEbus *BERR signal */
#define VBA_XBIA_INTERNAL     7                /* XBIA internal gate array */
#define VBA_IO_WRITE_FAIL     8                /* I/O write failure */
#define VBA_PMAP_FAULT        9                /* page map fault errors */
#define VBA_YABUS_ERROR      10                /* YAbus errors */
#define VBA_VME_MOD_FAIL     11                /* VME module failure */
#define VBA_VME_AC_LOW       12                /* VME AC below spec */
#define VBA_VIC_LOC_TOUT     13                /* VIC chip local timeout */
#define VBA_VIC_SELF_ACCESS  14                /* VIC self-acess select err */
#define VBA_VIC_LBERR        15                /* VIC *LBERR signal */
#define VBA_INVALID_PFN      16                /* invalid PFN */
#define VBA_MULTIPLE_ERRS    17                /* multiple errors */
#define VBA_CORR_ECC         18                /* correctable ECC */
#define VBA_UNCORR_ECC       19                /* uncorrectable ECC */
#define VBA_SYS_RESET        20                /* VME reset signal asserted */
#define VBA_CABLE_VIOLATION  21                /* Encoding violation on cable */

/* current ci event packet version
 * (el_body.elci.cicommon.ci_evpktver)
 */
#define	CI_EVPKTVER		 0

/* ci optional event packet field bit mask definitions
 * (el_body.elci.cicommon.ci_optfmask1)
 * bits 0x000000001 - 0x00004000 used, next free 0x00008000
 */
					/* ci device attention info fields */
#define	CI_REGS		0x00000001	/*  ci port registers */
#define	CI_BIREGS	0x00000002	/*  biic device registers */
#define	CI_XMIREGS	0x00000004	/*  xmi device registers */
#define	CI_UCODE	0x00000008	/*  bad ucode information */
#define	CI_REVLEV	0x00000010	/*  out-of-rev/invalid ucode info */
#define	CI_CPUREVLEV	0x00000020	/*  out-of-rev CPU ucode information */
#define CI_NPREGS       0x00000400      /*  N_PORT port registers */
#define CI_TCREGS       0x00000800      /*  tc device registers */
#define CI_NPPARMS      0x00001000      /*  N_PORT parmeters    */
					/* CI Logged Packet Info Fields */
#define	CI_LCOMMON	0x00000040	/*  common logged packet information */
#define	CI_PACKET	0x00000080	/*  logged packet */
#define	CI_EXPADRS	0x00000100	/*  explicit addrs format used  */
#define CI_NPPKT        0x00000200      /*  N_PORT format used  */
					/* CI Read Count Data    */
#define CI_TCA_RDCNT    0x00002000      /*  N_PORT CITCA read count data  */
#define CI_XCD_RDCNT    0x00004000      /*  CIPORT CIXCD read count data  */



/* current ci ppd event packet version
 * (el_body.elcippd.cippdcommon.cippd_evpktver)
 */
#define	CIPPD_EVPKTVER		 0

/* ci ppd optional event packet field bit mask definitions
 * (el_body.elcippd.cippdcommon.cippd_optfmask1)
 *
 */
					/* ci ppd sub id fields */
#define	CIPPD_CLTDEVTYP	0x00000001	/*  controller/device type */
#define	CIPPD_CLTDEVNUM	0x00000002	/*  controller number */
					/* ci ppd path specific info fields */
#define	CIPPD_PCOMMON	0x00000004	/*  common path specific information */
#define	CIPPD_DBCOLL	0x00000008	/*  database collision information */
#define	CIPPD_SYSAP	0x00000010	/*  name of local sysap crashing path*/
#define	CIPPD_NEWPATH	0x00000020	/*  new path information */
#define	CIPPD_PPACKET	0x00000040	/*  ci ppd logged packet */
					/* ci ppd common sys lev info fields */
#define	CIPPD_SCOMMON	0x00000080	/*  common system level information */
#define	CIPPD_PROTOCOL	0x00000100	/*  ci ppd protocol information */
#define	CIPPD_SPACKET	0x00000200	/*  ci ppd logged packet */

/* current msi event packet version
 * (el_body.elmsi.msicommon.msi_evpktver)
 */
#define	MSI_EVPKTVER		 0

/* msi optional event packet field bit mask definitions
 * (el_body.elmsi.msicommon.msi_optfmask1)
 *
 */
					/* msi device attention info fields */
#define	MSI_REGS	0x00000001	/*  msi port registers */
					/* msi logged packet info fields */
#define	MSI_LCOMMON	0x00000002	/*  common logged packet information */
#define	MSI_CMDBLK	0x00000004	/*  logged packet command block info */
#define	MSI_PACKET	0x00000008	/*  logged packet */

/* current scs event packet version
 * (el_body.elscs.scscommon.scs_evpktver)
 */
#define	SCS_EVPKTVER		 0

/* scs optional event packet field bit mask definitions
 * (el_body.elscs.scscommon.scs_optfmask1)
 */
					/* scs sub id fields */
#define	SCS_CLTDEVTYP	0x00000001	/*  controller/device type */
#define	SCS_CLTDEVNUM	0x00000002	/*  controller number */
					/* scs optional information fields */
#define	SCS_CONN	0x00000004	/*  scs connection information */
#define	SCS_LDIRID	0x00000008	/*  local directory id number */
#define	SCS_RREASON	0x00000010	/*  connection rejection reason */

#define EL_CILPKTSUBTRACT  EL_MISCSIZE + sizeof(struct ci_common)+ \
			sizeof(struct ci_lcommon) + sizeof(struct ci_packet)
#define EL_PNCSIZE	sizeof(struct el_pnc)
#define EL_MEMSIZE	sizeof(struct el_mem)

#define EL_REGMASK	0x012f3f19


struct el_mem {				/* mem. crd/rds packet */
	short elmem_cnt;		/* num. of mem. err structures */
	struct el_memerr {
		short cntl;		/* cntl. number 1-? */
		u_char type;		/*type err 1-crd,2-rds,3-cntl,4-wmask*/
		u_char numerr;		/* num. of errors on this address */
		int regs[6];		/* mem. regs */
	} elmemerr;			/* mem. err structure */
};

struct el_devhdr {			/* device header packet */
	dev_t devhdr_dev;		/* dev. major/minor numbers */
	int devhdr_flags;		/* buffer flags */
	int devhdr_bcount;		/* byte count of transfer */
	daddr_t devhdr_blkno;		/* logical block number */
	short devhdr_retrycnt;		/* retry count */
	short devhdr_herrcnt;		/* hard err count total */
	short devhdr_serrcnt;		/* soft err count total */
	short devhdr_csr;		/* device csr */
};

struct el_bdev {                        /* block device packet disk/tape */
        struct el_devhdr eldevhdr;      /* device header packet */
        union {
                u_int devreg[22];       /* device regs. non mscp drivers */
                struct el_mslg {
                    int mslg_len;      /* mscp packet length */
                    MSLG mscp_mslg;     /* mscp/tmscp datagram packet */
                } elmslg;
        } eldevdata;
};


struct el_esrpmax {                     /* PMAX Error & Status Registers */
        u_int esr_cause;               /* Cause Reg */
        u_int esr_epc;                 /* Exception PC (resume PC) */
        u_int esr_status;              /* Status Reg */
        u_int esr_badva;               /* Bad Virtual Address Reg */
        u_int esr_sp;                  /* Stack Ptr */
};

struct el_esr5100 {                     /* MIPSMATE Error & Status Registers */
        u_int esr_cause;               /* Cause Reg */
        u_int esr_epc;                 /* Exception PC (resume PC) */
        u_int esr_status;              /* Status Reg */
        u_int esr_badva;               /* Bad Virtual Address Reg */
        u_int esr_sp;                  /* Stack Ptr */
	u_int esr_icsr;                /* Interrupt CSR */
	u_int esr_leds;                /* LED register */
	u_int esr_wear;                /* Write Error Add. register */
	u_int esr_oid;                 /* Option ID register */
};

struct el_esrkn02 {                     /* 3MAX Error & Status Registers */
        u_int esr_cause;		/* Cause Reg */
        u_int esr_epc;			/* Exception PC (resume PC) */
        u_int esr_status;		/* Status Reg */
        u_int esr_badva;		/* Bad Virtual Address Reg */
        u_int esr_sp;			/* Stack Ptr */
        u_int esr_csr;			/* system csr */
        u_int esr_erradr;		/* Error Address reg */
};

struct el_esrkn02ba {                     /* 3MAX Error & Status Registers */
        u_int esr_cause;		/* Cause Reg */
        u_int esr_epc;			/* Exception PC (resume PC) */
        u_int esr_status;		/* Status Reg */
        u_int esr_badva;		/* Bad Virtual Address Reg */
        u_int esr_sp;			/* Stack Ptr */
        u_int esr_ssr;                 /* system support reg */
	u_int esr_sir;             	/* system interrupt reg */	
	u_int esr_sirm;             	/* system interrupt mask */
};

struct el_esrkn02ca {                   /* MAXine Error & Status Registers */
        u_int esr_cause;               /* Cause Reg */
	u_int esr_epc;                 /* Exception PC (resume PC) */
	u_int esr_status;              /* Status Reg */
	u_int esr_badva;               /* Bad Virtual Address Reg */
	u_int esr_sp;                  /* Stack Ptr */
	u_int esr_ssr;                 /* system support reg */
	u_int esr_sir;                 /* system interrupt reg */
	u_int esr_sirm;                /* system interrupt mask */
};

struct el_esrkn03 {                     /* 3MAX+ Error & Status Registers */
       u_int esr_cause;               /* Cause Reg */
       u_int esr_epc;                 /* Exception PC (resume PC) */
       u_int esr_status;              /* Status Reg */
       u_int esr_badva;               /* Bad Virtual Address Reg */
       u_int esr_sp;                  /* Stack Ptr */
       u_int esr_ssr;                 /* system support reg */
       u_int esr_sir;                 /* system interrupt reg */
       u_int esr_sirm;                /* system interrupt mask */
       u_int esr_cs;                  /* Memory Control Status reg */
	u_int esr_erradr;              /* Error Address reg */
};

struct el_esr5400 {                     /* MIPsfair Error&Status Regs */
	u_int esr_cause;               /* Cause Reg */
	u_int esr_epc;                 /* Exception PC (resume PC) */
	u_int esr_status;              /* Status Reg */
	u_int esr_badva;               /* Bad Virtual Address Reg */
	u_int esr_sp;                  /* Stack Ptr */
	u_int esr_wear;                /* Write Error Address Reg */
	u_int esr_dser;                /* DMA System Error Reg */
	u_int esr_qbear;               /* QBus Error Address Reg */
	u_int esr_dear;                /* DMA Error Address Reg */
	u_int esr_cbtcr;               /* CDAL Bus Timeout Control Reg */
	u_int esr_isr;                 /* Interrupt Status Reg */
};

struct el_esr5500 {                     /* MIPsfair Error&Status Regs */
        u_int esr_cause;               /* Cause Reg */
        u_int esr_epc;                 /* Exception PC (resume PC) */
        u_int esr_status;              /* Status Reg */
        u_int esr_badva;               /* Bad Virtual Address Reg */
        u_int esr_sp;                  /* Stack Ptr */
	u_int esr_dser;		/* DMA System Error Reg */
	u_int esr_qbear;		/* QBus Error Address Reg */
	u_int esr_dear;		/* DMA Error Address Reg */
	u_int esr_cbtcr;		/* CDAL Bus Timeout Control Reg */
	u_int esr_isr;			/* Interrupt Status Reg	*/
	u_int esr_mser;		/* ECC Memory Error Syndrome Reg */
	u_int esr_mear;		/* ECC Memory Error Address Reg */
	u_int esr_ipcr;			/* Inter Process Communication Reg.*/
};

struct el_esr {				/* Generic error & status regs	*/
	union {
                struct el_esrpmax el_esrkn01;      /* PMAX (DS2100/3100) */
		struct el_esrkn02 el_esrkn02;	   /* 3MAX (DS5000) */
		struct el_esrkn02ba el_esrkn02ba;  /* 3MIN (DS5000_100) */
		struct el_esrkn02ca el_esrkn02ca;  /* MAXine (DSMAXINE)  */
		struct el_esrkn03 el_esrkn03;      /* 3MAX+ (DS5000_300)   */
		struct el_esr5100 el_esr5100;      /* MIPSmate (DS5100) */
		struct el_esr5400 el_esr5400;	   /* Mipsfair (DS5400)	*/
		struct el_esr5500 el_esr5500;	   /* Mipsfair (DS5500)	*/
	} elesr;
};



struct el_uq {				/* uq device attention information */
	u_int	sa_contents;		/* sa register contents		   */
};

 
struct elci_dattn {			/* ci device attention information */
        struct ci_regs {                /* ci port registers */
		u_int ci_cnfr;			/* configuration register */
		u_int ci_pmcsr;		/* port maint ctrl & status */
		u_int ci_psr;			/* port status */
		u_int ci_pfaddr;		/* port failing address */
		u_int ci_pesr;			/* port error */
		u_int ci_ppr;			/* port parameter */
	} ciregs;
	union ci_icregs {		/* optional interconnect regs */
		struct bi_regs cibiregs;        /* biic device registers */
		struct cixmi_regs {		/* xmi device registers */
			u_int	xdev;			/* device type reg */
			u_int	xbe;			/* bus error reg */
			u_int	xfadrl;			/* failg addr reg low*/
			u_int	xfadrh;			/* failg addr reg hi */
			u_int	pidr;			/* port int dst reg */
			u_int	pvr;			/* port vector reg */
			u_int asnr;            /* adapter serial number reg */
			u_int pdcsr;           /* port diag. cntrl status reg*/
			u_int abbr;            /* adapter base block reg */
		} cixmiregs;
		struct citca_regs {     /* tc device registers */
			u_int tcdev;           /* device type register */
			u_int tcber;           /* turbochannel bus err reg */
			u_int asnr;            /* adapter serial number reg */
			u_int pdcsr;           /* port diag. cntrl status reg*/
			u_int abbr;            /* adapter base block reg */
		} citcaregs;
	} ciicregs;
	union ci_dattnopt {		/* optional device attention info */
		struct ci_ucode {		/* faulty ucode information */
			u_int ci_addr;			/* faulty ucode addr */
			u_int ci_bvalue;		/* bad ucode value */
			u_int ci_gvalue;		/* good ucode value */
		} ciucode;
		struct ci_revlev {		/* port microcode information*/
			u_int ci_romlev;		/* PROM/self-test lev*/
			u_int ci_ramlev;		/* RAM/fn ucode level*/
		} cirevlev;
		struct ci_cpurevlev {		/* out-of-rev CPU ucode */
			u_int ci_hwtype;		/* CPU hardware type */
			u_int ci_mincpurev;		/* min CPU rev lev */
			u_int ci_currevlev;		/* cur CPU rev lev */
		} cicpurevlev;
		struct ci_npparms {             /* N_PORT parmeters       */
		       struct ci_npapb {       /* adapter parmeter block */
			       u_int data[8];
		       } cinpapb;
		       struct ci_npcpb {       /* channel parmeter block */
			       u_int data[8];
		       } cinpcpb;
		} cinpparms;
	} cidattnopt;
};

struct elci_lpkt {			/* ci logged packet information */
        struct ci_lcommon {             /* common logged packet information */
		u_char ci_rsaddr[ 6 ];		/* remote station address */
		u_char ci_rsysid[ 6 ];		/* remote system id number */
		u_char ci_rname[ 8 ];		/* remote system node name */
	} cilcommon;
	union ci_lpktopt {		/* optional logged packet info */
		struct ci_packet {		/* logged packet information */
			u_short size;			/* size of pkt logged */
			u_char ci_port;			/* destination port */
			u_char ci_status;		/* status */
			u_char ci_opcode;		/* cmd operation code*/
			u_char ci_flags;		/* port command flags*/
		} cipacket;
		struct ci_nppacket {            /* logged packet information */
			u_short size;           /* size of pkt logged */
			u_char ci_opc;          /* adapter opcode  */
						/* full pkt logged not shown */
		} cinppacket;
	} cilpktopt;
};



struct elci_rdcnt {
	union ci_rdcntopt {
		struct citca_rdcnt {
		       u_int   data[36];
		} citcardcnt;
		struct cixcd_rdcnt {
			u_int   data[40];
		} cixcdrdcnt;
	} cirdcntopt;
};



struct el_ci {				/* ci event packet */
        struct ci_common {		/* common to all ci packets */
		u_int	ci_optfmask1;		/* opt err pkt field bit mask*/
		u_int	ci_optfmask2;		/* opt err pkt field bit mask*/
		u_int	ci_evpktver;		/* version of ci event packet*/
		u_char  ci_lpname[ 4 ];		/* local port name */
		u_char  ci_lname[ 8 ];		/* local system name */
		u_char  ci_lsysid[ 6 ];		/* local system id number */
		u_char  ci_lsaddr[ 6 ];		/* local station address */
		u_short ci_nerrs;		/* number of errors */
		u_short ci_nreinits;		/* number of port reinits */
	} cicommon;
	union ci_types {		/* packet/attention specific info */
		struct elci_dattn cidattn;	/* device attention info */
		struct elci_lpkt cilpkt;	/* logged packet info */
		struct elci_rdcnt cirdcnt;      /* logged read count info */
	} citypes;
};


struct elmsi_dattn {			/* msi device attention information */
        struct msi_regs {               /* msi port registers */
		u_short msi_csr;		/* control/status */
		u_short msi_idr;		/* id */
		u_short	msi_slcs;		/* selector control/status */
		u_short	msi_destat;		/* selection detector status */
		u_short msi_tr;			/* timeout */
		u_short	msi_dmctlr;		/* dma control */
		u_short	msi_dmlotc;		/* dma length to transfer */
		u_short	msi_dmaaddrl;		/* dma address, low */
		u_short	msi_dmaaddrh;		/* dma address, high */
		u_short	msi_stlp;		/* short target list pointer */
		u_short msi_tlp;		/* target list pointer */
		u_short msi_ilp;		/* initiator list pointer */
		u_short msi_dscr;		/* dssi control */
		u_short msi_dssr;		/* dssi status */
		u_short	msi_dstat;		/* data transfer status */
		u_short msi_dcr;		/* diagnostic control */
		u_short	msi_save_dssr;		/* saved dssi status */
		u_short	msi_save_dstat;		/* saved data transfer status*/
	} msiregs;
};

struct elmsi_lpkt {			/* msi logged packet information */
        struct msi_lcommon {		/* common logged packet information */
		u_char msi_rsaddr[ 6 ];		/* remote station address */
		u_char msi_rsysid[ 6 ];		/* remote system id number */
		u_char msi_rname[ 8 ];		/* remote system node name */
	} msilcommon;
	struct msi_cmdblk {		/* logged packet command block info */
		u_short	msi_thread;		/* addr next command block */
		u_short	msi_status;		/* command block Status */
		u_short	msi_command;		/* command word */
		u_short	msi_opcode;		/* command operation code */
		u_char	msi_dst;		/* destination station addr */
		u_char	msi_src;		/* source port station addr */
		u_short	msi_length;		/* frame length */
	} msilcmdblk;
	struct msi_packet {		/* logged packet information */
		u_char msi_opcode;		/* operation code( pkt type )*/
		u_char msi_flags;		/* operation code modifiers */
	} msipacket;
};

struct el_msi {				/* msi event packet */
        struct msi_common {		/* common to all msi packets */
		u_int	msi_optfmask1;		/* opt err pkt field bit mask*/
		u_int	msi_optfmask2;		/* opt err pkt field bit mask*/
		u_int	msi_evpktver;		/* version - msi event packet*/
		u_char  msi_lpname[ 4 ];	/* local port name */
		u_char  msi_lname[ 8 ];		/* local system name */
		u_char  msi_lsysid[ 6 ];	/* local system id number */
		u_char  msi_lsaddr[ 6 ];	/* local station address */
		u_short msi_nerrs;		/* number of errors */
		u_short msi_nreinits;		/* number of port reinits */
	} msicommon;
	union msi_types {		/* packet/attention specific info */
		struct elmsi_dattn msidattn;	/* device attention info */
		struct elmsi_lpkt msilpkt;	/* logged packet info */
	} msitypes;
};

struct elcippd_system {			/* ci ppd system specific information*/
	struct cippd_scommon {		/* common system specific information*/
		u_char	cippd_rswtype[ 4 ];	/* remote software type */
		u_char	cippd_rswver[ 4 ];	/* remote software version */
		u_char	cippd_rswincrn[ 8 ];	/* remote sw incarnation num */
		u_char	cippd_rhwtype[ 4 ];	/* remote hardware type */
		u_char	cippd_rhwver[ 12 ];	/* remote hardware version */
	} cippdscommon;
	union cippd_systemopt {		/* optional system specific info */
		struct cippd_protocol {		/* ci ppd protocol info */
			u_char	cippd_local;		/* local version */
			u_char	cippd_remote;		/* remote version */
		} cippdprotocol;
		struct cippd_spacket {		/* logged packet */
			u_short cippd_mtype;		/* ci ppd msg type */
		} cippdspacket;
	} cippdsystemopt;
};

struct elcippd_path {			/* ci ppd path specific information */
	struct cippd_pcommon {		/* common path specific information */
		u_char cippd_lpname[ 4 ];	/* local port name */
		u_char cippd_lsaddr[ 6 ];	/* local station address */
		u_char cippd_rsaddr[ 6 ];       /* remote station address */
		u_int cippd_pstate;		/* software path state */
	} cippdpcommon;
	union cippd_pathopt {		/* optional path specific information*/
		struct cippd_dbcoll {		/* database collision info */
			u_char cippd_rswincrn[ 8 ];	/* rem sw incrn num */
			u_char cippd_kswincrn[ 8 ];	/* known sw incrn num*/
			u_char cippd_kname[ 8 ];   	/* known system name */
			u_char cippd_ksysid[ 6 ];  	/* known system id # */
			u_char cippd_klsaddr[ 6 ];	/* known lstat'n addr*/
			u_char cippd_krsaddr[ 6 ]; 	/* known rstat'n addr*/
		} cippddbcoll;
		char	cippd_sysap[ 16 ];	/* name SYSAP crashing path */
		struct cippd_newpath {		/* new path information */
			u_short cippd_max_dg;		/* max appl dg size */
			u_short cippd_max_msg;		/* max appl msg size */
			u_char  cippd_swtype[ 4 ];	/* software type */
			u_char  cippd_swver[ 4 ];	/* software version */
			u_char  cippd_swincrn[ 8 ];	/* software incrn num*/
			u_char  cippd_hwtype[ 4 ];	/* hardware type */
			u_char  cippd_hwver[ 12 ];	/* hardware version */
		} cippdnewpath;
		struct cippd_ppacket {		/* logged packet */
			u_short cippd_mtype;		/* ci ppd msg type */
		} cippdppacket;
	} cippdpathopt;
};

struct el_cippd {			/* ci ppd event packet */
	struct cippd_common {		/* common to all packets */
		u_int cippd_optfmask1;		/* opt err pkt field bit mask*/
		u_int cippd_optfmask2;		/* opt err pkt field bit mask*/
		u_int cippd_evpktver;		/* version of cippd event pkt*/
		u_char cippd_lname[ 8 ];	/* local system node name */
		u_char cippd_rname[ 8 ];	/* remote system node name */
		u_char cippd_lsysid[ 6 ];	/* local system id number */
		u_char cippd_rsysid[ 6 ];	/* remote system id number */
		u_short cippd_npaths;		/* num total paths to rem sys*/
		u_short cippd_nerrs;		/* number of errors */
	} cippdcommon;
	union cippd_types {		/* system/path specific information */
		struct elcippd_system cippdsystem; /* system specific info */
		struct elcippd_path cippdpath;	/* path specific info */
	} cippdtypes;
};

struct el_scs {				/* scs event packet */
	struct scs_common {		/* common to all packets */
		u_int  scs_optfmask1;		/* opt err pkt field bit mask*/
		u_int  scs_optfmask2;		/* opt err pkt field bit mask*/
		u_int  scs_evpktver;		/* version of scs event pkt*/
		u_char  scs_lsysap[ 16 ];	/* local sysap name */
		u_char  scs_lconndata[ 16 ];	/* local connection data */
		u_int  scs_lconnid;		/* local connection id number*/
		u_char  scs_lname[ 8 ];		/* local system node name */
		u_char  scs_lsysid[ 6 ];	/* local system id number */
		u_short	scs_cstate;		/* connection state */
	} scscommon;
	union scs_opt {			/* optional scs event information */
		struct scs_conn {		/* scs connection information*/
			u_char  scs_rsysap[ 16 ];	/* remote sysap name */
			u_char  scs_rconndata[ 16 ];	/* remote conn data */
			u_int	scs_rconnid;		/* remote conn id num*/
			u_char  scs_rname[ 8 ];		/* rem sys node name */
			u_char  scs_rsysid[ 6 ];	/* rem system id num */
			u_char  scs_rsaddr[ 6 ];	/* rem station addr */
			u_char  scs_lpname[ 4 ];	/* local port name */
			u_char  scs_lsaddr[ 6 ];	/* local station addr*/
			u_short scs_nconns;		/* num conns on path */
		} scsconn;
		u_short	scs_ldirid;		/* local directory id number */
		u_int	scs_rreason;		/* connection reject reason */
	} scsopt;
};

struct el_strayintr {                   /* stray intr. packet */
	u_char stray_ipl;               /* ipl level */
	short stray_vec;                /* vector */
};



struct el_stkdmp {
        int addr;
	int size;
	int stack[EL_SIZE128];		/* stack dump of kernel/interpt/user */
};

struct el_pnc {				/* panic packet (bug check) */
	char pnc_asc[EL_SIZE64];	/* ascii panic string */
	int pnc_sp;
	int pnc_ap;
	int pnc_fp;
	int pnc_pc;
	struct pncregs {
	    int pnc_ksp;
	    int pnc_usp;
	    int pnc_isp;
	    int pnc_p0br;
	    int pnc_p0lr;
	    int pnc_p1br;
	    int pnc_p1lr;
	    int pnc_sbr;
	    int pnc_slr;
	    int pnc_pcbb;
	    int pnc_scbb;
	    int pnc_ipl;
	    int pnc_astlvl;
	    int pnc_sisr;
	    int pnc_iccs;
	} pncregs;
	struct el_stkdmp kernstk;		/* dump of kernel stack */
	struct el_stkdmp intstk;		/* dump of interrupt stack */
};


struct el_timchg {
	struct timeval timchg_time;	/* time in sec and usec */
	struct timezone timchg_tz;	/* time zone data */
	char timchg_version[EL_SIZE16];	/* ultrix vx.x */
};


/*
 *  VMEbus adapter registers error packet for 3max and Mipsfair2 
 *
 *                     The MVIB is the VME card containing
 *		       the registers for the 3VIA and MVIA,
 *                     which are the host-side cards for the
 *                     VME option on 3max and mipsfair2.
 */

struct el_vba_MVIB {
        int     mvib_viacsr;   /* xVIA control/status register */
        int     mvib_csr;      /* control/status register */
	int     mvib_vfadr;    /* vme failing address register */
	int     mvib_cfadr;    /* cpu failing address register */
	int     mvib_ivs;      /* interrupt vector source */
 	int 	 mvib_besr;	/* VIC bus err summary register */
	int	 mvib_errgi;    /* VIC err group inter. control reg */
	int     mvib_lvb;	/* VIC local vector base reg */
	int     mvib_err;   	/* VIC error vector register */
};



/*
 * XMI-based VMEbus adapter registers error packet (CMAX).
 *
 *           Registers found on both boards, the XBIA on
 *           the host-side, and the XVIB on the VME-side.
 */

struct el_vba_XBIA {            /* 2 board set -- xvib and xbia */

	int     xvib_vdcr;     /* device/configuration register */
	int     xvib_vesr;     /* error summary register */
	int     xvib_vfadr;    /* vme failing address register */
	int     xvib_vicr;     /* interrupt configuration register */
	int     xvib_vvor;     /* vector offset register */
	int     xvib_vevr;     /* error vector register */

	int     xbia_dtype;    /* device type/revision register */
	int     xbia_xbe;      /* XMI bus error register */
	int     xbia_fadr;     /* XMI failing address register */
	int     xbia_arear;    /* xbia responder error address register */
	int     xbia_aesr;     /* xbia error summary register */
	int     xbia_aimr;     /* xbia interrupt mask register */
	int     xbia_aivintr;  /* xbia implied vector inter. dest. register */
	int     xbia_adg1;     /* xbia diag 1 register */

};



/*
 *  VMEbus adapter registers error packet for DAA TC300/VME
 *
 *                     Registers found on both boards.
 */

struct el_vba_TC300 {
	int     tc3_tc_csr;    /* TC300 tc control/status register */
	int     tc3_vme_csr0;  /* TC300 vme control/status register 0 */
	int     tc3_vme_csr1;  /* TC300 vme control/status register 1 */
	   /* csr2 is write-only.  TC300 vme control/status register 2 */
	int     tc3_vme_csr3;  /* TC300 vme control/status register 3 */
};



/* VMEbus adapter error packet */
struct el_vba {
        union {                                  /* depends on adapter type */
		struct el_vba_MVIB elmvib;       /* 3max, mipsfair-2 */
		struct el_vba_XBIA elxbia;       /* cmax (xmi) */
		struct el_vba_TC300 eltc300;     /* DAA TC300/VME (TC-VME) */
	} elvba_reg;
};

/* VMEbus general purpose error packet for VME devices and controllers */
struct el_vme_dev_cntl {
        char module[EL_SIZE64];              /* name from uba structure */
        short num;			     /* num from uba structure */
	caddr_t csr1;                        /* csr1 address from uba struct*/
	caddr_t csr2;                        /* csr2 address from uba struct*/
        struct el_msg el_vme_error_msg;      /* error message from driver */
        struct el_vba elvba;                 /* adapter regs for more info */
};


/* XNA error packet (DEBNI, DEMNA) */
struct el_xna {
	union	xna_type {
		union	xna_xmi {
			struct xna_xmi_fatal {
				int	xna_type;
				int	xna_date_lo;
				int	xna_date_hi;
				int	xna_r0;
				int	xna_r1;
				int	xna_r2;
				int	xna_r3;
				int	xna_r4;
				int	xna_r5;
				int	xna_r6;
				int	xna_r7;
				int	xna_r8;
				int	xna_r9;
				int	xna_r10;
				int	xna_r11;
				int	xna_r12;
				int	xna_xbe;
				int	xna_xfadr;
				int	xna_xfaer;
				int	xna_gacsr;
				int	xna_diag;
				int	xna_xpst_init;
				int	xna_xpd1_init;
				int	xna_xpd2_init;
				int	xna_xpst_final;
				int	xna_xpd1_final;
				int	xnastack[6];
			} xnaxmi_fatal;
			struct xna_xmi_nonfatal {
				int	xna_date_lo;
				int	xna_date_hi;
				int	xna_r0;
				int	xna_r1;
				int	xna_r2;
				int	xna_r3;
				int	xna_xbe;
				int	xna_xfadr;
				int	xna_xfaer;
				int	xna_gacsr;
			} xnaxmi_nonfatal;
		} xnaxmi;
		union	xna_bi {
			struct	xna_bi_fatal {
				int	xna_type;
				int	xna_date_lo;
				int	xna_date_hi;
				int	xna_r0;
				int	xna_r1;
				int	xna_r2;
				int	xna_r3;
				int	xna_r4;
				int	xna_r5;
				int	xna_r6;
				int	xna_r7;
				int	xna_r8;
				int	xna_r9;
				int	xna_r10;
				int	xna_r11;
				int	xna_r12;
				int	xna_ber;
				int	xna_pad1;
				int	xna_pad2;
				int	xna_bicsr;
				int	xna_bci3_csr;
				int	xna_xpst_init;
				int	xna_xpd1_init;
				int	xna_xpd2_init;
				int	xna_xpst_final;
				int	xna_xpd1_final;
				int	xnastack[6];
			} xnabi_fatal;
			struct	xna_bi_nonfatal {
				int	xna_date_lo;
				int	xna_date_hi;
				int	xna_r0;
				int	xna_r1;
				int	xna_r2;
				int	xna_r3;
				int	xna_ber;
			} xnabi_nonfatal;

		} xnabi;
	} xnatype;
};

struct el_fza {
	u_short	fza_id;			/* fza id or version */
	u_short reset_count;		/* reset counter */
	u_int	timestamp_hi;		/* time stamp hi */
	u_short timestamp_lo;		/* time stamp lo */
	u_short write_count;			
	u_short int_reason;		/* Internal failure reason */
	u_short ext_reason;		/* External failure reason */
	u_int  cmd_next_ptr;		/* Next cmd entry to service */
	u_int  cmd_next_cmd;		/* Next cmd descr, 1st entry */
	u_int  dma_next_rmc_ptr;
	u_int  dma_next_rmc_descr;
	u_int  dma_next_rmc_own;
	u_int  dma_next_host_ptr;
	u_int  dma_next_host_descr;
	u_int  unsol_next_ptr;
	u_int  unsol_next_descr;
	u_int  smt_next_put_ptr;
	u_int  smt_next_put_descr;
	u_int  smt_next_take_ptr;
	u_int  smt_next_take_descr;
	u_short pm_csr;			/* Packet mem CSR */
	u_short int_68k_present;	/* 68k interrupt ctrl reg */
	u_short int_68k_mask;		/* 68k interrupt ctrl mask reg */
	u_short pint_event;		/* Port interrupt reg */
	u_short port_ctrl_a;		/* Port control A */
	u_short port_ctrl_a_mask;	/* Port control A mask */
	u_short port_ctrl_b;		/* Port control B */
	u_short port_status;		/* Port status */
	u_short ram_rom_map;		/* Map register */
	u_short phy_csr;		/* Phy CSR */
	u_short dma_done;		/* DMA done */
	u_short dma_err;		/* DMA error */
	u_short dma_start_lo;		/* DMA start dma low addr */
	u_short dma_start_hi;		/* DMA start high addr */
	u_short rmc_cmd;		/* RMC command */
	u_short rmc_mode;		/* RMC mode */
	u_short rmc_rcv_page;		/* RMC rcv page */
	u_short rmc_rcv_params;		/* RMC rcv parameters */
	u_short rmc_xmt_page;		/* RMC xmt page */
	u_short rmc_xmt_params;		/* RMC xmt parameters */
	u_short rmc_interrupts;		/* RMC interrupts */
	u_short rmc_int_mask;		/* RMC interrupt mask */
	u_short rmc_chan_status;	/* RMC channel status */
	u_short mac_rcv_cntrl;		/* MAC */
	u_short mac_xmt_cntrl;
	u_short mac_int_mask_a;
	u_short mac_int_mask_b;
	u_short mac_rcv_status;
	u_short mac_xmt_status;
	u_short mac_mla_a;
	u_short mac_mla_b;
	u_short mac_mla_c;
	u_short mac_t_req;
	u_short mac_tvx_value;
	u_int  crc;			/* TEMPORARY, REMOVE ON NEW ERR LOG */
 } ;


struct el_fta {
	u_int  event_status;           /* status of event header */
	u_int  caller_id;             /* entity that wrote this information */
	u_int  timestamp_l;            /* bits 31:00 of time */
	u_int  timestamp_h;            /* bits 63:32 of time */
	u_int  write_count;            /* # of times err log's been written */
	struct diag {
	u_int  fru_imp_mask;           /* mask of failing units */
	u_int  test_id;                /* id # of test which wrote the log */
	u_int  reserved[6];            /* reserved bytes */
	}diag;
	u_int  fw[111];                /* firmware info */
};




struct el_rec {					/* errlog record packet */ 
	struct el_rhdr elrhdr;			/* record header */
	struct el_sub_id elsubid;		/* subsystem id packet */
	union {
		struct el_bdev elbdev;                  /* device errors     */
		struct el_ci elci;			/* ci events         */
		struct el_cippd elcippd;                /* ci ppd events     */
		struct el_esr elesr;			/* gernic err/stat  */
		struct el_mem elmem;                    /* memory crd errors */
		struct el_msg elmsg;                    /* ascii text msg    */
		struct el_msi elmsi;			/* msi events	     */
		struct el_pnc elpnc;                    /* panic frame       */
		struct el_strayintr elstrayintr;        /* stray interrupts  */
		struct el_scs elscs;               	/* scs events	     */
		struct el_stkdmp elstkdmp;              /* stack dump        */
		struct el_timchg eltimchg;		/* time change  &    */
							/* startup/shutdown  */
		struct el_uq eluq;                      /* uq port errors    */
		struct el_xna elxna;                    /* xna port errors   */
		struct el_vba   el_vba;                 /* VME adapter errs */
		struct el_vme_dev_cntl elvme_devcntl;   /* VME dev/crtl errs */
		struct el_fza	el_fza;			/* fza port errors */
		struct el_fta   el_fta;                 /* fta port errors */
	} el_body;
	char eltrailer[EL_TRAILERSIZE];			/* asc trailer code  */
};

#endif /* __ERRLOG__ */
