/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	thread.h,v $
 * Revision 1.1.3.3  92/02/05  17:22:31  Donald_Dutile
 * 	New offsets for thread's kstack; part of mips kstack changes.
 * 	[92/01/09  23:54:42  Donald_Dutile]
 * 
 * Revision 1.1.3.2  91/11/20  13:49:02  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:10:31  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:13:06  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: thread.h,v $ $Revision: 1.1.3.3 $ (DEC) $Date: 92/02/05 17:22:31 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 *	File:	mips/thread.h
 *
 *	This file defines machine specific, thread related structures,
 *	variables and macros.
 *
*/
#ifndef	_MIPS_THREAD_
#define	_MIPS_THREAD_

/*
 *	Unlike Vaxen et al. we don't really have special scratch
 *	registers that we can use, so we go the canonical way..
 */
#ifdef	ASSEMBLER
#else	/* ASSEMBLER */

#ifdef	KERNEL
#include <machine/pcb.h>
#include <mach/mips/vm_param.h>

/*
 * The following structure definition is intended to hold wired down
 * per-thread mips state.  The ordering of the structures within this
 * structure is VERY important since they are used in calculating where
 * each structure is located within the two pages allocated for the kernel
 * stack.  This scheme was done so that kernel stack overflow is 
 * detectable by trying to access unmapped guard page.

               VM_MIN_KERNEL_ADDRESS 
                      +-------------------------------+ ---\
                      |   struct uthread              |     \
                      +-------------------------------+      \
                      |   struct pcb                  |       \
                      +-------------------------------+ KERNEL_STACK_SIZE
                      |               |               |        /
                      |               |               |       /
                      |               |               |      /
                      |               V               |     /
                      |         Kernel Stack          |    /
 thread->kernel_stack +-------------------------------+ --/
                      |     Future Kstack expansion   |
                      +-------------------------------+
                      |       stack guard page        |
                      +-------------------------------+
               Start K2 space
 */



/* these are the offset of each of the structure elements from 
 * 	thread->kernel_stack
 */
#define UTHREAD_START_OFFSET	KERNEL_STACK_SIZE \
				- sizeof(struct uthread) 

#define	PCB_START_OFFSET	UTHREAD_START_OFFSET \
				- sizeof(struct pcb) 

#define KERNEL_STACK_START_OFFSET	PCB_START_OFFSET

/* 
 * This is the magic wired address to get at the pcb, and uthread;
 */
#define PCB_WIRED_ADDRESS  ((struct pcb *)\
					(VM_MIN_KERNEL_ADDRESS \
					 - sizeof(struct uthread) \
	 				 - sizeof(struct pcb)))

#define u (PCB_WIRED_ADDRESS)->u_address

#endif	/* KERNEL */
#endif	/* ASSEMBLER */
#endif	/* _MIPS_THREAD_ */
