/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	xvia_data.c,v $
 * Revision 1.1.2.3  92/05/20  15:38:09  Stuart_Hollander
 * 	added tc300 fields
 * 	[92/05/19  12:55:41  Stuart_Hollander]
 * 
 * Revision 1.1.2.2  92/02/14  13:30:24  Stuart_Hollander
 * 	Name changed from vba_data.c to xvia_data.c
 * 	to reflect that it is xvia specific only.
 * 	[92/02/10  22:18:39  Stuart_Hollander]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: xvia_data.c,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/20 15:38:09 $";
#endif
/* 
 * derived from vba_data.c	4.2.1.1	(ULTRIX)	4/2/91
 */

/* ------------------------------------------------------------------------
 * Modification History:
 *
 *   22-Jan-1991	Mark Parenti
 *	Add defines and initialization for DMA PMR mapping.
 *
 *   15-Dec-1989	Mark Parenti
 *	Original version
 *
 * ------------------------------------------------------------------------
 */

#include <sys/param.h>
#include <io/dec/vme/vba_xvia.h>

/* VME Bus Request Level for adapter master cycles	*/
#define	VME_BR_0	0x0
#define	VME_BR_1	0x1
#define	VME_BR_2	0x2
#define	VME_BR_3	0x3

/* VME Arbitration timer definitions	*/

#define	VME_ARBTO_4US	0x0	/* 4 microseconds	*/
#define	VME_ARBTO_16US	0x1	/* 16 microseconds	*/
#define	VME_ARBTO_32US	0x2	/* 32 microseconds	*/
#define	VME_ARBTO_64US	0x3	/* 64 microseconds	*/
#define	VME_ARBTO_128US	0x4	/* 128 microseconds	*/
#define	VME_ARBTO_256US	0x5	/* 256 microseconds	*/
#define	VME_ARBTO_512US	0x6	/* 512 microseconds	*/
#define	VME_ARBTO_DIS	0x7	/* timeouts disabled	*/

/* VMEbus Interrupt Priority Levels handled by adapter	*/
#define	VME_IPL_1	0x0001
#define	VME_IPL_2	0x0002
#define	VME_IPL_3	0x0004
#define	VME_IPL_4	0x0008
#define	VME_IPL_5	0x0010
#define	VME_IPL_6	0x0020
#define	VME_IPL_7	0x0040
#define	VME_ALL_IPL	(VME_IPL_1 | \
			 VME_IPL_2 | \
			 VME_IPL_3 | \
			 VME_IPL_4 | \
			 VME_IPL_5 | \
			 VME_IPL_6 | \
			 VME_IPL_7 )

/* VMEbus Arbitration Select */
#define	VME_ARB_RR	0x0	/* Round-Robin Arbitration	*/
#define	VME_ARB_PRI	0x1	/* Priority Arbitration		*/
#define	VME_ARB_PRS	0x2	/* Prioritized Round Robin	*/
#define	VME_ARB_SGL	0x3	/* Single Level Arbitration	*/


/* VMEbus System Controller Select */
#define	VME_SYS_CONTROLLER	0x80000000 /* Adapter is VMEbus controller */
#define	VME_NOSYS_CONTROLLER	0x0	/* Adapter is not VMEbus controller */

/* VMEbus Bus Release Modes */
#define	VME_ROR			0x00	/* Release-on-request	*/
#define	VME_RWD			0x40	/* Release-when-done	*/

/* This field selects where in VME address space the DMA Page Map Registers */
/* are mapped. If 2 adapters are used they must use different values */
/* for this field.  Note that if VME_MAP_HIGH is selected only A32 DMA */
/* is supported.							*/
#define	VME_MAP_LOW		0x00	/* DMA mapped to first 1GB 	*/ 
#define	VME_MAP_HIGH		0x01	/* DMA mapped to second 1GB	*/


/*************************************************************************/
/*									 */
/* The following structure is used to customize various VMEbus 		 */
/* parameters. The default values specified should provide proper        */
/* VMEbus operation for most applications.  Care should be taken before  */
/* any of these values are modified. Not all adapters support all	 */
/* fields. 								 */
/*************************************************************************/

struct	xviadata xviadata = {
	VME_BR_3,		/* Bus Request Level for master cycles	*/
	VME_ARBTO_256US,	/* Arbitration Timeout		      	*/
	VME_ARB_RR,		/* Arbitration Method			*/
	VME_ALL_IPL,		/* Interrupt levels processed		*/
	VME_SYS_CONTROLLER,	/* System Controller			*/
	VME_ROR,		/* Release Type				*/
	VME_MAP_LOW,		/* DMA mapped to first 1GB		*/
	0x00cf0000,		/* TC300, SS, 64kb register region base */
	0x01000000		/* TC300, TT, A32 DMA 16M addr region base */
};
