/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dpi.h,v $
 * Revision 1.1.2.3  92/01/17  21:30:07  Mark_Himelstein
 * 	sync up with palo alto rcs tree
 * 	[92/01/02  20:56:26  Mark_Himelstein]
 * 
 * Revision 1.6  91/12/30  18:19:55  himel
 * 	ode changes, bugfixes, kernel debugging, dpi debugging
 * 
 * Revision 1.1.2.2  91/12/06  21:50:54  Jim_McHale
 * 	"Integrate with ag.bl0"
 * 
 * Revision 1.1.1.3  91/12/01  21:01:09  Jim_McHale
 * 	Fix from merge of 3.0
 * 
 * Revision 1.1.1.2  91/11/29  13:07:06  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * $EndLog$
 */
/*   "@(#)$RCSfile: dpi.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/01/17 21:30:07 $";
*/
/*
 * $Header: /usr/sde/osf1/rcs/src/./usr/include/cmplrs/dpi.h,v 1.1.2.3 92/01/17 21:30:07 Mark_Himelstein Exp $
 */
/* 
 * @DIGITAL_COPYRIGHT@
 */

#ifndef DPI_H
#define DPI_H
/* this file contains externally visible declarations for the 
 *	debug process interface (dpi) library.
 */

/* KNOWN PREFIXES:
 *
 *	DPI_BLK_	block access size for layer
 *	DPI_D_		debug flags
 *	DPI_C_		constants
 *	DPI_L_		layers
 *	DPI_Q_		query strings
 *	DPI_S_		states
 *	DPI_V_		version
 *	DPI_		results
 */

#define DPI_V_VERSION	4	/* hopefully for full backward compat */

/* well know results */
#define DPI_FAIL	0
#define DPI_SUCCESS	1

/* block sizes allowed through the different layers 
 *	layer use masks of these to make known their
 *	abilities. Specific requests for reads and write use single
 *	values of these for hints where applicable.
 */

#define DPI_BLK_FAIL	DPI_FAIL/* illegal value */
#define DPI_BLK_CHAR	1	/* can read a byte block */
#define DPI_BLK_BYTE	1	/* can read a byte block */
#define DPI_BLK_SHORT	2	/* can read a short block */
#define DPI_BLK_LONG	4	/* can read a long block */
#define DPI_BLK_DOUBLE	8	/* can read a double block */
#define DPI_BLK_ANY	0x80000000	/* can read any size block */

/* test to see if bit is set in flag */
#define DPI_BLK_TEST(mask,block_size) ((mask&block_size) || (mask&DPI_BLK_ANY))

/* debug flags */
#define DPI_D_NONE		0
#define DPI_D_LAYER		1	/* debug the layer to whatever */
#define DPI_D_COMM		2	/* debug low level comm */
#define DPI_D_PROTO		4	/* debug high level protocol */
#define DPI_D_INIT		8	/* debugged something during this run */
#define DPI_D_DPI		0x10	/* debug dpi interface */

/* query constant, specific to layers but must be supported
 *	by clients which wish to use those dpi facilities
 *	when dpi calls the query routine (which is the argument for
 *	dpi_create) with one of these constants, it either expects back DPI_FAIL
 *	or some address or address-sized constant which is meaning to the
 *	layer. See the README for detailed comments for each constant
 *
 *
 *      define constant     	constant	layer		return
 *	_______________	    	________	---------	type
 *      			 		         	------
 */
#define DPI_Q_GUEST	    	0		/* DPI_L_GUEST	init_routine */
#define DPI_Q_CORE_NAME	    	1		/* DPI_L_CORE	dpi_string */
#define DPI_Q_PID	    	2		/* DPI_L_KERNEL	dpi_pid */
#define DPI_Q_IMAGE_FILE    	3		/* DPI_L_IMAGE	dpi_string */
#define DPI_Q_OBJ_READ		4		/* DPI_L_OBJ  dpi_unsigned_32 */
#define DPI_Q_PATCH		5		/* DPI_L_OBJ  dpi_unsigned_32 */
#define DPI_Q_AFTER_EXEC	6		/* _dpi_unix  routine(pid) */
#define DPI_Q_PROGRAM		7		/* SABLE/PROM	dpi_string */
#define DPI_Q_DBGMON_BOOTDEV	8		/* PROM		dpi_string */
#define DPI_Q_DBGMON_PATH	9		/* PROM		dpi_string */
#define DPI_Q_AUTO_LOAD		10		/* PROM		dpi_flag */
#define DPI_Q_DEBUG_TTY		11		/* PROM		dpi_string */
#define DPI_Q_PDBX_PORT		12		/* PROM		dpi_string */
#define DPI_Q_USE_SOCKETS	13		/* SABLE/PROM	dpi_flag */
#define DPI_Q_SERVICE		14		/* PROM		dpi_string */
#define DPI_Q_SYNC_REMOTE	15		/* PROM		dpi_flag */
#define DPI_Q_UNRESERVED	8096	/* from here, guest queries can ovrlp */

/* miscellanious constants */
#define DPI_C_NO_DPI	0	/* bogus dpi */

/* layers */
typedef enum dpi_layer {
	DPI_L_DEFAULT,		/* when used, we'll use preset value */
	DPI_L_PTRACE,		/* ptrace layer */
	DPI_L_SPROC,		/* /proc */
	DPI_L_CORE,		/* debug core file */
	DPI_L_IMAGE,		/* image out on disk, needs a another layer */
	DPI_L_KERNELCORE,	/* debug kernel core files */
	DPI_L_SABLE,		/* sable simulator startup */
	DPI_L_PROM,		/* dbgmon startup */
	DPI_L_GUEST,		/* guest layer, must supply init by query */
	DPI_L_PIXIE,		/* pixie profiler map layer */
	DPI_L_PIO,		/* partial io layer, size/align issues */
	DPI_L_OBJ,		/* go to object when you can */
	DPI_L_BREAK,		/* breakpoint manager */
	DPI_L_MCACHE,		/* Memory cache */
	DPI_L_RCACHE,		/* register cache */
	DPI_L_TLIB,		/* thread library */
	DPI_L_FILE,		/* file access on read */
	DPI_L_MACHINE,		/* machine specific layer */
	DPI_L_KERNEL,		/* vtop mappings, and registers from pcbs */
	DPI_L_CROSS,		/* cross byte sex debugging */
	DPI_L_DEBUG,		/* debug layer */
	DPI_L_UNSUPPORTED	/* bottom layer */
} dpi_layer;


/* states */
enum dpi_state {
	DPI_S_NOTHERE=DPI_FAIL,	/* not registered */
	DPI_S_INIT,		/* registered */
	DPI_S_STOPPED,		/* known to not be running */
	DPI_S_EXITED,		/* known to have exited */
	DPI_S_RUNNING		/* known to be running */
};

/* argument/return types */


/* base types */
typedef unsigned long	dpi_unsigned_32;
typedef signed char	dpi_signed_8;
typedef unsigned char	dpi_unsigned_8;
typedef int		dpi_signed_32;

typedef int		dpi_fd;		/* file descriptors */
typedef dpi_signed_8	*dpi_data;	/* data buffers */
typedef dpi_signed_8	*dpi_string;	/* string arguments */
typedef dpi_signed_32	dpi_signal;	/* signals to pend and clear */
typedef dpi_signed_32	dpi_size;	/* bytes in dpi_data */
typedef dpi_signed_32	dpi_pid;	/* process id */
typedef dpi_signed_32	dpi_tid;	/* thread id */
typedef dpi_signed_32	dpi_count;	/* count of tids */
typedef dpi_signed_32	*dpi_tid_list;	/* thread id list */
typedef dpi_unsigned_32	dpi_address;	/* client addresses */
typedef dpi_unsigned_32	dpi_register_no;/* register identifier (ptrace.h) */
typedef dpi_unsigned_32	dpi_flag;	/* binary or of various bits */
typedef dpi_unsigned_32 dpi_result;	/* a lot of routines return this */
typedef dpi_unsigned_32 dpi_query_constant;/* query callback arg */
typedef dpi_signed_32	dpi_int;	/* Misc integer */

typedef dpi_string		*dpi_str_vec;	/* vector of string arguments */
typedef enum dpi_state		dpi_state;	/* state of this process */
typedef struct dpi_info		*dpi_info;	/* general info for process */
typedef struct dpi		*dpi;		/* function vector */
typedef struct obj_list		*dpi_objlist;	/* libmld dpi */
typedef dpi_result		(*dpi_query)	/* callback for layer
						 * specific info
						 */
		(dpi_query_constant	query_constant,
		 dpi_data		data);

/* dpi and functions were not always the same, and could change again
 *	so I'll maintain both.
 */

/* add new dpi to the end */

struct dpi {

    dpi	_next;		/* links layers must be first */

    dpi	_prev;		/* links layers */

    dpi_layer		_layer;		/* layer tag */

    dpi_info		_info;		/* points to base structure */

    dpi_data		_data;		/* layer specific data */

    dpi_query		_query;		/* private callback */

    dpi_string		_string;	/* informational string for the layer */

    dpi_result	(*catch_signal)(	/* catch signal for process */
		    dpi			dpi,
		    dpi_signal		sig);

    dpi_result	(*deliver_signal)(	/* deliver current signal */
		    dpi			dpi,
		    dpi_signal		sig);

    dpi_state	(*destroy) (		/* destructor for layer */
		    dpi			dpi);

    dpi_flag	(*get_block_access)(	/* return layer supported block size */
		    dpi			dpi);

    dpi_int	(*get_exitval)(		/* return process exit value */
		    dpi			dpi);

    dpi_result	(*get_fd)(		/* return file desc assoc with proc */
		    dpi			dpi,
		    dpi_fd		*fd);

    dpi_signal	(*get_last_signal)(	/* return last signal recieved */
		    dpi			dpi);

    dpi_string	(*get_string)(		/* return string assoc with layer */
		    dpi			dpi);

    dpi_state	(*get_state)(		/* return process state */
		    dpi			dpi);

    dpi_pid	(*get_pid)(		/* return process id */
		    dpi			dpi);

    dpi_tid	(*get_tid)(		/* return last stopped thread id */
		    dpi			dpi);

    dpi_count	(*get_tid_count)(	/* how many threads in process */
		    dpi			dpi);

    dpi_result	(*get_tid_list)(	/* return list of tids */
		    dpi			dpi,
		    dpi_count		max_tids,	/* get_tid_count */
		    dpi_tid_list	tid_list);	/* size is max_tids */

    dpi_result	(*ignore_signal)(	/* ignore signal for process */
		    dpi			dpi,
		    dpi_signal		sig);

    dpi_result	(*read)(		/* read data from target */
		    dpi			dpi,
		    dpi_address		address,
		    dpi_data		dest,
		    dpi_size		size,
		    dpi_flag		block_access);

    dpi_state	(*set_pid)(		/* set process id */
		    dpi			dpi,
		    dpi_tid		tid);

    dpi_result	(*start)(		/* start target */
		    dpi			dpi,
		    dpi_str_vec		argv,
		    dpi_str_vec		envp,
		    dpi_str_vec		files,
		    dpi_count		nfiles);

    dpi_result	(*stop)(		/* stop process */
		    dpi			dpi);

    dpi_result	(*terminate)(		/* terminate process */
		    dpi			dpi);

    dpi_result	(*thread_catch_signal)(	/* catch signal for thread */
		    dpi			dpi,
		    dpi_count		thread_count,
		    dpi_tid_list	tid_list,
		    dpi_signal		sig);

    dpi_result	(*thread_cont)(		/* continue listed threads */
		    dpi			dpi,
		    dpi_count		thread_count,
		    dpi_tid_list	tid_list);

    dpi_result	(*thread_cont_all_but)(	/* continue all but listed threads */
		    dpi			dpi,
		    dpi_count		thread_count,
		    dpi_tid_list	tid_list);

    dpi_state	(*thread_get_state)(	/* get thread state */
		    dpi			dpi,
		    dpi_tid		tid);

    dpi_result	(*thread_ignore_signal)(/* ignore signal for thread */
		    dpi			dpi,
		    dpi_count		thread_count,
		    dpi_tid_list	tid_list,
		    dpi_signal		sig);

    dpi_result	(*thread_read_reg)(	/* read registers for thread */
		    dpi			dpi,
		    dpi_tid		tid,
		    dpi_register_no	reg,
		    dpi_data		value);

    dpi_result	(*thread_step)(		/* step a thread */
		    dpi			dpi,
		    dpi_tid		tid);

    dpi_result	(*thread_terminate)(	/* terminate a thread */
		    dpi			dpi,
		    dpi_count		count,
		    dpi_tid_list	list);

    dpi_result	(*thread_write_reg)(	/* write registers for thread */
		    dpi			dpi,
		    dpi_tid		tid,
		    dpi_register_no	reg,
		    dpi_data		data);

    dpi_result	(*write)(		/* write data to process */
		    dpi			dpi,
		    dpi_address		address,
		    dpi_data		src,
		    dpi_size		size,
		    dpi_flag		block_access);

    dpi_result	(*wait)(		/* wait for a thread to stop */
		    dpi			dpi);
};

/* externally visible routines */

extern dpi	
dpi_add_layer(				/* add a layer to process */
    dpi			dpi,
    dpi_layer		layer,
    dpi_query		query)
;
extern dpi	
dpi_change_main_layer(			/* change the interface for process */
    dpi			dpi,
    dpi_layer		layer,
    dpi_query		query)
;
extern dpi_result
dpi_init()				/* to be called at start of prog */
;

extern dpi
dpi_create(				/* create a process, return dpi */
    dpi_string		name,		/* object file name */
    dpi_layer		base_layer,	/* base layer */
    dpi_objlist		*objlist,	/* libmld objlist pointer */
    dpi_query		query)		/* query for base layer */
;
extern dpi
dpi_debug_set(				/* set debug flags to print stuff */
    dpi			dpi,
    dpi_flag		flag,
    dpi_flag		on_off)
;
#endif DPI_H
