

#ifndef _BINSEM_H
#define _BINSEM_H 1

#include  <sys/limits.h>
#include <sys/psx4_nspace.h>
  
typedef  int            binsemset_t;
#define  SEM_LOCKED     1
#define  SEM_UNLOCKED   0
/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	binsem.h,v $
 * Revision 1.1.2.2  92/03/27  16:49:33  Lai-Wah_Hui
 * 	"Add RT support"
 * 
 * Revision 1.1.1.2  92/03/27  11:00:30  Lai-Wah_Hui
 * 	Init. checkin
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: binsem.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/03/27 16:49:33 $
 */




/*
 * One binary seamphore data structure per binary semaphore.
 */

typedef struct p4sem{
  int	        semstate;	                             /* semaphore state                  */
  int   	semncnt;	                             /* # awaiting semaphore             */
}p4sem_t;

/*
 * One binary semaphore set data structure (p4semid_set) for each set of semaphores 
 * in the system.
 */

typedef struct p4semid_set{ 
     struct obj_header       p4obj_hd;                  
     char                    semname[SEM_NAME_MAX];         /* semaphore set name                  */
     p4sem_t                 sem[SEM_NSEMS_MAX];            /* binary semaphore array              */
}p4semid_set_t;



#ifndef _KERNEL

/*
 * POSIX 1003.4 Binary Semaphores functions
 */
#ifdef _NO_PROTO

int sem_mksem();
int sem_destroy();
int sem_getnsem();
int sem_open();
int sem_close();
int sem_wait();
int sem_ifwait();
int sem_post();
#else                         

/* 
 * routine definitions
 */

int sem_mksem(const char *name, size_t nsems, int flags);  
int sem_destroy(const char *name);
int sem_open(const char *name, binsemset_t *b);  
int sem_close(binsemset_t binsemset); 
int sem_getnsem(binsemset_t binsemset); 
int sem_wait(binsemset_t binsemdes, int binsemnum);
int sem_ifwait(binsemset_t binsemdes, int binsemnum);
int sem_post(binsemset_t binsemdes, int binsemnum);
#endif  /* _NO_PROTO_ */
#endif  /* _KERNEL */
#endif	/* _BINSEM_H */



