   /*********************************************************************
    *  IOCB_32.H - include file for 32-bit IOCB (& DSCB) API mechanics  *
    *********************************************************************
    *                                                                   *
    *  Copyright (c) 1994                                               * 
    *  by DIGITAL Equipment Corporation, Maynard, Mass.                 *
    *                                                                   *
    *  This software is furnished under a license and may be used and   *
    *  copied only in accordance with the terms of such license and     *
    *  with the inclusion of the above copyright notice.  This          *
    *  software or any other copies thereof may not be provided or      *
    *  otherwise made available to any other person. No title to and 	*
    *  ownership of the software is hereby transferred.                 *
    *                                                                   *
    *  The information in this software is subject to change without    *
    *  notice and should not be construed as a commitment by DIGITAL 	*
    *  Equipment Corporation.                                           *
    *                                                                   *
    *  DIGITAL assumes no responsibility for the use or reliability of  *
    *  its software on equipment which is not supplied by DIGITAL.      *
    *                                                                   *
    *********************************************************************/

/* This is the include file for issuing 32-bit IOCB and DSCB requests.
   These calls are located in PWIOCB32.DLL which the application
   dynamically links to either at load-time using PWIOCB32.LIB or at
   run-time.  */

#pragma pack(1)              /* structures are byte aligned */
#ifndef IOCB_32BITS
    #define IOCB_32BITS TRUE     /* use 32-bit format for IOCB */
#endif
#include "iocb.h"
#include "dscb.h"

// signature defines
#define DECnet_Check   0xDE00   // test for DECnet presence
#define DECnet_API     0xDE01   // issue IOCB call to DECnet
#define LAT_Check      0xDE20   // test for LAT presence
#define LAT_API        0xDE21   // issue IOCB call to LAT
#define DECnet_DSCB    0xDC04   // issue DSCB call to DECnet

// 32-bit IOCB Function Calls

        // Determine if a specific IOCB/DSCB provider is installed
DWORD WINAPI IocbInstallCheck (DWORD signature);

        // Issue an IOCB request with optional WIN32 Event completion signal.
DWORD WINAPI IocbSubmit (DWORD signature, NIOCB *iocb, LPOVERLAPPED ols);
                   // Note: ols can be NULL if no event used, a typical case
	
        /* Please realize the WIN32 interface can return DWORD zero but an
           IOCB io_errno code can still be present with io_status set to
           error.  The converse is also true.  The IOCB io_status can be
           success but the WIN32 DWORD return can be an error.  Always
           check the WIN32 DWORD first; if zero, then check io_status. */

        // Issue a DSCB request which returns quickly.
DWORD WINAPI DscbSubmit (DWORD signature, DSCB *dscb);

        /* Use IocbInstallCheck for DSCB commands as well as IOCB commands.
           Same caveat about return codes applies here too. */

/* All return codes are WIN32 defined.  The return code is zero for success.
   The error codes are defined in WINERROR.H  */
   
// Status codes for io_status:

#define IOCB_SUCCESS   0        
                    // operation completed successfully
#define IOCB_ERROR     -1  
                    // operation failed with error code in io_errno
#define IOCB_PENDING   -2   
                    // network request is still pending, not complete

// Status codes for io_errno:  See ERRNO.H and IOCB.H for error code defines
