/*
 * Program NMAPI, Module NM_ENT.H
 *
 * Copyright (C) 1992 by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * MODULE DESCRIPTION:
 *
 * Program NMAPI,  Module NM_ENT.H
 *
 *  PCSG Client Engineering
 *
 * IDENT HISTORY:
 *
 *  06-FEb-1992 CLB     Changes for PWV5.0 (OSI, TCP/IP support)
 *  18-Sep-1992 CLB     New NM_ENT.H (formerly NM_FUNC.H+NM_STRCT.H)
 *  28-Sep-1992 CLB     Merged NM_DEF.H with NM_ENT.H
 *  20-Oct-1992 CLB     Added function codes for X25
 *  25-OCt-1992 CLB     Changed NMCB and NMCB2 "val" to far pointer
 *                        henceforth all data passed to stack "by address"
 *                      Merged circuit characteristics
 *  26-OCt-1992	CLB	Added CSTRING, TCPADDR data types
 *  15-Dec-1992 CLB     Moved ACCMASK and IDMASK here
 *  23-jun-1993 CLB     Added NM_HI32 and NM_HI64
 *  14-dec-1993 CLB     NM_OSI = 2
 */

//  PATHWORKS V5.1
//  21-mar-1994 CLB     NM_IPX = 3
//  20-jun-1994 CLB     Add PPP values


#ifndef NM_ENT_H
#define NM_ENT_H

#include <nm_api.h>

#define PWENT_FNAME     "PWENT.DAT"

/*
 * Current version number of NMH data base. This value should appear in the
 * first word of the data base file (PWENT.DAT). If significant changes are
 * made to any of the entity data structures, it should be reflected in
 * this data base version number.  NCP asks DNP for this value at runtime.
 */
#define NMH_DBVERSION 10

/* Structure for returning attribute to user */
typedef struct nm_attribute
{
    unsigned short   flags;               /* NM_IFILE/NM_XPORT, read/write */
    unsigned short   protocol;
    unsigned short   entity;
    unsigned short   instance;
    unsigned short   id;
    unsigned char  datatype;
    unsigned short   len;                /* Length of value in bytes */
    unsigned char  val[MAX_ATTR_SIZE];
} NM_ATTR;

// Format record
typedef struct nm_form      
{
    unsigned short id;      
    unsigned char datatype;
    unsigned char len;
} NM_FORMAT;

// Context block used by NmGetFirstAttr() and NmGetNextAttr()
typedef struct nm_context
{
    unsigned short cnt;          
    NM_FORMAT FAR *fptr;         
    unsigned char FAR *dptr;     
} NM_CONT;

/* bitmasks for characteristic data types */
#define NMH_ACCMASK 0xF000      /* access mode mask */
#define NMH_IDMASK  0x0FFF	/* parameter ID mask */

/*  Access mode flags */
#define NM_RW  0x0000           /* Read-Write   */
#define NM_RO  0x1000           /* Read Only    */
#define NM_SO  0x2000           /* Set Only     */
#define NM_SC  0x3000           /* Special Case */
#define NM_BO  0x4000           /* Reboot Only  */

/* Database types */
#define NM_XPORT     0x0000     /* Transport stack */
#define NM_IFILE     0x0001     /* Local entity file - PWENT.DAT */

// Transport stack IDs 
#define NM_DECNET       0
#define NM_TCPIP        1
#define NM_OSI          2
#define NM_IPX          3
#define NM_NETWARE      3
//#define NM_LAT        4

#define MAX_STACKS  5

/* DECnet entity types */
#define NM_EXEC_CH      0
#define NM_EXEC_CO      1
#define NM_CIRC_CH      2
#define NM_CIRC_E_CO    3
#define NM_CIRC_D_CO    4
#define NM_CIRC_T_CO    5
#define NM_CIRC_X_CO    6
#define NM_LINE_D_CH    9    
#define NM_LINE_D_CO    10
#define NM_LINE_E_CH    11
#define NM_LINE_E_CO    12
#define NM_LINE_T_CH    13
#define NM_LINE_T_CO    14
#define NM_LINE_X_CH    15
#define NM_LINE_X_CO    16
#define NM_LINE_S_CH    17
#define NM_LINE_S_CO    18
#define NM_XPM_CH       19
#define NM_XPM_CO       20
#define NM_CIRC_X_CH    21
#define NM_CIRC_I_CH    22
#define NM_ISDN_CH      23
#define NM_MODEMC_CH    24
#define NM_LINE_P_CH    25
#define NM_PPP_CH       25
#define NM_LINE_P_CO    26
#define NM_PPP_CO       26

#define MAX_DNET_ENTS   27


/* TCP entity types */
#define NM_SYSTEM_CH	0
#define NM_TCP_CH	1
#define NM_IP_CH	2
#define NM_ICMP_CH	3
#define NM_UDP_CH	4
#define NM_INET_CH      5
#define NM_MIB_COUNT    6
#define NM_TCP_CO       7
#define NM_IP_CO        8
#define NM_ICMP_CO      9
#define NM_UPD_CO      10
/* Remaining char/counters same as DECnet  11-24 */

#define MAX_TCPIP_ENTS  25


/* IPX  entity types */
//#define NM_CIRC_I_CH    22    

#define MAX_IPX_ENTS  23


/* Data types */
#define NM_C1        0x00   /* 1 byte, char                 */
#define NM_DU1       0x01   /* 1 byte, unsigned decimal     */
#define NM_DU2       0x02   /* 2 bytes, unsigned decimal    */
#define NM_BITMAP8   0x03   /* 2 bytes, counter/bitmap      */
#define NM_DU4       0x04   /* 4 bytes, unsigned decimal    */
#define NM_AI6       0x05   /* 7 bytes, counted ascii       */
#define NM_AI16      0x06   /* 17 bytes, counted ascii      */
#define NM_AI32      0x07   /* 33 bytes, counted ascii      */
#define NM_VERSION   0x08   /* 3 bytes, version             */
#define NM_NODET     0x09   /* 9 bytes, node addr/name      */
#define NM_OWNUSER   0x0A   /* 27 bytes, circuit user/owner */
#define NM_NA        0x0B   /* 2 bytes, node address        */
#define NM_BITMAP16  0x0C   /* 4 bytes, counter/bitmap      */
#define NM_AI64      0x0D   /* 65 bytes, counted ascii      */
#define NM_HI6       0x0E   /* 7 bytes, counted ascii hex   */
#define NM_AI8       0x0F   /* 9 bytes, counted ascii       */
#define NM_TCPADDR   0x10   /* 4 bytes, TCP/IP address */
#define NM_OSIADDR   0x11   /* 20 bytes, OSI address */
#define NM_CSTRING   0x12   /* 3 bytes (minimum), counted string */
#define NM_DU16	     0x13   /* 16 byte hex value */
#define NM_DU32      0x14   /* 32 byte hex value */
#define NM_AI4       0x15   /* 5 bytes, counted string */
#define NM_AI18      0x16   /* 19 bytes, counted string */
#define NM_AI20      0x17   /* 21 bytes, counted string */
#define NM_HI32      0x18   /* 33 bytes, counted hex string */
#define NM_HI64      0x19   /* 65 bytes, counted hex string */
#define NM_HU4       0x20   /* 4 bytes, hex value */

typedef struct bitmap8	    /* bitmapped 8 bit counter */
{
    unsigned char   bvalue;
    unsigned char   bmap8;
} BITMAP8;

typedef struct bitmap16	    /* bitmapped 16 bit counter */
{
    unsigned short    bval;
    unsigned short    bmap16;
} BITMAP16;

typedef unsigned char DU16[16];     /* String of 16 bytes */
typedef unsigned char DU32[32];     /* String of 32 bytes */

typedef unsigned char AI4[5];	    /* 4 char ascii string	*/
typedef unsigned char AI6[7];	    /* 6 char ascii string	*/
typedef unsigned char AI8[9];       /* 8 char ascii string  */
typedef unsigned char AI16[17];     /* 16 char ascii string */
typedef unsigned char AI18[19];     /* 18 char ascii string */
typedef unsigned char AI20[21];     /* 20 char ascii string */
typedef unsigned char AI32[33];     /* 32 char ascii string */
typedef unsigned char AI64[65];     /* 64 char ascii string */

typedef unsigned char HI6[7];       /* 6 char hex string    */
typedef unsigned char HI32[33];     /* 32 char hex string    */
typedef unsigned char HI64[65];     /* 64 char hex string    */

typedef struct version
{
    unsigned char ver;
    unsigned char eco;
    unsigned char usereco;
} VERSION;

typedef struct ownuser	    /* OWNER or USER of CIRCUIT	*/
{
    unsigned char   cuser_entity;
    AI16            cuser_ename;
    unsigned short    cuser_addr;
    AI16            cuser_name;
} OWNUSER;

typedef unsigned char TCPADDR[4];
typedef unsigned char OSIADDR[20];

typedef struct nodet
{
    unsigned short  node_addr;	    /* Node Address		       */
    AI6             node_name;	    /* Node Name		       */
} NODET;

#endif   /* NM_ENT.H */
