/*
 * Library NMAPI, Module NM_API.H
 *
 * Copyright (C) 1992 All Rights Reserved, by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * IDENT HISTORY:
 *
 *  19-Aug-1992 CLB     Create templates for local management files.
 *  25-OCt-1992 CLB     Removed reference to PWLOAD.DAT
 *  28-Oct-1992 CLB     Removed Node file info to NM_NODE.H
 *  15-Dec-1992 CLB     Changed pw_inacc_rec.type to unsigned char
 *                      Updated size of pw_inacc_rec.home_dir (+1)
 *  23-Jan-1993 CLB     Removed software id, moved events to NM_EVENT.H
 *                      Added APIENTRY
 *  13-apr-1993 CLB     int->short
 *  16-apr-1993 CLB     far->FAR, pascal->PASCAL
 *  12-jul-1993 CLB     Added PROT386
 *  15-feb-1995 CLB     Merge 16-bit and 32-bit headers
 *  07-apr-1995 CLB     Add FHANDLE for 16-bits
 */

#ifndef NM_API_H
#define NM_API_H

#ifndef	__HIGHC__
#pragma pack(1)			
#endif

#include <skdefs.h>
#include <sktypes.h>
#include <skproto.h>

#define SUCCESS  0
#ifndef PW_ERROR
    #define PW_ERROR -1
#endif
#ifndef FILE_ERROR
    #define FILE_ERROR  (int)-1 
#endif

// 16-bit only definitions
#ifndef WIN32
    #ifndef ERROR
        #define ERROR -1
    #endif
    #ifdef NMAPIDLL
        #undef  APIENTRY
        #define APIENTRY    short FAR PASCAL _loadds
        #undef  PW_APIENTRY
        #define PW_APIENTRY       FAR PASCAL _loadds
    #else
        #define APIENTRY        short FAR PASCAL
        #define PW_APIENTRY     FAR PASCAL
    #endif
    #ifndef FHANDLE
        #ifdef WINDOWS
            #define FHANDLE int 
        #else
            #define FHANDLE short
        #endif
    #endif            
#endif

/****************************/
/* Constants                */
/****************************/

#define PWINACC_FNAME   "PWINACC.DAT"
#define PWREM_FNAME     "PWREM.DAT"
#define PWOBJ_FNAME     "PWOBJ.DAT"
#define FILE_SIZE       128

/* Size in bytes of various node address types */
#define DNET_ADDR_SIZE      2
#define TCP_ADDR_SIZE       4   
#define OSI_ADDR_SIZE       20
#define ETHER_ADDR_SIZE     6

#define ADAPTER_SIZE       16   /* Max length of remote adapter name */
#define DNET_NAME_SIZE      6   /* Max length of DECnet node name */

#define NMH_BSIZE   512         /* maximum size of nmhbuf               */
#define KEY_BSIZE   256         /* size of keyboard input buffer        */
#define B2_SIZE      80         /* size of access parameter             */

#define DNET_FSIZE  255         /* Maximum length for file name */

#define NCP_MAXLINK     64      /* max active links                     */

#define MAX_ENTSIZE     65      
#define MAX_ATTR_SIZE   65      /* Maximum attribute length */
#define STRING_LEN  32
#define SIZE_1K     1024

/* NICE protocol types */
#define DDCMP_POINT     0
#define ETHERNET        6
#define TOKEN_RING      10
#define LAPB            5

/* Installed line  types */
#define LINE_BROADCAST      0x0001      /* Broadcast (Ethernet, Token-Ring) */
#define LINE_POINT          0x0002      /* Point-to-point  (DDCMP,X.25,SLIP) */

/****************************/
/* Incoming access file     */
/****************************/
#define MAX_PATH_SIZE   64
#define ACCESS_SIZE     39      /* Max bytes for user, acct, password */
#define MAX_DRIVES      64      /* Maximum logical drives on system */
#define NONE          0x00
#define RO            0x01
#define WO            0x02
#define RW            0x03

typedef struct pw_inacc_rec
{
    unsigned short flags;
    unsigned char user[ACCESS_SIZE+1];
    unsigned char password[ACCESS_SIZE+1];
    unsigned char type;
    unsigned char home_dir[MAX_PATH_SIZE+1];
} PW_INACC_REC;

/****************************/
/* Local DECnet object file */
/****************************/
#define OBJNAME_SIZE    16
#define CMD_ARG_SIZE    80
#define DNET_OBJ_BATCH  0x10           

typedef struct pw_obj_rec
{
    unsigned short flags;
    unsigned char objnum;
    unsigned char objname[OBJNAME_SIZE+1];
    unsigned char path[MAX_PATH_SIZE+1];
    unsigned char args[CMD_ARG_SIZE+1];
    short use_count;
} PW_OBJ_REC;

/**********************************/
/* Local remote adapter name file */
/**********************************/

typedef struct pw_rem_acc
{
    unsigned short  flags;
    unsigned char adapter[ADAPTER_SIZE+1];
    unsigned short  objnum;
    unsigned short  dnet_addr;
    unsigned char tcp_addr[TCP_ADDR_SIZE];
    unsigned char user[ACCESS_SIZE+1];
    unsigned char password[ACCESS_SIZE+1];
    unsigned char account[ACCESS_SIZE+1];
} PW_REM_REC;

#endif  /* NM_API_H */
