/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *	socket definitions			File: sockdefs.h	*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef SOCKDEFS_H
    #define SOCKDEFS_H

#ifndef	PW3COM	/* 'standard' DEC sockdefs.h */
    #include <skdefs.h>

    #ifndef	PWTYPES_H
        #include <sktypes.h>
    #endif

    #ifdef	__HIGHC__
        #define	_cdecl	
    #endif

    #ifdef IOCB_INCL_IN
        u_short _cdecl htons(u_short);
        u_long  _cdecl htonl(u_long);
        u_short _cdecl ntohs(u_short);
        u_long  _cdecl ntohl(u_long);

        void    _cdecl setnetent(int );
        void    _cdecl endnetent(void);
        struct netent * _cdecl getnetent(void);

        void _cdecl setprotoent(int );
        void _cdecl endprotoent(void);
        struct protoent * _cdecl getprotoent(void);

        void _cdecl setservent(int );
        void _cdecl endservent(void);
        struct servent * _cdecl getservent(void);

        void _cdecl sethostent(int );
        void _cdecl endhostent(void);
        struct hostent * _cdecl gethostent(void);

        void _cdecl _endhtent(void );
        void _cdecl _sethtent(int );
        struct hostent FAR * _cdecl _gethtent(void );

        u_long _cdecl inet_lnaof(struct in_addr);
        u_long _cdecl inet_netof(struct in_addr);
        u_long _cdecl inet_network(char *);
        u_long _cdecl inet_addr(char *);
        struct in_addr _cdecl  inet_makeaddr(u_long, u_long);
        char * _cdecl inet_ntoa(struct in_addr);

        struct servent * _cdecl getservbyname(char *,char *);
        struct servent * _cdecl getservbyport(int ,char *);

        short _cdecl gethostname(char *, int );
        struct netent * _cdecl getnetbyname(char *);
        struct protoent * _cdecl getprotobyname(char *);
        struct protoent * _cdecl getprotobynumber(int );

        struct hostent * _cdecl gethostbyaddr(CONST char *, int, int);
        struct hostent * _cdecl gethostbyname(CONST char *);

        struct in_addr * getlocalipaddress();

        struct hostent FAR * _gethtbyname(CONST char FAR *); 
        struct hostent * _gethtbyaddr(CONST char FAR *, int);  
    #endif 
#else	/* 3com-style declarations */
    #ifdef IOCB_INCL_IN
        #undef IOCB_INCL_IN 
    #endif

    // System calls
    int  cdecl far  accept( int, struct sockaddr far *, int far * );
    int  cdecl far  bind( int, struct sockaddr far *, int );
    int  cdecl far  sclose( int );
    #define	close_socket(n) sclose(n)
    int  cdecl far  connect( int, struct sockaddr far *, int );
    int  cdecl far  gethostname( char far *, int );
    int  cdecl far  getpeername( int, struct sockaddr far *, int far * );
    int  cdecl far  getsockname( int, struct sockaddr far *, int far * );
    int  cdecl far  getsockopt( int, int, int, char far *, int far * );
    int  cdecl far  sioctl( int, int, char far * );
    #define	ioctl(a, b, c) sioctl(a, b, c)
    int  cdecl far  listen( int, int );
    int  cdecl far  recv( int, char far *, int, int );
    int  cdecl far  recvfrom( int, char far *, int, int, struct sockaddr far *, int far * );
    int  cdecl far  select( int, fd_set far *, fd_set far *, fd_set far *, struct timeval far * );
    int  cdecl far  send( int, char far *, int, int );
    int  cdecl far  sendto( int, char far *, int, int, struct sockaddr far *, int );
    int  cdecl far  setsockopt( int, int, int, char far *, int );
    int  cdecl far  socket( int, int, int );

    char far * cdecl far  sock_strerror( int );

    #ifdef IOCB_INCL_IN
        // inet_*, byte swapping routines
        unsigned long   cdecl far inet_addr( char far * );
        long            cdecl far inet_lnaof( struct in_addr );
        struct in_addr  cdecl far inet_makeaddr( unsigned long, unsigned long );
        long            cdecl far inet_netof( struct in_addr );
        unsigned long   cdecl far inet_network( char far * );
        char far       *cdecl far inet_ntoa( struct in_addr );

        int             cdecl far htons( int ),  cdecl far ntohs( int );
        unsigned long   cdecl far htonl( long ), cdecl far ntohl( long );

        // library calls
        void                 cdecl far sethostent( int );
        void                 cdecl far endhostent( void );
        struct hostent far  *cdecl far gethostent( void );
        struct hostent far  *cdecl far gethostbyname( char far * );
        struct hostent far  *cdecl far gethostbyaddr( struct in_addr far *, int, int );

        void                 cdecl far setnetent( int );
        void                 cdecl far endnetent( void );
        struct netent far   *cdecl far getnetent( void );
        struct netent far   *cdecl far getnetbyname( char far * );
        struct netent far   *cdecl far getnetbyaddr( unsigned long, int );

        void                 cdecl far setprotoent( int );
        void                 cdecl far endprotoent( void );
        struct protoent far *cdecl far getprotoent( void );
        struct protoent far *cdecl far getprotobyname( char far * );
        struct protoent far *cdecl far getprotobynumber( int );

        void                 cdecl far setservent( int );
        void                 cdecl far endservent( void );
        struct servent far  *cdecl far getservent( void );
        struct servent far  *cdecl far getservbyname( char far *, char far * );
        struct servent far  *cdecl far getservbyport( int, char far * );
    #endif  
#endif	/* PW3COM */

#endif  // SOCKDEFS_H
