/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  NIOCB definitions			File: IOCB.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1992, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef IOCB_H
#define IOCB_H

/*  *********************************************************************
    *  Include the other includes					*
    ********************************************************************* */

/*
 *  First, include the regular includes (the ones that non-IOCB apps use)
 */

#ifndef DN_H
#include <dn.h>                 /* DECnet socket symbols and structures   */
#endif
#ifndef IN_H
#include <in.h>                 /* TCP/IP socket symbols and structures	  */
#endif
#ifndef OSI_H
#include <osi.h>                /* OSI socket symbols and structures 	  */
#endif

/*
 *  Now, include the parameter lists for the IOCBs
 */

#ifndef IOCB_DN_H
#include <iocb_dn.h>
#endif
#ifndef IOCB_IN_H
#include <iocb_in.h>
#endif
#ifndef IOCB_OSI_H
#include <iocb_osi.h>
#endif

/*  *********************************************************************
    *  Function codes for all protocols					*
    ********************************************************************* */

#define	PRU_ATTACH		0	/* attach protocol to up */
#define	PRU_DETACH		1	/* detach protocol from up */
#define	PRU_BIND		2	/* bind socket to address */
#define	PRU_LISTEN		3	/* listen for connection */
#define	PRU_CONNECT		4	/* establish connection to peer */
#define	PRU_ACCEPT		5	/* accept connection from peer */
#define	PRU_DISCONNECT		6	/* disconnect from peer */
#define	PRU_SHUTDOWN		7	/* won't send any more data */
#define	PRU_RCVD		8	/* have taken data; more room now */
#define	PRU_SEND		9	/* send this data */
#define	PRU_ABORT		10	/* abort (fast DISCONNECT, DETATCH) */
#define	PRU_CONTROL		11	/* control operations on protocol */
#define PRU_GETNEXT             11      /* LAT-only */
#define	PRU_SENSE		12	/* return status into m */
#define	PRU_RCVOOB		13	/* retrieve out of band data */
#define	PRU_SENDOOB		14	/* send out of band data */
#define	PRU_SOCKADDR		15	/* fetch socket's address */
#define	PRU_PEERADDR		16	/* fetch peer's address */
#define	PRU_CONNECT2		17	/* connect two sockets */
#define PRU_RECVFROM		18	/* receive from below */
#define PRU_SENDTO		19	/* send to below */
#define PRU_NREQ		19	/* ?? */
#define PRU_CANCEL		20	/* Cancel previous function request */
#define PRU_NETBIOS		21	/* NETBIOS functions */
#define PRU_LOCALINFO		22	/* Local node information */
#define PRU_SELECT		23	/* Select I/O descriptors */
#define PRU_SIOCTL		24	/* Socket I/O control */
#define PRU_SETSOCKOPT		25	/* Set socket option */
#define PRU_GETSOCKOPT		26	/* Get socket option */
#define PRU_KERNELKNOW		27	/* Get kernel knowledge */
#define PRU_READLOG		28	/* read event log */
#define PRU_WRITELOG		29	/* write event log */
#define PRU_NMH 		30	/* network management request */

#define MIB_GET_MIB		0		/* netstat, arp use MIB call */
#define MIB_GET_COUNTERS 0		/* sub type of MIB_GET_MIB */
#define MIB_GET_TABLE	1		/* sub type of MIB_GET_MIB */

#if 0
; The following structure is for network management.
; nmh_val is a pointer sometimes, and a value other times.
; currently, if it is a value, the high-order word is always zero.
; if that changes, decnet.asm will have to change, and so will VDNET.
; They will then have to special-case any functions that take long values.

; NMH_STRUC
NMH_STRUC           STRUC
    nmh_func        DW  ?
    nmh_entity      DW  ?
    nmh_param       DW  ?
    nmh_val         DD  ?       ; *SOMETIMES* this is a pointer
    nmh_cnt         DW  ?
NMH_STRUC           ENDS
#endif

struct	nmh {
	short	nmh_func;
	short	nmh_entity;
	short	nmh_param;
	long	nmh_val;
	short	nmh_cnt;
};

struct  mib {
	char	mib_func;
	char  mib_type;
	short  mib_entry_cnt;
	short  mib_buf_len;
	exptr  mib_buf_ptr;
	char   mib_depth;
	char   mib_tree[5];
	char   mib_reserved[4];
};

/*  *********************************************************************
    *  Shorthand definitions for iocb struction/union member access	*
    ********************************************************************* */

#define plcl 	plist.io_localinfo
#define patt	plist.io_attach
#define plsn 	plist.io_listen
#define psdn 	plist.io_sockaddr
#define psel 	plist.io_select
#define psel64	plist.io_select64
#define psel256	plist.io_select256
#define psio 	plist.io_sioctl
#define psop 	plist.io_sockopt
#define pedn 	plist.io_entrypts
#define pshd 	plist.io_shutdown
#define pbuf 	plist.io_bufd.io_buffer
#define plen 	plist.io_bufd.io_buflen
#define pclb 	plist.io_callback
#define psem 	plist.io_callback

/*  *********************************************************************
    *  IOCB structure.							*
    *  									*
    *  This consists of a header substructure which is fixed in size,	*
    *  followed by a parameter list that depends on the function.	*
    ********************************************************************* */

typedef struct	niocb
{
	unsigned char	io_fcode;   	/* Function code 		   */
	short		io_socket;  	/* Socket handle 		   */
	unsigned short  io_flags;   	/* Flags 			   */
	short 		io_status;  	/* Place for return status value   */
	short 		io_errno;   	/* Place for return of errno value */
	short 		io_psize;   	/* Size of function parameter list */
        unsigned char	io_resrv;   	/* Reserved, must be zero	   */
    	exptr		io_callback;	/* Callback address 		   */

	union		    		/* NIOCB Parameter List 	   */
	{
		struct	localinfo_dn io_localinfo;  /* Get local info */
		struct	localinfo_in io_localinfo_in;/* localinfo for IP */
		struct  localinfo_osi io_localinfo_osi; /* localinfo for OSI */
		struct	attach_dn    io_attach;     /* Attach (assign) */
		struct	listen_dn    io_listen;     /* Listen */
		struct	sockaddr_dn  io_sockaddr;   /* Connect, */
						    /* Connect Complete, */
						    /* Accept, Bind, */
						    /* Getsockaddr, */
						    /* Getpeeraddr */
		struct	sockaddr_in  io_sockaddr_in;/* .. sockaddr for IP */
		struct  sockaddr_osi io_sockaddr_osi;/* .. sockaddr for OSI */
		struct	select_dn    io_select;     /* Select */
		struct	select64_dn  io_select64;   /* Select64 */
		struct	select256_dn io_select256;  /* Select256 */
		struct	sioctl_dn    io_sioctl;     /* Sioctl */
		struct	sockopt_dn   io_sockopt;    /* Set/Getsockopt */
		struct	shutdown_dn  io_shutdown;   /* Shutdown */
                struct  buffer_dn    io_bufd;       /* Buffer descriptor */
		struct  tfbuffer_in  io_tfbufd;     /* Sendto\Recvfrom descriptor */
		exptr	io_buffer;		    /* Cancel */
		struct	nmh	     io_nmh;	    /* network management */
		struct   mib		  io_mib;			/* MIB stuff */
        } plist;
} NIOCB;

#endif	/* IOCB_H */


