%e 5000
%p 5000
C [+0-9]*
%%
\374*\t		s();
\n		{nl(); nl();}
\+PR\|		s();
\+PS\|		;
\+ET\|		nl();
\+OB\|		p("[");
\+EB\|		p("]");
\+HM[,][0-9]+[| ] hm();
\+LC[^| ]*[| ]	;
\+AR[^|]*\|	q("?");
\+NT\|		nl();
\+Q[NP]\|	nl();
\+AI\|		p("ante ");
\+CI\|		p("circa ");
\+IA\|		q("(A)");	/* usage alpha */
\+IB\|		q("(B)");	/* beta */
\+IG\|		q("(C)");	/* gamma */
\+ID\|		q("(D)");	/* delta */
\+IE\|		q("(E)");	/* epsilon */
\+IZ\|		q("(F)");	/* zeta */
\+IH\|		q("(G)");	/* eta */
\+IT\|		q("(H)");	/* theta */
\+FS\|		q("?");
\+S[OPNRS]\|	nl();
\+HW\|		;
\+BL\|		{nl(); p("*");}
\+EL\|		;
\+IL\|		{nl(); p("*");}
\+BF\|		;
\+EF\|		;
\+FB\|		;
\+NU\|		p("{");
\+DN\|		p("}/{");
\+FE\|		p("}");
\+QT\|		;
\+[IBSGR][| ]	;
\+RB\|		p(">");
\+NR\|		;	/* ? */
\+SC\|		;
\+P[RS]\|	;
\+VL\|		nl();
\+SU\|		p("<");
\+UP\|		p("<");
\+IN\|		p("<");
\+RR\|		;
\+IR\|		;
\+LA\|		;
\+H\|		p("-");
\]		p("!");
\+0\|		s();
\|		s();
\+1\|		p("=");		/* macron */
\+2\|		p("\"");	/* umlaut */
\+3\|		p("'");		/* acute */
\+4\|		p("`");		/* grave */
\+5\|		p("'");
\+6\|		;		/* short vowel */
\+7\|		p("ah");
\+8\|		;		/* greek accent */
\+9\|		;		/* greek accent */
\+10\|		p("..");
\+11[ |]	p(".");		/* main stress */
\+12\|		p(":");		/* secondary stress */
\+13\|		p("-");	/* dash */
\+14\|		p("-");
\+15\|		p("[");
\+16\|		p("]");
\+17\|		p("`");
\+18\|		p("'");
\+19\|		p("er");
\+20\|		p("uh");
\+21\|		p("*");
\+21\|\+19\|	p("*r");
\+22\|		p("+");
\+9?23{C}\|		p("ae");
\+9?24{C}\|		c("oe");
\+9?25{C}\|		c("zh");
\+9?26{C}\|		c("zh");	/* old english */
\+9?27{C}\|		c("dh");	/* thorn */
\+9?28{C}\|		c("dh");	/* thorn */
\+29\|		p("=");
\+30\|		p("ng");
\+31[| ]	p("+");		/* dagger */
\+32[| ]	p("||");
\+33[| ]	p("@");		/* paragraph */
\+34[| ]	p("|");
\+9?35\|	p("th");
\+36\|		p("PP");
\+37\|		p("``");
\+38\|		p("''");
\+9?39\|		c("d");
\+41\|		p("A");
\+42\|		p("b");
\+43\|		p("a");
\+44\|		p("ah");
\+45\|		p("sh");
\+9?47\|	c("zh");	/* old english */
\+9?48\|	c("l");
\+9?49\|	c("z");
\+50\|		;		/* v over letter */
\+51\|		p("^");
\+52\|		;		/* dot over letter */
\+53\|		;		/* dot under */
\+54\|		;		/* cedilla */
\+55\|		p("^");
\+56\|		p("~");
\+60\|		;
\+63\|		s();
\+64\|		;
\+9?75{C}\|	c("s");
\+9?76{C}\|	c("a");
\+9?77{C}\|	c("b");
\+9?78{C}\|	c("g");
\+9?79{C}\|	c("d");
\+9?80{C}\|	c("e");
\+9?81{C}\|	c("z");
\+9?82{C}\|	c("h");
\+9?83{C}\|	c("th");
\+9?84{C}\|	c("i");
\+9?85{C}\|	c("k");
\+9?86{C}\|	c("l");
\+9?87{C}\|	c("m");
\+9?88{C}\|	c("n");
\+9?89{C}\|	c("x");
\+9?90{C}\|	c("o");
\+9?91{C}\|	c("p");
\+9?92{C}\|	c("r");
\+9?93{C}\|	c("s");
\+9?94{C}\|	c("t");
\+9?95{C}\|	c("u");
\+9?96{C}\|	c("ph");
\+9?97{C}\|	c("ch");
\+9?98{C}\|	c("ps");
\+9?99{C}\|	c("w");
\+100\|		p("{");
\+102\|		p("SS");
\+103\|		p("L");		/* pound sterling */
\+105\|		p("->");
\+106\|		p("degrees");
\+107\|		p("...");
\+108\|		p("-");
\+112\|		p("!");
\+201\|		p("-");
\+202\|		p("*");
\+204\|		p("|");
\+205\|		p("\"");
\+206\|		p("|");
\+213\|		p("<");
\+232\|		q("DELTA");
\+235\|		p("/\\");
\+239\|		p(".");
\+241\|		p("=");
\+242\|		p("-");
\+304\|		p("+");
\+313\|		p("/\\");
\+317\|		p("b");
\+319\|		p("#");
\+334\|		p("'");
\+335\|		p("`");
\+336\|		p("^");
\+337\|		p("~");
\+338\|		p(",");
\+345\|		p("@");
\+349\|		q("sun");
\+350\|		p("#");
\+360\|		p("G");
\+361\|		p("<");
\+362\|		p("C");
\+363\|		p("C");
\+364\|		p("C");
\+365\|		p("G");
\+366\|		q("cancer");
\+367\|		q("alpha");
\+368\|		p("C");
\+369\|		q("Cbar");
\+372\|		p("_");
\+373\|		p("=");
\+377\|		p(".");
\+384\|		p("^");
\+385\|		p("'");
\+438\|		q("?");
\+466\|		q("?");
\+490\|		q("st");
\+[^|]*\|	p(yytext);
[^|+\374\n]+	p(yytext);
%%
#include <stdio.h>
#include <ctype.h>

int cpos;
int ll = 70;

s()
{
	if(cpos>0) {
		printf(" ");
		cpos++;
	}
}

p(s)
char *s;
{
	u(strlen(s));
	printf("%s",s);
}

u(n)
{
	if((cpos+=n) > ll) {
		nl();
		cpos = n;
	}
}

q(s)
char *s;
{
	u(strlen(s)+2);
	printf("*%s*",s);
}

c(s)
char *s;
{
	u(strlen(s));
	for( ; *s; s++)
		putchar(yytext[1]=='9'?toupper(*s):*s);
}

nl()
{
	printf("\n");
	cpos = 0;
}

hm()	/* +HM,number| */
{
	yytext[strlen(yytext)-1] = 0;
	p("[");
	p(&yytext[4]);
	p("]");
}
