/* viper.c:  Status driven device for Archiver 2125s */
#include "sys/param.h"
#include "sys/inode.h"
#include "saio.h"

#define	TAPEUNIT	5
static	char	request[] = { 3, 0, 0, 0, 14, 0 };
static	char	eof[] = { 0x10, 0, 0, 0, 2, 0 };
static	char	rewind[] = { 1, 0, 0, 0, 0, 0 };
static	char	data[14];
static	char	w[] = { 0xA, 1, 0, 0, 0, 0 };
static	char	r[] = { 8, 1, 0, 0, 0, 0, };

vpopen(io)
	struct iob *io;
{
	scsi(TAPEUNIT, request, data, sizeof data, NULL);
}

vpstrategy(io, func)		/* do io */
	struct iob *io;
{
	register char *cdb;
	register int n;

	cdb = func == WRITE ? w : r;
	cdb[4] = io->i_cc + 0777 >> 9;
	scsi(TAPEUNIT, cdb, io->i_ma, io->i_cc, NULL);
	return io->i_cc;
}

vpclose(io)
	struct iob *io;
{
	scsi(TAPEUNIT, eof, 0, 0, 0);
	scsi(TAPEUNIT, rewind, 0, 0, 0);
}
