#include "param.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "errno.h"
/*
 *	Memory specil file
 *	minor device 0 is physical memory
 *	minor device 1 is kernel memory
 *	minor device 2 is EOF/RATHOLE
 */

extern	maxmem;		/* size of physical memory */

mmread(dev)
{
	register caddr_t cp;
	register int c;

	if (minor(dev) == 2)
		return;
	cp = (caddr_t)u.u_offset;
	cp = (caddr_t)((int)cp | 0x80000000);
	do {
		if ((c = fubyte(cp)) == -1) {
			u.u_error = ENXIO;
			return;
		}
		cp++;
	} while (passc(c) >= 0);
}

mmwrite(dev)		/* write to memory */
{
	register caddr_t cp;
	register int c;

	if (minor(dev) == 2) {
		u.u_count = 0;
		return;
	}
	cp = (caddr_t)u.u_offset;
	cp = (caddr_t)((int)cp | 0x80000000);
	while ((c = cpass()) >= 0)
		if (subyte(cp++, c) == -1) {
			u.u_error = ENXIO;
			return;
		}
}
