/* tstrap.s: First block on a bootable tape */
/*
 * This strap goes in front of the /boot image.
 * This strap loads the rest of the tape file
 * starting at location 0x10000.  It then looks at the header and
 * It then branches to location 0x10020 which is the entry point
 * to /boot.
 * This code should be written to run anywhere.
 *
 * On entry the register look as follows:
 *	d0-d1-d2	scsi cdb to read from current tape in .5k blks
 *
 */

	.set	SCSIADDR,0xfffe4000		/* location of WD33C93 */
	.set	SCSIDATA,SCSIADDR+1
	.set	SCSIPICR,0xfffe102a
	.set	DMADA, 0xfffe1004
	.set	DMABC, 0xfffe1008
	.set	DMACSR, 0xfffe1021
	.set	FC,0x05000000			/* dma function code */
	.set	DELAY,51200

1:	bra	1b			/* hang -- for debugging */
	movl	#0x10000,d5		/* into bootstrap location */
1:
	bsr	delay
	bsr	scsiio
	bsr	dumpscsi
	addl	#512,d5			/* place to put next block */
	cmpb	#0x4b,d7		/* should get this on eof */
	beqs	1b			/* no, read another block */
	jmp	0x10020			/* yes, branch to it! */



dumpscsi:
	bsr	delay		/* hack */
	movl	d0,sp@-
	movl	a0,sp@-
	movl	#0x6000,a0		/* dump the chip registers */
	movl	#0x18,d0
	movb	#0,SCSIADDR
1:
	movb	SCSIDATA,a0@+		/* copy the byte */
	dbra	d0,1b
	movb	SCSIADDR,d0
	movb	d0,a0@+
	movl	sp@+,a0
	movl	sp@+,d0
	rts

/*
 * scsiio: do scsi io.
 *
 *	d0 = cdb0-3
 *	d1 = cdb4-7
 *	d2 = cdb8-11
 *	d3 = transfer length in bytes
 *	d4 = destination id
 *	d5 = data address
 *  on return
 *	d6 = scsi bus status
 *	d7 = chip status
 */

scsiio:
	tstl	d5		/* do we need dma? */
	beqs	1f		/* no -- skip dma setup */
	movb	#00, DMACSR	/* disable dma */
	movl	d5, DMADA	/* where we are dmaing to */
	movl	d3, DMABC	/* bytes to transfer */
	orl	#FC,DMABC	/* set supv data transfer */
	movb	#1, DMACSR	/* enable */

1:
	bsr	wdready		/* wait until chip can accept command */

	movb	#1,SCSIADDR
	movb	#0x84,SCSIDATA		/* dma mode 4, int on disconn */
	movb	#62,SCSIDATA		/* time out - 500ms */

	/* load the 12 bytes of cdb into the chip */

	movl	#2,d7		/* register counter */
1:
	movl	#3,d6		/* byte counter */
2:
	roll	#8,d0
	movb	d0,SCSIDATA
	dbra	d6, 2b

	exg	d0,d1
	exg	d1,d2
	dbra	d7, 1b

	movb	#0,SCSIDATA	/* target unit */
	movb	#0,SCSIDATA	/* command phase */
	movb	#0,SCSIDATA	/* sync transfer */

	/* load transfer count */

	movl	#2, d6
	rorl	#8, d3		/* get byte 1 into position */
	rorl	#8, d3
1:
	movb	d3,SCSIDATA
	roll	#8, d3
	dbra	d6, 1b
	rorl	#8, d3		/* get back as it was */

	movb	d4, SCSIDATA	/* destination id */
	movb	#7, SCSIDATA	/* source id -reconnect */
	movb	#0, SCSIDATA	/* scsi status -- no op to bump pointer */
	bsr	delay		/* can't touch command too soon */
	movb	#9, SCSIDATA	/* command */
	bsr	wdcomplete	/* wait until complete */
	movb	#0x17,SCSIADDR
	movb	SCSIDATA,d7	/* scsi status is returned */
	movb	#0x0f,SCSIADDR	/* fetch the devices status byte */
	movb	SCSIDATA,d6
	rts

/* 
 *	wdready checks that we can send a command to the chip
 */

wdready:
	rts

wdcomplete:
	movl	d0, sp@-
1:
	btst	#7,SCSIADDR		/* wait until the chip is done */
	beqs	1b
1:
	btst	#5,SCSIADDR		/* now wait for busy to clear */
	bnes	1b
	movb	#0x17,SCSIADDR		/* clear int bit */
	movb	SCSIDATA, d0
1:
	btst	#7,SCSIADDR		/* watch for int to clear */
	bnes	1b
1:
	btst	#4, SCSIADDR
	bnes	1b
	movl	sp@+,d0
	rts

delay:	/* Boy, I hate these hacks! */
	movl	d0,sp@-
	movl	#DELAY,d0
1:
	subl	#1,d0
	bnes	1b
	movl	sp@+,d0
	rts

