/*
 * adb - symbol table routines
 */
#include "defs.h"
#include <stab.h>

/* move this stuff to defs.h when finished. */

#define	MAXINT	0x7fffffff
#define	LPRMODE "%R"
#define	OFFMODE "+%R"

/* end of stuff to be moved to defs.h */
/*
 * Lookup a symbol by name.
 */
struct nlist *
lookup(symstr)
	char *symstr;
{
	register struct nlist *sp;

	cursym = 0;
	if (symtab)
	for (sp = symtab; sp < esymtab; sp++)
		/* SHOULD DO SOME OF EQSYM INLINE TO SAVE TIME */
		if ((sp->n_type & N_STAB) == 0) {
			if (eqsym(sp->n_un.n_name, symstr, '_'))
				return(cursym = sp);
		}
	return (0);
}

/*
 * Find the closest symbol to val, and return
 * the difference between val and the symbol found.
 * Leave a pointer to the symbol found as cursym.
 * Changed to include non-globals.
 */
findsym(val, type)
	unsigned long val;
	int type;
{
	unsigned diff;
	register struct nlist *sp;
	register t;

	cursym = 0;
	diff = ~0;
	if (type == NSYM || symtab == 0)
		return MAXINT;
	for (sp = symtab; sp < esymtab; sp++) {
		if (sp->n_type & N_STAB)
			continue;
		if ((t = sp->n_type & N_TYPE) == N_ABS || t == (N_FN&~1))
			continue;
		IF val >= (unsigned)sp->n_value
		ANDF val - (unsigned)sp->n_value < diff
		THEN	diff = val - (unsigned)sp->n_value;
			cursym = sp;
			IF diff == 0 THEN break; FI
		FI
	}
	return diff == 0xffffffff ? MAXINT : diff;
}

/* 
 * Version of findsym that locates the '-g' stuff and sets the cursym
 * to it.
 */

local_get(name)	
	char *name;
{
	register struct nlist *sp;
	register char *cp;

	if (symtab == 0)
		return;
	if (name[0] == '_')
		name++;
	for (sp = symtab; sp < esymtab; sp++) {
		if ((sp->n_type & ~1) != N_FUN)
			continue;
		if ((cp = strchr(sp->n_un.n_name, ':')) != NULL)
			*cp = '\0';	/* kill colons */
		if (strcmp(sp->n_un.n_name, name) == 0) {
			cursym = sp;
			return;
		}
	}
	cursym = 0;
}


/*
 * Advance cursym to the next local variable.
 * Leave its value in localval as a side effect.
 * Return 0 at end of file.
 */
localsym(cframe, cargp)
	ADDR cframe, cargp;
{
	register int type;
	register struct nlist *sp;
	register char *cp;

	if (cursym)
	for (sp = cursym; ++sp < esymtab; ) {
		type = sp->n_type;
		switch (sp->n_type) {
		case N_LSYM:
			localval = cframe + sp->n_value;
			cursym = sp;
			if (cp = strchr(sp->n_un.n_name, ':'))
				*cp = '\0';
			return (1);
		case N_PSYM:
			localval = cframe + sp->n_value;
			if (cp = strchr(sp->n_un.n_name, ':'))
				*cp = '\0';
			cursym = sp;
			return (1);
		case N_LCSYM:		/* local static */
			localval = sp->n_value;
			if (cp = strchr(sp->n_un.n_name, ':'))
				*cp = '\0';
			cursym = sp;
			return 1;
		case N_FUN:
			cursym = 0;
			return 0;
		}
	}
	cursym = 0;
	return (0);
}

/*
 * Print value v and then the string s.
 * If v is not zero, then we look for a nearby symbol
 * and print name+offset if we find a symbol for which
 * offset is small enough.
 *
 * For values which are just into kernel address space
 * that they match exactly or that they be more than maxoff
 * bytes into kernel space.
 */
psymoff(v, type, s)
	long v;
	int type;
	char *s;
{
	long w;

	IF v THEN w = findsym(v, type); FI
	IF v == 0 || w >= maxoff
	THEN
		printf(LPRMODE, v);
	ELSE
		printf("%s", cursym->n_un.n_name);
		IF w THEN printf(OFFMODE, w); FI
	FI
	printf(s);
}

/*
 * Print value v symbolically if it has a reasonable
 * interpretation as name+offset.  If not, print nothing.
 * Used in printing out registers $r.
 */
valpr(v, idsp)
	long v;
{
	off_t d;

	d = findsym(v, idsp);
	if (d >= maxoff)
		return;
	printf("%s", cursym->n_un.n_name);
	if (d)
		printf(OFFMODE, d);
}

/*
 * find and print the filename:lineno for value
 */

plineoff(v, type, s)
	L_INT v;
{
	register struct nlist *sp;
	register struct nlist *sline, *so;

	if (type == NSYM || symtab == 0) {
		psymoff(v, type, s);
		return;
	}
	for (sp = symtab; sp < esymtab; sp++) {
		if ((sp->n_type & N_STAB)==0)
			continue;
		if (sp->n_type == N_SO)
			so = sp;
		else if (sp->n_type == N_SLINE)
			if (sp->n_value > v)
				break;
			else
				sline = sp;
	}
	if (so && sp) {
		printf("%s.%d", so->n_un.n_name, sline->n_desc);
		printf(s);
	} else
		psymoff(v, type, s);
}
