/* ureg.c:  Establish and load user page table entries. */

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "proc.h"
#include "text.h"
#include "errno.h"

/*
 *	Load the user user page table from the prototypes in the u segment.
 *	The u segment values must have been setup by estabur.
 */

extern	struct	segment segtable[];

sureg()
{
	register taddr, daddr;
	int n;
	struct text *tp;
	register struct segment *p, *q;

	taddr = daddr = (long) u.u_procp->p_addr;
	if ((tp = u.u_procp->p_textp) != NULL)
		taddr = (int)tp->x_caddr;
	taddr = ctob(taddr);
	daddr = ctob(daddr);
	for (p = &u.u_proto[0], q = segtable; p < &u.u_proto[3]; p++, q++) {
		*q = *p;
		if (q->addr & TX) {
			q->addr &= ~TX;
			q->addr += taddr;
		} else
			q->addr += daddr;
	}
	segtable[MESGSEG].limit = NMESG;
	segtable[MESGSEG].status = 0xFC02;	/* pointer to short pte */
	segtable[MESGSEG].addr = ctob(u.u_procp->p_addr);
	asm("	nop");
	asm("	.word	0xf000");		/* pflusha */
	asm("	.word	0x2400");
	asm("	movl	#0x3919,d0");		/* clear cache */
	asm("	.long	0x4e7b0002");		/* movec d0, cacr */
}

/*
 *	Set up prototype fields with C segment sizes to be used
 *	by sureg to load the segment table.  Text, data, stack segment
 *	sizes are passed as arguments.  
 *	The last argument determines whether the text
 *	segment is read-write or read-only.
 *	If the text segment is empty, put the data segment in the
 *	text segment.  (This means that it is impure text.)
 */

estabur(nt, nd, ns, xrw)
	unsigned nt, nd, ns;
{
	int a;
	register struct segment *sp;

	if (nt > SEGSIZE || nd > SEGSIZE || ns > SEGSIZE)
		goto err;
	if (nt + nd + ns > MAXMEM)
		goto err;
	a = 0;
	sp = &u.u_proto[TEXTSEG];
	if (nt) {
		sp->limit = nt - 1;
		sp->status = 0xfc01 | xrw;
		sp->addr = 0 | TX;
		a += nt;
		sp++;
	} 
	a = USIZE;
	if (nd) {
		sp->limit = nd - 1;
		sp->status = 0xfc01;
		sp->addr = ctob(a);
		a += nd;
		sp++;
	}
	if (sp == &u.u_proto[DATASEG]) {
		sp->limit = 0;
		sp->status = 0xfc00;
		sp->addr = 0;
		sp++;
	}
	if (ns) {
		sp->limit = ED | SEGSIZE - ns;
		sp->status = 0xfc01;
		sp->addr = ctob(a + ns - SEGSIZE);
	}
	/* later, add message segment stuff here */
	sureg();
	return 0;
err:
	u.u_error = ENOMEM;
	return -1;
}
