/* mon.c: monitor code */

/*
 * The buffer that holds the user information has the following
 * structure.
 *	struct {
 *		long lowpc;
 *		long highpc;
 *		long cntsiz;
 *		struct {
 *			int (*funcp)();
 *			long count;
 *		} [cntsiz];
 *		u_short	histo[?];
 */

monitor(lowpc, highpc, buf, bufsiz, cntsiz)
	char *lowpc, *highpc;
	short *buf, bufsiz;
{
	register o;
	static short *sbuf, ssiz;

	if (lowpc == 0) {
		profil(0, 0, 0, 0);
		o = creat("mon.out", 0666);
		write(o, sbuf, ssiz<<1);
		close(o);
		return;
	}
	ssiz = bufsiz;
	*((long *)&buf[0]) = (int)lowpc;
	*((long *)&buf[2]) = (int)highpc;
	*((long *)&buf[4]) = (int)cntsiz;
	sbuf = buf;
	buf += 4*(cntsiz+1);
	bufsiz -= 4*(cntsiz+1);
	if (bufsiz<=0)
		return;
	o = ((highpc - lowpc)>>1) & 077777;
	if(bufsiz < o)
		o = ((long)bufsiz<<15) / o;
	else
		o = 077777;
	profil(buf, bufsiz<<1, lowpc, o<<1);
	printf ("monitor: turned on\n");
}
