/* r.c */
#include <sys/types.h>
#include <time.h>
#include <stdio.h>

#include <sys/ethernet.h>
#include <sys/ipm.h>
#include "pep.h"


#define MAX_PACKET 4096

extern int dbg;
static struct trid_last *tridtop;

/* should i put in an upper bound on the number of connections ??*/
static updtrid(w)
register char *w;
{
	register struct trid_last  *p;
	struct pephdr *pp;
	u_short *pidp;

	pp = (struct pephdr *)(w + ETHERHLEN);
	pidp = (u_short *)(w + ETHERHLEN + PEPHLEN);

	if (tridtop == NULL) {
		tridtop = (struct trid_last *)malloc(sizeof(struct trid_last));
		tridtop->scope = *pidp;
		tridtop->last_trid = pp->trid;
		tridtop->next = NULL;
		return(0);
	} else {
		p = tridtop;
		while(p->next != NULL && p->scope != *pidp)
			p = p->next;
		if (p->scope == *pidp) {
			if (p->last_trid == pp->trid) {
				/* duplicate data packet */
				return(-1);
			} else {
				/* common path */
				p->last_trid = pp->trid;
				return(0);
			}
		} else {
			p->next = (struct trid_last *)malloc(sizeof(struct trid_last));
			p = p->next;
			p->scope = *pidp;
			p->last_trid = pp->trid;
			p->next = NULL;
			return(0);
		}
	}
}

char *fwdmsgs(buf, len)
register char *buf;
int len;
{
	register char *p, *dp;
	struct ether *ep;
	struct pephdr *pp;
	struct mesghdr *mhp;
	u_short *pidp;

	ep = (struct ether *)buf;
	pp = (struct pephdr *)(buf + ETHERHLEN);

	switch(pp->type) {
	case PEP_DATA:
		mhp = (struct mesghdr *)(buf + ETHERHLEN + PEPHLEN);
		dp = buf + ETHERHLEN+PEPHLEN+MHHLEN;
		sendreply(buf);
		if (updtrid(buf) == 0) {
			alarm(2);
			p = msgalloc(mhp->length);
			alarm(0);
			if ((int)p != -1) {
				memcpy(p, dp, mhp->length);
				if (msgsend(mhp, p) == -1) {
					perror("msgsend");
					msgfree(p);
				}
			}
		} else {
			/* drop message, it is a dup */
		}
		break;
	case PEP_ACK:
		pidp = (u_short *)(buf+ETHERHLEN+PEPHLEN);
		switch(remtop(*pidp, pp->trid)) {
			case 0: /* queue is empty */
				break;
			case -1: /* duplicate ack */
				break;
			default:
				sendtop(*pidp);
		}
		break;

	case PEP_SET_TRID:
		updtrid(buf);
		break;

	default:
		/* trash in type field */
		break;
	}
}
