/* filename : 	neconioctl.h
 * purpose  : 	define constants for con ethernet driver
 * author   :	Randy Wright
 *
 * 		Copyright ((C)) 1993 Randy Wright
 *
 * 
 * 
 * $Log:	neioctl.h,v $
 * Revision 2.1  94/01/25  22:07:19  root
 * put in low buffer usage stats.
 * note that arpcom struct will disappear.
 * However, that will apply mainly to the
 * STREAMS version which is under a paralell
 * development track.
 * 
 * Revision 2.0  94/01/19  16:16:53  root
 * initial revision, usder rcs to sync with
 * ne.c and wsub.c
 * 
 * 
 *
 */

#ifndef ne_H
#define ne_H ne_H

#define ne_data		0x10	/* Data Transfer port */
#define ne_reset	0x1f	/* Card Reset port */

#define	PKTSZ	3*512		/* Size of transmit buffer */

/* Span of memory on an NE2000 */
#define	TBUF16	(16*1024)	/* Starting location of Transmit Buffer */
#define	RBUFEND16	(32*1024)	/* Ending location of Receive Buffer */

/* Span of memory on an NE1000 */
#define	TBUF8	(8*1024)	/* Starting location of Transmit Buffer */
#define	RBUFEND8	(16*1024)	/* Ending location of Receive Buffer */

#ifndef ETHER_MIN_LEN
#define ETHER_MIN_LEN 64
#endif
#ifndef ETHER_MIN_LEN
#define ETHER_MAX_LEN 1536
#endif

	/* NOTE: this structure will be disappearing in the future,
	 * so don't use it for new code. It is a remnant of bsd days.
	 */
struct arpcom {
	unsigned char ac_enaddr[6];
	unsigned short if_flags;
	char *acc_if;
	};

struct ether_header {
	unsigned char ether_dhost[6];
	unsigned char ether_shost[6];
	unsigned short ether_type;
	};

struct nestats
	{
		/* statistics on data flow through our wires 
		 * copied from driver
		 */
	int	nestat_collisions;		/* number of collisions */
	int	nestat_oerrors;			/* number of xmit errors */
	int	nestat_ierrors;			/* number of recv errors */
	int	nestat_opackets;		/* xmitted packets */
	int	nestat_ipackets;		/* recv'd packets */
	int	nestat_idiscards;		/* incoming packets discarded */
	int	nestat_lox;			/* lowest num of xmit buffs 
						 * -- cleared on ioctl */
	int	nestat_lor;			/* lowest num of recv buffs 
						 * -- cleared on ioctl */
	};

	/* change the definition to whatever is correct */
typedef int neattr_t; 

	/* ioctl commands */
#define NEIOCGFLAGS	0x01		/* get flags, arg is pointer to
					 * an arpcom. acc_if is not returned
					 */

#define NEIOCSFLAGS	0x02		/* set flags,
					 * arg is pointer to arpcom 
					 */

/* the following 3 are not supported */
#define NEIOCGMODE	0x03		/* get mode (promiscous/normal) */

#define NEIOCSNORM	0x04		/* set mode to normal */

#define NEIOCSPROM	0x05		/* set mode to promiscous */

/* we support these next ones */
#define NEIOCGSTATS	0x06		/* retreive stats into struct nestats */

#define NEIOCGLOWWAT	0x07		/* get the current low-water figure
					 * this is only significant on the
					 * write side flow control.
					 */

#define NEIOCSLOWWAT	0x08		/* set the low-water figure. */


/* if_flags constants */
#define	IFF_UP		0x1		/* interface is up */
#define	IFF_BROADCAST	0x2		/* broadcast address valid */
#define	IFF_DEBUG	0x4		/* turn on debugging */
#define	IFF_LOOPBACK	0x8		/* is a loopback net */
#define	IFF_POINTOPOINT	0x10		/* interface is point-to-point link */
#define	IFF_NOTRAILERS	0x20		/* avoid use of trailers */
#define	IFF_RUNNING	0x40		/* resources allocated */
#define	IFF_NOARP	0x80		/* no address resolution protocol */
/* next two not supported now, but reserved: */
#define	IFF_PROMISC	0x100		/* receive all packets */
#define	IFF_ALLMULTI	0x200		/* receive all multicast packets */
#define	IFF_OACTIVE	0x400		/* transmission in progress */
#define	IFF_SIMPLEX	0x800		/* can't hear own transmissions */
#define	IFF_LLC0	0x1000		/* interface driver control/status */
#define	IFF_LLC1	0x2000		/* interface driver control/status */
#define	IFF_LLC2	0x4000		/* interface driver control/status */

#endif /* ne_H */

/* end of file neioctl.h */
