.TH ACE/gr 1 "April 1992"
.SH NAME
ACE/gr \- graphics for exploratory data analysis
.SH SYNOPSIS
.B xvgr (XView) or xmgr (Motif)
[
.B \-autoscale
.I x|y|xy
] [
[
.B \-noauto
.I x|y|xy
] [
.B \-arrange
.I rows columns
] [
.B \-cols
.I columns
] [
.B \-rows
.I rows
] [
.B \-device
.I device_number
] [
.B \-batch
.I batch_file
] [
.B \-pipe
] [
.B \-graph
.I graph_number
] [
.B \-maxplot
.I number_of_sets
] [
.B \-maxgraph
.I number_of_graphs
] [
.B \-graphsets
.I number_of_sets
] [
.B \-graphtype
.I graph_type
] [
.B \-log
.I x|y|xy
] [
.B \-printfile
.I graphics_output_file
] [
.B \-type
.I XY_data_set_type
] [
.B \-ihl
.I IHL_formatted_file
] [
.B \-nxy
] [
.B \-xy
] [
.B \-xydx
] [
.B \-xydy
] [
.B \-xydxdx
] [
.B \-xydydy
] [
.B \-xydxdy
] [
.B \-xyz
] [
.B \-xyd
] [
.B \-xyr
] [
.B \-hilo
] [
.B \-block
.I block_data
] [
.B \-parameter
.I parameter_file
] [
.B \-pexec
.I parameter_string
] [
.B \-results
.I result_file
] [
.B \-rvideo
] [
.B \-mono
] [
.B \-world
.I xmin ymin xmax ymax
] [
.B \-view
.I xmin ymin xmax ymax
] [
.B \-source
.I data_source
] [
.B \-GXinvert
] [
.B \-GXxor
] [
.B \-maxcolors
.I number_of_colors
] [
.B \-bc
] [
.B \-bs
] [
.B \-nobs
] [
.B \-dc
] [
.B \-nodc
] [
.B \-redraw
] [
.B \-noredraw
] [
.B \-refresh
.I refresh_value
] [
.B \-debug
.I debug_level
] [
.B
.I data_files
]
.SH DESCRIPTION
.I ACE/gr 
is a data/function plotting tool for workstations or X-terminals using X.
A few of its features are:
.PP
.IP \(bu 
Polynomial regression, splines, running averages, DFT/FFT, cross/auto-correlation.
.IP \(bu 
Plots up to 10 graphs with 30 datasets per graph.
.IP \(bu
User-defined scaling, tick marks, labels, symbols, line styles, colors.
.IP \(bu
Batch mode for unattended plotting.
.IP \(bu
Read and write parameters used during a session.
.IP \(bu
Support through device independent graphic drivers for
PostScript, and FrameMaker .mif format.
.SH OVERVIEW
.PP
While ACE/gr has a convenient point-and-click interface, most parameter settings
and operations are available through a command line interface (found in Files/Commands). See
the ACE/gr User's Manual for further information. The following discusses command line parameters, 
data file formats, hot keys, examples, and a few bugs. See the ACE/gr User's Manual for a 
complete description of ACE/gr and its capabilities.
.SH OPTIONS
.IP \fB\-autoscale\fP\ [\fIx|y|xy\fP]
Autoscale the axis denoted by "x" or "y" or both axes by "xy" overiding
any parameter file specified by the -p or -parameter option.
.IP \fB\-noauto\fP\ [\fIx|y|xy\fP]
Suppress autoscaling  the axis denoted by "x" or "y" or both axes by "xy." Use -noauto if the data has imbedded parameter settings that set the world and tick spacing.
.IP \fB\-arrange\fP\ [\fIrows\fP\ \fIcolumns\fP]
Arrange graphs in column major order starting from the lower left corner in a grid rows by columns.
For example, '-arrange 2 2' will position the first four graphs (0, 1, 2, 3) in a 2x2
matrix of graphs starting with graph 0 in the lower left corner of the plotting surface.
.IP \fB\-rows\fP\ [\fIrows\fP]
Arrange the first 'rows' graphs in 'rows' rows.
.IP \fB\-cols\fP\ [\fIcols\fP]
Arrange the first 'cols' graphs in 'cols' columns.
.IP \fB\-batch\fP\ [\fIbatch_file\fP]
Execute the commands in 
.I batch_file
on startup.
.IP \fB\-device\fP\ [\fIdevice_number\fP]
Set the hardcopy device to 
.I device.

The device numbering follows:

    1 .. PostScript landscape
    2 .. PostScript portrait
    3 .. FrameMaker .mif landscape
    4 .. FrameMaker .mif portrait
    5 .. HPGL landscape
    6 .. HPGL portrait

.IP \fB\-printfile\fP\ [\fIgraphics_output_file\fP]
Write the graphics output to file
.I graphics_output_file
rather than spool graphics data to a printer.
.IP \fB\-ihl\fP\ [\fIfile_name\fP]
Assume 
.I file_name 
or the next source of data is in IHL format (a local format)
.IP \fB\-log\fP\ [\fIx|y|xy\fP]
Set the current graph type to logarithmic 
depending the the string "x" or "y" or both axes by "xy".
.IP \fB\-nxy\fP
The format of the next data source is X1, Y1, Y2, ..., Yn.
.IP \fB\-block\fP\ [\fIblock_data\fP]
The file block_data is a block data file.
.IP \fB\-type\fP\ [\fIdata_set_type\fP]
The format of the next data source is 
.I data_set_type.
Where
.I data_set_type
is one of xydx (XY data with error bars along X), xydy (XY data with error bars along Y),
xydxdx (XY data with error bars along X of differing values),
xydydy (XY data with error bars along Y of differing values), and
.IP \fB\-param\fP\ [\fIparm_file\fP]
Read the parameter file 
.I parm_file.
.IP \fB\-pexec\fP\ [\fIparameter_setting\fP]
Interpret
.I parameter_setting
as a parameter setting.
.IP \fB\-graph\fP\ [\fIgraph_number\fP]
Make 
.I graph_number
the current graph.
.I Graph_number
is an integer between 0 and MAXGRAPH (usually 10).
.IP \fB\-graphtype\fP\ [\fIgraph_type\fP]
Set the current graph type to 
.I graph_type.
Where
.I graph_type
is one of xy, logx, logy, logxy, or bar.
.IP \fB\-rvideo\fP
Exchange the color indices for black and white.
.IP \fB\-mono\fP
Ignore the number of available colors and use black and white on the display only.
.IP \fB\-GXinvert\fP
Set the write mode to INVERT for rubberband lines and focus markers.
.IP \fB\-GXxor\fP
Set the write mode to XOR for rubberband lines and focus markers.
.IP \fB\-dc\fP
Allow double click operations overriding resource settings.
.IP \fB\-nodc\fP
Disallow double click operations overriding resource settings.
.IP \fB\-redraw\fP
Allow redraw for refreshing the canvas when the display does not do backing store.
.IP \fB\-noredraw\fP
Do not do a redraw for refreshing the canvas when the display does not do backing store.
.IP \fB\-maxplot\fP\ [\fInumber_of_sets\fP]
Set the number of sets for each graph.
.IP \fB\-maxgraph\fP\ [\fInumber_of_graphs\fP]
Set the number of graphs for the current session.
.IP \fB\-source\fP\ [\fIdisk|pipe|source\fP]
Set source for the next data file,
the argument takes on the following values: 

   disk - Data file is on disk.
   pipe - Read from a pipe.
   stdin - ACE/gr is in a pipe, read from standard input.
   
   The setting selected here stays in effect until the next use of the -source command line option is given. This differs from earlier versions of ACE/gr.

.IP \fB\-world\fP\ [\fIxmin\ ymin\ xmax\ ymax\fP]
Set the user coordinate system of the current graph to a rectangle described by
.I (xmin, ymin) and (xmax, ymax).
.IP \fB\-view\fP\ [\fIxmin\ ymin\ xmax\ ymax\fP]
Set the viewport of the current graph to a rectangle described by
.I (xmin, ymin) and (xmax, ymax).
.IP \fB\-legend\ load\fP
When all sets have been read, copy the set comments (usually the file name from 
which the set was read) to the set legend labels and turn the legend on.
.IP \fB\-usage\fP
Display a brief explanation of command line settings
.LP
On startup,
.I ACE/gr
will look for a
.I .xmgrrc\ (XView)\ or\ .xmgrrc\ (Motif)
file in the users' home directory allowing the user to change the
default behavior of ACE/gr. The construction of the
.I .xmgrrc\ (XView)\ or\ .xmgrrc\ (Motif)
file is the same as for a parameter file.

.SH REFERENCE
.PP File formats

Note: all data are assumed to be delimited by tabs or blanks.

XY data sets:

   xy     ...   Multiple xy data sets composed of X and Y one point per line, data sets separated by
\'&' or some other non digit character (except '#' and '@', see below).

   nxy     ...   Multiple xy data sets composed of X and Y1 Y2 Y3 Y4 ... Y30. These data files may be concatenated as with the 'xy' format.

   xydx   ...   Multiple xy data sets composed of X Y DX one point per line,  data sets separated by
\'&' or some other non digit character. DX is the value that will be printed as an error relative to X,
i.e., the point will be plotted with an error bar at (x+-dx, y).

   xydy   ...   Multiple xy data sets composed of X Y DY one point per line,  data sets separated by
\'&' or some other non digit character. DY is the value that will be printed as an error relative to Y,
i.e., the point will be plotted with an error bar at (x, y+-dy). This is the usual file type for error
bars.

   xydxdx ...   Multiple xy data sets composed of X Y DX1 DX2 one point per line,  data sets separated by
\'&' or some other non digit character. DX1 and DX2 are the values of the error bars to be draw to the 
right and left of X respectively (assuming DX1 and DX2 are positive),
i.e., the point will be plotted with error bars at (x+dx1, y) and (x-dx2, y).

   xydydy ...   Multiple xy data sets composed of X Y DY1 DY2 one point per line,  data sets separated by
\'\&' or some other non digit character. DY1 and DY2 are the values of the error bars to be draw to the 
on the top and bottom of Y respectively (assuming DY1 and DY2 are positive),
i.e., the point will be plotted with error bars at (x, y+dy1) and (x, y-dy2).

   xydxdy ...   Multiple xy data sets composed of X Y DX DY one point per line,  data sets separated by
\'\&' or some other non digit character. DX and DY are the values of the error bars to be draw to the 
left and right of X and on the top and bottom of Y respectively (assuming DX and DY are positive),
i.e., the point will be plotted with error bars at (x+dx, y+dy) and (x-dx, y-dy).

For the xy, xydx, xydy, xydxdx, xydydy, xydxdy data file formats, sets are separated by a 
line containing non-numeric characters, that are neither comment lines (lines with a
\'#' in column 1) nor parameter lines (lines beginning with an '@').
Data files can have imbedded comments by placing a '#' in the first
column of the comment line. Plot parameters can be set by placing a '@' in
the first column of the line followed immediately by the parameter name
and setting as described in the format for parameter files. Comment lines
and parameter lines can occur at any place in the data file, and are not
used to indicate data set separators. I recommend a single '&' on a line
to use as a data set separator.

Block data file format.

    Block data files are composed of equal length columns. For example:

  1 2 3
  4 5 6
  7 8 9

is a block data file consisting of 3 columns. Each row is assumed to have the same number of entries.

.IP "Hot keys:"
When the mouse is on the canvas (where the graph is drawn), 
there are some shortcuts that can be taken to bring up several 
popups or perform certain operations. They are:

  ^A - autoscale plot
  ^B - draw a box (using the current settings for boxes)
  ^C - bring up the transformations popup
  ^D - delete an object (string, line, or box)
  ^E - bring up the edit points popup
  ^F - bring up the files popup
  ^G - bring up the define world/view popup
  ^L - locate the legend
  ^N - move an object (string, line, or box)
  ^P - draw a line (using the current settings for lines)
  ^R - bring up the files popup
  ^S - setops popup
  ^T - tics popup
  ^V - set the viewport with the mouse
  ^W - write a string (using the current settings for strings)
  ^X - exit ACE/gr
  ^Z - enable zoom

.RE
.IP \fBNOTE\fP:
.SH EXAMPLES

.PP
The following examples use xmgr, xvgr will provide similar results.

.PP
o   Read a single data file, autoscale axes, and use default settings:

unix% xmgr test.dat
.PP
o   Read a single data file and use plot parameters previously saved in the file
"test.par":

unix% xmgr test.dat -param test.par

or

unix% xmgr test.dat -p test.par
.PP
o   Read a data file and use plot parameters previously saved in the file
"test.par", read the output resulting from the execution of the
program "myprog test.dat":

unix% xmgr test.dat -pipe test.par -source pipe "myprog test.dat"
.PP
o   Read data from a pipe (the '-source pipe' as the last command line parameter tells xmgr
to read from STDIN), use parameter file "test2.par", use device 7 to use as the
hardcopy device, and ( -h ) don"t run interactive - just print and quit.

unix% awk "{print $4, $3}" mydata.dat | xmgr -device 2 -param test2.par -source stdin
.PP
o   Read data from a pipe (in this case a program running on a hypercube),
use parameter file "test2.par". The data will be X1, Y1, Y2, ..., Yn,
(from the -nxy). Override the settings in the parameter file
for the Y-axis and autoscale (the -autoscale), set the type of plot to linear-log
(the -log y).

unix% xmgr -param test2.par -nxy -source pipe "rsh ipsc2.oacis.org gdata" -autoscale y -log y

.SH AUTHOR
Paul Turner, Oregon Graduate Institute.
pturner@ese.ogi.edu.
.SH BUGS
.PP
There is no way to abort a plot.
