/*****************************************************************************
 * xlogo2.c: Display the X logo
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xol/OpenLook.h>
#include <Xol/Stub.h>
#include <X11/Xutil.h>
#include "xlogo64"

void     redisplay();
void     resize();
extern Pixmap create_logo();

typedef struct {
  Pixmap     pix;
  GC         gc;
  Dimension  width, height;
} pixmap_data;

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget       toplevel, canvas;
  Arg          wargs[10];
  int          n;
  XGCValues    values;
  pixmap_data  data;

  toplevel = OlInitialize(argv[0], "Xlogo", NULL, 0,
                          &argc, argv);
  /*
   * Create a widget in which to display the logo.
   */
  n = 0;
  XtSetArg(wargs[n], XtNexpose, redisplay); n++;
  XtSetArg(wargs[n], XtNresize, resize); n++;
  XtSetArg(wargs[n], XtNuserData, &data); n++;
  canvas = XtCreateManagedWidget("canvas",
                                 stubWidgetClass,
                                 toplevel, wargs, n);
 /*
  * Use the foreground and background colors
  * of the canvas to create a graphics context.
  */
  n = 0;
  XtSetArg(wargs[n], XtNforeground, &values.foreground); n++;
  XtSetArg(wargs[n], XtNbackground, &values.background); n++;
  XtGetValues(canvas, wargs, n);
  data.gc = XtGetGC(canvas, GCForeground | GCBackground, &values);
  /*
   * Create the pixmap conatinign the X logo. Store the
   * pixmap, as well as the size of the pixmap in the struct.
   */
  data.width = xlogo64_width;
  data.height = xlogo64_height;
  data.pix = create_logo(canvas, data.gc, xlogo64_bits,
                         xlogo64_width, xlogo64_height );

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

Pixmap
create_logo(w, gc, bits, width, height)
  Widget    w;
  char     *bits;
  Dimension width, height;
{
  Pixmap bitmap;
  /*
   * Create a bitmap containing the logo.
   */
  bitmap=XCreateBitmapFromData(XtDisplay(w),
                               RootWindowOfScreen(XtScreen(w)),
                               bits, width, height);
  return(bitmap);
}

void
redisplay (w, xevent, region)
  Widget        w;
  XEvent   *xevent;
  Region *region;
{
  Arg          wargs[3];
  int          n;
  Dimension    widget_width, widget_height;
  pixmap_data *data;

  /*
   * Get the current size of the widget window.
   */
  n = 0;
  XtSetArg(wargs[n], XtNwidth,  &widget_width); n++;
  XtSetArg(wargs[n], XtNheight, &widget_height); n++;
  XtSetArg(wargs[n], XtNuserData, &data); n++;
  XtGetValues(w, wargs, n);
  /*
   * Copy plane 1 of the bitmap to the center
   * of the window, using the widget's foreground
   * and background color.
   */
  XCopyPlane(XtDisplay(w), data->pix, XtWindow(w), data->gc,
             0, 0,  data->width, data->height,
             (int)(widget_width - data->width) / 2,
             (int)(widget_height - data->height) / 2, 1);
}

void
resize (w)
  Widget w;
{
  if(XtIsRealized(w))
    XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, TRUE);
}
