


OLVWMRC(5)                                             OLVWMRC(5)


NNAAMMEE
       olvwmrc  -  Resource file for the OPEN LOOK Virtual Window
       Manager

SSYYNNOOPPSSIISS
       $HOME/.olvwmrc

DDEESSCCRRIIPPTTIIOONN
        .olvwmrc is a file which controls advanced keybinding and
       menu  features  for  the  OPEN  LOOK Window Manager _o_l_v_w_m_.
       Four features of _o_l_v_w_m are controlled by entries  in  this
       file:

       LLooccaall VVaarriiaabblleess
              which can be used in key or screen bindings

       KKeeyy BBiinnddiinnggss
              which can map specific actions to function keys

       SSccrreeeenn BBiinnddiinnggss
              which  can  control  where certain applications are
              started

       WWIINNMMEENNUU
              entries which can control  the  behavior  of  items
              selected from the _o_l_v_w_m WINMENU menu.

       The syntax for each of these entries is given below.  Com-
       mon to all syntax entries is the notion  of  an  ``identi-
       fier'':   this  is  a string which somehow specifies which
       window(s) the given entry applies to.  When determining if
       a  particular  window  is affected by a particular rule in
       _._o_l_v_w_m_r_c_, _o_l_v_w_m first checks a window's WM_NAME to see  if
       it  matches the identifier listed in the rule.  This match
       is done only for the length of the identifier, so that the
       identifier  _M_a_i_l  will  match all windows which begin with
       the 4 letters Mail in their WM_NAME.   If  this  does  not
       match,  _o_l_v_w_m  next checks the instance and then the class
       fields of the window's WM_CLASS attribute to check  for  a
       possible  match.   If  a  match  is found for any of these
       fields, the window is affected by the given rule.  Case is
       significant in checking all matches.

       Identifiers  may contain any alpha-numeric characters; any
       other characters must be enclosed within quotes (single or
       double).   Thus,  _M_a_i_l  is a valid identifier, as is "_M_a_i_l
       _T_o_o_l" but _M_a_i_l _T_o_o_l is not.  Similarly, strings which  are
       to  be  executed should be enclosed in quotes if they con-
       tain non alpha-numeric characters.  Quotes may  be  nested
       in  strings,  so  that to start a clock with the label _f_o_o
       _b_a_r_,  you  would  specify   _'_c_l_o_c_k  _-_l_a_b_e_l   _"_f_o_o   _b_a_r_"_'.
       Finally, single quotes may be escaped with a backslash, so
       that the full WM_NAME of  DevGuide,  for  example,  should
       appear as _"_O_p_e_n_W_i_n_d_o_w_s _D_e_v_e_l_o_p_e_r_\_'_s _G_u_i_d_e_".



                         30 November 1992                       1





OLVWMRC(5)                                             OLVWMRC(5)


       All  whitespace  in this file is ignored; and lines begin-
       ning with a # are considered comments (but only if  the  #
       is in column 1).

VVaarriiaabblleess
       The  _._o_l_v_w_m_r_c file may define local variables by assigning
       a value to a legal variable name.  Variable names must  be
       made  up  of alphanumeric charcaters or the '_' character.
       Variable names may begin with a number and assignments may
       contain spaces either before of after the '=' operator.

       Variable  names  are  referenced by using _%_V_a_r_i_a_b_l_e_N_a_m_e or
       _%_{_V_a_r_i_a_b_l_e_N_a_m_e_}; %% will yield a single %.  Variable  ref-
       erences may appear as part of the definition of any key or
       screen binding.  Variable references may  also  appear  in
       assignment statements.

       In  addition to _o_l_v_w_m variables, environment variables may
       be used in the same contexts using the familiar  _$_N_A_M_E  or
       _$_{_N_A_M_E_} syntax; again, $$ will yield a single $.

       The following example illustrates the use of variables:

       #
       # Define screen size.
       #
       Xsize = '1136'
       Ysize = '798'

       WholeScreenSize = '%{Xsize}x%{Ysize}+3+3'

       #
       # Define file names.
       #
       FileName = '.olvwmrc'

       PathName = '$HOME/%FileName'

KKeeyy//AAccttiioonn BBiinnddiinnggss
       _o_l_v_w_m  can  be  made to perform a series of actions when a
       specific key is pressed.  The  key  can  be  any  valid  X
       keysym name and may be specified by itself or with any one
       or more of the following modifiers:  Shift, Control,  Alt,
       Meta,  Hyper,  Super,  Shift  Lock, or Caps Lock, in which
       case the key must be pressed with the given modifiers.

       The functionality for a key  specified  in  a  binding  in
       _._o_l_v_w_m_r_c  takes  precedence  over any other functions that
       key might perform. Thus, if you bind  the  L5  key  to  an
       action in _._o_l_v_w_m_r_c_, you will not be able to use the L5 key
       to bring windows to the front; if you bind the R8 key, you
       will  not  be  able to scroll up on the desktop using that
       key.  Since the unmodified versions of 29 of the  possible
       35  standard  function  keys on a type-4 keyboard (L1-L10,



                         30 November 1992                       2





OLVWMRC(5)                                             OLVWMRC(5)


       F1-F10, and R1-R15) already have a meaning  within  _o_l_v_w_m_,
       it  is  recommended that at least one modifier be used for
       keys in this manner so as not to conflict with  other  key
       meanings.

       There  are  thirteen valid actions which can be associated
       with a key:

       WWaarrpp   This action  requires  a  single  identifier.   The
              youngest  window  matching  this identifier will be
              located, and the view  into  the  desktop  will  be
              warped so that the found window is displayed on the
              screen.  The window itself will not change position
              relative to the other windows; merely the view into
              the desktop will be changed.  If no matching window
              is  found,  the  view  is  unchanged.  The mouse is
              moved into the matching window, and that window  is
              given input focus.

       OOppeenn   This  action  requires  a list of identifiers sepa-
              rated by commas.  Each  iconified  window  will  be
              matched against this list and those which match any
              identifier in the list will be opened.

       CClloossee  This action requires a list  of  identifiers  sepa-
              rated by commas.  Each non-iconified window will be
              matched against this list and those which match any
              identifier in the list will be closed.

       RRaaiissee  This  action  requires  a list of identifiers sepa-
              rated by  commas.   Each  window  will  be  matched
              against this list and those which match any identi-
              fier in the list will be raised.  Windows  will  be
              raised  youngest  first, so that the oldest windows
              in the list will end up on top.

       LLoowweerr  This action requires a list  of  identifiers  sepa-
              rated  by  commas.   Each  window  will  be matched
              against this list and those which match any identi-
              fier  in the list will be lowered.  Windows will be
              lowered youngest first, so that the oldest  windows
              in the list will end up on the bottom.

       RRaaiisseeLLoowweerr
              This  action  requires  a list of identifiers sepa-
              rated by  commas.   Each  window  will  be  matched
              against this list and those which match any identi-
              fier in the list will be raised to the top  of  the
              stack  if they are partially obscured or lowered to
              the bottom of the stack if they are on top.

       EExxeeccuuttee
              This action requires a list of  commands  separated
              by  commas.   Each  command  will be executed via a



                         30 November 1992                       3





OLVWMRC(5)                                             OLVWMRC(5)


              Bourne-shell in the same manner as  commands  given
              in  the  _o_l_v_w_m menu file [except that multiple com-
              mands may be listed in this case.]

       GGoottoo   This action requires a  single  integer  parameter,
              which  is  the  logical screen to which the desktop
              should warp when the given key(s) are pressed.

       QQuuiitt   This action requires a list  of  identifiers  sepa-
              rated  by  commas.   Each  window  will  be matched
              against this list and those which match any identi-
              fier in the list will be killed.

       GGeeoommeettrryy
              This  action  requires  a  single  identifier.  The
              identifier must be a valid X  geometry  string  but
              may  be partially specified (may only specify posi-
              tion or size).  This geometry will  be  applied  to
              the  current window.  If there is no current window
              this action will have no effect.

       RReebbiinndd This action optionally takes a filename  parameter.
              If  no  parameter is specified the normal search is
              performed  to  find  the  correct  version  of  the
              _._o_l_v_w_m_r_c  file  (as at startup).  If a parameter is
              given it is used as the _._o_l_v_w_m_r_c file.  All current
              key bindings are discarded and the _._o_l_v_w_m_r_c file is
              read.  If the _._o_l_v_w_m_r_c files  does  not  exist  the
              current key bindings are not discarded.

       SSttiicckk  This  action requires a single parameter which must
              be one of the following:  _O_L_V_W_M___U_S_E___S_E_L_E_C_T_I_O_N,  _o_n,
              _o_f_f,  _t_o_g_g_l_e,  or  a  list of window names.  If the
              parameter is either _O_L_V_W_M___U_S_E___S_E_L_E_C_T_I_O_N or  _t_o_g_g_l_e,
              the  sticky attribute of the current window will be
              toggled.  Similarly, if the parameter is a list  of
              window  names then those window's sticky attributes
              will be toggled.  The values _o_n and _o_f_f can be used
              to  explicitly  set  the  current  window's  sticky
              attribute.

       SSeettSSiizzee
              This action requires a single parameter which  must
              be one of the following: _O_L_V_W_M___U_S_E___S_E_L_E_C_T_I_O_N, _f_u_l_l,
              _s_a_v_e, _s_t_o_r_e, _r_e_s_t_o_r_e, _t_o_g_g_l_e, or a list  of  window
              names.   If the parameter is _O_L_V_W_M___U_S_E___S_E_L_E_C_T_I_O_N or
              _t_o_g_g_l_e, either the window's current  geometry  will
              be  saved  and its size will be set to full size or
              its saved geometry will be restored,  depending  on
              the  window's  current  state.   Similarly,  if the
              parameter is a list of window names then  the  same
              action  will  be  performed for those windows.  The
              parameter _s_a_v_e can be used to preserve the  current
              window's  geometry  such  that  a  restore size (or



                         30 November 1992                       4





OLVWMRC(5)                                             OLVWMRC(5)


              _t_o_g_g_l_e) will restore the windows position and size.
              Note that _s_a_v_e will only store the windows geometry
              if it has not already been  saved.   The  parameter
              _s_t_o_r_e will always save a windows geometry (possibly
              overwriting the  currently  saved  geometry).   The
              _r_e_s_t_o_r_e  parameter  will simply restore the current
              window's saved geometry (if it has one).

       FFooccuuss  This action requires a single parameter which  must
              be either _s_a_v_e or _r_e_s_t_o_r_e.  The _s_a_v_e parameter will
              cause the window with focus to be  remembered  such
              that a _r_e_s_t_o_r_e will restore focus to that window.

       These  actions  may  appear  in any order and will be per-
       formed in the reverse of the  order  specified.   Commands
       may  be  listed multiple times; this is useful in case you
       want a different stacking  order  than  that  obtained  by
       using  a  single raise command.  To do this, list separate
       raise commands for each window and put the  raise  command
       for the window you want to be on top first.

       The full syntax for a Key/Action binding is

              _K_e_y_N_a_m_e _{ _A_c_t_i_o_n_s _}

       A Key Name is a valid key (L1-L10, F1-F10, or R1-R15) fol-
       lowed by plus signs and the modifiers desired.

       For example, given the following entry:

       L2 + Shift {
           Warp: "OpenWindows Developer\'s Guide"
           Execute: '$OPENWINHOME/bin/xview/clock -label "foo bar"',
                 "$OPENWINHOME/bin/xview/iconedit"
           Raise: xterm, shelltool
       }


TThheenn wwhheenn SShhiifftt LL22 iiss pprreesssseedd,, tthhee ffoolllloowwiinngg wwiillll ooccccuurr::
       1)     The view will shift so that the  youngest  copy  of
              DevGuide is on the screen.

       2)     A  clock  will be started; its namestripe will con-
              tain foo bar.  The IconEditor will also be started.

       3)     All  xterms  and  shelltools  will be raised to the
              front of the stacking order.

SSccrreeeenn BBiinnddiinnggss
       _o_l_v_w_m can arrange to begin any application relative  to  a
       particular  logical  screen.   A ``logical screen'' is the
       area on the virtual desktop which maps to the size of your
       monitor;  in  the  VDM, each logical screen is outlined in
       dashed lines (unless  you've  turned  this  feature  off).



                         30 November 1992                       5





OLVWMRC(5)                                             OLVWMRC(5)


       Screens  are  numbered  by row starting with 1.  Note that
       the position of a logical screen will  vary  depending  on
       the  size  of  a desktop:  in the default (2x3) configura-
       tion, screen 4 is in the bottom left-hand  corner  of  the
       VDM  but  in  a  smaller (2x2) configuration, it is in the
       bottom right-hand corner.

       The syntax for specifying a screen binding is

              _S_c_r_e_e_n _# _{ _I_d_e_n_t_i_f_i_e_r_s _}

       where _# is the logical number of the  screen  and  _I_d_e_n_t_i_-
       _f_i_e_r_s  is a list of comma-separated window identifiers for
       windows which should always start on  that  screen.   Note
       that  it  is always possible to move the window to another
       screen later.

       For example, the following entry will ensure that the win-
       dows started by Sun's AnswerBook (windows with names Navi-
       gator and Viewer) will always start on screen 6:

       Screen 6 { Navigator, Viewer }


WWIINNMMEENNUU AAccttiioonnss
       When a window is selected in the WINMENU menu, _o_l_v_w_m  will
       perform  certain  actions.   The  possible actions are the
       same as those listed above for Key  Actions,  except  that
       the mouse position will not change on a warp.  By default,
       windows behave as if a warp, raise,  and  open  were  per-
       formed on the selected window.

       To effect a different action list for a particular window,
       you can specify

              Identifier { Actions }

       Each of these is a MenuGroup; one or  more  of  these  can
       appear in the following syntax:

              WINMENU { MenuGroups }

       For example, here is a possible entry:

       WINMENU {
           "File Manager" {
               Warp: "Mail Tool"
               Open: OLVWM_USE_SELECTION
           }
           xterm { }
           "Virtual Desktop" {
               Open: OLVWM_USE_SELECTION
               Execute: "$OPENWINHOME/bin/props"
           }



                         30 November 1992                       6





OLVWMRC(5)                                             OLVWMRC(5)


       }


       If you select the File Manager from your WINMENU, then the
       view will
       warp to your Mail Tool instead of your file  manager,  and
       your file manager, if closed, will be opened.  [This isn't
       that contrived an example: pretend your  file  manager  is
       sticky  and  your mail tool isn't, and you anticipate that
       you'll need to drag between the two.]

       If you select an xterm from your WINMENU, absolutely noth-
       ing will happen.  This implements a No-Op for that window.

       If you select the VDM from your WINMENU, it will be opened
       and the properties application will be started.

       Note  that  this  Identifier  list can contain the special
       entry _O_L_V_W_M___U_S_E___S_E_L_E_C_T_I_O_N  which,  as  you  might  expect,
       operates on the single window corresponding to the one you
       selected.  A subtle distinction exists  here:   given  the
       MenuGroup

              xterm { Raise:  xterm }

       then  ALL xterms will be raised when any xterm is selected
       via the WINMENU.  However, the entry

              xterm { Raise:  OLVWM_USE_SELECTION }

       will  raise  only  the  xterm  corresponding  to  the  one
       selected via the WINMENU.

RREESSOOUURRCCEESS AANNDD KKEEYY BBIINNDDIINNGGSS
       There  are  a  few  resources  which are particular to the
       operation of olvwmrc.


       VViirrttuuaallRReeRReeaadd _(_b_o_o_l_e_a_n_)
              When this resource is True, oollvvwwmm will re-read  the
              _._o_l_v_w_m_r_c  file  whenever it receives a Function Key
              event.  This will happen whenever a function key is
              pressed  in the VDM or on the root window, or when-
              ever a function key grabbed by  oollvvwwmm  is  pressed.
              _D_e_f_a_u_l_t _v_a_l_u_e_:  _T_r_u_e


       NNooVViirrttuuaallKKeeyy _(_l_i_s_t _o_f _w_i_n_d_o_w_s_)
              This  resource  disables the virtual keys set up in
              _._o_l_v_w_m_r_c for a particular window.  The list of win-
              dows  follows  the  same  syntax  as other resource
              lists like MinimalDecor and VirtualSticky.  When  a
              window  in  this  list  has the input focus and the
              user executes a key sequence which is mentioned  in



                         30 November 1992                       7





OLVWMRC(5)                                             OLVWMRC(5)


              _._o_l_v_w_m_r_c_,  that  key sequence will be passed to the
              application  rather  than  initiating  the  olvwmrc
              action.   Note  that this disabling applies only to
              bindings established via entries in _._o_l_v_w_m_r_c_;  nor-
              mal  oollvvwwmm  and  oollwwmm  bindings  are  not affected.
              _D_e_f_a_u_l_t _v_a_l_u_e_:  _N_o_n_e


       NNooVViirrttuuaallFFKKeeyy _(_l_i_s_t _o_f _w_i_n_d_o_w_s_)
              This resource is like NoVirtualKey,  but  only  the
              Function  keys  F1  to F10 will be disabled for the
              given window.  _D_e_f_a_u_l_t _v_a_l_u_e_:  _N_o_n_e


       NNooVViirrttuuaallLLKKeeyy _(_l_i_s_t _o_f _w_i_n_d_o_w_s_)
              This resource is like NoVirtualKey,  but  only  the
              keys  L1  to  L10  (which map to F11-F20 on non-Sun
              keyboards) will be disabled for the  given  window.
              _D_e_f_a_u_l_t _v_a_l_u_e_:  _N_o_n_e


       NNooVViirrttuuaallRRKKeeyy _(_l_i_s_t _o_f _w_i_n_d_o_w_s_)
              This  resource  is  like NoVirtualKey, but only the
              keys R1 to R15 will be disabled for the given  win-
              dow.  _D_e_f_a_u_l_t _v_a_l_u_e_:  _N_o_n_e

SSEEEE AALLSSOO
       olvwm(1), olwm(1)

NNOOTTEESS
       Please  see  the LEGAL_NOTICES file for full disclosure of
       copyright information and olvwm(1) for acknowledgments.

BBUUGGSS
       The multiple interfaces  for  NoVirtualKeys  is  something
       only a Wall Street trader could appreciate.





















                         30 November 1992                       8


