D			[0-9]
L			[a-zA-Z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%{
#include <stdio.h>
#include "y.tab.h"

#undef input
extern int input();

unsigned char yyfilename[256] = "stdin";
%}

%%

"#"			{ line_number(); }
"/*"			{ comment(); }

"auto"			{ return(AUTO); }
"break"			{ return(BREAK); }
"case"			{ return(CASE); }
"char"			{ return(CHAR); }
"const"			{ return(CONST); }
"continue"		{ return(CONTINUE); }
"default"		{ return(DEFAULT); }
"do"			{ return(DO); }
"double"		{ return(DOUBLE); }
"else"			{ return(ELSE); }
"enum"			{ return(ENUM); }
"extern"		{ return(EXTERN); }
"float"			{ return(FLOAT); }
"for"			{ return(FOR); }
"goto"			{ return(GOTO); }
"if"			{ return(IF); }
"int"			{ return(INT); }
"long"			{ return(LONG); }
"register"		{ return(REGISTER); }
"return"		{ return(RETURN); }
"short"			{ return(SHORT); }
"signed"		{ return(SIGNED); }
"sizeof"		{ return(SIZEOF); }
"static"		{ return(STATIC); }
"struct"		{ return(STRUCT); }
"switch"		{ return(SWITCH); }
"typedef"		{ return(TYPEDEF); }
"union"			{ return(UNION); }
"unsigned"		{ return(UNSIGNED); }
"void"			{ return(VOID); }
"volatile"		{ return(VOLATILE); }
"while"			{ return(WHILE); }

{L}({L}|{D})*		{ return(IDENTIFIER); }

0[xX]{H}+{IS}?		{ return(CONSTANT); }
0[xX]{H}+{IS}?		{ return(CONSTANT); }
0{D}+{IS}?		{ return(CONSTANT); }
0{D}+{IS}?		{ return(CONSTANT); }
{D}+{IS}?		{ return(CONSTANT); }
{D}+{IS}?		{ return(CONSTANT); }
'(\\.|[^\\'])+'		{ return(CONSTANT); }

{D}+{E}{FS}?		{ return(CONSTANT); }
{D}*"."{D}+({E})?{FS}?	{ return(CONSTANT); }
{D}+"."{D}*({E})?{FS}?	{ return(CONSTANT); }

\"(\\.|[^\\"])*\"	{ return(STRING_LITERAL); }

"..."                   { return(ELLIPSIS); }
">>="			{ return(RIGHT_ASSIGN); }
"<<="			{ return(LEFT_ASSIGN); }
"+="			{ return(ADD_ASSIGN); }
"-="			{ return(SUB_ASSIGN); }
"*="			{ return(MUL_ASSIGN); }
"/="			{ return(DIV_ASSIGN); }
"%="			{ return(MOD_ASSIGN); }
"&="			{ return(AND_ASSIGN); }
"^="			{ return(XOR_ASSIGN); }
"|="			{ return(OR_ASSIGN); }
">>"			{ return(RIGHT_OP); }
"<<"			{ return(LEFT_OP); }
"++"			{ return(INC_OP); }
"--"			{ return(DEC_OP); }
"->"			{ return(PTR_OP); }
"&&"			{ return(AND_OP); }
"||"			{ return(OR_OP); }
"<="			{ return(LE_OP); }
">="			{ return(GE_OP); }
"=="			{ return(EQ_OP); }
"!="			{ return(NE_OP); }
";"			{ return(';'); }
"{"			{ return('{'); }
"}"			{ return('}'); }
","			{ return(','); }
":"			{ return(':'); }
"="			{ return('='); }
"("			{ return('('); }
")"			{ return(')'); }
"["			{ return('['); }
"]"			{ return(']'); }
"."			{ return('.'); }
"&"			{ return('&'); }
"!"			{ return('!'); }
"~"			{ return('~'); }
"-"			{ return('-'); }
"+"			{ return('+'); }
"*"			{ return('*'); }
"/"			{ return('/'); }
"%"			{ return('%'); }
"<"			{ return('<'); }
">"			{ return('>'); }
"^"			{ return('^'); }
"|"			{ return('|'); }
"?"			{ return('?'); }

[ \t\v\n\f]		{ }
.			{ /* ignore bad characters */ }

%%

int yycolumn = 0;

yywrap()
{
	return(1);
}

int input()
{
	if (yysptr > yysbuf) {
		/* retrieve pushed-back character */
		yytchar = *--yysptr;
	} else {
		yytchar = getc(yyin);
		if (yytchar == EOF) {
			return 0;
		} 
	}

	/* count yycolumn and yylineno */
	if (yytchar == '\n') {
		yylineno++;
		yycolumn = 0;
	} else if (yytchar == '\t') {
		yycolumn += 8 - (yycolumn % 8);
	} else {
		yycolumn++;
	}

	return yytchar;
}

comment()
{
	char c, c1;

loop:
	/* we have already seen a / and a * */
	while ((c = input()) != '*' && c != 0) /* NOTHING */;

	if (c != 0 && (c1 = input()) != '/' )
	{
		unput(c1);
		goto loop;
	}
}

#define READWHILE(cond)	while(cond) c = input();
line_number()
{
	char c;
	/* skip spaces */
	c = input();
	READWHILE ((c == ' ' || c == '\t'));

	if (c >= '0' && c <= '9') {
		/* line number specification */
		int line_num = 0;
		while (c >= '0' && c <= '9') {
			line_num = line_num * 10 + c - '0';
			c = input();
		}
		if (line_num > 0)
		    yylineno = line_num - 1;
		READWHILE ((c == ' ' || c == '\t'));
		if (c == '"') {
			unsigned char *yf = yyfilename;
			do {
				*yf++ = c;
				c = input();
			} while (c != '"');
			*yf++ = c;
			*yf = '\0';
		}
	}

	/* flush rest of line */
	READWHILE ((c != '\n'));
}
