.\" $Header: /disk3/npm/src/winterp/doc/RCS/winterp.man,v 2.3 1994/06/08 18:45:48 npm Exp $
.\" Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
.\" WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
.\" WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Enterprise Integration Technologies,
.\" Hewlett-Packard Company, or Niels Mayer not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission. Enterprise Integration Technologies, Hewlett-Packard
.\" Company, and Niels Mayer makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express or
.\" implied warranty.
.\" 
.\" ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
.\" INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
.\" FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"  
.TH WINTERP 1 "June 6, 1994" "X11r6 contrib"
.SH NAME
WINTERP - An object-oriented rapid prototyping, development and delivery environment for building extensible applications with the OSF/Motif UI Toolkit and Xtango-based graphics/animation. (Version 2.0)
.SH SYNOPSIS
.B winterp
[\fB\-class <classname>\fP]
[\fB\-init_file <file.lsp>\fP]
[\fB\-transcript_file <file.out>\fP]
[\fB\-lib_dir <path\-to\-load\-dir>\fP]
[\fB\-load_path <:\-separated\-list\-of\-paths\-to\-load\-dir>\fP]
[\fB\-no_init_msgs\fP]
[\fB\-enable_init_msgs\fP]
[\fB\-init_message <string>\fP]
[\fB\-no_xterr_brk\fP]
[\fB\-enable_xterr_brk\fP]
[\fB\-no_xtwarn_brk\fP]
[\fB\-enable_xtwarn_brk\fP]
[\fB\-no_xerr_brk\fP]
[\fB\-enable_xerr_brk\fP]
[\fB\-no_stdin_server\fP]
[\fB\-enable_stdin_server\fP]
[\fB\-serv_port <portnum>\fP]
[\fB\-serv_name <servname>\fP]
[\fB\-no_inet_server\fP]
[\fB\-enable_inet_server\fP]
[\fB\-no_unix_server\fP]
[\fB\-enable_unix_server\fP]
[\fB\-unix_socket_file <socket\-filepath>\fP]
[\fB ... X\-Toolkit\-options ... \fP]
.SH DESCRIPTION

\-\-\->> FOR DETAILS ON WINTERP SEE /usr/local/winterp/doc/winterp.doc <<\-\-\-

WINTERP is a Widget INTERPreter, an application development environment
enabling rapid prototyping of graphical user\-interfaces (GUI) through the
interactive programmatic manipulation of user interface objects and their
attached actions. The interpreter, based on David Betz, Tom Almy, et al's
XLISP\-PLUS, provides an interface to the X11 toolkit Intrinsics, the
OSF/Motif widget set, primitives for collecting data from UN*X processes,
and facilities for interacting with other UN*X processes. WINTERP thus
supports rapid prototyping of GUI\-based applications by allowing the user
to interactively change both the UI appearance and application
functionality. These features make WINTERP a good tool for learning and
experimenting with the capabilities of the OSF/Motif UI toolkit, allowing
UI designers to more easily play "what if" games with different interface
styles.
.PP
WINTERP is also an excellent platform for delivering extensible or
customizable applications. By embedding a small, efficient language
interpreter with UI primitives within the delivered application, users and
system integrators can tailor the static and dynamic layout of the UI,
UI\-to\-application dialogue, and application functionality. WINTERP's use of
a real programming language for customization allows WINTERP\-based
applications to be much more flexible than applications using customization
schemes provided by the X resource database, OSF/Motif's UIL (user
interface language), and resource\-based languages such as WCL.
.PP
An environment similar to WINTERP's already exists in the Gnu\-Emacs text
editor \-\- WINTERP was strongly influenced by Gnu\-Emacs' successful design.
In Gnu\-Emacs, a mini\-Lisp interpreter is used to extend the editor to
provide text\-browser style interfaces to a number of UN*X applications
(e.g. e\-mail user agents, directory browsers, debuggers, etc). Whereas
Emacs\-Lisp enables the creation of new applications by tying together
C\-implemented primitives operating on text\-buffer UI objects, WINTERP\-Lisp
ties together operations on graphical UI objects implemented by the Motif
widgets. Both achieve a high degree of customizability that is common for
systems implemented in Lisp, while still attaining the speed of execution
and (relatively) small size associated with C\-implemented applications.
.PP
Other features:
.TP 5
\-\->
WINTERP is free software \-\- available via anonymous ftp from ftp.x.org.
.TP 5
\-\->
Portable \-\- runs without porting on many Unix systems.	
.TP 5
\-\->
Interface to GNU Emacs' lisp\-mode allows code to be developed
and tested without leaving the editor.
.TP 5
\-\->
Interactive programing also available in the "WINTERP Control Panel",
with editing taking place in a Motif text widget controlled by
WINTERP.
.TP 5
\-\->
Built\-in RPC mechanism for inter\-application communications;
.TP 5
\-\->
XLISP provides a simple Smalltalk\-like object system.
.TP 5
\-\->
OSF/Motif widgets are real XLISP objects \-\- widgets can be
specialized via subclassing, methods added or altered, etc.
.TP 5
\-\->
Automatic storage management of all Motif/Xt/X data.
.TP 5
\-\->
Contains facilities for "direct manipulation" of UI components;
.PP
The WINTERP 2.0 release includes the following new features:
.TP 5
\-\->
High\-level, object\-oriented 2.5D graphics/animation package featuring
pixel\-independent/resizeable/scalable rendering, path\-transition
animation, and high\-level animation operators. This is based on
Stasko&Hayes' Xtango system.
.TP 5
\-\->
Asynchronous subprocess facility enables non\-blocking GUI
interfaces to existing interactive unix commands and interactive
network services. Enables use of multiple asynchronous subprocesses.
.TP 5
\-\->
New XmGraph widget for creating directed acyclic graphs, trees, and
direct\-manipulation displays.
.TP 5
\-\->
New Table widget allows constraint\-based GUI static layout
using tbl(1)\-style specifications.
.TP 5
\-\->
Uses XLISP\-PLUS version 2.1c \-\- more functionality, better subset of
Common Lisp, e.g. good support for sequence operators.
.TP 5
\-\->
Support for OSF/Motif 1.2.*
.TP 5
\-\->
GIF Image Support.
.TP 5
\-\->
Many new examples, improved example WINTERP applications.
.TP 5
\-\->
Major code cleanups, bugfixes, etc.

.SH OPTIONS

.BI [\-class <classname>]:

This optional argument pair must occur first in the list of command\-line
arguments. This argument pair tells winterp the name of the application
defaults file to use (e.g.  /usr/lib/X11/app\-defaults/<Classname>, and also
sets the default class for all WINTERP top level shells. Note that
<classname> should begin with a capital letter. If no [\-class <classname>]
parameter is given, the application 
.I winterp
will default to class
"Winterp" and will look for an application\-default file in
/usr/lib/X11/app\-defaults/Winterp.

.BI [... X\-toolkit\-options ...]:

.I winterp
works just like a standard Xtoolkit/Motif application,
and handles all the command line options allowed by the Xtoolkit,
e.g. \-bg, \-fg, \-font \-display, \-geometry, \-iconic, \-title, \-name,
\-xrm, etc...  For more information on these options, see the X11r4
document "X Toolkit Intrinsics \-\- C Language Interface" chapter 2.3
"Parsing the Command Line". Alternately, see the appropriate watered down
documentation provided in the Motif users guide.

.BI [\-init_file <file.lsp>]:

this optional argument tells WINTERP to load the Winterp\-Lisp file
<file.lsp> upon startup. Setting this argument pair does the same thing as
supplying the resource "Winterp.lispInitFile: <file.lsp>".

.BI [\-lib_dir <path\-to\-load\-dir>]:

this optional argument pair sets the default path used by the Xlisp LOAD
and REQUIRE primitive for loading files that are not qualified by a
directory path.  Setting this argument pair does the same thing as
supplying the resource "Winterp.lispLibDir: <path\-to\-load\-dir>".

.BI [\-load_path <:\-separated\-list\-of\-paths\-to\-load\-dir>]:

this optional argument pair sets the search path used by LOAD and REQUIRE
primitive for loading files without fully qualified pathnames.  Setting
this argument pair does the same thing as supplying the resource
"Winterp.lispLoadPath: <:\-separated\-list\-of\-paths\-to\-load\-dir>".

.BI [\-transcript_file <file.out>]:

this optional argument sets the file used by the Xlisp DRIBBLE
primitive. Setting this argument pair does the same thing as supplying the
resource "Winterp.lispTranscriptFile: <file.out>".

.BI [\-no_init_msgs]:

specifying this argument prevents WINTERP from printing initialization
messages to the standard output.  Setting this argument does the same thing
as supplying the resource "Winterp.enableInitMsgs: false".

.BI [\-enable_init_msgs]:

specifying this argument enables printing of initialization messages from
WINTERP \-\- this is enabled by default.  Setting this argument does the same
thing as supplying the resource "Winterp.enableInitMsgs: true".

.BI [\-init_message <string>]:

Specifies the string displayed in the WINTERP "default window" which
flashes on the screen when WINTERP start up.  Setting this argument does
the same thing as supplying the resource <<Winterp.initMessageString:
<string>>>.

NOTE: display of initialization message\-box is is not disabled by
"enableInitMsgs: FALSE"

.BI [\-no_xterr_brk]:

specifying this argument will cause WINTERP not to call an XLISP
break when the Xtoolkit signals an error (via XtError()); when this
argument is specified, Xtoolkit errors will print an error message
on stderr and cause WINTERP to exit. Setting this argument does the
same thing as supplying the resource "Winterp.enableXtErrorBreak:
false".

.BI [\-enable_xterr_brk]:

specifying this argument will cause WINTERP to call an XLISP break when the
Xtoolkit signals an error (via XtError()) \-\- this is enabled by
default. When this argument is specified, Xtoolkit errors will print an
error message and signal a Lisp error \-\- the Lisp call\-sequence (or
callback) that caused the error will terminate, however WINTERP will be
able to execute other callbacks, input from the XLISP eval\-server,
etc. Setting this argument does the same thing as supplying the resource
"Winterp.enableXtErrorBreak: true".

.BI [\-no_xtwarn_brk]:

specifying this argument will cause WINTERP not to call an XLISP break when
the Xtoolkit gives a warning (via XtWarning()); when this argument is
specified, Xtoolkit warnings will print an error message on stderr and
continue executing. Setting this argument does the same thing as supplying
the resource "Winterp.enableXtWarningBreak: false".

.BI [\-enable_xtwarn_brk]:

specifying this argument will cause WINTERP to call an XLISP break when the
Xtoolkit gives a warning (via XtWarning()) \-\- this is enabled by
default. When this argument is specified, Xtoolkit warnings will print an
error message and signal a Lisp error \-\- the Lisp call\-sequence (or
callback) that caused the error will terminate, however WINTERP will be
able to execute other callbacks, input from the XLISP eval\-server,
etc. Setting this argument does the same thing as supplying the resource
"Winterp.enableXtWarningBreak: true".

.BI [\-no_xerr_brk]:

specifying this argument will cause WINTERP not to call an XLISP break when
the X library/server signals an error (via XError()); when this argument is
specified, X errors will print an error message on stderr and cause WINTERP
to exit. Setting this argument does the same thing as supplying the
resource "Winterp.enableXErrorBreak: false".

.BI [\-enable_xerr_brk]:

specifying this argument will cause WINTERP to call an XLISP break when the
X signals an error (via XError()) \-\- this is enabled by default. When this
argument is specified, X errors will print an error message and signal a
Lisp error \-\- the Lisp call\-sequence (or callback) that caused the error
will terminate, however WINTERP will be able to execute other callbacks,
input from the XLISP eval\-server, etc. Setting this argument does the same
thing as supplying the resource "Winterp.enableXErrorBreak: true".

.BI [\-no_stdin_server]:

specifying this argument disables WINTERP's stdin eval\-server.  Setting
this argument does the same thing as supplying the resource
"Winterp.enableStdinServer: false". Disabling the stdin server might be
desired for standalone WINTERP\-based applications, or to prevent errors on
systems that don't support XtAppAddInput() on stdin.

.BI [\-enable_stdin_server]:

specifying this argument enables WINTERP's stdin eval\-server, which means
that WINTERP/XLISP will attempt to interactively evaluate s\-expressions
typed into WINTERP's controlling terminal. Setting this argument does the
same thing as supplying the resource "Winterp.enableStdinServer: true".

.BI [\-no_unix_server]:

specifying this argument disables WINTERP's Unix Domain Socket eval\-server.
Setting this argument does the same thing as supplying the resource
"Winterp.enableUnixServer: false".

.BI [\-enable_unix_server]:

specifying this argument enables WINTERP's Unix Domain Socket eval\-server
\-\- this is the default.  Setting this argument does the same thing as
supplying the resource "Winterp.enableUnixServer: true".

.BI [\-unix_socket_file <socket\-filepath>]:

specifying this argument pair sets the Unix Domain Socket specified by
<socket\-filepath>.  By default, <socket\-filepath> is "/tmp/.winterp_serv",
you may want to specify a different <socket\-filepath> if multiple 
.I winterp
applications are running. Alternately, you may want to hide the Unix Domain
Socket from other users if you are on a multi\-user machine.  Setting this
argument does the same thing as supplying the resource
"Winterp.unixSocketFilepath: <socket\-filepath>". Note that specifying 
environment variable WINTERP_UNIX_SOCKET_FILEPATH overrides this command
line argument (as well as resource ".unixSocketFilepath").

.BI [\-no_inet_server]:

specifying this argument disables WINTERP's TCP/IP eval\-server \-\- this is
the default.  Setting this argument does the same thing as supplying the
resource "Winterp.enableInetServer: false".

.BI [\-enable_inet_server]:

specifying this argument enables WINTERP's TCP/IP
eval\-server. Setting this argument does the same thing as supplying
the resource "Winterp.enableInetServer: true".

.BI [\-serv_port <portnum>]:

setting this optional argument pair does the same thing as supplying the
resource "Winterp.servicePort: <portnum>" Note that specifying environment
variable WINTERP_INET_PORTNUM overrides this command line argument (as well
as resource ".servicePort").

.BI [\-serv_name <servname>]:

setting this optional argument pair does the same thing as supplying the
resource "Winterp.serviceName: <portnum>"

.SH AVAILABILITY:
You may obtain the latest released version of the WINTERP source,
documentation, and examples via anonymous ftp from internet host ftp.x.org
in directory /contrib/devel_tools, file winterp\-2.xx.tar.gz, where 'xx'
represents the revision number. Directory /contrib/devel_tools/winterp
contains slides, papers, further documentation, contributed code, etc.
.PP
An automated reply indicating the locations and status of the latest
WINTERP source may be obtained by sending an e\-mail message to
winterp\-source@netcom.com.

.SH CONTACTING OTHER USERS
winterp@netcom.com is the mailing list for WINTERP\-related announcements
and discussions. To get added/removed from the list, send mail to
winterp\-request@netcom.com. Please do not send junk mail or
subscribe/unsubscribe messages to the mailing list winterp@netcom.com.
.PP
For discussions about XLISP, see the USENET newsgroup comp.lang.lisp.x.
.SH SEE ALSO
wl(1), wl\-tcpip(1).
.SH FILES
/usr/lib/X11/app\-defaults/Winterp
/usr/local/winterp/examples/*.lsp
/usr/local/winterp/doc/winterp.doc
/usr/local/winterp/doc/xlisp.doc
/usr/local/winterp/doc/XlispRef.doc
/usr/local/winterp/doc/XlispRef.doc
/usr/local/winterp/doc/XlispImpl.doc
$HOME/.Xdefaults
$HOME/.winterp
$HOME/.winterpapp
.SH AUTHOR
Niels Mayer (mayer@netcom.com)
