/***************************************************************************\
 *
 * PROGRAMMNAME: AMouse
 * -------------
 *
 * VERSION: 2.70
 * --------
 *
 * MODULNAME: AMouData.H
 * ----------
 *
 * BESCHREIBUNG:
 * -------------
 *   Header-Datei fr AMouData.C
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  1.00    20-02-00  First release
 *  2.00    06-16-01  WheelThread in separate process
 *  2.10    05-12-02  Handling of shift-keys
 *  2.20    10-03-02  USB support added
 *  2.40    02-01-03  support for 2 wheels; wildcards for process name
 *  2.50    04-20-03  application behaviour support added
 *  2.60    06-13-04  remove unused settings pages from mouse object
 *  2.70    10-23-04  support for 7 buttons added
 *
 *  Copyright (C) noller & breining software 2001...2004
 *
\******************************************************************************/
#ifndef AMOUDATA_H
#define AMOUDATA_H

#include "AMouseGlobal.h"

typedef struct
    {
    HWND    hwnd;
    ULONG   flWindow;
    } WINDOWDATA, *PWINDOWDATA;

//#define CULMAXWND  (0x1000 - 2*sizeof(PULONG))/sizeof(WINDOWDATA)
//
//struct arHwnd
//    {
//    struct arHwnd *parHwndNext;
//    struct arHwnd *parHwndLast;
//    WINDOWDATA     strWindow[CULMAXWND];
//    } _ARHWND;
//
//typedef struct arHwnd ARHWND, *PARHWND;

typedef struct _ARHWND
    {
    ULONG       ulcHwnd;                // number of entries in the array
    WINDOWDATA  arWindow[1];            // array of WINDOWDATA structures
    } ARHWND, *PARHWND;


extern HMODULE hModule;
extern HAB     hab;

extern PMOUSEDATA pShMemMouseData;
extern HMTX       hmtxWheelThread;      // semaphore for synchronisation of pShMem
extern HEV        hevWheelThreadUpdate; // semaphore for updating data in strucMouseData
extern HEV        hevXWPWidgetUpdate;   // semaphore for updating XCenter Widget

#endif /* AMOUDATA_H */
