
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.24
 */


/***************************************************************************\
 *
 * PROGRAMMNAME: AMOUSE
 * -------------
 *
 * VERSION: 2.80
 * --------
 *
 * MODULNAME: AMOUSE
 * ----------
 *
 * BESCHREIBUNG:
 * -------------
 *   SOM-Methoden
 *
 * FUNKTIONEN:
 * -----------
 *
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  1.00    20-02-00  First release
 *  2.00    06-16-01  WheelThread in separate process
 *  2.10    05-12-02  Handling of shift-keys
 *  2.20    10-03-02  USB support added
 *  2.40    02-01-03  support for 2 wheels; wildcards for process name
 *  2.50    04-20-03  application behaviour support added
 *  2.60    06-13-04  remove unused settings pages from mouse object
 *  2.70    10-23-04  support for 7 buttons added
 *  2.80    10-02-06  support of arbitary key combinations
 *
 *  Copyright (C) noller & breining software 2001...2006
 *
\******************************************************************************/
#define INCL_WIN
#define INCL_DOS
#define INCL_DOSERRORS

#ifndef SOM_Module_amouse_Source
#define SOM_Module_amouse_Source
#endif
#define AMouse_Class_Source
#define M_AMouse_Class_Source

#include <os2.h>
#include <bsedev.h>
#include <stdio.h>
#include <string.h>

#include <cutil.h>

#pragma info(noeff)         // suppress SOM compiler informationals

#include "AMouseGlobal.h"
#include "AMouse.ih"

#include "AMouseData.h"
#include "dialogs.h"
#include "res.h"
#include "dlg.h"
#include "panel.h"
#include "common.h"
#include "CommonDlg.h"
#include "debug.h"

#define TITLELEN      80                    // Length of title in message box

/*
 *   Non-Method function prototypes
 */
ULONG setPageinfo (AMouse *somSelf, HWND hwndNotebook, PFNWP pfnwp, USHORT dlgId,
                   USHORT usPageStyleFlags, USHORT usPageInsertFlags, ULONG ulPageId,
                   USHORT stringId, USHORT panelId, ULONG ulPageType);

/***************** GLOBAL/STATIC (NON-INSTANCE) DATA SECTION ******************
*****                                                                     *****
*****    This data shouldn't be changed by instance methods or it will    *****
*****    effect all instances!  Any variables that are specific (unique   *****
*****    values) for each instance of this object should be declared as   *****
*****  instance data or dynamically allocated and stored as window data.  *****
*****                                                                     *****
*****      This global data should be declared as class instance data     *****
*****    if it will change after initialization.  In this case, it will   *****
*****                  be accessed through class methods.                 *****
*****                                                                     *****
******************************************************************************/
HEV   hevWheelThreadUpdate = NULLHANDLE;    // semaphore to notice wheel thread of updated data

/* method apply stub for AMouseX_RemoveUnusedMousePage */
static void SOMLINK somAP_AMouseX_RemoveUnusedMousePage (SOMObject *somSelf,
                                                         void *__retVal,
                                                         somMethodProc *__methodPtr,
                                                         va_list __ap)
    {
    SOMObject *__somSelf = va_arg (__ap, SOMObject *);
    HWND       __hwnd    = va_arg (__ap, HWND);

    SOM_IgnoreWarning (somSelf);
    SOM_IgnoreWarning (__retVal);

    ((somTD_AMouse_RemoveUnusedMousePage)__methodPtr)(__somSelf, __hwnd);

    return;
    }

ULONG setPageinfo (AMouse *somSelf, HWND hwndNotebook, PFNWP pfnwp, USHORT dlgId,
                   USHORT usPageStyleFlags, USHORT usPageInsertFlags, ULONG ulPageId,
                   USHORT stringId, USHORT panelId, ULONG ulPageType)
    {
    PCREATEDATA pCreateData;
    PAGEINFO    pageinfo;
    CHAR        szPageName[CCHMAXPGNAME];

    pCreateData = (PCREATEDATA)_wpAllocMem (somSelf, sizeof (CREATEDATA), NULL);
    pCreateData->cb         = sizeof (CREATEDATA);
    pCreateData->somObject  = somSelf;
    pCreateData->ulPageType = ulPageType;

    WinLoadString (hab, hmodLng, stringId, CCHMAXPGNAME, szPageName);
    memset ((PCH)&pageinfo, 0, sizeof (PAGEINFO));

    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.pfnwp              = pfnwp;
    pageinfo.resid              = hmodLng;
    pageinfo.pCreateParams      = pCreateData;
    pageinfo.dlgid              = dlgId;
    pageinfo.usPageStyleFlags   = BKA_STATUSTEXTON | usPageStyleFlags;
    pageinfo.usPageInsertFlags  = usPageInsertFlags;
    pageinfo.ulPageInsertId     = ulPageId;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pszName            = (usPageStyleFlags & BKA_MAJOR) ? szPageName : NULL;
    pageinfo.idDefaultHelpPanel = panelId;
    pageinfo.pszHelpLibraryName = szHelpFile;
    pageinfo.hmodHelpSubtable   = hmodLng;

    return _wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo);
    }

/*
 * METHOD: AddDeviceInfoPage                              ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddDeviceInfoPage (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddDeviceInfoPage");

    if (bIsWarp4)
        dlgId = IDD_DEVICEINFO_40;
    else
        dlgId = IDD_DEVICEINFO;

    return setPageinfo (somSelf,
                        hwndNotebook,
                        DeviceInfoDlgProc,
                        dlgId,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        BKA_FIRST,
                        0,
                        IDS_PAGENAME_DEVINFO,
                        PANEL_DEVICEINFO,
                        0);
    }

/*
 * METHOD: AddWlDeviceInfoPage                            ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the wireless device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddWlDeviceInfoPage (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId, ulPageId;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddWlDeviceInfoPage");

    if (bIsWarp4)
        dlgId = IDD_WLDEVICEINFO_40;
    else
        dlgId = IDD_WLDEVICEINFO;

    ulPageId = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (NULLHANDLE), MPFROM2SHORT (BKA_FIRST, BKA_MAJOR));
    if (ulPageId)
        {
        /* position after "device info" tab */
        if (ulPageId)
            {
            ulPageId = setPageinfo (somSelf,
                                    hwndNotebook,
                                    WlDeviceInfoDlgProc,
                                    dlgId,
                                    BKA_MINOR,
                                    BKA_NEXT,
                                    ulPageId,
                                    IDS_PAGENAME_DEVINFO,
                                    PANEL_WLDEVICEINFO,
                                    0);
            }
        }

    return ulPageId;
    }

SOM_Scope ULONG SOMLINK AMouseX_wpAddMouseMappingsPage (AMouse *somSelf, HWND hwndNotebook)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpAddMouseMappingsPage");

    if (hmodLng)
        {
        _AddKeySettings2Page (somSelf, hwndNotebook);

        if (checkForWheelMouse (hmodLng))
            {
            _AddKeySettings1Page (somSelf, BTNPAGE_ALT,  hwndNotebook);
            _AddKeySettings1Page (somSelf, BTNPAGE_CTRL, hwndNotebook);
            _AddKeySettings1Page (somSelf, BTNPAGE_NONE, hwndNotebook);
            }
        }

    return AMouse_parent_WPMouse_wpAddMouseMappingsPage (somSelf, hwndNotebook);
    }

/*
 * METHOD: AddKeySettingsPage                             ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
/*
 * METHOD: AddKeySettings1Page                            ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the key setings 1 page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddKeySettings1Page (AMouse *somSelf,
                                                     ULONG ulBtnPageType,
                                                     HWND hwndNotebook)
    {
    ULONG dlgId;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddKeySettings1Page");

    if (bIsWarp4)
        dlgId = IDD_KEYSETTINGS1_40;
    else
        dlgId = IDD_KEYSETTINGS1;

    return setPageinfo (somSelf,
                        hwndNotebook,
                        KeySettings1DlgProc,
                        dlgId,
                        BKA_MINOR,
                        BKA_FIRST,
                        0,
                        IDS_PAGENAME_BUTTONS,
                        PANEL_KEYSETTINGS1,
                        ulBtnPageType);
    }

/*
 * METHOD: AddKeySettings2Page                            ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the key settings 2 page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddKeySettings2Page (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug("AMouse","AMouseX_AddKeySettings2Page");

    if (bIsWarp4)
        dlgId = IDD_KEYSETTINGS2_40;
    else
        dlgId = IDD_KEYSETTINGS2;

    return setPageinfo (somSelf,
                        hwndNotebook,
                        KeySettings2DlgProc,
                        dlgId,
                        BKA_MINOR,
                        BKA_FIRST,
                        0,
                        IDS_PAGENAME_BUTTONS,
                        PANEL_KEYSETTINGS2,
                        0);
    }

/*
 * METHOD: AddWheelSettings1Page                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddWheelSettings1Page (AMouse *somSelf,
                                                       ULONG ulWheelPageType,
                                                       HWND hwndNotebook)
    {
    ULONG dlgId, ulPageId1, ulPageId2, ulIndex;
    ULONG ulcMajor;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddWheelSettings1Page");

    if (bIsWarp4)
        dlgId = IDD_WHEELSETTINGS1_40;
    else
        dlgId = IDD_WHEELSETTINGS1;

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            ulcMajor = 3;
            break;

        default:
            ulcMajor = 4;
        }

    ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (NULLHANDLE), MPFROM2SHORT (BKA_FIRST, BKA_MAJOR));
    if (ulPageId1)
        {
        /* position after specific major tab */
        for (ulIndex = 0; ulIndex < ulcMajor; ulIndex++)
            ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MAJOR));
        if (ulPageId1)
            {
            /* position after last minor tab inside specific major tab */
            while (ulPageId1)
                {
                ulPageId2 = ulPageId1;
                ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MINOR));
                }
            if (ulPageId2)  // ulPageId1 is already NULLHANDLE at this point
                ulPageId1 = setPageinfo (somSelf,
                                         hwndNotebook,
                                         WheelSettings1DlgProc,
                                         dlgId,
                                         ((ulWheelPageType == WHEELPAGE_NONE) ? BKA_MAJOR : BKA_MINOR),
                                         BKA_NEXT,
                                         ulPageId2,
                                         IDS_PAGENAME_WHEEL,
                                         PANEL_WHEELSETTINGS1,
                                         ulWheelPageType);
            }
        }

    DebugULx (D_SOM, "_AddWheelSettings1Page", "ulPageId1 = ", ulPageId1);

    return ulPageId1;
    }

/*
 * METHOD: AddWheelSettings2Page                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddWheelSettings2Page (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId, ulPageId1, ulPageId2, ulIndex;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddWheelSettings2Page");

    if (bIsWarp4)
        dlgId = IDD_WHEELSETTINGS2_40;
    else
        dlgId = IDD_WHEELSETTINGS2;

    ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (NULLHANDLE), MPFROM2SHORT (BKA_FIRST, BKA_MAJOR));
    if (ulPageId1)
        {
        /* position after first "wheel" tab */
        for (ulIndex = 0; ulIndex < 4; ulIndex++)
            ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MAJOR));
        if (ulPageId1)
            {
            /* position after last minor tab inside specific major tab */
            while (ulPageId1)
                {
                ulPageId2 = ulPageId1;
                ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MINOR));
                }
            if (ulPageId2)  // ulPageId1 is already NULLHANDLE at this point
                ulPageId1 = setPageinfo (somSelf,
                                         hwndNotebook,
                                         WheelSettings2DlgProc,
                                         dlgId,
                                         BKA_MINOR,
                                         BKA_NEXT,
                                         ulPageId2,
                                         IDS_PAGENAME_WHEEL,
                                         PANEL_WHEELSETTINGS2,
                                         0);
            }
        }

    return ulPageId1;
    }

/*
 * METHOD: AddWheelSettings3Page                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the device info page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddWheelSettings3Page (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId, ulPageId1, ulPageId2, ulIndex;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddWheelSettings3Page");

    if (bIsWarp4)
        dlgId = IDD_WHEELSETTINGS3_40;
    else
        dlgId = IDD_WHEELSETTINGS3;

    ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (NULLHANDLE), MPFROM2SHORT (BKA_FIRST, BKA_MAJOR));
    if (ulPageId1)
        {
        /* position after first "wheel" tab */
        for (ulIndex = 0; ulIndex < 4; ulIndex++)
            ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MAJOR));
        if (ulPageId1)
            {
            /* position after last minor tab inside specific major tab */
            while (ulPageId1)
                {
                ulPageId2 = ulPageId1;
                ulPageId1 = (ULONG)WinSendMsg (hwndNotebook, BKM_QUERYPAGEID, MPFROMLONG (ulPageId1), MPFROM2SHORT (BKA_NEXT, BKA_MINOR));
                }
            if (ulPageId2)  // ulPageId1 is already NULLHANDLE at this point
                ulPageId1 = setPageinfo (somSelf,
                                         hwndNotebook,
                                         WheelSettings3DlgProc,
                                         dlgId,
                                         BKA_MINOR,
                                         BKA_NEXT,
                                         ulPageId2,
                                         IDS_PAGENAME_WHEEL,
                                         PANEL_WHEELSETTINGS3,
                                         0);
            }
        }

    return ulPageId1;
    }

/*
 * METHOD: RemoveUnusedMousePage                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method removes unused settings pages from the settings
 *   notebook.
 *
 * RETURN:
 *   SETTINGS_PAGE_REMOVED
 */
SOM_Scope ULONG SOMLINK AMouseX_RemoveUnusedMousePage (AMouse *somSelf, HWND hwndNotebook)
    {
    AMouseData *somThis = AMouseGetData (somSelf);
    AMouseMethodDebug ("AMouse","AMouseX_RemoveUnusedMousePage");

    SOM_IgnoreWarning (somThis);
    SOM_IgnoreWarning (hwndNotebook);

    return SETTINGS_PAGE_REMOVED;
    }

SOM_Scope ULONG SOMLINK AMouseX_wpAddMouseTimingPage(AMouse *somSelf, HWND hwndNotebook)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpAddMouseTimingPage");

    if (hmodLng)
        _AddTimingSettingsPage (somSelf, hwndNotebook);

    return AMouse_parent_WPMouse_wpAddMouseTimingPage (somSelf, hwndNotebook);
    }

/*
 * METHOD: AddTimingSettingsPage                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *   This method adds the timing page to the settings
 *   notebook.
 *
 * RETURN:
 *   0              Unsuccessful
 *   ulPageId       Identifier for the inserted page
 *
 * HOW TO OVERRIDE:
 *   Method should always be overridden in order to replace or remove
 *   the device info page from an object which is a descendent of AMouse.
 *   In most cases, an override of this method will not call the parent.
 */
SOM_Scope ULONG SOMLINK AMouseX_AddTimingSettingsPage (AMouse *somSelf, HWND hwndNotebook)
    {
    ULONG dlgId;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddTimingSettingsPage");

    if (bIsWarp4)
        dlgId = IDD_TIMINGSETTINGS_40;
    else
        dlgId = IDD_TIMINGSETTINGS;

    return setPageinfo (somSelf,
                        hwndNotebook,
                        TimingSettingsDlgProc,
                        dlgId,
                        BKA_MINOR,
                        BKA_FIRST,
                        0,
                        IDS_PAGENAME_TIMING,
                        PANEL_TIMINGSETTINGS,
                        0);
    }

/*
 *  METHOD: wpAddSettingsPages                             ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *    Add our own settings pages
 *
 */
SOM_Scope BOOL SOMLINK AMouseX_wpAddSettingsPages (AMouse *somSelf, HWND hwndNotebook)
    {
    BOOL bRC;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_AddSettingsPages");

    if (hmodLng)
        {
        // determine the name of the help file
        DetermineHelpFileName (szHelpFile);
        }

    bRC = AMouse_parent_WPMouse_wpAddSettingsPages (somSelf, hwndNotebook);

    DebugE (D_SOM, "_wpAddSettingsPages; parent_wpAddSettingsPages : ", bRC ? "TRUE" : "FALSE");

    // If hModLng is NULLHANDLE don't add settings pages but don't
    // report error to caller. Report real state in each other case.
    if (hmodLng)
        {
        bRC = bRC && _AddDeviceInfoPage   (somSelf, hwndNotebook);
        DebugE (D_SOM, "_wpAddSettingsPages; AddDeviceInfoPage : ", bRC ? "TRUE" : "FALSE");
        bRC = bRC && _AddWlDeviceInfoPage (somSelf, hwndNotebook);
        DebugE (D_SOM, "_wpAddSettingsPages; AddWlDeviceInfoPage : ", bRC ? "TRUE" : "FALSE");

        if (checkForWheelMouse (hmodLng))
            {
            DebugE (D_SOM, "_wpAddSettingsPages", "now add wheel pages");
            bRC = bRC && _AddWheelSettings1Page (somSelf, WHEELPAGE_NONE, hwndNotebook);
            bRC = bRC && _AddWheelSettings1Page (somSelf, WHEELPAGE_CTRL, hwndNotebook);
            bRC = bRC && _AddWheelSettings1Page (somSelf, WHEELPAGE_ALT,  hwndNotebook);
            bRC = bRC && _AddWheelSettings2Page (somSelf, hwndNotebook);
            bRC = bRC && _AddWheelSettings3Page (somSelf, hwndNotebook);
            }
        }

    DebugE (D_SOM, "_wpAddSettingsPages", bRC ? "settings pages added" : "Failed to add settings pages");
    return bRC;
    }

SOM_Scope BOOL SOMLINK AMouseX_wpModifyPopupMenu (AMouse *somSelf,
                                                  HWND hwndMenu,
                                                  HWND hwndCnr,
                                                  ULONG iPosition)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpModifyPopupMenu");

    if (hmodLng)
        _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmodLng,
                                 IDM_MAINMENU, WPMENUID_PRIMARY);

    return (AMouse_parent_WPMouse_wpModifyPopupMenu(somSelf,
                                                    hwndMenu,
                                                    hwndCnr,
                                                    iPosition));
    }

SOM_Scope ULONG SOMLINK AMouseX_wpFilterPopupMenu (AMouse *somSelf,
                                                   ULONG ulFlags,
                                                   HWND hwndCnr,
                                                   BOOL fMultiSelect)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpFilterPopupMenu");

    if (strcmp ("NoMouse", _wpQueryTitle (somSelf)) == 0)
        {
        _wpSetStyle (somSelf, (_wpQueryStyle (somSelf) & (~OBJSTYLE_NODELETE)));
        return (AMouse_parent_WPMouse_wpFilterPopupMenu (somSelf,
                                                         ulFlags,
                                                         hwndCnr,
                                                         fMultiSelect) | CTXT_DELETE );
        }
    else
        {
        _wpSetStyle (somSelf, (_wpQueryStyle (somSelf) | OBJSTYLE_NODELETE));
        return (AMouse_parent_WPMouse_wpFilterPopupMenu (somSelf,
                                                         ulFlags,
                                                         hwndCnr,
                                                         fMultiSelect));
        }
    }

SOM_Scope BOOL SOMLINK AMouseX_wpMenuItemSelected (AMouse *somSelf,
                                                   HWND hwndFrame,
                                                   ULONG ulMenuId)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpMenuItemSelected");

    /* Welcher Menpunkte wurde ausgewhlt? */
    switch (ulMenuId)
        {
        case IDM_ABOUT:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_ABOUT, 0) != NULLHANDLE);

        #ifdef _TRACE_
        case IDM_OPENDEBUG:
            return (_wpViewObject (somSelf, hwndFrame, OPEN_DEBUG, 0)  != NULLHANDLE);
        #endif /* _TRACE_ */
        }

    return AMouse_parent_WPMouse_wpMenuItemSelected (somSelf, hwndFrame, ulMenuId);
    }

SOM_Scope HWND SOMLINK AMouseX_wpOpen (AMouse *somSelf, HWND hwndCnr,
                                       ULONG ulView, ULONG param)
    {
    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpOpen");

    DebugE (D_SOM, "AMouse", "wpOpen called");
    switch (ulView)
        {
        case OPEN_ABOUT:
            if (!_wpSwitchTo (somSelf, OPEN_ABOUT))
                {
                WinLoadDlg (HWND_DESKTOP, HWND_DESKTOP,
                    (PFNWP)AboutDlgProc, hmodLng, IDD_ABOUTBOX, (PVOID)somSelf);
                }
            break;

        #ifdef _TRACE_
        case OPEN_DEBUG:
            {
            ULONG ulResult;

            SOMOutCharRoutine = myReplacementForSOMOutChar;

            ulResult = WinDlgBox (HWND_DESKTOP, HWND_DESKTOP,
                (PFNWP)DbgDlgProc, hmodLng, IDD_DEBUG, NULL);

            SOM_TraceLevel  = (ulResult >> SHFT_TRACE)  & 3;
            SOM_WarnLevel   = (ulResult >> SHFT_WARN)   & 3;
            SOM_AssertLevel = (ulResult >> SHFT_ASSERT) & 3;
            }
            break;
        #endif /* _TRACE_ */
        }

    return AMouse_parent_WPMouse_wpOpen (somSelf, hwndCnr, ulView, param);
    }

SOM_Scope BOOL SOMLINK AMouseX_wpSetup (AMouse *somSelf, PSZ pszSetupString)
    {
    BOOL  bStatus;
    ULONG cbValue;
    PSZ   pszValue;

    /* AMouseData *somThis = AMouseGetData (somSelf); */
    AMouseMethodDebug ("AMouse", "AMouseX_wpSetup");

    DebugE (D_SOM, "AMouse", "wpSetup entered");

    bStatus = AMouse_parent_WPMouse_wpSetup (somSelf, pszSetupString);
    if (bStatus && pszSetupString && *pszSetupString)
        {
        if (_wpScanSetupString (somSelf,
                                pszSetupString,
                                "DEVINFO_DEBUG",
                                NULL,
                                &cbValue))
            {
            pszValue = (PSZ)_wpAllocMem (somSelf, cbValue, NULL);
            if (pszValue)
                {
                if (_wpScanSetupString (somSelf,
                                        pszSetupString,
                                        "DEVINFO_DEBUG",
                                        pszValue,
                                        &cbValue))
                    SetDebugMode (stricmp (pszValue, "YES") == 0);
                }
            _wpFreeMem(somSelf, (PBYTE)pszValue);
            }
        }

    DebugULd (D_SOM, "AMouse", "wpSetup return value: ", bStatus);
    return bStatus;
    }

/*********************************************************************/
/*                   C L A S S   M E T H O D S                       */
/*********************************************************************/

/*--------------------------------------------------------------------*/
/* Class initialization method.  It initializes the instance data and */
/* then calls the parent's method.                                    */
/*--------------------------------------------------------------------*/
SOM_Scope void SOMLINK AMouseM_wpclsInitData (M_AMouse *somSelf)
    {
    ULONG           versionData[2];
    CHAR            szBuffer[BUFFERSIZE];
    APIRET          rc;
    HPOINTER        hPtr;
    TID             tid;
    boolean         bRC;
    ULONG           ulc;
    PCHAR           mouseClassName = "WPMouse";
    somId           mouseClassId;
    SOMClass       *mouseClass;
    somMethodPtr    methodPtr;
    somId           methodId;
    somId           methodDescrId;

    M_AMouseData *somThis = M_AMouseGetData (somSelf);
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_wpclsInitData");

    /* Call the parent class method */
    DebugE (D_SOM, "wpclsInitData", "Calling parent initialization method...");
    M_AMouse_parent_M_WPMouse_wpclsInitData (somSelf);

    /* Initialize class data */
    DebugE (D_SOM, "wpclsInitData", "Initializing class data...");
    memset (somThis, 0, sizeof (M_AMouseData));

    /* open/create semaphore for thread unblocking */
    if (DosOpenEventSem (SEMNAMEEVT_UPDATE, &hevWheelThreadUpdate))
        DosCreateEventSem (SEMNAMEEVT_UPDATE, &hevWheelThreadUpdate, DC_SEM_SHARED, TRUE);

    /* Get resource module handle of WPS dll */
    rc= DosQueryModuleHandle (RESOURCE_MODULE, &hmod);

    if (rc)
        rc = DosLoadModule (szBuffer,
                            BUFFERSIZE,
                            RESOURCE_MODULE,
                            &hmod);

    if (hmod == NULLHANDLE || rc != NO_ERROR)
        {
        DebugULd (D_SOM, "wpclsInitData", "DosLoadModule failed rc =", rc);
        DebugE (D_SOM, "Failure due to ", szBuffer);
        WinAlarm (HWND_DESKTOP, WA_ERROR);
        }
    DebugULx (D_SOM, "wpclsInitData", "hmod = ", hmod);

    /* Load language module and determine its module handle */
    hmodLng = LoadLanguageModule (szModuleName);
    DebugULd (D_SOM, "wpclsInitData", "hmodLng = ", hmodLng);
    if (hmodLng == NULLHANDLE && hmod != NULLHANDLE)
        {
        /* display error message only if hmod was determined successfully */
        static BOOL bIsAlreadyDisplayed = FALSE;
        PCHAR  pFile = szModuleName;
        CHAR   szMessage[TITLELEN];
        CHAR   szErrorMsg[TITLELEN];

        if (!bIsAlreadyDisplayed)
            {
            WinLoadString (hab, hmod, IDS_ERR_MOD, TITLELEN, szMessage);

            DosInsertMessage (&pFile, 1, szMessage, strlen (szMessage), szErrorMsg, TITLELEN-1, &ulc);
            szErrorMsg[ulc] = '\0';

            asyncMessageBox (HWND_DESKTOP,
                             HWND_DESKTOP,
                             szErrorMsg,
                             APP_AMOUSE,
                             0,
                             MB_OK | MB_ERROR);

            bIsAlreadyDisplayed = TRUE;
            }
        }

    /* Query OS version */
    DosQuerySysInfo (QSV_VERSION_MAJOR, QSV_VERSION_MINOR, versionData, 8);
    if ((versionData[0] <= 20) && (versionData[1] < 40))
        bIsWarp4 = FALSE;
    else
        bIsWarp4 = TRUE;

    /* Get icon handle */
    hPtr = WinLoadPointer (HWND_DESKTOP,        // DESKTOP
                           hmod,                // own module handle
                           IDI_ICON);           // Icon ressource id
    _hMyIcon = hPtr;

    /* read class data from ini-file */
    _clsSetScrollMode    (somSelf, WHEELPAGE_NONE, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE,    SCROLL_MODE_STD));
    _clsSetScrollMode    (somSelf, WHEELPAGE_CTRL, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE_C,  SCROLL_MODE_NONE));
    _clsSetScrollMode    (somSelf, WHEELPAGE_ALT,  PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE_A,  SCROLL_MODE_NONE));
    _clsSetScrollNum     (somSelf, WHEELPAGE_NONE, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM,     3));
    _clsSetScrollNum     (somSelf, WHEELPAGE_CTRL, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM_C,   3));
    _clsSetScrollNum     (somSelf, WHEELPAGE_ALT,  PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM_A,   3));
    _clsSetWheelTarget   (somSelf, WHEELPAGE_NONE, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET,   WHEEL_TARGET_POINTER));
    _clsSetWheelTarget   (somSelf, WHEELPAGE_CTRL, PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET_C, WHEEL_TARGET_POINTER));
    _clsSetWheelTarget   (somSelf, WHEELPAGE_ALT,  PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET_A, WHEEL_TARGET_POINTER));
    _clsSetStartupMode   (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_STARTUPMODE,   SCROLL_DIR_VERT));
    _clsSetAccelDelay    (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELDELAY,    ACCEL_DEF_DELAY));
    _clsSetAccelValue    (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELVALUE,    ACCEL_DEF_VALUE));
    _clsSetPollingRate   (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_POLLINGRATE,   DEF_VALUE_POLLING_RATE));
    _clsSetAccelLevel1   (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL1,   DEF_VALUE_ACCEL_LEVEL1));
    _clsSetAccelLvl1Mult (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL1MULT, DEF_VALUE_ACCEL_L1MULT));
    _clsSetAccelLevel2   (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL2,   DEF_VALUE_ACCEL_LEVEL2));
    _clsSetAccelLvl2Mult (somSelf,                 PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL2MULT, DEF_VALUE_ACCEL_L2MULT));

    for (ulc = 0; ulc < CULNUMBUTTONS; ulc++)
        {
        _clsSetBtnMode (somSelf,
                        BTNPAGE_NONE,
                        CIDBUTTONMIN+ulc,
                        _clsGetBtnMode (somSelf, BTNPAGE_NONE, CIDBUTTONMIN+ulc));
        }

    /* remove unused settings pages */
    mouseClassId = somIdFromString (mouseClassName);
    DebugULx (D_SOM, "wpclsInitData", "mouseClassId = ", mouseClassId);
    mouseClass = SOMClassMgr_somClassFromId (SOMClassMgrObject,
                                             mouseClassId);
    if (mouseClass)
        {
        methodId      = somIdFromString ("wpAddMouseSinglePage");
        methodDescrId = somIdFromString ("WPMouse::wpAddMouseSinglePage");
        bRC = _somFindMethod (mouseClass,
                              methodId,
                              &methodPtr);
        if (bRC == TRUE)
            {
            SOMClass_somAddDynamicMethod (somSelf,
                                          methodId,
                                          methodDescrId,
                                          (somMethodProc *) AMouseX_RemoveUnusedMousePage,
                                          (somMethodProc *) somAP_AMouseX_RemoveUnusedMousePage);
            }
        SOMFree (methodId);
        SOMFree (methodDescrId);

        methodId      = somIdFromString ("wpAddNewMouseStickPage");
        methodDescrId = somIdFromString ("WPMouse::wpAddNewMouseStickPage");
        bRC = _somFindMethod (mouseClass,
                              methodId,
                              &methodPtr);
        if (bRC == TRUE)
            {
            SOMClass_somAddDynamicMethod (somSelf,
                                          methodId,
                                          methodDescrId,
                                          (somMethodProc *) AMouseX_RemoveUnusedMousePage,
                                          (somMethodProc *) somAP_AMouseX_RemoveUnusedMousePage);
            }
        SOMFree (methodId);
        SOMFree (methodDescrId);
        }

    /* Start Battery check thread */
    DosCreateThread (&tid, (PFNTHREAD)BatteryCheckThread,  (ULONG)0, 0L, 0x8000);

    DebugE (D_SOM, "wpclsInitData", "Done initializing");
    }

/*--------------------------------------------------------------------*/
/* Class uninitialization method.  It frees the object's title string */
/* and resource module handle.                                        */
/*--------------------------------------------------------------------*/
SOM_Scope void  SOMLINK AMouseM_wpclsUnInitData (M_AMouse *somSelf)
    {
    M_AMouseData *somThis = M_AMouseGetData (somSelf);
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_wpclsUnInitData");

    if (hmod != NULLHANDLE)
        DosFreeModule (hmod);

    if (hmodLng != NULLHANDLE)
        DosFreeModule (hmodLng);

    if (_hMyIcon != NULLHANDLE)
        WinFreeFileIcon (_hMyIcon);

    M_AMouse_parent_M_WPMouse_wpclsUnInitData (somSelf);
    }

/*--------------------------------------------------------------------*/
/* Query default view method.  Returns the default view to open for   */
/* the object.  In this method, the default view is the Settings      */
/* notebook because AMouse has no other views.                        */
/*--------------------------------------------------------------------*/
SOM_Scope ULONG SOMLINK AMouseM_wpclsQueryDefaultView (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_wpclsQueryDefaultView");

    /* Suppress warnings */
    M_AMouse_parent_M_WPMouse_wpclsQueryDefaultView_resolved = M_AMouse_parent_M_WPMouse_wpclsQueryDefaultView_resolved;

    USE_SOMSELF
    return OPEN_SETTINGS;   /* Open Settings notebook by default */
    }

/*--------------------------------------------------------------------*/
/* Query icon data method.  Sets the default icon for the class.      */
/* The icon handle is loaded in wpclsInitData.                        */
/*--------------------------------------------------------------------*/
SOM_Scope HPOINTER SOMLINK AMouseM_wpclsQueryIcon (M_AMouse *somSelf)
    {
    M_AMouseData *somThis = M_AMouseGetData (somSelf);
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_wpclsQueryIcon");

    if (_hMyIcon == NULLHANDLE)
       return (M_AMouse_parent_M_WPMouse_wpclsQueryIcon (somSelf));
    else
       return _hMyIcon;
    }

/*--------------------------------------------------------------------*/
/* Query default help method.  This method sets the pHelpPanelId      */
/* and pszHelpLibrary fields to set the default help panel for the    */
/* object.  The help panel is displayed when Help->General Help is    */
/* selected off the object's popup menu.                              */
/*--------------------------------------------------------------------*/
SOM_Scope BOOL SOMLINK AMouseM_wpclsQueryDefaultHelp (M_AMouse *somSelf,
                                                      PULONG pHelpPanelId,
                                                      PSZ pszHelpLibrary)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_wpclsQueryDefaultHelp");

    /* Set default help panel id - substitute your own here */
    if (pHelpPanelId)
      *pHelpPanelId = IDH_AMOUSE_DEFAULT;

    /* Copy help filename - substitute your own here */
    if (pszHelpLibrary)
      strcpy (pszHelpLibrary, AMOUSE_HELPFILE);

    /* Suppress warnings */
    M_AMouse_parent_M_WPMouse_wpclsQueryDefaultHelp_resolved = M_AMouse_parent_M_WPMouse_wpclsQueryDefaultHelp_resolved;

    USE_SOMSELF
    return TRUE;
    }

SOM_Scope void SOMLINK AMouseM_clsSaveData (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSaveData");

    DebugE (D_SOM, "AMouse", "clsSaveData");
    USE_SOMSELF
    return;
    }

SOM_Scope void SOMLINK AMouseM_clsSetScrollMode (M_AMouse *somSelf,
                                                 ULONG ulWheelPageType,
                                                 ULONG ulScrollMode)
    {
    PCHAR pKey;
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf);*/
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetScrollMode");

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            pKey = KEY_SCROLLMODE;
            break;

        case WHEELPAGE_CTRL:
            pKey = KEY_SCROLLMODE_C;
            break;

        case WHEELPAGE_ALT:
            pKey = KEY_SCROLLMODE_A;
            break;
        }

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, pKey, _itoa (ulScrollMode, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetScrollMode (M_AMouse *somSelf,
                                                  ULONG ulWheelPageType)
    {
    ULONG ulDefValue;
    PCHAR pKey;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf);*/
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetScrollMode");

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            ulDefValue = SCROLL_MODE_STD;
            pKey       = KEY_SCROLLMODE;
            break;

        case WHEELPAGE_CTRL:
            ulDefValue = SCROLL_MODE_NONE;
            pKey       = KEY_SCROLLMODE_C;
            break;

        case WHEELPAGE_ALT:
            ulDefValue = SCROLL_MODE_NONE;
            pKey       = KEY_SCROLLMODE_A;
            break;
        }

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, pKey, ulDefValue);
    }

SOM_Scope void SOMLINK AMouseM_clsSetScrollNum (M_AMouse *somSelf,
                                                ULONG ulWheelPageType,
                                                ULONG ulNewScrollNum)
    {
    PCHAR pKey;
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetScrollNum");

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            pKey = KEY_SCROLLNUM;
            break;

        case WHEELPAGE_CTRL:
            pKey = KEY_SCROLLNUM_C;
            break;

        case WHEELPAGE_ALT:
            pKey = KEY_SCROLLNUM_A;
            break;
        }

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, pKey, _itoa (ulNewScrollNum, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetScrollNum (M_AMouse *somSelf,
                                                 ULONG ulWheelPageType)
    {
    PCHAR pKey;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf);*/
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetScrollNum");

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            pKey = KEY_SCROLLNUM;
            break;

        case WHEELPAGE_CTRL:
            pKey = KEY_SCROLLNUM_C;
            break;

        case WHEELPAGE_ALT:
            pKey = KEY_SCROLLNUM_A;
            break;
        }

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, pKey, 3);
    }

SOM_Scope void SOMLINK AMouseM_clsSetWheelTarget (M_AMouse *somSelf,
                                                  ULONG ulWheelPageType,
                                                  ULONG ulNewWheelTarget)
    {
    PCHAR pKey;
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetWheelTarget");

    DebugULd (D_SOM, "clsSetWheelTarget", "ulNewWheelTarget ", ulNewWheelTarget);

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            pKey = KEY_WHEELTARGET;
            break;

        case WHEELPAGE_CTRL:
            pKey = KEY_WHEELTARGET_C;
            break;

        case WHEELPAGE_ALT:
            pKey = KEY_WHEELTARGET_A;
            break;
        }

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, pKey, _itoa (ulNewWheelTarget, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetWheelTarget (M_AMouse *somSelf,
                                                   ULONG ulWheelPageType)
    {
    PCHAR pKey;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetWheelTarget");

    switch (ulWheelPageType)
        {
        case WHEELPAGE_NONE:
            pKey = KEY_WHEELTARGET;
            break;

        case WHEELPAGE_CTRL:
            pKey = KEY_WHEELTARGET_C;
            break;

        case WHEELPAGE_ALT:
            pKey = KEY_WHEELTARGET_A;
            break;
        }

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, pKey, WHEEL_TARGET_POINTER);
    }

SOM_Scope void SOMLINK AMouseM_clsSetStartupMode (M_AMouse *somSelf,
                                                  ULONG ulStartupMode)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetStartupMode");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_STARTUPMODE, _itoa (ulStartupMode, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetStartupMode (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetStartupMode");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_STARTUPMODE, SCROLL_DIR_VERT);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelDelay (M_AMouse *somSelf,
                                                 ULONG ulAccelDelay)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelDelay");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELDELAY, _itoa (ulAccelDelay, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelDelay (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelDelay");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELDELAY, ACCEL_DEF_DELAY);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelValue (M_AMouse *somSelf,
                                                 ULONG ulAccelValue)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelValue");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELVALUE, _itoa (ulAccelValue, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelValue (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelValue");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELVALUE, ACCEL_DEF_VALUE);
    }

SOM_Scope void SOMLINK AMouseM_clsSetPollingRate (M_AMouse *somSelf, ULONG ulPollingRate)
    {
    CHAR sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetPollingRate");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_POLLINGRATE, _itoa (ulPollingRate, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetPollingRate (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetPollingRate");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_POLLINGRATE, DEF_VALUE_POLLING_RATE);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelLevel1 (M_AMouse *somSelf, ULONG ulAccelLevel)
    {
    CHAR sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelLevel1");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL1, _itoa (ulAccelLevel, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelLevel1 (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelLevel1");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL1, DEF_VALUE_ACCEL_LEVEL1);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelLvl1Mult (M_AMouse *somSelf, ULONG ulAccelLvlMult)
    {
    CHAR sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelLvl1Mult");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL1MULT, _itoa (ulAccelLvlMult, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelLvl1Mult (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelLvl1Mult");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL1MULT, DEF_VALUE_ACCEL_L1MULT);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelLevel2 (M_AMouse *somSelf, ULONG ulAccelLevel)
    {
    CHAR sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelLevel2");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL2, _itoa (ulAccelLevel, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelLevel2 (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelLevel2");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL2, DEF_VALUE_ACCEL_LEVEL2);
    }

SOM_Scope void SOMLINK AMouseM_clsSetAccelLvl2Mult (M_AMouse *somSelf, ULONG ulAccelLvlMult)
    {
    CHAR sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetAccelLvl2Mult");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL2MULT, _itoa (ulAccelLvlMult, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetAccelLvl2Mult (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetAccelLvl2Mult");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL2MULT, DEF_VALUE_ACCEL_L2MULT);
    }

SOM_Scope void SOMLINK AMouseM_clsSetBtnMode (M_AMouse *somSelf,
                                              ULONG ulKeyPageType,
                                              ULONG ulKeyNum,
                                              ULONG ulBtnMode)
    {
    PCHAR pKey;
    UCHAR ucarMode[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData(somSelf); */
    M_AMouseMethodDebug("M_AMouse","AMouseM_clsSetBtnMode");

    switch (ulKeyPageType)
        {
        case BTNPAGE_NONE:
            pKey = KEY_BTNMODE;
            break;

        case BTNPAGE_CTRL:
            pKey = KEY_BTNCMODE;
            break;

        case BTNPAGE_ALT:
            pKey = KEY_BTNAMODE;
            break;
        }

    ulc = sizeof (ucarMode);
    if (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, pKey,
                                      (PVOID)ucarMode, &ulc))
        {
        setDefaultKeySettings (ulKeyPageType, ucarMode);
        }
    ucarMode[ulKeyNum-CIDBUTTONMIN] = (UCHAR)ulBtnMode;
    PrfWriteProfileData (HINI_USERPROFILE, APP_AMOUSE, pKey, (PVOID)ucarMode, sizeof (ucarMode));

    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetBtnMode (M_AMouse *somSelf,
                                               ULONG ulKeyPageType,
                                               ULONG ulKeyNum)
    {
    PCHAR pKey;
    UCHAR ucarMode[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData(somSelf); */
    M_AMouseMethodDebug("M_AMouse","AMouseM_clsGetBtnMode");

    switch (ulKeyPageType)
        {
        case BTNPAGE_NONE:
            pKey       = KEY_BTNMODE;
            break;

        case BTNPAGE_CTRL:
            pKey       = KEY_BTNCMODE;
            break;

        case BTNPAGE_ALT:
            pKey       = KEY_BTNAMODE;
            break;
        }

    ulc = sizeof (ucarMode);
    if ((BTNPAGE_NONE != ulKeyPageType) ||
        (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, pKey,
                                       (PVOID)ucarMode, &ulc)))
        {
        setDefaultKeySettings (ulKeyPageType, ucarMode);
        }

    USE_SOMSELF
    return (ULONG)ucarMode[ulKeyNum-CIDBUTTONMIN];
    }

SOM_Scope void SOMLINK AMouseM_clsSetBtnKeyCombMP1 (M_AMouse *somSelf,
                                                    ULONG ulKeyPageType,
                                                    ULONG ulKeyNum,
                                                    ULONG ulMP1)
    {
    ULONG ularMP1[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse","AMouseM_clsSetBtnKeyCombMP1");

    if (BTNPAGE_NONE == ulKeyPageType)
        {
        ulc = sizeof (ularMP1);
        if (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP1,
                                          (PVOID)ularMP1, &ulc))
            {
            memset (ularMP1, '\0', sizeof (ularMP1));
            }
        ularMP1[ulKeyNum-CIDBUTTONMIN] = ulMP1;
        PrfWriteProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP1,
                             (PVOID)ularMP1, sizeof (ularMP1));

        DosPostEventSem (hevWheelThreadUpdate);
        }

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetBtnKeyCombMP1 (M_AMouse *somSelf,
                                                     ULONG ulKeyPageType,
                                                     ULONG ulKeyNum)
    {
    ULONG ularMP1[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse","AMouseM_clsGetBtnKeyCombMP1");

    ulc = sizeof (ularMP1);
    if ((BTNPAGE_NONE != ulKeyPageType) ||
        (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP1,
                                       (PVOID)ularMP1, &ulc)))
        {
        memset (ularMP1, '\0', sizeof (ularMP1));
        }

    USE_SOMSELF
    return ularMP1[ulKeyNum-CIDBUTTONMIN];
    }

SOM_Scope void SOMLINK AMouseM_clsSetBtnKeyCombMP2 (M_AMouse *somSelf,
                                                    ULONG ulKeyPageType,
                                                    ULONG ulKeyNum,
                                                    ULONG ulMP2)
    {
    ULONG ularMP2[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse","AMouseM_clsSetBtnKeyCombMP2");

    if (BTNPAGE_NONE == ulKeyPageType)
        {
        ulc = sizeof (ularMP2);
        if (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP2,
                                          (PVOID)ularMP2, &ulc))
            {
            memset (ularMP2, '\0', sizeof (ularMP2));
            }
        ularMP2[ulKeyNum-CIDBUTTONMIN] = ulMP2;
        PrfWriteProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP2,
                             (PVOID)ularMP2, sizeof (ularMP2));

        DosPostEventSem (hevWheelThreadUpdate);
        }

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetBtnKeyCombMP2 (M_AMouse *somSelf,
                                                     ULONG ulKeyPageType,
                                                     ULONG ulKeyNum)
    {
    ULONG ularMP2[CULNUMBUTTONS];
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse","AMouseM_clsGetBtnKeyCombMP2");

    ulc = sizeof (ularMP2);
    if ((BTNPAGE_NONE != ulKeyPageType) ||
        (FALSE == PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_BTNKEYCOMBMP2,
                                       (PVOID)ularMP2, &ulc)))
        {
        memset (ularMP2, '\0', sizeof (ularMP2));
        }

    USE_SOMSELF
    return ularMP2[ulKeyNum-CIDBUTTONMIN];
    }

SOM_Scope void SOMLINK AMouseM_clsSetWheelCount (M_AMouse *somSelf,
                                                 ULONG ulWheelCount)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetWheelCount");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELCOUNT, _itoa (ulWheelCount, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetWheelCount (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetWheelCount");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELCOUNT, DEF_VALUE_WHEELCOUNT);
    }

SOM_Scope void SOMLINK AMouseM_clsSetApplications (M_AMouse *somSelf, STRUCTAPPL *pstructApplications)
    {
    PCHAR p;
    ULONG ulc;

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetApplications");

    ulc = ApplStruct2Profile (pstructApplications, &p);
    PrfWriteProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_APPLICATIONS, (PVOID)p, ulc);
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope STRUCTAPPL *SOMLINK AMouseM_clsGetApplications (M_AMouse *somSelf)
    {
    PCHAR       pcApplications;
    PSTRUCTAPPL p;
    ULONG       ulc = CCHMAXAPPL * sizeof (STRUCTAPPL);

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetApplications");

    pcApplications = (PCHAR)malloc (ulc);
    memset (pcApplications, '\0', ulc);
    PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_APPLICATIONS, pcApplications, &ulc);

    p = ApplProfile2Struct (pcApplications);
    free (pcApplications);

    USE_SOMSELF
    return p;
    }

SOM_Scope void SOMLINK AMouseM_clsSetPMCtlsFlags (M_AMouse *somSelf,
                                                  ULONG ulFlgPmCtls)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsSetPMCtlsFlags");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_PMCTLS, _itoa (ulFlgPmCtls, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetPMCtlsFlags (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData (somSelf); */
    M_AMouseMethodDebug ("M_AMouse", "AMouseM_clsGetPMCtlsFlags");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_PMCTLS, 0);
    }

SOM_Scope void SOMLINK AMouseM_clsSetSmartCruise (M_AMouse *somSelf,
                                                  ULONG ulSmartCruise)
    {
    CHAR  sz[13];

    /* M_AMouseData *somThis = M_AMouseGetData(somSelf); */
    M_AMouseMethodDebug("M_AMouse","AMouseM_clsSetSmartCruise");

    PrfWriteProfileString (HINI_USERPROFILE, APP_AMOUSE, KEY_SMARTCRUISE, _itoa (ulSmartCruise, sz, 10));
    DosPostEventSem (hevWheelThreadUpdate);

    USE_SOMSELF
    return;
    }

SOM_Scope ULONG SOMLINK AMouseM_clsGetSmartCruise (M_AMouse *somSelf)
    {
    /* M_AMouseData *somThis = M_AMouseGetData(somSelf); */
    M_AMouseMethodDebug("M_AMouse","AMouseM_clsGetSmartCruise");

    USE_SOMSELF
    return PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SMARTCRUISE, DEF_VALUE_SMARTCRUISE);
    }


