/* 51Shades.CMD */

PARSE ARG argumenten

grootte=128
doel='51Shades.TGA'

IF Words(argumenten)<2 | Words(argumenten)>3 THEN DO
   SAY
   SAY '51Shades creates (or overwrites) an image,' doel||'. This file can be used' 
   SAY 'as a copy & paste-source to create a part of another image, like an icon.'
   SAY
   SAY 'Additional software has to be used to, for example, rotate images. 51Shades'
   SAY 'just creates the basic image.'
   SAY
   SAY 'Syntax:'
   SAY
   SAY '   51SHADES.CMD <RGB_color_top_left> <RGB_color_bottom_right> [size]'
   SAY
   SAY 'RGB_color_top_left    : hexadecimal RGB color value, range 000000 - FFFFFF'
   SAY 'RGB_color_bottom_right: hexadecimal RGB color value, range 000000 - FFFFFF'
   SAY 'Size                  : image size, range 2 - 65536 pixels (default: 128)' 
   SAY
   SAY 'Example:'
   SAY
   SAY '   51SHADES.CMD FCFCFC A19857 64'
   SAY
   SAY 'This creates a 64x64, 24-bits version of the colors of an eCS 1.2 folder icon.'
   SAY
   EXIT   
END

PARSE VAR argumenten kleur2 kleur1 rest

IF Length(kleur2)<>6 | DataType(kleur2,'X')=0 THEN DO
   SAY
   SAY 'Error:' kleur2 'is not a valid RGB color value. Valid range: 000000 - FFFFFF'
   SAY
   EXIT
END
IF Length(kleur1)<>6 | DataType(kleur1,'X')=0 THEN DO
   SAY
   SAY 'Error:' kleur1 'is not a valid RGB color value. Valid range: 000000 - FFFFFF'
   SAY
   EXIT
END

IF rest<>'' THEN DO
   grootte=rest
   IF DataType(grootte,'W')=0 THEN DO
      SAY
      SAY 'Error:' grootte 'is not a valid image size. Valid range: 2 - 65536'
      SAY
      EXIT
   END
   IF grootte<2 | grootte > 65536 THEN DO
      SAY
      SAY 'Error: image size' grootte 'is not valid. Valid range: 2 - 65536'
      SAY
      EXIT
   END
   IF grootte>256 THEN DO      
      SAY
      SAY 'Warning: 51Shades is quite slow, so it may be better to use an optimized' 
      SAY '         choice of colors instead of a "huge" image size'
      SAY
   END

END

IF Stream(doel,'C','QUERY EXISTS')<>'' THEN DO
   CALL SysFileDelete doel
   SAY
   IF Stream(doel,'C','QUERY EXISTS')<>'' THEN DO
      SAY 'Error: cannot delete file' doel
      SAY
      EXIT
   END
   SAY 'File' doel 'deleted.'
   SAY
END
SAY 'Creating file' doel||'.'
DO 2
   CALL CharOut doel,D2C(0)
END
CALL CharOut doel,D2C(2)
DO 9
   CALL CharOut doel,D2C(0)
END
DO 2
   CALL CharOut doel,D2C(grootte//256)
   CALL CharOut doel,D2C(grootte%256)
END
CALL CharOut doel,D2C(24)
CALL CharOut doel,D2C(20)
SAY 'Header created.'
PARSE VAR kleur1 1 r1 3 g1 5 b1 7 .
PARSE VAR kleur2 1 r2 3 g2 5 b2 7 .
r1=X2D(r1)
g1=X2D(g1)
b1=X2D(b1)
r2=X2D(r2)
g2=X2D(g2)
b2=X2D(b2)

sr=(r2-r1)/(grootte*2-1) 
sg=(g2-g1)/(grootte*2-1) 
sb=(b2-b1)/(grootte*2-1) 

kleur.=X2C('000000')
kleur.1=D2C(b1)||D2C(g1)||D2C(r1)
DO i=2 TO grootte*2-1
   r1=r1+sr
   g1=g1+sg
   b1=b1+sb
   kleur.i=D2C(Format(b1,,0))||D2C(Format(g1,,0))||D2C(Format(r1,,0))
END i
SAY 'Colors calculated.'

SAY 'Calculating pixels...'
DO i=1 TO grootte*2-1
   DO x=i TO 1 BY -1
      IF x<=grootte THEN DO
         y=i+1-x
         pixel.x.y=kleur.i
      END
   END x
END i
SAY 'Pixels calculated.'
SAY 'Creating image, size' grootte 'x' grootte||'...'

DO x=1 TO grootte 
   DO y=1 TO grootte
       Call CharOut doel,pixel.x.y   
   END y
END x

CALL CharOut doel

SAY 'Done.'
SAY

EXIT
