CODE	SEGMENT
	ASSUME	CS:CODE
	ORG	100H

START:	JMP	DOSVER

OLD13	DD	0
AFLAG	DB	0
BFLAG	DB	0

;-------------------------------------------

INT13	PROC	FAR

	STI

	PUSH	ES
	PUSH	AX
	MOV	AX,40H
	MOV	ES,AX

	CMP	AFLAG,0
	JE	INT13A

	MOV	AL,BYTE PTR ES:[90H]
	AND	AL,0DFH
	OR	AL,07H
	MOV	BYTE PTR ES:[90H],AL

INT13A:
	CMP	BFLAG,0
	JE	INT13B

	MOV	AL,BYTE PTR ES:[91H]
	AND	AL,0DFH
	OR	AL,07H
	MOV	BYTE PTR ES:[91H],AL

INT13B:
	POP	AX
	POP	ES

	PUSHF
	CLI
	CALL	OLD13

	PUSHF

	PUSH	ES
	PUSH	AX
	MOV	AX,40H
	MOV	ES,AX

	CMP	AFLAG,0
	JE	INT13C

	MOV	AL,BYTE PTR ES:[90H]
	AND	AL,0DFH
	OR	AL,07H
	MOV	BYTE PTR ES:[90H],AL

INT13C:
	CMP	BFLAG,0
	JE	INT13D

	MOV	AL,BYTE PTR ES:[91H]
	AND	AL,0DFH
	OR	AL,07H
	MOV	BYTE PTR ES:[91H],AL

INT13D:
	POP	AX
	POP	ES

	POPF

	RET	2

INT13	ENDP

;-------------------------------------------

MULTIPLEX_NUMBER  EQU  0EEH
OLD2F	DD	0
MULTIPLEX_NAME	DB	'800K    '

;multiplex interrupt -- tests for installed
; state of program by passed string of
; length 8 pointed to by DS:SI

INT2F	PROC	FAR

	CMP	AH,MULTIPLEX_NUMBER
	JNE	INT2FX

	PUSH	ES
	PUSH	DI
	PUSH	SI
	PUSH	CX

	MOV	CX,CS
	MOV	ES,CX

	CLD
	MOV	CX,4
	LEA	DI,MULTIPLEX_NAME
	REPE	CMPSW

	POP	CX
	POP	SI
	POP	DI
	POP	ES

	JNE	INT2FX

;our address verified, test for which function

	CMP	AL,0
	JE	INT2FA

	CMP	AL,1
	JE	INT2FB

;AL = 2  -->  un-install

	PUSH	ES
	PUSH	DS
	PUSH	DX
	PUSH	AX
	LDS	DX,OLD13
	MOV	AX,2513H
	INT	21H
	LDS	DX,OLD2F
	MOV	AX,252FH
	INT	21H
	MOV	ES,CS:[2CH]
	MOV	AH,49H
	INT	21H
	PUSH	CS
	POP	ES
	MOV	AH,49H
	INT	21H
	POP	AX
	POP	DX
	POP	DS
	POP	ES
	SUB	AL,AL
	IRET

;AL = 1  -->  update A/B flags

INT2FB:
	MOV	AFLAG,DH
	MOV	BFLAG,DL
	IRET

;AL = 0  -->  signal installed state

INT2FA:
	MOV	AL,0FFH
	IRET

INT2FX:
	JMP	CS:OLD2F

INT2F	ENDP

;-------------------------------------------

CUTOFF	LABEL	BYTE

;-------------------------------------------

;on completion: 1=sw found

SW1FLG	DB	0
SW2FLG	DB	0
SW3FLG	DB	0

;on completion: contains string following
; colon after switch, terminated by 20h,
; slash, or <cr> in command line
; and 00h here
;
;example: PROGRAM /A/B:1234/C XYZ
; SW2PARM would contain 31h,32h,33h,34h,00h,
; etc.

SW1PARM	DB	64 DUP (0)
SW2PARM	DB	64 DUP (0)
SW3PARM	DB	64 DUP (0)

;lower case in command line converted
; to upper case

SWLIST	DB	'ABU'

SWLSTLEN EQU	3

;it is assumed that DS and ES both point
; to the PSP.

SWSCAN	PROC

	CLD
	MOV	DI,80H
	MOV	CL,[DI]
	SUB	CH,CH
	INC	DI

	CMP	CX,1
	JBE	SWSCAN1

;search for "/" character

SWSCAN3:
	MOV	AL,'/'
	REPNE	SCASB
	JCXZ	SWSCAN1

;compare next character to list

	MOV	AL,[DI]
	CMP	AL,61H
	JB	SWSCAN4
	SUB	AL,20H
SWSCAN4: PUSH	DI
	PUSH	CX
	LEA	DI,SWLIST
	MOV	CX,SWLSTLEN
	REPNE	SCASB
	JNE	SWSCAN2
	LEA	AX,SWLIST
	DEC	DI
	SUB	DI,AX
	MOV	BX,DI
	LEA	AX,SW1FLG
	ADD	DI,AX
	MOV	BYTE PTR [DI],1
SWSCAN2: POP	CX
	POP	DI

;convert the two characters to blanks

	MOV	WORD PTR [DI-1],2020H

;is next character a colon?

	INC	DI
	CMP	BYTE PTR [DI],":"
	JNE	SWSCAN5

;blank it

	MOV	BYTE PTR [DI],20H
	DEC	CX
	JCXZ	SWSCAN1

;set a pointer to the parm area

	PUSH	CX
	MOV	CL,6
	SHL	BX,CL
	POP	CX
	LEA	AX,SW1PARM
	ADD	BX,AX

;transfer bytes until terminating character
	
SWSCAN6:
	INC	DI
	CMP	BYTE PTR [DI],20H
	JBE	SWSCAN5
	CMP	BYTE PTR [DI],"/"
	JE	SWSCAN5
	MOV	AL,[DI]
	MOV	BYTE PTR [DI],20H
	MOV	[BX],AL
	INC	BX
	LOOP	SWSCAN6
	JMP	SWSCAN1

;loop back & continue scan

SWSCAN5:
	JMP	SWSCAN3

;exit

SWSCAN1:
	RET

SWSCAN	ENDP

;-------------------------------------------

HELP DB 0Ah,'800K - Version 1.0  --  Copyright (C) 1987, Alan D. Jones'
 DB 0Dh,0Ah,0Ah
 DB 'This is a memory-resident program which allows diskettes',0Dh,0Ah
 DB 'formatted with the companion program 800KFMAT to be written',0Dh,0Ah
 DB 'and read in the normal manner by DOS. It must be un-installed',0Dh,0Ah
 DB '(with the /U switch) to restore operation with conventionally',0Dh,0Ah
 DB 'formatted diskettes.',0Dh,0Ah,0Ah
 DB 'This program hooks INT 13h and modifies the "diskette state',0Dh,0Ah
 DB 'machine" bytes at 40:90 and 40:91 to prevent BIOS from',0Dh,0Ah
 DB 'double-stepping the high density diskette drive after detecting',0Dh,0Ah
 DB 'the presence of a diskette formatted to 300kbs density.',0Dh,0Ah,0Ah
 DB 'Syntax:  To install for drive A:  800K/A',0Dh,0Ah
 DB '         To install for drive B:  800K/B',0Dh,0Ah
 DB '         To install for both:     800K/A/B',0Dh,0Ah
 DB '         To un-install:           800K/U',0Dh,0Ah,0Ah,24h

EMSG1	DB	'800K was not installed.',0Dh,0Ah,24h
MSG1	DB	'800K has been un-installed.',0Dh,0Ah,24h
EMSG2   DB      'Requires DOS 3.2 or later.',0Dh,0Ah,24h
MSG2	DB	'A/B switch settings adjusted.',0Dh,0Ah,24h
MSG3	DB	'800K is now installed.',0Dh,0Ah,24h

;check DOS version number

DOSVER:
	MOV	AH,30H
	INT	21H
	XCHG	AL,AH
        CMP     AX,0314H
	JAE	GETSWITCH

;wrong version, display message & exit

	MOV	DX,OFFSET EMSG2
	MOV	AH,9
	INT	21H
	MOV	AX,4C01H
	INT	21H

;get command line switches

GETSWITCH:
	CALL	SWSCAN
	MOV	AL,SW1FLG
	MOV	AFLAG,AL
	MOV	AL,SW2FLG
	MOV	BFLAG,AL

;are any switches set?

	MOV	AL,SW1FLG
	ADD	AL,SW2FLG
	ADD	AL,SW3FLG
	CMP	AL,0
	JNE	TESTINS

;no, so just display "help" message

	MOV	DX,OFFSET HELP
	MOV	AH,9
	INT	21H
	MOV	AX,4C00H
	INT	21H

;test for already installed

TESTINS:
	MOV	SI,OFFSET MULTIPLEX_NAME
	MOV	AH,MULTIPLEX_NUMBER
	MOV	AL,0
	INT	2FH

;branch based on whether installed or not

	CMP	AL,0FFH
	JE	ITSTHERE

;not installed

;requesting un-install?

	CMP	SW3FLG,1
	JNE	INSTALL

;display error message

	MOV	DX,OFFSET EMSG1
	MOV	AH,9
	INT	21H
	MOV	AX,4C00H
	INT	21H

;hook vectors and do a TSR

INSTALL:
	MOV	AX,3513H
	INT	21H
	MOV	WORD PTR OLD13,BX
	MOV	WORD PTR OLD13+2,ES
	MOV	DX,OFFSET INT13
	MOV	AX,2513H
	INT	21H

	MOV	AX,352FH
	INT	21H
	MOV	WORD PTR OLD2F,BX
	MOV	WORD PTR OLD2F+2,ES
	MOV	DX,OFFSET INT2F
	MOV	AX,252FH
	INT	21H

	MOV	DX,OFFSET MSG3
	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET CUTOFF
	ADD	DX,0FH
	MOV	CL,4
	SHR	DX,CL
	MOV	AX,3100H
	INT	21H

;already present

ITSTHERE:

;requesting un-install?

	CMP	SW3FLG,1
	JNE	ALTERFLAGS

;make multiplex interrupt call for un-install

	MOV	SI,OFFSET MULTIPLEX_NAME
	MOV	AH,MULTIPLEX_NUMBER
	MOV	AL,2
	INT	2FH

;display informatory message

	MOV	DX,OFFSET MSG1
	MOV	AH,9
	INT	21H
	MOV	AX,4C00H
	INT	21H

;requesting A/B flag alteration, make appropriate
; multiplex interrupt call

ALTERFLAGS:
	MOV	SI,OFFSET MULTIPLEX_NAME
	MOV	AH,MULTIPLEX_NUMBER
	MOV	DH,AFLAG
	MOV	DL,BFLAG
	MOV	AL,1
	INT	2FH

;display informatory message

	MOV	DX,OFFSET MSG2
	MOV	AH,9
	INT	21H
	MOV	AX,4C00H
	INT	21H

CODE	ENDS
	END	START

