;
; direct mouse access at the hardware level (for DOS)
;
code    segment
        org     100h
        jmp     start
;
        mousebuffer     db      8 dup (0),' \'
        Return          db      13,10,'\'
        Overrun         db      'Overrun Error',13,10,'\'
        Framing         db      'Framing Error',13,10,'\'
        Error           db      'Error in 3FA or 3FD',13,10,'\'
        count           dw      02h
;
start:
        in al, 021h
        or al, 00010000xb
        out 021h, al    ; turn off IRQ4

        cli             ; STOP all interrupts

        mov dx, 03FBh
        mov al, 10000000xb
        out dx, al      ; set DLAB in Line Control Register

        mov dx, 03F8h
        mov al, 060h
        out dx, al      ; set Divisor Latch - low
        mov dx, 03F9h
        mov al, 0h
        out dx, al      ; set Divisor Latch - high -- 1200 baud

        mov dx, 03FBh
        mov al, 00000010xb
        out dx, al      ; set Line Ctrl Reg -- 
                        ;       set 7 bits, 1 stop, no parity
                        ;       and reset DLAB bit

        mov dx, 03F9h
        mov al, 00000101xb
        out dx, al      ; set Interrupt Enable Reg -- 
                        ;       receiver line status 
                        ;       received data available

        mov dx, 03FAh
        mov al, 0h
        out dx, al      ; set FIFO Control Register --
                        ;       disable FIFOs

        mov dx, 03FCh   
        mov al, 00001010xb      
        out dx, al      ; set Modem Control Register --
                        ;       force active RTS, set OUT2 bit
                        ;       DTR - not connected to serial mouse

        sti             ; START interrupts again

        mov dx, 03F8h
        in al, dx       ; clear any byte in buffer
;-----------------------------------------------------------    
getByte:
        mov dx, 03FAh
        in al, dx               ; check Interrupt Indentification Register
        test al, 00000001xb     ; test for pending interrupts
        jnz getByte     

        and al, 00000111xb
        cmp al, 00000110xb      ; check for receiver line status interrupt 
        jz checkLineStatus
        cmp al, 00000100xb      ; check for received data available interrupt
        jz readByte
        jmp Exit                ; should not get to here!

checkLineStatus:
        mov dx, 03FDh
        in al, dx               ; check Line Status Register - 03FDh

checkForError:
        test al, 00000010xb     ; check for overrun error
        jz checkForMoreErrors
        lea bp, Overrun
        call WriteString
        jmp readByte 

checkForMoreErrors:
        test al, 00001000xb     ; check for framing error
        jz checkForOtherErrors 
        lea bp, Framing 
        call WriteString
        jmp anotherByte 

checkForOtherErrors:
        test al, 00000001xb     ; check whether data ready
        jnz readByte 
        jmp Exit                ; should not get here!

readByte:
        mov dx, 03F8h
        in al, dx               ; read byte from Receiver Buffer Register

        mov ah, 0h
        lea bp, mousebuffer
        mov di, 08h
        call Bits2Ascii
        lea bp, mousebuffer
        call WriteString

checkForEndByteTrio:
        mov ax, count
        inc ax
        mov count, ax
        cmp ax, 03h
        jl anotherByte
        mov ax, 0h
        mov count, ax
        lea bp, Return 
        call WriteString
anotherByte:
        jmp getByte

Exit:
        lea bp, Error 
        call WriteString

        mov dx, 03FCh   
        mov al, 00001000xb      
        out dx, al      ; set Modem Control Register --
                        ;       force inactive RTS, set OUT2 bit

        mov ax,4C00h
        int 21h 

;-------------------------------------------------------------
; sub-routines
;-------------------------------------------------------------

WriteString:                    ;BP-string memory location, ends in "\"
        mov al, [bp]
        cmp al, "\"
        jz ws_done
        call WriteChar
        inc bp
        jmp WriteString
ws_done:
        ret
;-------------------------------------------------------------
Bits2Ascii:                     ; AX-binary no.,BP-ASCII buffer,DI-no.bits
        dec di
        mov [bp+di]b, "0"
        shr ax, 1
        jnc nextDigit 
        mov [bp+di]b, "1"
nextDigit:
        cmp di, 0h
        jnz Bits2Ascii
        ret
;-------------------------------------------------------------
WriteChar:                      ;AL-ASCII character code
        mov ah, 0Eh
        int 10h
        ret
end
