;
;
;
	ORG	100H
RESTART	LXI	SP,JUMPS
	CALL	SETUP
;
;
;
MAINLP	LXI	H,VTABL
	INX	H
	MOV	A,M
	CPI	DEAD
	JZ	MP1
	PUSH	H
	CALL	ADDSCR
	LDA	SCRFLG
	ORA	A
	CP	VMOVE
	POP	H
MP1	CALL	USER
	CALL	BIGCTR
	CALL	NEWFISH
	LXI	H,VTABL
	MVI	B,MAXFISH+1
FISHES	PUSH	B
	PUSH	H
	CALL	FISHY
	POP	H
	CALL	BUMP6
	POP	B
	DCR	B
	JNZ	FISHES
	JMP	MAINLP
;
;
;
SETPHA	LXI	H,ETV-LENL+6
	MOV	C,A
	LXI	D,PHAMSG
	MVI	B,0AH
MOVPHA	LDAX	D
	ORI	BIAS
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVPHA
	MOV	A,C
	ADI	ZERO
	STA	ETV-LENL+16
	SUI	ZERO
	RLC
	RLC
	RLC
	MVI	D,0
	MOV	E,A
	LHLD	CTLPTR
	DAD	D
	LXI	D,LNEWF
	MVI	B,8
TRPHA	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	TRPHA
	MVI	A,0
	STA	BIGTWO
	RET
;
;
;
BMTPHA	LDA	PHASE
	CPI	9
	RZ
	INR	A
	STA	PHASE
	CALL	SETPHA
	RET
;
;
;
STOP	POP	H
GETPHA	CALL	INPUT
	CPI	'0'
	RC
	CPI	'9'
	RNC
	SUI	'0'
	STA	PHASE
	CALL	SETPHA
	RET
;
;
;
ADDSCR	LDA	PHASE
	INR	A
	MOV	B,A
	LXI	H,STV-12
MORSCR	CALL	SCORIT
	DCR	B
	JNZ	MORSCR
	LXI	H,VPOS
	MOV	D,M
	INX	H
	MOV	E,M
	CALL	CONVERT
	LDA	GOODCAL
	CMP	D
	JNZ	CHKBMP
	CPI	ONE
	JNZ	LEFTCOL
	MVI	A,WIDTH-2
	JMP	SETCOL
LEFTCOL	MVI	A,ONE
SETCOL	STA	GOODCAL
	LDA	LBONUS
	MOV	B,A
GIVBON	LXI	H,STV-12
	CALL	ASCBMP
	DCR	B
	JNZ	GIVBON
CHKBMP	LDA	BIGTWO
	CPI	14H
	RNZ
	JMP	BMTPHA
;
;
;
SCORIT	LDA	SCRCTR
	INR	A
	STA	SCRCTR
	CPI	2DH
	RNZ
	MVI	A,0
	STA	SCRCTR
ASCBMP	MOV	A,M
	CPI	BLANK
	JNZ	GOTDIG
	MVI	M,ZERO+1
	RET
GOTDIG	CPI	ZERO+9
	JNZ	NOT9
	MVI	M,ZERO
	DCX	H
	JMP	ASCBMP
NOT9	INR	A
	MOV	M,A
	RET
;
;
;
SCRCTR	INX	B
ASCDEC	MOV	A,M
	CPI	BLANK
	JZ	CNTDEC
	CPI	ZERO
	JNZ	NOTZERO
	MVI	M,ZERO+9
	DCX	H
	JMP	ASCDEC
NOTZERO	DCR	A
	MOV	M,A
	CPI	ZERO
	RNZ
	DCX	H
	MVI	A,BLANK
	CMP	M
	RNZ
	INX	H
	MOV	M,A
	RET
;
;
;
CNTDEC	MVI	A,0FFH
	STA	SCRFLG
	RET
;
;
;
BIGCTR	LXI	H,BIGONE
	INR	M
	RNZ
	INX	H
	INR	M
	RNZ
	INX	H
	INR	M
	RNZ
	INX	H
	INR	M
	RET
;
;
;
NEWFISH	LDA	LNEWF
	CALL	RANDOM
	CPI	ONE
	RNZ
	MVI	A,FRATE
	CALL	RANDOM
	CPI	0
	RNZ
	CALL	ALIVE
	MOV	A,H
	ORA	A
	JNZ	GOTFISH
	MOV	A,L
	ORA	A
	RZ
GOTFISH	MVI	M,ONE
	INX	H
	MVI	A,64H
	CALL	RANDOM
	MOV	B,A
	LDA	LTRACK
	CMP	B
	JNC	DOTRACK
	MVI	M,NOTRK
	JMP	NOTRACK
DOTRACK	MVI	M,FTRK
NOTRACK	INX	H
	LDA	LSRNG
	CALL	RANDOM
	MOV	B,A
	LDA	LMINS
	ADD	B
	MOV	M,A
	DCX	H
	DCX	H
	MOV	A,M
	CALL	BUMP3
	PUSH	H
	LDA	LSIDE
	CALL	RANDOM
	CPI	3
	JZ	BRNLFT
	CPI	2
	JZ	BRNRHT
	CPI	ONE
	JZ	BRNTOP
	MVI	B,SUBL
	MVI	A,WIDTH-2
	LXI	H,ETV-3*LENL
	LXI	D,1
	JMP	FBORN
BRNTOP	MVI	B,LENL
	MVI	A,WIDTH-2
	LXI	H,DTV+LENL
	LXI	D,1
	JMP	FBORN
BRNRHT	MVI	B,0FFH
	MVI	A,NLINES-3
	LXI	H,DTV+WIDTH-2
	LXI	D,LENL
	JMP	FBORN
BRNLFT	MVI	B,ONE
	MVI	A,NLINES-3
	LXI	H,DTV+1
	LXI	D,LENL
FBORN	CALL	RANDOM
	INR	A
MOVEIT	DAD	D
	DCR	A
	JNZ	MOVEIT
	XCHG
	POP	H
	LDAX	D
	CPI	BLANK
	JZ	SETFISH
	DCX	H
	DCX	H
	MVI	M,DEAD
	RET
;
;
;
SETFISH	MOV	M,B
	INX	H
	MOV	M,D
	INX	H
	MOV	M,E
	MVI	A,FISH
	STAX	D
	RET
;
;
;
RANDOM	PUSH	B
	PUSH	H
	MOV	B,A
RAND1	LHLD	RPTR
	MVI	C,8
RAND3	MOV	A,H
	RRC
	XRA	H
	RRC
	RRC
	XRA	H
	RRC
	XRA	L
	RRC
	RRC
	RRC
	XRI	1
	ANI	1
	DAD	H
	ADD	L
	MOV	L,A
	DCR	C
	JNZ	RAND3
RAND	SHLD	RPTR
	MOV	A,H
	ADD	L
	MOV	H,A
	MOV	A,B
RAND2	MOV	L,A
	ADD	B
	CMP	B
	JNC	RAND2
	MOV	A,H
	CMP	L
	JNC	RAND1
TOPS	CMP	B
	JC	GOTNUM
	SUB	B
	JMP	TOPS
GOTNUM	POP	H
	POP	B
	RET
;
;
;
USER	IN	INSTAT
	ANI	RDA
	RNZ
	CALL	INPUT
	DCX	H
	MVI	M,1
	CALL	BUMP3
	PUSH	H
	LXI	H,CHARS
	MVI	B,CHARL
COMP	CMP	M
	JZ	FOUND
	INX	H
	DCR	B
	JNZ	COMP
RETURN	POP	H
	RET
FOUND	MVI	A,CHARL
	SUB	B
	ANI	0FEH
	MVI	H,JUMPS SHR 8
	MOV	L,A
	MOV	E,M
	INX	H
MOV	D,M
	XCHG
	PCHL
;
;
;
INPUT	IN	INSTAT
	ANI	RDA
	JNZ	INPUT
	IN	INDAT
	ANI	7FH
	RET
;
;
;
UP	MVI	A,SUBL
	JMP	MOVHIM
RIGHT	MVI	A,ONE
	JMP	MOVHIM
DOWN	MVI	A,LENL
	JMP	MOVHIM
LEFT	MVI	A,0FFH
	JMP	MOVHIM
UL	MVI	A,SUBL-1
	JMP	MOVHIM
UR	MVI	A,SUBL+1
	JMP	MOVHIM
LR	MVI	A,LENL+1
	JMP	MOVHIM
LL	MVI	A,LENL-1
MOVHIM	POP	H
	CMP	M
	JZ	SDIREC
	MOV	M,A
	DCX	H
	MVI	M,VMAXS
	RET
;
;
;
SDIREC	DCX	H
	MVI	M,VFAST
	RET
;
;
;
HALT	POP	H
	MVI	M,0
	RET
;
;
;
AUTO	POP	H
	LDA	SCRFLG
	CMA
	STA	SCRFLG
	RET
;
;
;
ESC	LXI	B,CHARGO
	LXI	D,STRING
	LXI	H,DTV
ESC1	LDAX	D
	INX	D
	CPI	0FFH
	JZ	RESTART
	ORI	BIAS
	MOV	M,A
	INX	H
	CPI	'-'+BIAS
	JNZ	ESC1
	CALL	GET
	MVI	M,BLANK
	INX	H
	JMP	ESC1
GET	CALL	INPUT
	CPI	1BH
	JZ	RESTART
	STAX	B
	INX	B
	INX	B
	ORI	BIAS
	MOV	M,A
	INX	H
	RET
;
;
;
VMOVE	LXI	H,VTABL
	MOV	A,M
	CPI	ONE
	RNZ
	LDA	STV-15
	CPI	BLANK
	RZ
	LXI	H,STV-12
	CALL	ASCDEC
	LXI	H,VPOS
	MOV	B,M
	INX	H
	MOV	C,M
	CALL	NBR1
	MOV	D,A
	DCX	H
	DCX	H
	MOV	A,M
	ORA	A
	JNZ	MOVING
	LDA	GOODCAL
	CPI	ONE
	MVI	A,0FFH
	JZ	EQUAL1
	 MVI	A,ONE
EQUAL1	MOV	M,A
MOVING	CALL	NBR3
	MOV	E,A
	RLC
	ADD	E
	MOV	E,A
	RRC
	ORA	E
	MOV	E,A
	ANA	D
	ORA	A
	RZ
	MVI	B,7
	LDA	ROTATE
	XRI	8
	STA	ROTATE
WAY3	MOV	A,E
ROTATE	RLC
	MOV	E,A
	ANA	D
	ORA	A
	JZ	GOTWAY
	DCR	B
	JNZ	WAY3
	MOV	A,E
	RLC
	RLC
	ANA	E
	MOV	E,A
	MVI	B,8
WAY1	MOV	A,E
	RRC
	MOV	E,A
	ANA	D
	ORA	A
	JZ	FINDIREC
	DCR	B
	JNZ	WAY1
	MVI	M,0
	RET
GOTWAY	MOV	A,E
	RLC
	MOV	E,A
	RRC
	RRC
	ANA	E
FINDIREC	CALL	NBR2
	MOV	M,A
	MVI	B,7
SUBLOOP	LXI	H,STV-13
	CALL	ASCDEC
	DCR	B
	JNZ	SUBLOOP
	RET
;
;
;
NBR1	PUSH	H
	LXI	H,NBTB2
	MVI	A,0
	STA	COUNT
	MVI	A,8
LOOP1	STA	LCTR
	MOV	A,M
	ORA	A
	MOV	E,A
	MVI	D,0
	JP	FWD
	MVI	D,0FFH
FWD	XCHG
	DAD	B
	MOV	A,M
	XCHG
	INX	H
	CPI	BLANK
	JZ	NONBR
	CPI	BORDER
	JZ	NONBR
	MOV	D,M
	LDA	COUNT
	ADD	D
	STA	COUNT
NONBR	INX	H
	INX	H
	LDA	LCTR
	DCR	A
	JNZ	LOOP1
	LDA	COUNT
	POP	H
	RET
;
;
;
NBR2	PUSH	H
	LXI	H,NBTB1
	JMP	NXTENT
NBR3	PUSH	H
	LXI	H,NBTB2
NXTENT	CMP	M
	JZ	FINDENT
	CALL	BUMP3
	JMP	NXTENT
FINDENT	INX	H
	MOV	A,M
	POP	H
	RET
;
;
;
FISHY	DCR	M
	RNZ
	MVI	A,MRATE
	CALL	RANDOM
	CPI	0
	RNZ
	INX	H
	MOV	A,M
	CPI	DEAD
	RZ
	CPI	MARKED
	JZ	DIE
	PUSH	H
	CPI	FTRK
	CZ	TRACK
	POP	H
	INX	H
	MOV	A,M
	DCX	H
	DCX	H
	MOV	M,A
	CALL	BUMP3
	MVI	D,0
	MOV	E,M
	MOV	A,E
	ORA	A
	RZ
	ORA	A
	JP	FRWARD
	MVI	D,0FFH
FRWARD	INX	H
	MOV	B,M
	INX	H
	MOV	C,M
	LDAX	B
	CPI	BLANK
	JNZ	MOVER
	CALL	DEC4
	MVI	M,DEAD
	RET
;
;
;
MOVER	PUSH	H
	MOV	H,B
	MOV	L,C
	DAD	D
	XCHG
	POP	H
	LDAX	D
	CPI	BORDER
	JZ	HITBOR
	CPI	BLANK
	JNZ	BANG4
	DCX	H
	MOV	M,D
	INX	H
	MOV	M,E
	LDAX	B
	STAX	D
	MVI	A,BLANK
	STAX	B
	RET
;
;
;
CONVERT	PUSH	B
	LXI	H,-DTV
	DAD	D
	LXI	D,-LENL
	MVI	B,NLINES
FINEG	DAD	D
	DCR	B
	MOV	A,H
	ORA	A
	JP	FINEG
	MOV	E,B
	MOV	A,L
	ADI	LENL
	MOV	D,A
	POP	B
	RET
;
;
;
TRACK	MVI	A,64H
	CALL	RANDOM
	MOV	B,A
	LDA	LSTRK
	CMP	B
	RC
	CALL	BUMP3
	PUSH	H
	MOV	D,M
	INX	H
	MOV	E,M
	CALL	CONVERT
	MOV	B,D
	MOV	C,E
	LDA	VPOS
	MOV	D,A
	LDA	VPOS+1
	MOV	E,A
	CALL	CONVERT
	MOV	A,B
	SUB	D
	MOV	D,A
	CPI	7FH
	JC	POS1
	CMA
POS1	MOV	B,A
	MOV	A,C
	SUB	E
	MOV	E,A
	ORA	A
	JP	POS2
	CMA
POS2	CMP	B
	JC	TRKLIN
	MOV	A,E
	ORA	A
	JM	MOVEUP
	MVI	A,LENL
	JMP	SETDIR
MOVEUP	MVI	A,SUBL
	JMP	SETDIR
TRKLIN	MOV	A,D
	ORA	A
	JP	MOVELFT
	MVI	A,ONE
	JMP	SETDIR
MOVELFT	MVI	A,0FFH
SETDIR	POP	H
	DCX	H
	MOV	B,A
	MOV	A,M
	CMP	B
	RZ
	CMA
	CMP	B
	JZ	OPPOS
	MOV	M,B
	RET
;
;
;
OPPOS	CPI	SUBL
	JZ	MOVRHT
	CPI	LENL
	JZ	MOVRHT
	MVI	M,LENL
	RET
;
;
;
MOVRHT	MVI	M,ONE
	RET
;
;
;
HITBOR	CALL	DEC4
	MOV	A,M
	CPI	VICTIM
	JZ	VHIT
	DCX	H
	CALL	KILL
	RET
;
;
;
VHIT	MVI	A,0
	INX	H
	INX	H
	MOV	M,A
	RET
;
;
;
BANG4	CALL	DEC5
	CALL	KILL
	CALL	FIND
	CALL	KILL
	LXI	H,ONE
	DAD	B
	CALL	BANG
	LXI	H,0FFFFH
	DAD	B
	CALL	BANG
	LXI	H,LENL
	DAD	B
	CALL	BANG
	LXI	H,-LENL
	DAD	B
	CALL	BANG
	RET
;
;
;
DIE	DCX	H
	CALL	KILL
	RET
;
;
;
BANG	MOV	A,M
	CPI	BLANK
	JZ	EMPTY
	CPI	BORDER
	RZ
	CPI	BOOM
	RZ
	PUSH	H
	PUSH	B
	XCHG
	CALL	FIND
	CALL	KILL
	POP	B
	POP	H
EMPTY	XCHG
	PUSH	B
	CALL	ALIVE
	POP	B
	LDA	LTIME
	MOV	M,A
	INX	H
	MVI	M,MARKED
	CALL	BUMP3
	MOV	M,D
	INX	H
	MOV	M,E
	MVI	A,BOOM
	STAX	D
	RET
;
;
;
KILL	INX	H
	MVI	M,DEAD
	CALL	BUMP3
	MOV	B,M
	INX	H
	MOV	C,M
	MVI	A,BLANK
	STAX	B
	RET
;
;
;
ALIVE	LXI	H,FTABL+1
	MVI	B,MAXFISH
MORDEAD	MOV	A,M
	CPI	DEAD
	JZ	FNDEAD
	CALL	BUMP6
	DCR	B
	JNZ	MORDEAD
	LXI	H,ONE
FNDEAD	DCX	H
	RET
;
;
;
FIND	LXI	H,VTABL
	MVI	B,MAXFISH+1
LOOK	CALL	BUMP4
	MOV	A,M
	INX	H
	CMP	D
	JNZ	NOFIND
	MOV	A,M
	CMP	E
	JNZ	NOFIND
	CALL	DEC5
	RET
;
;
;
NOFIND	INX	H
	DCR	B
	JNZ	LOOK
	LXI	H,0
	RET
;
;
;
SETUP	LXI	H,DTV
	MVI	B,NLINES
BLKCH	MVI	C,LENL
BLKEH	MVI	M,BLANK
	INX	H
	DCR	C
	JNZ	BLKEH
	DCR	B
	JNZ	BLKCH
	LXI	H,DTV
	LXI	D,ETV-2*LENL
	MVI	B,WIDTH
	MVI	A,BORDER
SETBOR	MOV	M,A
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	SETBOR
	MVI	B,NLINES-2
	LXI	D,DTV+LENL
NXTROW	MOV	M,A
	MVI	C,WIDTH-1
SETSIDE	INX	H
	DCR	C
	JNZ	SETSIDE
	MOV	M,A
	MVI	C,LENL+1-WIDTH
PADSIDE	INX	H
	DCR	C
	JNZ	PADSIDE
	DCR	B
	JNZ	NXTROW
	LXI	H,VTABL
	MVI	M,VMAXS
	INX	H
	MVI	M,VICTIM
	INX	H
	MVI	M,VMAXS
	INX	H
	MVI	M,0
	INX	H
	LXI	B,DTV+LENL*NLINES/2-LENL+WIDTH/2
	MOV	M,B
	INX	H
	MOV	M,C
	MVI	A,VSYM
	STAX	B
	MVI	D,MAXFISH
NOFISH	INX	H
	INX	H
	MVI	M,DEAD
	CALL	BUMP4
	DCR	D
	JNZ	NOFISH
	LXI	H,STV-25
	MVI	B,14H
	LXI	D,SCRMSG
PTRSCR	LDAX	D
	ORI	BIAS
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	PTRSCR
	MVI	A,0FFH
	STA	SCRFLG
	MVI	A,0
	STA	PHASE
	CALL	SETPHA
	CALL	GETPHA
	RET
;
;
;
BUMP6	INX	H
	INX	H
BUMP4	INX	H
BUMP3	INX	H
	INX	H
	INX	H
	RET
;
;
;
DEC5	DCX	H
DEC4	DCX	H
DEC3	DCX	H
	DCX	H
	DCX	H
	RET
;
;
;
NBTB1	DB	1
NBTB2	DB	SUBL,1,2
	DB	SUBL+1,2,4
	DB	1,4,8
	DB	LENL+1,8,10H
	DB	LENL,10H,20H
	DB	LENL-1,20H,40H
	DB	0FFH,40H,80H
	DB	SUBL-1,80H
LCTR	DB	8
COUNT	DB	0
RPTR	DB	0,0
BIGONE	DB	0
BIGTWO	DB	0,0,0
SCRMSG	DB	'SCORE '
	DB	'      00      '
PHAMSG	DB	'PHASE      '
SCRFLG	DB	0FFH
GOODCAL	DB	WIDTH-2
PHASE	DB	0
LNEWF	DB	100
LSIDE	DB	1
LMINS	DB	20
LSRNG	DB	80
LTIME	DB	28H
LTRACK	DB	1
LSTRK	DB	1
LBONUS	DB	0
CTLPTR	DW	CONTROL
	DB	22
;
;
;
CONTROL	DB	40H,1,2,60H,30H,10,1,50
	DB	48H,1,26H,5CH,30H,20,4,75
	DB	50H,1,24H,58H,2CH,30,7,100
	DB	58H,1,22H,54H,2CH,40,10,125
	DB	60H,2,20H,50H,28H,50,13,150
	DB	68H,2,1EH,4CH,28H,60,16,175
	DB	70H,2,1CH,48H,24H,70,19,200
	DB	78H,2,1AH,44H,24H,80,22,225
	DB	80H,4,18H,40H,20H,90,25,250
	DB	88H,4,16H,3CH,20H,100,28,255
;
;
;
MARKED	EQU	58H
FRATE	EQU	4
MRATE	EQU	1
RDA	EQU	80H
INDAT	EQU	06CH
INSTAT	EQU	06EH
FTRK	EQU	49H
MONIT	EQU	0
NOTRK	EQU	41H
VMAXS	EQU	17H
VFAST	EQU	7
VICTIM	EQU	50H
LENL	EQU	64
WIDTH	EQU	64
SCORSP	EQU	20H
SUBL	EQU	0C0H
BIAS	EQU	0
BLANK	EQU	' '+BIAS
ZERO	EQU	'0'+BIAS
BIN0	EQU	0
ONE	EQU	1
VSYM	EQU	7+BIAS
DEAD	EQU	4FH
BOOM	EQU	'+'+BIAS
FISH	EQU	'*'+BIAS
BORDER	EQU	0A0H
DTV	EQU	0F800H
NLINES	EQU	16
ETV	EQU	DTV+LENL*NLINES
STV	EQU	ETV-LENL+WIDTH
MAXFISH	EQU	(NLINES+WIDTH)/3
;
;
;
	ORG	800H
JUMPS	DW	MONIT
	DW	ESC
	DW	RESTART
	DW	UP
	DW	DOWN
	DW	LEFT
	DW	RIGHT
	DW	UL
	DW	UR
	DW	LL
	DW	LR
	DW	HALT
	DW	STOP
	DW	AUTO
	DW	RETURN
CHARS	DB	0FFH,01H
	DB	1BH,1BH
CHARGO	DB	'S',0DH
	DB	'U','8'
	DB	'J','2'
	DB	'H','4'
	DB	'K','6'
	DB	'Y','7'
	DB	'I','9'
	DB	'N','1'
	DB	',','3'
	DB	' ','5'
	DB	'P','.'
	DB	'A','0'
ENDCH	DB	0FFH
CHARL	EQU	ENDCH-CHARS
STRING	DB	' ENTER NEW VALUES FOR: GO-'
	DB	'U-'
	DB	'D-'
	DB	'L-'
	DB	'R-'
	DB	'UL-'
	DB	'UR-'
	DB	'LL-'
	DB	'LR-'
	DB	'H-'
	DB	'P-'
	DB	'A-'
	DB	0FFH
VTABL	DB	VMAXS
	DB	VICTIM
VSPEED	DB	VMAXS
VDIREC	DB	0
VPOS	DW	DTV+LENL*(NLINES-1)/2
FTABL	DS	MAXFISH*6
	END
