(*    PLOT TEST PROGRAM

   Program plots a bullseye test pattern on the graphics
   printer.  Designed to demonstrate the calling sequence
   to the graphics plotting package.

      Version:  JRT PASCAL

      Date:    20 February 1983

      Programmer:

               David H. Freese Jr.
               Clermont Computer Consultants
               RD 1 Box 316 
               Cape May Court House, NJ  08210
               (609) 263 7511

*)
program jpltst;

type  pline = array [1..413] of char;
      plt   = array [1..52] of pline;

var   image : plt;
      i : integer;
   
   
procedure jplot(func: char; p1,p2,p3,p4,p5,p6,p7: integer); extern;

begin

(* initialize the plot image in memory *)

jplot('I', 0,0,0,0,0,0,0);

(* plot axis centered at 200, 200,
         minor ticks at intervals of 5,
         major ticks at intervals of 25,
         superimpose a grid *)

jplot('A', 200, 200, 5, 5, 25, 25, 1);

(* plot a crossed pair of lines *)

jplot('L', 10, 10, 390, 390, 0,0,0);
jplot('L', 10, 390, 390, 10, 0,0,0);

(* plot data point marks at ends of lines *);

jplot('D', 10, 10, 0,0,0,0,0);
jplot('D', 10, 390, 0,0,0,0,0);
jplot('D', 390, 10, 0,0,0,0,0);
jplot('D', 390, 390, 0,0,0,0,0);
 
(* plot 8 concentric circles of increasing radius *)

for i := 1 to 8 do
   jplot('C', 200, 200, 25*i, 0,0,0,0);

(* transfer image to printer *)

jplot('T', 0,0,0,0,0,0,0);

end.
