(*    PLOT TEST PROGRAM

   Program plots a bullseye test pattern on the graphics
   printer.  Designed to demonstrate the calling sequence
   to the graphics plotting package.

      Version:  PASCAL/Z

      Date:    20 February 1983

      Programmer:

               David H. Freese Jr.
               Clermont Computer Consultants
               RD 1 Box 316 
               Cape May Court House, NJ  08210
               (609) 263 7511

*)
program zpltst;


var   i : integer;
   
   
(* EXTERNAL PROCEDURES contained in file PASPLOT.REL *)

procedure   axis(x0,y0,xa,ya,xb,yb: integer; grid: boolean); external;
procedure   line(x1,y1,x2,y2: integer); external;
procedure   plot(x1,y1: integer); external;
procedure   point(x1,y1: integer); external;
procedure   circle(x1,y1,radius: integer); external;
procedure   init; external;
procedure   xfrplt; external;

begin

(* initialize the plot image in memory *)

init;

(* plot axis centered at 200, 200,
         minor ticks at intervals of 5,
         major ticks at intervals of 25,
         superimpose a grid *)

axis(200, 200, 5, 5, 25, 25, true);

(* plot a crossed pair of lines *)

line(10, 10, 390, 390);
line(10, 390, 390, 10);

(* plot data point marks at ends of lines *);

point(10, 10);
point(10, 390);
point(390, 10);
point(390, 390);
 
(* plot 8 concentric circles of increasing radius *)

for i := 1 to 8 do
   circle(200,200, 25*i);

(* transfer image to printer *)

xfrplt;

end.
